<?php

namespace app\Http\Controllers\Admin;

use app\Http\Controllers\Admin\BaseController;
use app\Model\Admin\SmtpSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Validator;

class SmtpSettingsController extends BaseController
{

    private $const;
    private $breadCrumb;
    private $url;
    private $title;
    private $subTitle;
    private $controllerUri;
    private $actionUri;

    /**
     * @Name: Sandeep
     * @Method: __construct()
     * @Scope: public
     * @Params: null
     * @Description: Initialize variable with module scope, breadcrumb
     * @Created 02/Dec/2019
     * @Updated 02/Dec/2019
     */
    public function __construct()
    {
        try {
            parent::__construct();
            $this->middleware('auth.admin');

            $this->url = config('admin.path.ADMIN_BASE_URL') . '/smtp-settings/1';
            $this->title = 'Manage SMTP Setting';
            $this->controllerUri = 'smtp-settings';

            //department logo path & base urls
            $this->const['url'] = $this->url;
            $this->const['title'] = $this->title;
            $this->const['controllerUri'] = $this->controllerUri;

            //used in adminForm layout to load validation messges in js variable
            $this->const['objValidationMsgs'] = 'smtp-setting';
            $this->const['objValidationJs'] = 'smtp-setting';

            $this->const = array_merge($this->adminConst(), $this->const);

            //default breadcrumb option (Dashboard) for every route
            $this->breadCrumb['faClass'] = 'fa-table';
            $this->breadCrumb['breadCrumData'] = [
                0 => [
                    'text' => 'Dashboard',
                    'url' => config('admin.path.ADMIN_BASE_URL'),
                    'breadFaClass' => 'fa-dashboard',
                ],

            ];
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Name: Sandeep
     * @Method: show()
     * @Scope: public
     * @params  int  $id
     * @Description: Show the form for editing the specified resource.
     * @Created 02/Dec/2019
     * @Updated 02/Dec/2019
     */
    public function show($id)
    {
        try {
            // method/action specific initializations
            $this->subTitle = 'Edit';
            $this->actionUri = 'edit';
            $formId = 'smtpForm';

            //pre-populated data
            $this->const['subTitle'] = $this->subTitle;
            $this->const['actionUri'] = $this->actionUri;
            $this->const['formId'] = $formId;

            //push current controller then method in breadcrumb at position 1 & 2
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->title,
                'url' => $this->url,
                'breadFaClass' => '',
            ];
            $this->breadCrumb['breadCrumData'][2] = [
                'text' => $this->subTitle,
                'breadFaClass' => 'active',
            ];

            $smtpDetail = SmtpSetting::FindOrFail($id);

            $this->data['smtpDetail'] = $smtpDetail;

            $data = array_merge($this->data, $this->const, $this->breadCrumb);
            return \View('Admin.' . $this->controllerUri . '.edit')->with($data);

        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Name: Sandeep
     * @Method: update()
     * @Scope: public
     * @params: @id
     * @input: @name, @status
     * @Description: Update the specified resource in storage.
     * @Created 02/Dec/2019
     * @Updated 03/Dec/2019
     */
    public function update(Request $request, $id = null)
    {
        try {
            $id = \Crypt::decryptString($id);
            $smtpSetting = SmtpSetting::FindOrFail($id);
            if ($request->isMethod('put')) {
                $input = Input::all();
                $validator = Validator::make($input, SmtpSetting::Rules($id), SmtpSetting::messages());

                if ($validator->fails()) {
                    return \Redirect::back()->withInput()->withErrors($validator->errors());
                } else {
                    $input['id'] = $smtpSetting->id;
                    unset($input['_method']);
                    unset($input['_token']);
                    $smtpSetting->fill($input)->save();

                    \Session::flash('success', __('admin/flash_msg.success.SmtpUpdated'));
                    return \Redirect::to($this->url);
                }
            }
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

}
