<?php

namespace app\Http\Controllers\Admin;

use app\Http\Controllers\Admin\BaseController;
use app\Model\Admin\Role;
use app\Model\Admin\Order;
use Auth;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class RestaurantTransactionController extends BaseController
{
    private $const;
    private $roleId;
    private $roleName;
    private $breadCrumb;
    private $url;
    private $title;
    private $subTitle;
    private $controllerUri;
    private $actionUri;
    /**
     * @Method: __construct()
     * @Scope: public
     * @Params: null
     * @Description: Initialize variables like  @roleId, @roleName, @url within private scope of current class
     * @Created 24/Jan/2022
     * @Updated 24/Jan/2022
     */
    public function __construct()
    {
        try {
            parent::__construct();
            $this->middleware('auth.admin');

            //fixed role for this module
            $this->roleId = config('admin.constants.RESTAURANT_OWNER_ROLE');
            $role = Role::select('name')->where('id', $this->roleId)->first();
            if ($role->name) {
                $this->roleName = $role->name;
            }

            $this->url = config('admin.path.ADMIN_BASE_URL') . '/restaurant-transaction';
            $this->title = 'Manage Restaurant Transactions';
            $this->controllerUri = 'restaurant-transaction';
            $this->customerUrl = config('admin.path.ADMIN_BASE_URL') . '/customer';
            $this->orderUrl = config('admin.path.ADMIN_BASE_URL') . '/order';
            $this->deliveryPersonUrl = config('admin.path.ADMIN_BASE_URL') . '/delivery-persons';
            $this->restaurantUrl = config('admin.path.ADMIN_BASE_URL') . '/restaurant';
            $this->const['url'] = $this->url;
            $this->const['title'] = $this->title;
            $this->const['controllerUri'] = $this->controllerUri;
            $this->const['roleId'] = $this->roleId;
            $this->const['roleName'] = $this->roleName;
            $this->const['customerUrl'] = $this->customerUrl;
            $this->const['orderUrl'] = $this->orderUrl;
            $this->const['restaurantUrl'] = $this->restaurantUrl;
            //used in adminForm layout to load validation messges in js variable
            $this->const['objValidationMsgs'] = 'category';
            $this->const['objValidationJs'] = 'category';


            //merge constant into single array with parent controller values
            $this->const = array_merge($this->adminConst(), $this->const);

            //default breadcrumb option (Dashboard) for every route
            $this->breadCrumb['faClass'] = 'fa-table';
            $this->breadCrumb['breadCrumData'] = [
                0 => [
                    'text' => 'Dashboard',
                    'url' => config('admin.path.ADMIN_BASE_URL'),
                    'breadFaClass' => 'fa-dashboard',
                ],

            ];
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }
    /**
     * Author: Jaidev
     * @Method: index()
     * @Scope: public
     * @Params: @page,
     * @returns: A List of Restaurant order transaction
     * @Description: This function fetches  orders  from database, sets up
     *  breadcrumb & other constants.
     * @Created 24/Jan/2022
     * @Updated 24/Jan/2022
     */
    public function index(Request $request)
    {
        try {
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->const['title'],
            ];
            $page = $request->query('page', 1);
            $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
            $this->const['page'] = $page;
            $this->const['limit'] = $limit;
            $dataList = Order::restaurantOrderList($request);
            // dd($dataList);
            $data['orderList'] = $dataList;
            $data['restaurantList'] = \DB::table('restaurants')->orderBy('name', 'asc')->pluck('name', 'id')->toArray();
            // dd($data['restaurantList']);
            $data = array_merge($data, $this->const, $this->breadCrumb);
            return view('Admin.transaction.restaurant.index')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }


    /**
     * Author: jaidev
     * Email: jaidev@nmgtechnologies.com
     * @Method: paymentStatusHandler()
     * @Scope: public
     * @params: @id
     * @input: orderIds
     * @Created 24/Jan/2022
     * @Updated 24/Jan/2022
     */
    public function paymentStatusHandler(Request $request)
    {
        try {
            $response['status'] = 0;
            if ($request->isMethod('post')) {
                $input = $request->only(['orderIds', 'status']);
                $validator = Validator::make($input, [
                    'orderIds' => 'bail|required|array|min:1',
                    'status' => 'bail|required|in:0,1'

                ]);
                if ($validator->fails()) {
                    $msg = $validator->errors()->first();
                } else {
                    $update = Order::whereIn('id', $input['orderIds'])->update(['vendor_payment_status' => $input['status']]);

                    if ($update) {
                        $response['status'] = 1;
                        $msg = __('admin/flash_msg.success.orderPaymentStatusUpdated');
                    } else {
                        $msg = __('admin/flash_msg.error.UnableToUpdatePaymentStatus');
                    }
                }
                $response['msg'] = $msg;
                return json_encode($response);
            }
        } catch (\Exception $e) {
            // dd($e);
            $this->saveErrorLog($e);
            $response['status'] = 0;
            // $response['msg'] = __('admin/flash_msg.error.SomethingWrong');
            $response['msg'] = $e->getMessage();
            return json_encode($response);
        }
    }
}
