<?php

namespace app\Http\Controllers\Admin;

use app\Http\Controllers\Admin\BaseController;
use app\Model\Admin\Modules;
use app\Model\Admin\Permissions;
use app\Model\Admin\Role;
use Auth;
use Illuminate\Http\Request;

class PermissionsController extends BaseController
{

    protected $authUserId;
    private $const;
    private $breadCrumb;
    private $url;
    private $title;
    private $subTitle;
    private $controllerUri;
    private $actionUri;

    /**
     * @Method: __construct()
     * @Scope: public
     * @Params: null
     * @Description: Initialize variable with module scope, breadcrumb
     * @Created 28/Nov/2019
     * @Updated 28/Nov/2019
     */

    public function __construct()
    {
        try {
            parent::__construct();
            $this->middleware('auth.admin');
            $this->url = config('admin.path.ADMIN_BASE_URL') . '/roles';
            $this->title = 'Roles';
            $this->controllerUri = 'roles';

            $this->const['url'] = $this->url;
            $this->const['title'] = $this->title;
            $this->const['controllerUri'] = $this->controllerUri;
            $this->const['objValidationMsgs'] = 'role';
            $this->const['objValidationJs'] = 'role';
            $this->const = array_merge($this->adminConst(), $this->const);

            $this->breadCrumb['faClass'] = 'fa-table';
            $this->breadCrumb['breadCrumData'] = [
                0 => [
                    'text' => 'Dashboard',
                    'url' => config('admin.path.ADMIN_BASE_URL'),
                    'breadFaClass' => 'fa-dashboard',
                ],

            ];
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Method: index()
     * @Scope: public
     * @Params: @id(role_id), @page, @limit, @search
     * @returns: returns modules for a particular role
     * @Description: This function will display tree view of module for the selected role, and
     * provide the option to assign access right of particualr module
     * @Created 28/Nov/2019
     * @Updated 28/Nov/2019
     */
    public function index(Request $request)
    {
        try {
            // method/action specific initializations
            $this->subTitle = 'Permissions';
            $this->actionUri = 'index';
            $formId = 'permissionForm';

            //pre-populated data
            $this->const['subTitle'] = $this->subTitle;
            $this->const['actionUri'] = $this->actionUri;
            $this->const['formId'] = $formId;

            //push current controller then method in breadcrumb at position 1 & 2
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->title,
                'url' => $this->url,
                'breadFaClass' => '',
            ];
            $this->breadCrumb['breadCrumData'][2] = [
                'text' => $this->subTitle,
                'breadFaClass' => 'active',
            ];

            $roleId = \Crypt::decryptString($request->get('id'));
            $roleName = Role::where('id', $roleId)->first()->name;

            $data = [];
            $data['modulesList'] = Modules::getChildrenList($roleId);
            $data['roleId'] = $roleId;
            $data['roleName'] = $roleName;
            $data['rolesList'] = Role::where('id', $roleId)->where('status', 1)->get();

            $data = array_merge($data, $this->const, $this->breadCrumb);
            return \View('Admin.permissions.index')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', config('admin.flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Method: updatePermission()
     * @Scope: public
     * @input: role_id with module details
     * @Description: This function grant or revoke access permission for particular module or it's action
     * @Created 28/Nov/2019
     * @Updated 28/Nov/2019
     */
    public function updatePermission(Request $request)
    {
        $response = ['success' => 0, 'permission' => [], 'message' => __('admin/flash_msg.error.permissionErrorMessage')];
        try {
            if ($request->isMethod('post')) {
                $data = $request->all();
                $roleId = \Crypt::decryptString($data['role_id']);
                $modules = [];

                $permissions = Permissions::where('role_id', $roleId)->delete();
                $saveFlag = false;
                if (!empty($data['modules'])) {
                    foreach ($data['modules'] as $moduleId) {

                        $permission = new \app\Model\Admin\Permissions();

                        $permission->module_id = $moduleId;
                        $permission->role_id = $roleId;
                        $permission->status = 1;
                        $permission->created_by = Auth::guard('admin')->user()['id'];
                        $permission->updated_by = Auth::guard('admin')->user()['id'];
                        if ($permission->save()) {
                            $saveFlag = true;
                            $response['success'] = 1;
                            $modules[] = $permission;
                        }
                    }
                }
                if ($saveFlag) {
                    $response['success'] = 1;
                    $response['permission'] = $modules;
                    $response['message'] = __('admin/flash_msg.success.PermissionSuccessMessage');
                }
            }
            return response()->json($response);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return response()->json($response);
        }
    }

}
