<?php

namespace app\Http\Controllers\Admin;

use app\Components\Api\PushNotification;
use app\Http\Controllers\Admin\BaseController;
use app\Model\Admin\Facility;
use app\Model\Admin\InstantMail;
use app\Model\Admin\Role;
use app\Model\Admin\User;
use Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class MailboxController extends BaseController
{
    private $const;
    private $breadCrumb;
    private $url;
    private $title;
    private $subTitle;
    private $controllerUri;
    private $actionUri;

    /**
     * @Method: __construct()
     * @Scope: public
     * @Description: mailbox constructor method, initializes all controller specidfic common settings
     * @Created 14/Jan/2020
     * @Updated 14/Jan/2020
     */
    public function __construct()
    {
        try {
            parent::__construct();
            $this->middleware('auth.admin');

            $this->url = config('admin.path.ADMIN_BASE_URL') . '/mailbox';
            $this->title = 'Manage Mailbox';
            $this->controllerUri = 'mailbox';

            //title logo path & base urls
            $this->const['url'] = $this->url;
            $this->const['title'] = $this->title;
            $this->const['controllerUri'] = $this->controllerUri;

            //used in adminForm layout to load validation messges in js variable
            $this->const['objValidationMsgs'] = 'mailbox';
            $this->const['objValidationJs'] = 'mailbox';

            $this->const = array_merge($this->adminConst(), $this->const);

            //default breadcrumb option (Dashboard) for every route
            $this->breadCrumb['faClass'] = 'fa-table';
            $this->breadCrumb['breadCrumData'] = [
                0 => [
                    'text' => 'Dashboard',
                    'url' => config('admin.path.ADMIN_BASE_URL'),
                    'breadFaClass' => 'fa-dashboard',
                ],
            ];
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * @Method: create()
     * @Scope: public
     * @Params: null
     * @Description: A form having roles, facility, to, subject, content, push title, push content.
     * push notification will be optioanl
     * @Created 14/Jan/2020
     * @Updated 14/Jan/2020
     */
    public function create()
    {
        try {
            $this->subTitle = 'Compoase New Message';
            $this->actionUri = 'create';
            $formId = 'mailboxForm';

            //pre-populated data
            $this->const['subTitle'] = $this->subTitle;
            $this->const['actionUri'] = $this->actionUri;
            $this->const['formId'] = $formId;

            //push current controller then method in breadcrumb at position 1 & 2
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->title,
                'url' => $this->url,
                'breadFaClass' => '',
            ];
            $this->breadCrumb['breadCrumData'][2] = [
                'text' => $this->subTitle,
                'breadFaClass' => 'active',
            ];

            $roles = Role::select('roles.id', 'roles.name')->leftJoin('users', function ($join) {
                $join->on('users.role_id', '=', 'roles.id');
            })->whereNotNull('users.role_id')->get()->pluck('name', 'id')->toArray();
            $this->const['roles'] = $roles;
            $data = [];

            $data = array_merge($this->const, $this->breadCrumb);
            return \View('Admin.' . $this->controllerUri . '.create')->with($data);
        } catch (\Exception $e) {
            dd($e);
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Method: store()
     * @Scope: public
     * @Params: null
     * @returns: json response for ajax call
     * @Description: This function will trigger instant emails & push notifications to the registered user
     * as per the selected criteria like- role, facility or comma seprted email
     * @Created 14/Jan/2020
     * @Updated 14/Jan/2020
     */
    public function store(Request $request)
    {
        try {
            if ($request->isMethod('post')) {
                $rollBack = false;
                $authId = Auth::guard('admin')->user()->id;
                $input = $request->only(['type', 'role_id', 'facility_id', 'email', 'subject', 'content', 'push_title', 'push_content', 'attachment']);
                if (isset($input['role_id']) && is_array($input['role_id'])) {
                    if (($key = array_search(0, $input['role_id'])) !== false) {
                        unset($input['role_id'][$key]);
                    }
                }
                //To: field can accept multiple comma separted emai,
                //which will coverted to array for validation
                if (!empty($input['email'])) {
                    $arrEmails = explode(",", $input['email']);
                    $input['email'] = $arrEmails;
                }
                $validator = Validator::make($input, InstantMail::Rules(), InstantMail::messages());
                if ($validator->fails()) {
                    $response = [
                        'status' => 'error',
                        'message' => $validator->errors()->first(),
                    ];
                    return response()->json($response, 200);
                } else {
                    $status = 'error';
                    $message = __('admin/validation/mailbox.error.wrong');
                    if (!empty($input['type'])) {
                        //send email/notification to the users as per email address
                        $content = '';
                        if (!empty($this->const['baseUrl'])) {
                            $content = $input['content'];
                            $content = str_replace('../../public/storage/uploads/mailbox/', $this->const['baseUrl'] . 'public/storage/uploads/mailbox/', $content);
                        }
                        if ($input['type'] == 'single') {
                            //send notifications for users whos emails mentioned
                            if (is_array($input['email']) && count($input['email']) > 0) {
                                foreach ($input['email'] as $email) {
//                                    $user = User::select('id', 'role_id', 'facility_id', 'title_id', 'department_id', 'first_name', 'last_name')
                                      $user = User::select('id', 'role_id','first_name', 'last_name')
                                        ->with([
                                            'latestAvatar' => function ($query) {
                                                $query->select('id', 'user_id', 'avatar');
                                            },
                                        ])
                                        ->where([['email', '=', $email], ['status', '=', 1]])->first();
                                    if (!empty($user)) {
                                        \DB::beginTransaction();
                                        if (InstantMail::create([
                                            'type' => $input['type'],
                                         //   'role_id' => $user->role_id,
                                            'user_id' => $user->id,
                                            'email' => $email,
                                            'subject' => $input['subject'],
                                            'content' => $content,
                                         //  'push_title' => $input['push_title'],
                                        //  'push_content' => $input['push_content'],
                                            'created_by' => $authId,
                                        ])) {
                                            ###Instant Email#####
                                            if (!empty($input['lang'])) {
                                                \App::setLocale($input['lang']);
                                            }
                                            $params['replaceKeywords']['{USER_NAME}'] = $user->full_name;
                                        //    $params['replaceKeywords']['{FACILITY_NAME}'] = $facilityName;
                                        //    $params['replaceKeywords']['{DEPARTMENT_NAME}'] = $departmentName;
                                        //    $params['replaceKeywords']['{TITLE}'] = $titleName;
                                            $params['toEmail'] = $email;
                                            //emailTemplates content
                                            $params['emailSlug'] = 'broadcast_email';
                                            //inatant content
                                            $params['subject'] = $input['subject'];
                                            $params['content'] = $content;
                                            if ($request->hasFile('attachment')) {
                                                $file = $request->attachment;
                                                $params['attachment'] = $file->getRealPath();
                                                //$params['attachmentName'] = 'pradeep.jpeg';
                                                $params['attachmentName'] = $file->getClientOriginalName();
                                            }
                                            if ($this->customMailer($params)) {
                                                \DB::commit();
                                                $status = 'success';
                                                $message = __('admin/validation/mailbox.success.sent');
                                            } else {
                                                \DB::rollBack();
                                                $message = __('admin/validation/mailbox.error.sent');
                                            }
                                            ############ Push Notifications ###########
                                            if (!empty($input['push_title']) && !empty($input['push_content'])) {
                                                $action = (int) config('api.notification.TYPE_ID.USER.BROADCAST.CODE');
                                                $notificationData = [
                                                    'notifiable_id' => $user->id,
                                                    'receiver_id' => $user->id,
                                                    'sender_id' => $authId,
                                                    'bold_string' => $user->full_name,
                                                    'replaced_array' => [$user->full_name, env('APP_NAME')],
                                                    'left_image_id' => null,
                                                    'right_image_id' => $user->id,
                                                    'title' => $input['push_title'],
                                                    'message' => $input['push_content'],
                                                ];
                                                $sent = PushNotification::triggerPush($action, $notificationData);
                                            }
                                            ###################################
                                        } else {
                                            $message = __('admin/validation/mailbox.error.unable');
                                        }
                                    } else {
                                        $message = __('admin/validation/mailbox.error.blocked');
                                    }
                                }
                            }
                        } else if ($input['type'] == 'bulk') {
                            //send email/notification to the users filtered by role, facility one , all or many
                            $query = User::select('id', 'role_id', 'facility_id', 'title_id', 'department_id', 'email', 'first_name', 'last_name')
                                ->with([
                                    'latestAvatar' => function ($query) {
                                        $query->select('id', 'user_id', 'avatar');
                                    },
                                ])
                                ->where('status', 1);
                            if (!empty($input['role_id'])) {
                                $query->whereIn('role_id', $input['role_id']);
                                $query->where('status', 1);
                            }
                            $users = $query->get();
                            if ($users->count() > 0) {
                                foreach ($users as $user) {
                                    \DB::beginTransaction();
                                    if (InstantMail::create([
                                        'type' => $input['type'],
                                        'role_id' => $user->role_id,
                                        'user_id' => $user->id,
                                        'email' => $user->email,
                                        'subject' => $input['subject'],
                                        'content' => $content,
                                        'push_title' => $input['push_title'],
                                        'push_content' => $input['push_content'],
                                        'created_by' => $authId,
                                    ])) {
                                        ###Instant Email#####
                                        if (!empty($input['lang'])) {
                                            \App::setLocale($input['lang']);
                                        }
                                        $params['replaceKeywords']['{USER_NAME}'] = $user->full_name;
                                        $params['replaceKeywords']['{FACILITY_NAME}'] = $facilityName;
                                        $params['replaceKeywords']['{DEPARTMENT_NAME}'] = $departmentName;
                                        $params['replaceKeywords']['{TITLE}'] = $titleName;
                                        $params['toEmail'] = $user->email;
                                        //emailTemplates content
                                        $params['emailSlug'] = 'broadcast_email';
                                        //inatant content
                                        $params['subject'] = $input['subject'];
                                        $params['content'] = $content;
                                        if ($this->customMailer($params)) {
                                            \DB::commit();
                                            $status = 'success';
                                            $message = __('admin/validation/mailbox.success.sent');
                                        } else {
                                            \DB::rollBack();
                                        }
                                        ############ Push Notifications ###########
                                        if (!empty($input['push_title']) && !empty($input['push_content'])) {
                                            $action = (int) config('api.notification.TYPE_ID.USER.BROADCAST.CODE');
                                            $notificationData = [
                                                'notifiable_id' => $user->id,
                                                'receiver_id' => $user->id,
                                                'sender_id' => $authId,
                                                'bold_string' => $user->full_name,
                                                'replaced_array' => [$user->full_name, env('APP_NAME')],
                                                'left_image_id' => null,
                                                'right_image_id' => $user->id,
                                                'title' => $input['push_title'],
                                                'message' => $input['push_content'],
                                            ];
                                            $sent = PushNotification::triggerPush($action, $notificationData);
                                        }
                                        ###################################
                                    }
                                }
                            }
                        } else {
                            $message = __('admin/validation/mailbox.error.invalidType');
                        }
                    }
                    $response = [
                        'status' => $status,
                        'message' => $message,
                    ];
                    return response()->json($response, 200);
                }
            }
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            $response = [
                'status' => 'error',
                'message' => __('admin/flash_msg.error.SomethingWrong'),
            ];
            return response()->json($response, 200);
        }
    }

    /**
     * @Method: uploadEditorImage()
     * @Scope: public
     * @Description: used in upload editor images for mailbox
     * @Created 15/Jan/2020
     * @Updated 15/Jan/2020
     */
    public function uploadEditorImage(Request $request)
    {
        try {
            $this->uploadEditorImageUpload($_FILES, 'mailbox');
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            $response = [
                'status' => 'error',
                'message' => __('admin/flash_msg.error.SomethingWrong'),
            ];
            return response()->json($response, 200);
        }
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

}
