<?php

namespace app\Http\Controllers\Admin;

use app\Http\Controllers\Admin\BaseController;
use app\Model\Admin\ContactSupport;
use DB;
use Auth;
use Illuminate\Http\Request;

class ContactSupportController extends BaseController
{
    private $const;
    private $breadCrumb;
    private $url;
    private $title;
    private $subTitle;
    private $controllerUri;
    private $actionUri;

    /**
     * @Method: __construct()
     * @Scope: public
     * @Params: null
     * @Description: Initialize variable with module scope, breadcrumb
     * @Created 16/Jan/2020
     * @Updated 16/Jan/2020
     */
    public function __construct()
    {
        try {
            parent::__construct();
            $this->middleware('auth.admin');

            $this->url = config('admin.path.ADMIN_BASE_URL') . '/contact-supports';
            $this->title = 'Contact Support List';
            $this->controllerUri = 'contact-supports';

            //department logo path & base urls
            $this->const['url'] = $this->url;
            $this->const['title'] = $this->title;
            $this->const['controllerUri'] = $this->controllerUri;

            //used in adminForm layout to load validation messges in js variable
            $this->const['objValidationMsgs'] = 'contact-support';
            $this->const['objValidationJs'] = 'contact-supports';

            $this->const = array_merge($this->adminConst(), $this->const);

            //default breadcrumb option (Dashboard) for every route
            $this->breadCrumb['faClass'] = 'fa-table';
            $this->breadCrumb['breadCrumData'] = [
                0 => [
                    'text' => 'Dashboard',
                    'url' => config('admin.path.ADMIN_BASE_URL'),
                    'breadFaClass' => 'fa-dashboard',
                ],

            ];
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Method: index()
     * @Scope: public
     * @Params: @page, @limit, @search
     * @returns: Display a listing of the resource
     * @Description: display the listing of blocked users
     * @Created 16/Jan/2020
     * @Updated 16/Jan/2020
     */
    public function index(Request $request)
    {
        try {

            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->const['title'],
            ];
            $page = $request->query('page', 1);
            $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
            $this->const['page'] = $page;
            $this->const['limit'] = $limit;

            $search = !empty($request->search) ? $request->search : '';

            $data = [];
            $query = ContactSupport::select(
                'contact_supports.id',
                'contact_supports.user_id',
                'contact_supports.message',
                'contact_supports.title_id',
                'contact_supports.title as titleString',
                'contact_supports.created_at'
            )->with(['users'])->with('title');

            if (!empty($search)) {
                $query->whereHas('users', function ($query) use ($search) {
                    $query->where('first_name', 'like', '%' . $search . '%');
                    $query->orWhere('last_name', 'like', '%' . $search . '%');
                    $query->orWhere('email', 'like', '%' . $search . '%');
                });
                $query->orWhere(function ($q) use ($search) {
                    $q->orwhereHas('restaurant', function ($q) use ($search) {
                        return $q->where('restaurants.name', 'like', "%$search%");
                    });
                });
            }



            if (Auth::guard('admin')->user()->role_id == config('admin.constants.SUB_ADMIN_ROLE')) {

                $query->whereHas('users', function ($q) {
                    //  $q->where('facility_id', Auth::guard('admin')->user()->facility_id);
                    $q->where('role_id', config('admin.constants.PUBLIC_USERS_ROLE'));
                });
            }

            $contactSupportList = $query->sortable(['id' => 'desc'])->paginate($limit);
            // dd($contactSupportList);

            $data['contactSupportList'] = $contactSupportList;
            $data = array_merge($data, $this->const, $this->breadCrumb);
            return \View('Admin.' . $this->controllerUri . '.index')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }
}
