<?php

namespace app\Http\Controllers\Admin;

use app\Http\Controllers\Admin\BaseController;
use app\Model\Admin\Role;
use app\Model\Admin\User;
use app\Model\Admin\GeneralSetting;
use Auth;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class CommisionSettingController extends BaseController
{
    private $const;
    private $roleId;
    private $roleName;
    private $breadCrumb;
    private $url;
    private $title;
    private $subTitle;
    private $controllerUri;
    private $actionUri;

    /**
     * @Method: __construct()
     * @Scope: public
     * @Params: null
     * @Description: Initialize variables like  @roleId, @roleName, @url within private scope of current class
     * @Created 28/Apr/2021
     * @Updated 28/Apr/2021
     */
    public function __construct(GeneralSetting $generalSetting)
    {
        try {
            parent::__construct();
            $this->middleware('auth.admin');

            //fixed role for this module
            $this->roleId = config('admin.constants.PUBLIC_USERS_ROLE');
            $role = Role::select('name')->where('id', $this->roleId)->first();
            if ($role->name) {
                $this->roleName = $role->name;
            }

            $this->url = config('admin.path.ADMIN_BASE_URL') . '/commission-setting';
            $this->title = 'Commission Fee Setting';
            $this->controllerUri = 'commission-setting';

            $this->const['url'] = $this->url;
            $this->const['title'] = $this->title;
            $this->const['controllerUri'] = $this->controllerUri;
            $this->const['roleId'] = $this->roleId;
            $this->const['roleName'] = $this->roleName;

            //used in adminForm layout to load validation messges in js variable
            $this->const['objValidationMsgs'] = 'general-setting-commission';
            $this->const['objValidationJs'] = 'general-setting-commission';


            //merge constant into single array with parent controller values
            $this->const = array_merge($this->adminConst(), $this->const);

            //default breadcrumb option (Dashboard) for every route
            $this->breadCrumb['faClass'] = 'fa-table';
            $this->breadCrumb['breadCrumData'] = [
                0 => [
                    'text' => 'Dashboard',
                    'url' => config('admin.path.ADMIN_BASE_URL'),
                    'breadFaClass' => 'fa-dashboard',
                ],

            ];
            $this->generalSetting = $generalSetting;
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * Author: Bibhash
     * Email: bibhash.shisodiya@nmgtechnologies.com
     * @Method: index()
     * @returns: A Row return of commission charges for admin
     * @Description: This function fetches  admin commission from database, sets up
     *  breadcrumb & other constants. 
     * @Created 21/June/2021
     * @Updated 21/June/2021
     */
    public function index(Request $request)
    {
        try {
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->const['title'],
            ];
            $page = $request->query('page', 1); 
            $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
            $this->const['page'] = $page;
            $this->const['limit'] = $limit;
            $generalSetting = $this->generalSetting->commission($request);
            $data['CommissionSetting'] = $generalSetting;
            $data = array_merge($data, $this->const, $this->breadCrumb);
            return \View('Admin.commission-setting.index')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * Author: Bibhash
     * Email: bibhash.shisodiya@nmgtechnologies.com
     * @Method: edit()
     * @returns: A Row return of commission charges for admin
     * @Description: This function fetches  admin commission from database, sets up
     *  breadcrumb & other constants. 
     * @Created 21/June/2021
     * @Updated 21/June/2021
     */
    public function edit($id)
    {
        try {


            // method/action specific initializations
            $this->subTitle = 'Edit';
            $this->actionUri = 'edit';
            $formId = 'createCommissionCharge';

            //pre-populated data
            $this->const['subTitle'] = $this->subTitle;
            $this->const['actionUri'] = $this->actionUri;
            $this->const['formId'] = $formId;
            $this->const['roles'] = [$this->roleId => $this->roleName];

            //push current controller then method in breadcrumb at position 1 & 2
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->title,
                'url' => $this->url,
                'breadFaClass' => '',
            ];
            $this->breadCrumb['breadCrumData'][2] = [
                'text' => $this->subTitle,
                'breadFaClass' => 'active',
            ];

            $id = \Crypt::decryptString($id);

            $commission = \app\Model\Admin\GeneralSetting::select('*')->where('id', $id)->first();
            $data['userDetail'] = $commission;

            $data = array_merge($data, $this->const, $this->breadCrumb);
            return \View('Admin.' . $this->controllerUri . '.edit')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * Author: Bibhash
     * Email: bibhash.shisodiya@nmgtechnologies.com
     * @Method: update()
     * @returns: A Row return of commission charges for admin
     * @Description: This function updated admin Service fee to database.
     * @Created 21/June/2021
     * @Updated 21/June/2021
     */
    public function update(Request $request, $id)
    {
        try {
            $id = \Crypt::decryptString($id);
            if ($request->isMethod('put')) {
                $rollBack = false;
                DB::beginTransaction();
                $input = Input::except(['_token']);
                $model = new \app\Model\Admin\GeneralSetting();

                    $commission = \app\Model\Admin\GeneralSetting::find($id);
                    $commission->value = $input['admin_commison'];
                    $recdUpdated = $commission->save();

                if ($recdUpdated) {
                    DB::commit();
                    \Session::flash('success', __('admin/flash_msg.success.AdminCommissionUpdated'));
                    return redirect()->to($this->url);
                }
                else {
                        return redirect()->back()->withInput()->with('error', __('admin/flash_msg.error.UnableToUpdate'));
                    }
            }
        } catch (\Exception $e) {
            DB::rollBack();
            $this->saveErrorLog($e);
            return redirect()->back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }

    }
}
