<?php

namespace app\Http\Controllers\Admin;

use app\Http\Controllers\Admin\BaseController;
use app\Model\Admin\BlockedUser;
use app\Model\Admin\User;
use DB;
use Auth;
use Illuminate\Http\Request;

class BlockedUsersController extends BaseController
{
    private $const;
    private $breadCrumb;
    private $url;
    private $title;
    private $subTitle;
    private $controllerUri;
    private $actionUri;

    /**
     * @Method: __construct()
     * @Scope: public
     * @Params: null
     * @Description: Initialize variable with module scope, breadcrumb
     * @Created 16/Jan/2020
     * @Updated 16/Jan/2020
     */
    public function __construct()
    {
        try {
            parent::__construct();
            $this->middleware('auth.admin');

            $this->url = config('admin.path.ADMIN_BASE_URL') . '/blocked-users';
            $this->title = 'Reported (Inappropriate) Users';
            $this->controllerUri = 'blocked-users';

            //department logo path & base urls
            $this->const['url'] = $this->url;
            $this->const['title'] = $this->title;
            $this->const['controllerUri'] = $this->controllerUri;

            //used in adminForm layout to load validation messges in js variable
            $this->const['objValidationMsgs'] = 'blocked-user';
            $this->const['objValidationJs'] = 'blocked-users';

            $this->const = array_merge($this->adminConst(), $this->const);

            //default breadcrumb option (Dashboard) for every route
            $this->breadCrumb['faClass'] = 'fa-table';
            $this->breadCrumb['breadCrumData'] = [
                0 => [
                    'text' => 'Dashboard',
                    'url' => config('admin.path.ADMIN_BASE_URL'),
                    'breadFaClass' => 'fa-dashboard',
                ],

            ];
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Method: index()
     * @Scope: public
     * @Params: @page, @limit, @search
     * @returns: Display a listing of the resource
     * @Description: display the listing of blocked users
     * @Created 16/Jan/2020
     * @Updated 16/Jan/2020
     */
    public function index(Request $request)
    {
        try {

            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->const['title'],
            ];
            $page = $request->query('page', 1);
            $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
            $this->const['page'] = $page;
            $this->const['limit'] = $limit;

            $search = !empty($request->search) ? $request->search : '';

            $data = [];
            $query = BlockedUser::select(
                'blocked_users.id',
                'blocked_users.user_id',
                'blocked_users.blocked_by',
                'blocked_users.blocked_reason_id',
                'blocked_users.created_at',
                'blocked_users.status'
            )->with(['users', 'blockedBy', 'blockedReason']);

            if (!empty($search)) {
                $query->whereHas('users', function ($query) use ($search) {
                    $query->where('user_name', 'like', '%' . $search . '%');
                });
            }

            // if (Auth::guard('admin')->user()->role_id == config('admin.constants.SUB_ADMIN_ROLE')) {
            //     $query->whereHas('users', function($q){
            //         $q->where('facility_id', Auth::guard('admin')->user()->facility_id);
            //         $q->where('role_id', config('admin.constants.PUBLIC_USERS_ROLE'));
            //     });
            // }

            $blockUserList = $query->sortable(['id' => 'desc'])->paginate($limit);

            ########### download spreadsheet/pdf #######
            $blockUserListListX = $blockUserList;

            $outData = [];

            foreach ($blockUserListListX as $key => $blockUser) {

                $outData[$key]['id'] = $blockUser->id;
                $outData[$key]['full_name'] = $blockUser->users->full_name;
                $outData[$key]['blocked_by'] = $blockUser->blockedBy->full_name;
                $outData[$key]['blocked_reason_id'] = $blockUser->blockedReason->reason;
                $outData[$key]['created_at'] = $blockUser->created_at;
            }

            if ($request->input('xlsx') == true) {
                $columnHeaders = [
                    'id' => 'ID',
                    'full_name' => 'Blocked User',
                    'blocked_by' => 'Blocked By',
                    'blocked_reason_id' => 'Reason',
                    'created_at' => 'Blocked On',
                ];
                $this->exportXlsx($columnHeaders, $outData, 'blocked-users');
            }
            if ($request->input('csv') == true) {
                $columnHeaders = [
                    'id' => 'ID',
                    'full_name' => 'Blocked User',
                    'blocked_by' => 'Blocked By',
                    'blocked_reason_id' => 'Reason',
                    'created_at' => 'Blocked On',
                ];
                $this->exportCsv($columnHeaders, $outData, 'blocked-users');
            }
            if ($request->input('pdf') == true) {
                $pdfData['title'] = $this->const['title'];
                $pdfData['blockUserListX'] = $blockUserList;
                $pdfView = \View('Admin.' . $this->controllerUri . '.pdf', $pdfData)->render();
                $this->exportPdf($pdfView);
            }
            #############################

            $data['blockUserList'] = $blockUserList;
            $data = array_merge($data, $this->const, $this->breadCrumb);
            return \View('Admin.' . $this->controllerUri . '.index')->with($data);
        } catch (\Exception $e) {
            dd($e);
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Method: edit()
     * @Scope: public
     * @params: @id
     * @Description: using for user blocked and unblocked by the superadmin
     * @Created 21/Jan/2020
     * @Updated 21/Jan/2020
     */
    public function edit(Request $request)
    {
        try {
            if (request()->ajax()) {

                if (request()->isMethod('get')) {

                    if (request()->isJson()) {
                        $input = request()->json()->all();
                    } else {
                        $input = request()->all();
                    }
                    $id = \Crypt::decryptString($input['id']);
                    $modelStatus = DB::table('blocked_users')->select('status')->find($id);
                    $modelData = array('status' => '1');
                    $modelValue = array('status' => '<span style="cursor:pointer" class="fa fa-unlock-alt" title="Unblocked"></span>');

                    if ($modelStatus->status == '1') {
                        $modelData = array('status' => '0');
                        $modelValue = array('status' => '<span style="cursor:pointer" class="fa fa-fw fa-ban" title="Blocked"></span>');

                        $result = DB::table('blocked_users')->where('id', $id)->update($modelData);
                    } else {
                        $result = DB::table('blocked_users')->where('id', $id)->update($modelData);
                    }
                    if ($result) {
                        $status = '1';
                    }
                }
                return response()->json(['success' => $status, 'changeStatus' => $modelValue, 'id' => $id]);
            }
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Method: destroy()
     * @Scope: public
     * @params: @id
     * @Description: blocked the users.
     * @Created 16/Jan/2020
     * @Updated 16/Jan/2020
     */
    public function destroy(Request $request, $id = null)
    {
        try {
            $id = \Crypt::decryptString($id);
            if(!empty($id)){

            $recordDel = BlockedUser::find($id)->delete();

            if (!empty($recordDel)) {
                \Session::flash('success', __('admin/flash_msg.success.blockedUserDeleted'));
            }

            }

            return \Redirect::to($this->url);

        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }
}
