<?php

/**
 * @Description: The `BaseController` have all the common methods or properties access throught
 *  the admin panel as all admin controller calss will extend it.
 * @auther: NMG - PR
 * @dated: 19/Nov/2019
 */

namespace app\Http\Controllers\Admin;

use app\Http\Controllers\Controller;
use Auth;
use File;
use Illuminate\Http\Request;

class BaseController extends Controller
{
    /**
     * @Method: __construct()
     * @Scope: public
     * @Description: Verify admin authentication & redirect request to corresponding controllers
     * @Created 19/Nov/2019
     * @Updated 19/Nov/2019
     */
    public function __construct()
    {
        $this->middleware('auth.admin');
        $this->middleware(function ($request, $next) {
            $this->user = Auth::guard('admin')->user();
            if (!$this->user) {
                //dd($request);
                return \Redirect::to(config("admin.constants.ADMIN_ROUTE_NAME"));
            }
            return $next($request);
        });
    }
    /**
     * @Method: adminConst()
     * @Scope: public
     * @returns: commonly used constants thoughout the admin or CMS
     * @Description: All the child class inherit these constants
     * @Created 27/Nov/2019
     * @Updated 13/Sep/2021
     * @updateDesc : added defaultRestaurantImage 
     * @updateBy : jaidev@nmgtechnologies.com
     */
    public function adminConst()
    {
        $const = [];
        $const['baseUrl'] = config('admin.path.BASE_URL');
        $const['adminUrl'] = config('admin.path.ADMIN_BASE_URL');

        // $const['defaultAvatarUrl'] = config('admin.path.avatar.DEFAULT_URL');
        $const['defaultAvatarUrl'] = config('admin.path.avatar.RESTAURANT_DEFAULT_IMAGE');
        $const['defaultRestaurantImage'] = config('admin.path.avatar.RESTAURANT_DEFAULT_IMAGE');
        $const['avatarBaseUrl'] = config('admin.path.avatar.BASE_URL');
        $const['avatarStoragePath'] = config('admin.path.STORAGE_DIR') .
            config('admin.path.UPLOAD_DIR') . '/' .
            config('admin.path.avatar.DIR');
        $const['restaurantItemPath'] = config('admin.path.STORAGE_DIR') . config('admin.path.UPLOAD_DIR') . '/' . config('admin.path.avatar.RESTAURANT_ITEM_DIR');
        return $const;
    }
    /**
     * @Method: changeStatus()
     * @Scope: public
     * @Params: null
     * @returns: jsondata with success or failure messages
     * @Description: It is used by several child controller to change the status of particular
     *  records they have and if required.
     * @Created 19/Nov/2019
     * @Updated 19/Nov/2019
     */
    public function changeStatus(Request $request)
    {
        try {
            $status = 0;
            if ($request->isMethod('post')) {
                if ($request->isJson()) {
                    $input = $request->json()->all();
                } else {
                    $input = $request->all();
                }
                $id = \Crypt::decryptString($input['id']);
                $model = \Crypt::decryptString($input['model']);
                $modelStatus = \DB::table($model)->select('status')->find($id);
                $modelData = array('status' => '1');
                $modelValue = array('status' => '<span class="glyphicon glyphicon-ok" title="Inactive"></span>');

                if ($modelStatus->status == '1') {
                    $modelData = array('status' => '0');
                    $modelValue = array('status' => '<span class="glyphicon glyphicon-remove" title="Active"></span>');

                    $result = \DB::table($model)->where('id', $id)->update($modelData);
                } else {
                    $result = \DB::table($model)->where('id', $id)->update($modelData);
                }
                if ($result) {
                    $status = '1';
                }
            }
            return response()->json(['success' => $status, 'changeStatus' => $modelValue, 'id' => $id]);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return response()->json(['success' => 0, 'message' => __('admin/flash_msg.error.SomethingWrong')]);
        }
    }

    /**
     * @Method: facilityUUID()
     * @Scope: public
     * @Params: null
     * @returns: return a unique 10 digit number for the facility
     * @Description: It is used to have a uuid for facility(hospital)
     * @Created 28/Nov/2019
     * @Updated 28/Nov/2019
     */
    public function facilityUUID($digits = 10)
    {
        $uuid = rand(pow(10, $digits - 1), pow(10, $digits) - 1);
        if (Facility::where('uuid', $uuid)->exists()) {
            $this->facilityUUID($digits);
        }
        return $uuid;
    }

    /**
     * @Method: exportXlsx()
     * @Scope: public
     * @Params: $columns(headers for xls), $dataRows (cell values), $sheetName (filename to downlaod)
     * @Description: This function will download xlsx file for the current list of records
     * @Created 06/Dec/2019
     * @Updated 06/Dec/2019
     */
    public function exportXlsx($columns, $dataRows, $sheetName)
    {
        if (is_array($columns) && count($columns) > 0) {
            $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();
            $headers = $cells = [];
            $asscii = 65;
            foreach ($columns as $key => $value) {
                $headers[$key] = $value;
                $cells[$key] = chr($asscii);
                $asscii++;
            }

            //write spreadsheet headers
            foreach ($headers as $key => $header) {
                $sheet->setCellValue($cells[$key] . '1', $header);
                $sheet->getStyle($cells[$key] . '1')->applyFromArray(['font' => ['bold' => true]]);
            }
            // write cell values
            $i = 2;
            foreach ($dataRows as $row) {
                foreach ($headers as $key => $header) {
                    if (is_array($row)) {
                        $row = (object) $row;
                    }
                    if (isset($row->{$key})) {
                        if ($key == 'status') {
                            $row->{$key} = ($row->{$key} == 1) ? 'Active' : 'In-active';
                        }
                        $sheet->setCellValue($cells[$key] . $i, $row->{$key});
                    }
                }
                $i++;
            }
            $filename = $sheetName . date('Ymd') . '-' . date('His');
            //write to a folder
            //$writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
            //direct download
            $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xls');
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment; filename="' . $filename . '.xls"');
            $writer->save("php://output");
        }
    }

    /**
     * @Method: exportCsv()
     * @Scope: public
     * @Params: $columns(headers for csv), $dataRows (cell values), $sheetName (filename to downlaod)
     * @Description: This function will download csv file for the current list of records
     * @Created 06/Dec/2019
     * @Updated 06/Dec/2019
     */
    public function exportCsv($columns, $dataRows, $sheetName)
    {
        // No point in creating the export file on the file-system. We'll stream
        // it straight to the browser. Much nicer.

        // Open the output stream
        $fh = fopen('php://output', 'w');

        // Start output buffering (to capture stream contents)
        ob_start();

        // CSV Header
        $header = $columns;
        fputcsv($fh, $header);

        // CSV Data
        foreach ($dataRows as $row) {
            foreach ($columns as $key => $val) {
                if ($key == 'status') {
                    if (is_object($row)) {
                        $row->$key = ($row->{$key} == 1) ? 'Active' : 'In-active';
                    } else {
                        $row[$key] = ($row[$key] == 1) ? 'Active' : 'In-active';
                    }
                }
                if (is_object($row)) {
                    $line[$key] = $row->$key;
                } else {
                    $line[$key] = $row[$key];
                }
            }
            fputcsv($fh, $line);
        }

        // Get the contents of the output buffer
        $string = ob_get_clean();

        // Set the filename of the download
        $filename = $sheetName . date('Ymd') . '-' . date('His');

        // Output CSV-specific headers
        header('Pragma: public');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Cache-Control: private', false);
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $filename . '.csv";');
        header('Content-Transfer-Encoding: binary');

        // Stream the CSV data
        exit($string);
    }

    /**
     * @Method: exportPdf()
     * @Scope: public
     * @Params: $pdfView( A complete html layout to display list of records in pdf for current controller)
     * @Description: This function uses wkhtmltopdf binary executable to convert html content to pdf
     * @Created 06/Dec/2019
     * @Updated 06/Dec/2019
     */
    public function exportPdf($pdfView)
    {
        $pdf = new \mikehaertl\wkhtmlto\Pdf();
        $globalOptions = [
            'orientation' => 'portrait',
            'margin-top' => 15,
            'margin-right' => 5,
            'margin-bottom' => 15,
            'margin-left' => 5,
        ];
        $pdf->setOptions($globalOptions);
        $pdf->binary = env('WKHTMLTOPDF_PATH', '/usr/bin/wkhtmltopdf'); //use whereis
        $pdf->addPage($pdfView);
        if (!$pdf->send()) {
            throw new \Exception('Could not create PDF: ' . $pdf->getError());
        }

        $content = $pdf->toString();
        if ($content === false) {
            throw new \Exception('Could not create PDF: ' . $pdf->getError());
        }
    }

    /**
     * @Method: uploadEditorImageUpload()
     * @Scope: public
     * @params: $request
     * @Description: upload tinymce image on server
     * @Created 30/Dec/2019
     * @Updated 30/Dec/2019
     */
    public function uploadEditorImageUpload($files, $type)
    {

        $accepted_origins = array("http://localhost", "http://127.0.0.1", "http://demo.newmediaguru.co");

        $uploadDir = config('admin.path.UPLOAD_DIR');
        if ($type == 'email') {
            $staicPagesDir = config('admin.path.emailTemplate.DIR');
            $staticPageBaseUrl = config('admin.path.emailTemplate.BASE_URL');
        } else if ($type == 'staticPage') {
            $staicPagesDir = config('admin.path.emailTemplate.DIR');
            $staticPageBaseUrl = config('admin.path.emailTemplate.BASE_URL');
        } else if ($type == 'mailbox') {
            $staicPagesDir = config('admin.path.mailbox.DIR');
            $staticPageBaseUrl = config('admin.path.mailbox.BASE_URL');
        }
        $imageFolder = storage_path('app/public') . '/' . $uploadDir . '/' . $staicPagesDir . '/';

        if (!File::exists($imageFolder)) {
            File::makeDirectory($imageFolder, 0755, true);
        }

        reset($files);
        $temp = current($files);
        if (is_uploaded_file($temp['tmp_name'])) {
            if (isset($_SERVER['HTTP_ORIGIN'])) {
                // same-origin requests won't set an origin. If the origin is set, it must be valid.
                if (in_array($_SERVER['HTTP_ORIGIN'], $accepted_origins)) {
                    header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
                } else {
                    header("HTTP/1.0 403 Origin Denied");
                    return;
                }
            }
            /*
            If your script needs to receive cookies, set images_upload_credentials : true in
            the configuration and enable the following two headers.
             */
            // header('Access-Control-Allow-Credentials: true');
            // header('P3P: CP="There is no P3P policy."');

            // Sanitize input
            if (preg_match("/([^\w\s\d\-_~,;:\[\]\(\).])|([\.]{2,})/", $temp['name'])) {
                header("HTTP/1.0 500 Invalid file name.");
                return;
            }

            // Verify extension
            if (!in_array(strtolower(pathinfo($temp['name'], PATHINFO_EXTENSION)), array("gif", "jpg", "jpeg", "png"))) {
                header("HTTP/1.0 500 Invalid extension.");
                return;
            }

            // Accept upload if there was no origin, or if it is an accepted origin
            $filetowrite = $imageFolder . $temp['name'];
            move_uploaded_file($temp['tmp_name'], $filetowrite);
            // Respond to the successful upload with JSON.
            // Use a location key to specify the path to the saved image resource.
            // { location : '/your/uploaded/image/file'}
            echo json_encode(array('location' => $staticPageBaseUrl . '/' . $temp['name']));
        } else {
            // Notify editor that the upload failed
            header("HTTP/1.0 500 Server Error");
        }
    }

    /**
     * @Method: getDepartment()
     * @Scope: public
     * @params: @id
     * @Description: dropdown display department and subdepartment depth level
     * @Created 09/Jan/2020
     * @Updated 09/Jan/2020
     */
    public function getDepartment()
    {
        try {

            if (request()->ajax()) {

                if (request()->isMethod('get')) {
                    $success = false;
                    $titleSuccess = false;
                    $html = '';
                    $titleHtml = '';

                    if (request()->isJson()) {
                        $input = request()->json()->all();
                    } else {
                        $input = request()->all();
                    }

                    if (!empty($input['facility_id'])) {

                        $departmentArr = Department::where('facility_id', $input['facility_id'])->get();

                        $titleArr = Title::where('facility_id', $input['facility_id'])->get();

                        if (count($departmentArr)) {


                            $html .= '<option value="">--Choose One--</option>';
                            foreach ($departmentArr as $dept) {
                                $html .= '<option value=' . $dept->id . '>' . $dept->name . '</option>';
                            }
                            $success = true;
                        }

                        if (count($titleArr)) {


                            $titleHtml .= '<option value="">--Choose One--</option>';
                            foreach ($titleArr as $title) {
                                $titleHtml .= '<option value=' . $title->id . '>' . $title->name . '</option>';
                            }
                            $titleSuccess = true;
                        }
                    }
                }
                return response()->json(['success' => $success, 'titleSuccess' => $titleSuccess, 'html' => $html, 'titleHtml' => $titleHtml]);
            }
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }
}
