<?php

namespace app\Http\Controllers\Admin;

use app\Http\Controllers\Controller;
use app\Http\Controllers\Admin\BaseController;
use app\Model\Admin\UpdateApp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Validator;


class AppUpdateController extends BaseController
{

    private $const;
    private $roleId;
    private $roleName;
    private $breadCrumb;
    private $url;
    private $title;
    private $subTitle;
    private $controllerUri;
    private $actionUri;


    /**
     * @Method: __construct()
     * @Scope: public
     * @Params: null
     * @Description: Initialize variable with module scope, breadcrumb
     * @Created 25/Aug/2021
     * @Updated 25/Aug/2021
     */
    public function __construct()
    {
        try {
            parent::__construct();
            $this->middleware('auth.admin');
            $this->url = \Config::get('admin.path.ADMIN_BASE_URL') . '/app-version';
            $this->title = 'Manage App Version';
            $this->controllerUri = 'app-version';
            $this->const['url'] = $this->url;
            $this->const['title'] = $this->title;
            $this->const['controllerUri'] = $this->controllerUri;
            $this->const['objValidationMsgs'] = 'app-version';
            $this->const['objValidationJs'] = 'app-version';
            $this->const = array_merge($this->adminConst(), $this->const);

            $this->breadCrumb['faClass'] = 'fa-table';
            $this->breadCrumb['breadCrumData'] = [
                0 => [
                    'text' => 'Dashboard',
                    'url' => \Config::get('admin.path.ADMIN_BASE_URL'),
                    'breadFaClass' => 'fa-dashboard',
                ],

            ];
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Method: index()
     * @Scope: public
     * @Params: @page, @limit, @search
     * @return \Illuminate\Http\Response.
     * @Created 26/Aug/2021
     */

    public function index(Request $request)
    {
        try {
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->const['title'],
            ];
            $page = $request->query('page', 1);
            $limit = $request->query('limit', config('admin.constants.DEFAULT_PAGE_LIMIT'));
            $this->const['page'] = $page;
            $this->const['limit'] = $limit;

            $appVersion = UpdateApp::get();
            $this->data['appVersion'] = $appVersion;

            $data = array_merge($this->data, $this->const, $this->breadCrumb);
            return \View('Admin.' . $this->controllerUri . '.index')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Method: edit()
     * @Scope: public
     * @Params: @page, @limit, @search
     * @return \Illuminate\Http\Response.
     * @Created 26/Aug/2021
     */

    public function edit($id)
    {
        try {
            $this->subTitle = 'Edit';
            $this->actionUri = 'edit';
            $formId = 'appVersionForm';
            //pre-populated data
            $this->const['subTitle'] = $this->subTitle;
            $this->const['actionUri'] = $this->actionUri;
            $this->const['formId'] = $formId;

            //push current controller then method in breadcrumb at position 1 & 2
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->title,
                'url' => $this->url,
                'breadFaClass' => '',
            ];
            $this->breadCrumb['breadCrumData'][2] = [
                'text' => $this->subTitle,
                'breadFaClass' => 'active',
            ];

            $id = \Crypt::decryptString($id);
            $appVersion = UpdateApp::FindOrFail($id);

            $data['appVersion'] = $appVersion;

            $data = array_merge($data, $this->const, $this->breadCrumb);
            return \View('Admin.' . $this->controllerUri . '.edit')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }
    /**
     * @Name: Akshay
     * @Method: show()
     * @Scope: public
     * @params  int  $id
     * @Description: Show the form for editing the specified resource.
     * @Created 26/Aug/2021
     * @Updated 26/Aug/2021
     */
    public function show($id)
    {

        try {
            // method/action specific initializations
            $this->subTitle = 'Edit';
            $this->actionUri = 'edit';
            $formId = 'appVersionForm';
            //pre-populated data
            $this->const['subTitle'] = $this->subTitle;
            $this->const['actionUri'] = $this->actionUri;
            $this->const['formId'] = $formId;

            //push current controller then method in breadcrumb at position 1 & 2
            $this->breadCrumb['breadCrumData'][1] = [
                'text' => $this->title,
                'url' => $this->url,
                'breadFaClass' => '',
            ];
            $this->breadCrumb['breadCrumData'][2] = [
                'text' => $this->subTitle,
                'breadFaClass' => 'active',
            ];
            $id = \Crypt::decryptString($id);
            $appVersion = UpdateApp::FindOrFail($id);

            $this->data['appVersion'] = $appVersion;

            $data = array_merge($this->data, $this->const, $this->breadCrumb);
            return \View('Admin.' . $this->controllerUri . '.edit')->with($data);
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }

    /**
     * @Name: Sandeep
     * @Method: update()
     * @Scope: public
     * @params: @id
     * @input: @name, @status
     * @Description: Update the specified resource in storage.
     * @Created 25/Aug/2021
     * @Updated 25/Aug/2021
     */
    public function update(Request $request, $id = null)
    {
        try {
            $id = \Crypt::decryptString($id);
            $updateApp = UpdateApp::FindOrFail($id);
            if ($request->isMethod('put')) {
                $input = Input::all();
                $validator = Validator::make($input, UpdateApp::Rules($id), UpdateApp::messages());

                if ($validator->fails()) {
                    return \Redirect::back()->withInput()->withErrors($validator->errors());
                } else {
                    $input['id'] = $updateApp->id;
                    unset($input['_method']);
                    unset($input['_token']);
                    $updateApp->fill($input)->save();

                    \Session::flash('success', __('admin/flash_msg.success.AppVersion'));
                    return \Redirect::to($this->url);
                }
            }
        } catch (\Exception $e) {
            $this->saveErrorLog($e);
            return \Redirect::back()->withInput()->with('error', __('admin/flash_msg.error.SomethingWrong'));
        }
    }
}
