<?php
namespace app\Helpers;
use app\Model\Admin\User;

class ResizeImagesHelper
{
    /** 
     * @Method: resizeImage()
     * @Description: Get image resize url.
     * @Created 06/Sep/2021
     * @Updated 06/Sep/2021
     * 
     */

     static public function resizeImage($imageUrl){
         
         $imageHeight = request()->header('height');
         $imageWidth = request()->header('width');
         $replaceImageUrl = str_replace(env('AWS_BASE_URL'),env('AWS_RESIZE_URL'),$imageUrl);
         
         if(!empty($imageWidth) && !empty($imageHeight)){

           $imageResizeUrl = $replaceImageUrl.'?height=' . $imageHeight .'&width=' . $imageWidth;

         }else if(!empty($imageHeight)){

           $imageResizeUrl = $replaceImageUrl.'?height=' . $imageHeight;

         }else if(!empty($imageWidth)){
           
           $imageResizeUrl = $replaceImageUrl.'?width=' . $imageWidth;
         }
         
         return $imageResizeUrl;
    } 
}