<?php
namespace app\Helpers;
use app\Model\Admin\User;

class LatLongHelper
{
    /** 
     * @Method: getLongAndLat()
     * @Description: Get latitude and longitude value.
     * @Created 05/July/2021
     * @Updated 05/July/2021
     * 
     */

    public static function getLongAndLat($address){
        
        $apiKey = env('ADDRESS_API_KEY'); // Google maps now requires an API key.
        
        // Get JSON results from this request
        $geo = file_get_contents('https://maps.googleapis.com/maps/api/geocode/json?address='.urlencode($address).'&sensor=false&key='.$apiKey);
        $geo = json_decode($geo, true); // Convert the JSON to an array
        
        $data = array();
        if (isset($geo['status']) && ($geo['status'] == 'OK')) {
           $data['latitude'] = $geo['results'][0]['geometry']['location']['lat']; // Latitude
           $data['longitude'] = $geo['results'][0]['geometry']['location']['lng']; // Longitude
        }
        return $data;
    } 
}
