<?php

namespace app\Helpers;

use app\Model\Admin\User;
use app\Traits\FilePathUrl;
use app\Model\Admin\Facility;
use app\Model\Admin\GroupImage;
use app\Model\Admin\PubnubImage;
use app\Model\Admin\GeneralSetting;
use app\Model\Admin\FoodCategory;
use app\Model\Admin\Restaurant_menu;

class CommonHelper
{
    use FilePathUrl;
    public static function getuserAvatarUri($user_id = null)
    {
        if (empty($user_id)) {
            return false;
        }
        $arrImage = self::userAvatar($user_id);
        return !empty($arrImage['origional']) ? self::userAvatar($user_id) : false;
        //return self::userAvatar($user_id);

    }

    /**
     * Customer Avtar
     */
    public static function getCustomerAvatarUri($user_id = null)
    {
        if (empty($user_id)) {
            return false;
        }
        $arrImage = self::customerAvatar($user_id);
        return !empty($arrImage['origional']) ? self::customerAvatar($user_id) : false;
        //return self::userAvatar($user_id);

    }

    public static function getdeliveryDocUri($id = null, $f = null)
    {
        if (empty($id)) {
            return false;
        }
        $arrImage = self::deliverypIdproof($id, $f);
        return !empty($arrImage['origional']) ? self::deliverypIdproof($id, $f) : false;
        //return self::userAvatar($user_id);

    }

    public static function getrestaurantPic($user_id = null)
    {
        if (empty($user_id)) {
            return false;
        }
        $arrImage = self::restaurantPic($user_id);
        return !empty($arrImage['origional']) ? self::restaurantPic($user_id) : false;
        //return self::userAvatar($user_id);

    }

    public static function getfacilityImageUri($facility_id = null)
    {
        if (empty($facility_id)) {
            return false;
        }

        $arrImage = self::facilityImage($facility_id);
        return !empty($arrImage['origional']) ? self::facilityImage($facility_id) : false;
        //return self::facilityImage($facility_id);

    }

    public static function getGroupImageUri($space_id = null)
    {
        if (empty($space_id)) {
            return false;
        }

        $arrImage = self::getGroupImage($space_id);
        return !empty($arrImage['original']) ? self::getGroupImage($space_id) : false;
        //return self::facilityImage($space_id);

    }

    public static function getPubNubImageUri($user_id = null)
    {
        if (empty($user_id)) {
            return false;
        }

        $arrImage = self::getPubNubImage($user_id);
        return !empty($arrImage['original']) ? self::getPubNubImage($user_id) : false;
        //return self::facilityImage($space_id);

    }

    public static function getPubNubAudioUri($user_id = null)
    {
        if (empty($user_id)) {
            return false;
        }

        $arrImage = self::getPubNubAudio($user_id);
        return !empty($arrImage['original']) ? self::getPubNubAudio($user_id) : false;
        //return self::facilityImage($space_id);

    }


    public static function calculateDeliveryFees($distance)
    {
        // Delivery charges = Fixed DC  + ((distance - minDistanceForDC) * perMileDC)
        $fixedDeliveryCharge = GeneralSetting::getDeliveryCharges();
        $perMileCharges = GeneralSetting::getMileCharges();
        $minDistanceForDC = GeneralSetting::dcApplicableAfter();
        if ($distance <= $minDistanceForDC) {
            return (float) $fixedDeliveryCharge;
        } else {
            return (float) ($fixedDeliveryCharge + ($perMileCharges * ($distance - $minDistanceForDC)));
        }
    }


    public static function getAddressType($type)
    {
        $addressType[1] = 'Home';
        $addressType[2] = 'Work';
        $addressType[3] = 'Other';

        return (array_key_exists($type, $addressType) ? $addressType[$type] : null);
    }

    public static function getRoleName($roleId)
    {
        $role[1] = 'Admin';
        $role[2] = 'Restaurant';
        $role[3] = 'User';

        return (array_key_exists($roleId, $role) ? $role[$roleId] : null);
    }

    public static function getRoleForNotification($roleId, $actionId = false)
    {
        $role[1] = 'Admin';
        $role[2] = 'Restaurant';
        $role[3] = 'User';
        $role[4] = 'Delivery Person';
        if ($roleId == 3 && in_array($actionId, [config('api.constants.push_notification.actionId.rider_order_details'), config('api.constants.push_notification.actionId.rider_profile')])) {
            $roleId = 4;
        }

        return (array_key_exists($roleId, $role) ? $role[$roleId] : null);
    }

    public static function getTransactionMode($modeType)
    {
        $mode[1] = 'Online';
        $mode[2] = 'Cash on delivery';

        return (array_key_exists($modeType, $mode) ? $mode[$modeType] : null);
    }

    /*public static function imageUpload($fileKey, $file){
        try {

            $file_info = new \finfo(FILEINFO_MIME_TYPE);
            $mime_type = $file_info->buffer(file_get_contents($file));

            $extArr = explode(".", $fileKey);
            $ext = end($extArr);
            $fileArr = explode('/', $fileKey);
            $fileName = end($fileArr);

            $s3Client = \AWS::createClient('s3');
            $req = $s3Client->putObject([
                'Key' => $fileKey,
                'Body' => file_get_contents($file),
                'ContentType' => $mime_type,
                'Bucket' => env('AWS_BUCKET'),
            ]);
            return $fileName;
        } catch (\Exception $e) {
            \App\Http\Controllers\Api\BaseController::saveErrorLog($e);

        }

    }

    public static function getImageUri($user_id = null){
        try {

            if (empty($user_id)) {
                return false;
            }

            $arrImage = self::userAvatar($user_id);
            return !empty($arrImage['origional']) ? self::userAvatar($user_id) : false ;

        } catch (\Exception $e) {
            \App\Http\Controllers\Api\BaseController::saveErrorLog($e);
            //echo $e->getMessage();
        }

    }*/

    /**
     * Author: NMG
     * function: userAvatar
     * Description: Generate user image of image path by just providing user id
     * Input: user id, image_id(optional), is_url(flag)
     * output: ['key'(for s3 url generation)] or ['origioanl image', 'resized image', 'thumb image']
     * Dated: 05/September/2019
     */
    /*public static function userAvatar($user_id = null, $isUrl = true)
    {
        if (empty($user_id)) {
            return false;
        }

        $localStoragePath = config('admin.path.STORAGE_DIR');

        $uploadDir = config('admin.path.UPLOAD_DIR');
        $avatarDir = config('admin.path.avatar.DIR');

        $resizedPrefix = config('admin.path.avatar.RESIZE_PREFIX');
        $thumbPrefix = config('admin.path.avatar.THUMB_PREFIX');

        $originalUrl = $resizedUrl = $thumbUrl = null;

        if (is_numeric($user_id)) {
            $userAvatar = User::select('profile_image')->where('id', $user_id)->latest()->first();
            if (!empty($userAvatar->profile_image)) {
                $pathKey = $uploadDir . '/' . $avatarDir . '/' . $user_id;

                if (env('S3_ENABLED') == true) {
                    $resizedDimensions = $thumbDimensions = '';
                    $resizedImageDimensions = request()->header('Image-Dimensions-Resized');
                    if (empty($resizedImageDimensions)) {
                        $resizedImageDimensions = config('admin.path.avatar.RESIZE_WIDTH');
                    }
                    if (!empty($resizedImageDimensions)) {
                        $keywords = explode("x", $resizedImageDimensions);
                        $resizedDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $resizedDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }
                    $thumbImageDimensions = request()->header('Image-Dimensions-Thumb');
                    if (empty($thumbImageDimensions)) {
                        $thumbImageDimensions = config('admin.path.avatar.THUMB_WIDTH');
                    }
                    if (!empty($thumbImageDimensions)) {
                        $keywords = explode("x", $thumbImageDimensions);
                        $thumbDimensions .= (!empty($keywords[0])) ? '&w=' . $keywords[0] : '';
                        $thumbDimensions .= (!empty($keywords[1])) ? '&h=' . $keywords[1] : '';
                    }
                    $key = $pathKey . '/' . $userAvatar->profile_image;
                    if ($isUrl) {
                        // return image original, resized & thumb urls
                        $originalUrl = self::s3Uri($key);
                        $s3Client = \AWS::createClient('s3');
                        $response = $s3Client->doesObjectExist(config('filesystems.disks.s3.bucket'), $key);
                        if (!empty($response)) {
                            $resizedUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $resizedDimensions;
                            $thumbUrl = str_replace(env('AWS_URL'), env('AWS_RESIZE_IMAGE_URL'), $originalUrl) . $thumbDimensions;
                        }
                    } else {
                        //return image s3 key
                        return $key;
                    }
                } else {
                    if ($isUrl) {
                        if (file_exists($localStoragePath . '/' . $pathKey . '/' . $userAvatar->profile_image)) {
                            $originalUrl = url('/public/storage') . '/' . $pathKey . '/' . $userAvatar->profile_image;
                            $resizedUrl = url('/public/storage') . '/' . $pathKey . '/' . $resizedPrefix . '_' . $userAvatar->profile_image;
                            $thumbUrl = url('/public/storage') . '/' . $pathKey . '/' . $thumbPrefix . '_' . $userAvatar->profile_image;
                        }
                    } else {
                        return $pathKey . '/' . $userAvatar->profile_image;
                    }
                }
                    return [
                        'origional' => $originalUrl,
                        'resized' => $resizedUrl,
                        'thumb' => $thumbUrl,
                    ];
            }
            return null;
        } else {
            return [
                'origional' => $originalUrl,
                'resized' => $resizedUrl,
                'thumb' => $thumbUrl,
            ];
        }
    }*/

    /**
     * Author: NMG
     * Function: getAssociateSpaceMemberList
     * Description: get associate member list
     * Input: ['userId']
     * Output: return json response
     * Dated: 18/March/2020
     */
    public static function getAllSpace()
    {

        $ch = curl_init();

        curl_setopt_array($ch, array(
            CURLOPT_URL => 'https://ps.pndsn.com/v1/objects/' . config('app.pubnub.sub_key') . '/spaces?include=custom&limit=10&count=true',
            CURLOPT_RETURNTRANSFER => true,
        ));

        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    /**
     * Author: NMG
     * Function: getAssociateSpaceMemberList
     * Description: get associate member list
     * Input: ['userId']
     * Output: return json response
     * Dated: 18/March/2020
     */
    public static function getAssociateSpaceMemberList($userId)
    {
        if (empty($userId)) {
            return false;
        }

        $ch = curl_init();

        curl_setopt_array($ch, array(
            CURLOPT_URL => 'https://ps.pndsn.com/v1/objects/' . config('app.pubnub.sub_key') . '/users/' . $userId . '/spaces?include=custom&limit=10&count=true',
            CURLOPT_RETURNTRANSFER => true,
        ));

        $response = curl_exec($ch);
        curl_close($ch);

        return $response;
    }

    /**
     * Author: NMG
     * Function: getAssociateSpaceMemberList
     * Description: get associate member list
     * Input: ['userId']
     * Output: return json response
     * Dated: 18/March/2020
     */
    public static function getSpaceDetailBySpaceId($spaceId)
    {
        if (empty($spaceId)) {
            return false;
        }

        $ch = curl_init();

        curl_setopt_array($ch, array(
            CURLOPT_URL => 'https://ps.pndsn.com/v1/objects/' . config('app.pubnub.sub_key') . '/spaces/' . $spaceId . '?include=custom',
            CURLOPT_RETURNTRANSFER => true,
        ));

        $response = curl_exec($ch);
        curl_close($ch);

        return $response;
    }

    /**
     * Author: NMG
     * Function: deleteSpace
     * Description: get associate member list
     * Input: ['userId']
     * Output: return json response
     * Dated: 18/March/2020
     */
    public static function deleteSpace($spaceID)
    {
        $ch = curl_init();

        $headers = [
            'Content-Type: application/json'
        ];

        curl_setopt_array($ch, array(
            CURLOPT_URL => 'https://ps.pndsn.com/v1/objects/' . config('app.pubnub.sub_key') . '/spaces/' . $spaceID,
            CURLOPT_CUSTOMREQUEST => 'DELETE',
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
        ));

        $response = curl_exec($ch);
        curl_close($ch);
        dd($response);
        return $response;
    }

    /**
     * Author: NMG
     * Function: updateSpaceDetail
     * Description: get associate member list
     * Input: ['userId']
     * Output: return json response
     * Dated: 18/March/2020
     */
    public static function createSpace()
    {
        $jsonObje['id'] = 'first';
        $jsonObje['name'] = 'testSpace';
        $jsonObje['description'] = 'mynew fisrt';
        $jsonObje['custom']['data'] = 'mynew fisrt';

        $jsonData = json_encode($jsonObje);

        $ch = curl_init();

        $headers = [
            'Content-Type: application/json'
        ];

        curl_setopt_array($ch, array(
            CURLOPT_URL => 'https://ps.pndsn.com/v1/objects/' . config('app.pubnub.sub_key') . '/spaces',
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,

            CURLOPT_POSTFIELDS => $jsonData
        ));

        $response = curl_exec($ch);
        curl_close($ch);
        echo '<pre>';
        print_r($response);
        return $response;
    }

    /**
     * Author: NMG
     * Function: updateSpaceDetail
     * Description: get associate member list
     * Input: ['userId']
     * Output: return json response
     * Dated: 18/March/2020
     */
    public static function updateSpaceDetail($spaceData, $spaceId)
    {
        $stringCon = '' . json_encode($spaceData) . '';
        $jsonObje['custom']['data'] = $stringCon;
        $jsonData = json_encode($jsonObje, true);


        if (empty($spaceData)) {
            return false;
        }

        $ch = curl_init();

        $headers = [
            'Content-Type: application/json'
        ];

        curl_setopt_array($ch, array(
            CURLOPT_URL => 'https://ps.pndsn.com/v1/objects/' . config('app.pubnub.sub_key') . '/spaces/' . $spaceId . '?include=custom',
            CURLOPT_CUSTOMREQUEST => 'PATCH',
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,

            CURLOPT_POSTFIELDS => $jsonData
        ));

        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    /**
     * Author: NMG
     * Function: unlinkOldImage
     * Description: delete old images
     * Input: ['path', 'type']
     * Output: return json response
     * Dated: 30/March/2020
     */
    public static function unlinkOldImage($table, $id, $path)
    {

        if ($table == 'group_images') {

            $groupImage = GroupImage::select('image')->where('space_id', $id)->first();

            $oiginFile = $path . '/' . $groupImage->image;
            $rszFile = $path . '/rsz_' . $groupImage->image;
            $thumbFile = $path . '/tmb_' . $groupImage->image;
        } else if ($table == 'facilities') {

            $facilityLogo = Facility::select('logo')->where('id', $id)->first();

            $oiginFile = $path . '/' . $facilityLogo->logo;
            $rszFile = $path . '/rsz_' . $facilityLogo->logo;
            $thumbFile = $path . '/tmb_' . $facilityLogo->logo;
        } else if ($table ==  'users') {

            $userAvatar = User::select('id', 'profile_image')->where('id', $id)->latest()->first();

            $oiginFile = $path . '/' . $userAvatar->profile_image;
            $rszFile = $path . '/rsz_' . $userAvatar->profile_image;
            $thumbFile = $path . '/tmb_' . $userAvatar->profile_image;
        } else if ($table ==  'restaurant_menus') {


            $userAvatar = Restaurant_menu::select('id', 'image')->where('id', $id)->latest()->first();

            $oiginFile = $path . '/' . $userAvatar->image;
            $rszFile = $path . '/rsz_' . $userAvatar->image;
            $thumbFile = $path . '/tmb_' . $userAvatar->image;
        } else if ($table ==  'food_categories') {
            $userAvatar = FoodCategory::select('id', 'image')->where('id', $id)->latest()->first();
            // dd($path);
            // dd($userAvatar->image);
            $oiginFile = $path . '/' . basename($userAvatar->image);
            // dd($oiginFile);
            $rszFile = $path . '/rsz_' . basename($userAvatar->image);
            $thumbFile = $path . '/tmb_' . basename($userAvatar->image);
            // $oiginFile = $path;
            // $rszFile = $path;
            // $thumbFile = $path;
        }

        if (\Storage::disk('s3')->exists($oiginFile)) {
            \Storage::disk('s3')->delete($oiginFile);
        }

        if (\Storage::disk('s3')->exists($rszFile)) {
            \Storage::disk('s3')->delete($rszFile);
        }

        if (\Storage::disk('s3')->exists($thumbFile)) {
            \Storage::disk('s3')->delete($thumbFile);
        }

        return true;
    }

    public static function sortString($s, $id)
    {
        if (strlen($s) <= 80) {
            return $s;
        } else {
            $s1 = str_replace("'", "'", $s);
            $s1 = $s;
            $str1 = substr($s1, 0, 80);
            $str2 = substr($s1, 80);

            return $final_str = $str1 . '<span id="dots' . $id . '">...</span>
            <span id="more' . $id . '" style="display: none;">' . $str2 . '</span>
            <b><a  onclick="readMoreLess(' . $id . ')" id="read-more-less' . $id . '" style="cursor: pointer;">Read more</a></b>';
        }
    }


    public static function calcDeliveryPersonRevenue($distance)
    {
        $fixedFee = GeneralSetting::riderFixedDeliveryFee();
        $pencePerMile = GeneralSetting::pencePerMile();
        $riderFee = number_format($fixedFee + ($distance * $pencePerMile), 2, '.', '0');
        return $riderFee;
    }


    public static function getAwsCredentials()
    {
        return [
            "bucket_name" => env('AWS_BUCKET'),
            "bucket_secret_key" => env('AWS_SECRET_ACCESS_KEY'),
            "bucket_key" => env('AWS_ACCESS_KEY_ID'),
            "region" => env('AWS_DEFAULT_REGION')
        ];
    }

    public static function getPayStackCredentials()
    {
        return [
            "secret_key" => env('PAYSTACK_SECRET_KEY'),
            "public_key" => env('PAYSTACK_PUBLIC_KEY')
        ];
    }
}
