<?php
namespace App\Exceptions;

use Exception;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Http\Response;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

    /**
     * Report or log an exception.
     *
     * @param  \Exception  $exception
     * @return void
     */
    public function report(Exception $exception)
    {

        parent::report($exception);

        if ($this->shouldntReport($exception)) {
            return;
        }

        \Log::channel('daily')->error(
            $exception->getMessage(),
            array_merge($this->context(), ['exception' => $exception])
        );
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Exception  $exception
     * @return \Illuminate\Http\Response
     */
    public function render($request, Exception $exception)
    {
        if ($request->is('api/*')) {
            //echo get_class($exception);die;
            if ($exception instanceof \Symfony\Component\HttpKernel\Exception\NotFoundHttpException) {
                $this->httpCode = config('api.constants.httpCodes.NOT_FOUND');
                $this->code = config('api.constants.httpCodes.NOT_FOUND');
                $this->message = __('api/common.HTTP_BAD_REQUEST');
                return response()->json([
                    'code' => (int) $this->code,
                    'message' => $this->message,
                    'data' => (object) [],
                ], (int) $this->httpCode);

            } elseif ($exception instanceof \Illuminate\Auth\AuthenticationException) {
                $this->httpCode = config('api.constants.httpCodes.SESSION_EXPIRE');
                $this->code = config('api.constants.httpCodes.SESSION_EXPIRE');
                $this->message = __('api/common.TOKEN_EXPIRE');
                return response()->json([
                    'code' => (int) $this->code,
                    'message' => $this->message,
                    'data' => (object) [],
                ], (int) $this->httpCode);

            } elseif ($exception instanceof \Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException) {
                //echo 'xzczxc';die;
                $this->httpCode = config('api.constants.httpCodes.METHOD_NOT_ALLOWED');
                $this->code = config('api.constants.httpCodes.METHOD_NOT_ALLOWED');
                $this->message = __('api/common.METHOD_NOT_ALLOWED');
                return response()->json([
                    'code' => (int) $this->code,
                    'message' => $this->message,
                    'data' => (object) [],
                ], (int) $this->httpCode);

            } elseif ($exception instanceof \Illuminate\Foundation\Http\Exceptions\MaintenanceModeException) {
                $this->httpCode = config('api.constants.httpCodes.SERVICE_UNAVAILABLE');
                $this->code = config('api.constants.httpCodes.SERVICE_UNAVAILABLE');
                $this->message = __('api/common.MAINTENANCE_MODE');
                if (!empty($exception->getMessage())) {
                    $this->message = $exception->getMessage();
                }
                return response()->json([
                    'code' => (int) $this->code,
                    'message' => $this->message,
                    'data' => (object) [],
                ], (int) $this->httpCode);
            }

        } elseif ($exception instanceof \Illuminate\Session\TokenMismatchException) {
            return redirect()
                   ->back()
                   ->withInput($request->except(['password', 'password_confirmation']))
                   ->with('error', 'The form has expired due to inactivity. Please try again');
        }
        return parent::render($request, $exception);
    }
}
