<?php

namespace app\Enums;

use BenSampo\Enum\Enum;

/**
 * @method static static OptionOne()
 * @method static static OptionTwo()
 */
final class AppUpdateForceType extends Enum
{
    const Yes  =   1;
    const No   =   0;
    const Idle =   2;

    /**
     * select array modified for all values except mentioned in exceptArray
     *
     * @param array $exceptArray
     * @return array
     */
    public static function SelectArrayExcept(array $exceptArray): array
    {
        $array       = static::toArray();
        $selectArray = [];

        foreach ($array as $key => $value) {
            if (!in_array($value, $exceptArray)) {
                $selectArray[$value] = static::getDescription($value);
            }

        }
        return $selectArray;
    }
}
