<?php

namespace app\Console\Commands;

use app\Model\Admin\User;
use Illuminate\Console\Command;

class SendEmails extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'email:send {emailSlug?} {--role=*} {--facility=*}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send smtp e-mails to a user';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //get auth userId
        $senderId = (!empty(\Auth::guard('admin')->user()->id)) ? \Auth::guard('admin')->user()->id : null;
        //get emailSlug if passed
        $emailSlug = (!empty($this->argument('emailSlug'))) ? $this->argument('emailSlug') : 'broadcast_email';
        // other options like role, facility etc.
        $options = $this->options();

        $roles = $options['role'];
        $facilities = $options['facility'];

        $query = User::select(
            'users.id',
            'users.facility_id',
            'users.first_name',
            'users.last_name',
            'users.email'
        )->where('users.status', 1);
        if (!empty($roles)) {
            //select users of given role only
            $query->whereIn('users.role_id', $roles);
        }
        if (!empty($facilities)) {
            //select users of given facilities only
            $query->whereIn('users.facility_id', $facilities);
        }
        $users = $query->get();
        if ($users->count()) {
            foreach ($users as $user) {
                if (!empty($user->email) && filter_var($user->email, FILTER_VALIDATE_EMAIL)) {
                    ###Email BroadCast#####
                    if (!empty($input['lang'])) {
                        \App::setLocale($input['lang']);
                    }
                    $isSent = 1;

                    $params['replaceKeywords']['{USER_NAME}'] = $user->full_name;
                    $params['toEmail'] = $user->email;
                    $params['emailSlug'] = 'broadcast_email';
                    $objMail = new \app\Http\Controllers\Controller();
                    if (!$objMail->customMailer($params)) {
                        $isSent = 0;
                    }
                    //save status report in database
                    if (\app\Model\Admin\BroadcastEmail::create([
                        'sender_id' => $senderId,
                        'receiver_id' => $user->id,
                        'receiving_email' => $user->email,
                        'email_slug' => $emailSlug,
                        'is_sent' => $isSent,
                    ])) {
                        echo $user->Email . '<br/>';
                    }
                }
            }
        }
    }
}