<?php

namespace app\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class RemoveOldNotification extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notification:remove';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This command remove 30 days old notification';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //
        $deleteTillDate = \Carbon\Carbon::now()->subDays(30)->format('Y-m-d H:i:s');
        DB::table('notifications')->where('created_at', '<=', $deleteTillDate)->delete();
        echo "Notification removed";
    }
}
