<?php

namespace app\Console\Commands;

use Illuminate\Console\Command;
use app\Model\Api\V1\Order;
use app\Model\Vendor\OrderLog;
use app\Model\Api\V1\User;
use app\Components\Api\V1\PushNotification;
use app\Helpers\CommonHelper;

class CancelNonAcceptedOrder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'order:cancel';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Cancel the orders which is not accepted by the restaurant within 10 minutes';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //
        $data = \DB::table('orders')->where(['order_status_id' => 1])->where('created_at', '<', \Carbon\Carbon::now()->subMinutes(10)->toDateTimeString())->get();
        if (!empty($data)) {
            foreach ($data as $order) {
                // cancel order due to non-acceptance of order within 10 minutes
                // send order cancellation mail
                $orderData = Order::find($order->id);
                $orderData->order_status_id = config('admin.constants.ORDER_STATUS_CANCELED');
                $orderData->save();
                OrderLog::saveLog($orderData->id, $orderData->order_status_id);

                $user = User::find($orderData->user_id);

                #### send push notification to customer ##
                $title = "Order cancelled";
                $body = "Your order has been cancelled due to non-accepting of order by restaurant";
                $notification = array('title' => $title, 'body' => $body, 'sound' => 'default', 'badge' => '1', 'orderId' => $orderData->id, 'actionId' => config('api.constants.push_notification.actionId.customer_order_details'));
                PushNotification::sendNotification($orderData->user_id, $notification,  $orderData->id);

                #### end sending push notification to customer ##

                if (!empty($user->email)) {
                    ### Email Sending #####
                    $params['replaceKeywords']['{USER_NAME}'] = $orderData->firstname . ' ' . $orderData->lastname;
                    $params['replaceKeywords']['{ORDER_ID}'] = $orderData->id;
                    $params['replaceKeywords']['{AMOUNT}'] = $orderData->total_amount;
                    $params['replaceKeywords']['{DELIVER_TO}'] = $orderData->firstname . ' ' . $orderData->lastname;
                    $params['replaceKeywords']['{ADDRESS}'] = $orderData->address1;
                    $params['replaceKeywords']['{ADDRESS_TYPE}'] = CommonHelper::getAddressType($orderData->address_type);
                    $params['toEmail'] = $user->email;
                    $params['emailSlug'] = 'customer_restaurant_due_nonavailability_cancle_order';
                    $this->customMailer($params);
                }
            }
        }

        echo "cancel order scheduler";
    }
}
