<?php

namespace App\Components\Api\V1;

use app\Model\Api\V1\User;
use app\Traits\FilePathUrl;
use app\Model\Api\V1\FcmToken;
use app\Model\Api\V1\Notification;
use Illuminate\Support\Facades\DB;

// Server file
class PushNotification
{

    use FilePathUrl;

    /**
     * Author: NMG
     * Function: deleteDuplicateNotification
     * Description: Utility to erase duplicate alerts/notification from database
     * Input: title, notifiable_id(reference_id), receiver_id, sender_id
     * Output: true/false
     * Dated: 16/September/2019
     */
    public static function deleteDuplicateNotification($title = null, $notifiable_id = null, $user_id = null, $notified_by_id = null)
    {
        try {
            if (!empty($title) && !empty($notifiable_id)) {
                \DB::enableQueryLog();
                if (Notification::where([
                    ['title', '=', $title],
                    ['notifiable_id', '=', $notifiable_id],
                    ['user_id', '=', $user_id],
                    ['notified_by_id', '=', (int) $notified_by_id],
                ])->delete()) {
                    return true;
                }
                //print_r(\DB::getQueryLog());
                return true;
            }
            return false;
        } catch (\Exception $exception) {
            $dataList = [];
            $obj = new \App\Http\Controllers\Api\V1\BaseController();
            $log = $obj->saveErrorLog($exception);
            throw new \Exception($exception->getMessage());
            //throw new \Exception(__('api/common.PUSH_NOTIFICATION_ERROR'));
        }
    }

    /**
     * Author: NMG
     * Function: triggerPush
     * Description: Utility function called throughout the application to trigger push notifications     * Input: title, notifiable_id(reference_id), receiver_id, sender_id
     * Input: notification type, payload data
     * Output: true/false
     * Dated: 16/September/2019
     */
    public static function triggerPush($action = null, $data = [])
    {
        try {
            if (empty($action) || empty($data)) {
                return false;
            }
            $inputKeys = [
                'notifiable_id',
                'receiver_id',
                'sender_id',
                'bold_string',
                'replaced_array',
                'left_image_id',
                'right_image_id',
                'title',
                'message',
            ];

            if (!empty($data['room_name'])) {
                array_push($inputKeys, 'room_name');
                array_push($inputKeys, 'call_type');
                array_push($inputKeys, 'is_busy');
            }

            if (!empty($data['click_action'])) {
                array_push($inputKeys, 'click_action');
                array_push($inputKeys, 'space_id');
                array_push($inputKeys, 'sender');
            }

            if (is_array($data) && count($data) > 0) {
                foreach ($data as $key => $value) {
                    //check valid keys in input array
                    if (!in_array($key, $inputKeys)) {
                        echo $key . '=>' . $value;
                        die;
                        return false;
                    }
                }
            }
            // change the value of submit true/false according to user push notification settings
            $submit = true;
            $dbData = $extras = [];

            if (!empty($data['receiver_id'])) {
                switch ($action) {
                    case (int) config('api.notification.TYPE_ID.USER.BROADCAST.CODE'):
                        $submit = config('api.notification.TYPE_ID.USER.BROADCAST.TRIGGER');
                        if ($submit) {
                            if (!empty($data['title'])) {
                                $title = $data['title'];
                            } else {
                                $title = __('api/notification.user.broadcast.title');
                            }

                            if (!empty($data['message'])) {
                                $message = str_replace(
                                    ['#USER_NAME', '#APP_NAME'],
                                    $data['replaced_array'],
                                    $data['message']
                                );
                            } else {
                                $message = str_replace(
                                    ['#USER_NAME', '#APP_NAME'],
                                    $data['replaced_array'],
                                    __('api/notification.user.welcome.message')
                                );
                            }

                            $left_image_id = (!empty($data['left_image_id'])) ? trim($data['left_image_id']) : null;
                            $right_image_id = (!empty($data['right_image_id'])) ? trim($data['right_image_id']) : null;

                            $dbData = [
                                'notifiable_module_id' => (int) config('api.notification.MODULE_ID.USER'), //default
                                'notification_type_id' => (int) config('api.notification.TYPE_ID.USER.BROADCAST.CODE'),
                                'notifiable_id' => (!empty($data['notifiable_id'])) ? trim($data['notifiable_id']) : null,
                                'user_id' => (!empty($data['receiver_id'])) ? trim($data['receiver_id']) : null,
                                'notified_by_id' => (!empty($data['sender_id'])) ? trim($data['sender_id']) : null,
                                'title' => $title,
                                'message' => $message,
                                'bold_string' => (!empty($data['bold_string'])) ? trim($data['bold_string']) : null,
                                'left_image_id' => $left_image_id,
                                'right_image_id' => $right_image_id,
                            ];
                            $extras['left_image_Url'] = null;
                            $extras['right_image_Url'] = null;

                            if (!empty($right_image_id)) {
                                $right_image_Url = self::userAvatar($right_image_id);
                                $extras['right_image_Url'] = (!empty($right_image_Url)) ? $right_image_Url['thumb'] : null;
                            }
                        } else {
                            $submit = false;
                        }
                        break;

                    case (int) config('api.notification.TYPE_ID.USER.WELCOME.CODE'):
                        $submit = config('api.notification.TYPE_ID.USER.WELCOME.TRIGGER');
                        if ($submit) {
                            //echo '<pre>';print_r($data);die;
                            $title = __('api/notification.user.welcome.title');

                            $message = str_replace(
                                ['#USER_NAME', '#APP_NAME'],
                                $data['replaced_array'],
                                __('api/notification.user.welcome.message')
                            );

                            $left_image_id = (!empty($data['left_image_id'])) ? trim($data['left_image_id']) : null;
                            $right_image_id = (!empty($data['right_image_id'])) ? trim($data['right_image_id']) : null;

                            $dbData = [
                                'notifiable_module_id' => config('api.notification.MODULE_ID.USER'), //default
                                'notification_type_id' => config('api.notification.TYPE_ID.USER.WELCOME.CODE'),
                                'notifiable_id' => (!empty($data['notifiable_id'])) ? trim($data['notifiable_id']) : null,
                                'user_id' => (!empty($data['receiver_id'])) ? trim($data['receiver_id']) : null,
                                'notified_by_id' => (!empty($data['sender_id'])) ? trim($data['sender_id']) : null,
                                'title' => $title,
                                'message' => $message,
                                'bold_string' => (!empty($data['bold_string'])) ? trim($data['bold_string']) : null,
                                'left_image_id' => $left_image_id,
                                'right_image_id' => $right_image_id,
                            ];
                            $extras['left_image_Url'] = null;
                            $extras['right_image_Url'] = null;

                            if (!empty($right_image_id)) {
                                $right_image_Url = self::userAvatar($right_image_id);
                                $extras['right_image_Url'] = (!empty($right_image_Url)) ? $right_image_Url['thumb'] : null;
                            }
                        } else {
                            $submit = false;
                        }
                        break;

                    case (int) config('api.notification.TYPE_ID.USER.MESSAGE.NOTIFICATION.CODE'):
                        $submit = config('api.notification.TYPE_ID.USER.MESSAGE.NOTIFICATION.TRIGGER');
                        if ($submit) {
                            //echo '<pre>';print_r($data);die;

                            $left_image_id = (!empty($data['left_image_id'])) ? trim($data['left_image_id']) : null;
                            $right_image_id = (!empty($data['right_image_id'])) ? trim($data['right_image_id']) : null;

                            $dbData = [
                                'notifiable_module_id' => config('api.notification.MODULE_ID.USER'), //default
                                'notification_type_id' => config('api.notification.TYPE_ID.USER.WELCOME.CODE'),
                                'notifiable_id' => (!empty($data['notifiable_id'])) ? trim($data['notifiable_id']) : null,
                                'user_id' => (!empty($data['receiver_id'])) ? trim($data['receiver_id']) : null,
                                'notified_by_id' => (!empty($data['sender_id'])) ? trim($data['sender_id']) : null,
                                'title' => $data['title'],
                                'message' => $data['message'],
                                'click_action' => $data['click_action'],
                                'space_id' => $data['space_id'],
                                'sender' => $data['sender'],
                                'bold_string' => (!empty($data['bold_string'])) ? trim($data['bold_string']) : null,
                                'left_image_id' => $left_image_id,
                                'right_image_id' => $right_image_id,
                            ];
                            $extras['left_image_Url'] = null;
                            $extras['right_image_Url'] = null;

                            if (!empty($right_image_id)) {
                                $right_image_Url = self::userAvatar($right_image_id);
                                $extras['right_image_Url'] = (!empty($right_image_Url)) ? $right_image_Url['thumb'] : null;
                            }
                        } else {
                            $submit = false;
                        }
                        break;

                    case (int) config('api.notification.TYPE_ID.USER.CALL.VIDEO.CODE'):
                        $submit = config('api.notification.TYPE_ID.USER.CALL.VIDEO.TRIGGER');

                        if ($submit) {
                            //echo '<pre>';print_r($data);die;
                            $title = __('api/notification.user.call.video.title');

                            $message = str_replace(
                                ['#USER_NAME', '#APP_NAME'],
                                $data['replaced_array'],
                                __('api/notification.user.call.video.message')
                            );

                            $left_image_id = (!empty($data['left_image_id'])) ? trim($data['left_image_id']) : null;
                            $right_image_id = (!empty($data['right_image_id'])) ? trim($data['right_image_id']) : null;

                            $dbData = [
                                'notifiable_module_id' => config('api.notification.MODULE_ID.USER'), //default
                                'notification_type_id' => config('api.notification.TYPE_ID.USER.CALL.VIDEO.CODE'),
                                'notifiable_id' => (!empty($data['notifiable_id'])) ? trim($data['notifiable_id']) : null,
                                'user_id' => (!empty($data['receiver_id'])) ? trim($data['receiver_id']) : null,
                                'notified_by_id' => (!empty($data['sender_id'])) ? trim($data['sender_id']) : null,
                                'title' => $title,
                                'message' => $message,
                                'bold_string' => (!empty($data['bold_string'])) ? trim($data['bold_string']) : null,
                                'left_image_id' => $left_image_id,
                                'right_image_id' => $right_image_id,
                            ];

                            if (!empty($data['room_name'])) {
                                $dbData['room_name'] = $data['room_name'];
                                $dbData['call_type'] = $data['call_type'];
                                $dbData['is_declined'] = false;
                            }

                            $extras['left_image_Url'] = null;
                            $extras['right_image_Url'] = null;

                            if (!empty($right_image_id)) {
                                $right_image_Url = self::userAvatar($right_image_id);
                                $extras['right_image_Url'] = (!empty($right_image_Url)) ? $right_image_Url['thumb'] : null;
                            }
                        } else {
                            $submit = false;
                        }
                        break;

                    case (int) config('api.notification.TYPE_ID.USER.CALL.VIDEO_DISCONNECT.CODE'):
                        $submit = config('api.notification.TYPE_ID.USER.CALL.VIDEO_DISCONNECT.TRIGGER');
                        if ($submit) {
                            //echo '<pre>';print_r($data);die;
                            $title = __('api/notification.user.call.video_disconnect.title');

                            $message = str_replace(
                                ['#USER_NAME', '#APP_NAME'],
                                $data['replaced_array'],
                                __('api/notification.user.call.video_disconnect.message')
                            );

                            $left_image_id = (!empty($data['left_image_id'])) ? trim($data['left_image_id']) : null;
                            $right_image_id = (!empty($data['right_image_id'])) ? trim($data['right_image_id']) : null;

                            $dbData = [
                                'notifiable_module_id' => config('api.notification.MODULE_ID.USER'), //default
                                'notification_type_id' => config('api.notification.TYPE_ID.USER.CALL.VIDEO_DISCONNECT.CODE'),
                                'notifiable_id' => (!empty($data['notifiable_id'])) ? trim($data['notifiable_id']) : null,
                                'user_id' => (!empty($data['receiver_id'])) ? trim($data['receiver_id']) : null,
                                'notified_by_id' => (!empty($data['sender_id'])) ? trim($data['sender_id']) : null,
                                'title' => $title,
                                'message' => $message,
                                'bold_string' => (!empty($data['bold_string'])) ? trim($data['bold_string']) : null,
                                'left_image_id' => $left_image_id,
                                'right_image_id' => $right_image_id,
                            ];

                            if (!empty($data['room_name'])) {
                                $dbData['room_name'] = $data['room_name'];
                                $dbData['call_type'] = $data['call_type'];
                                $dbData['is_declined'] = true;
                                $dbData['is_busy'] = $data['is_busy'];
                            }

                            $extras['left_image_Url'] = null;
                            $extras['right_image_Url'] = null;

                            if (!empty($right_image_id)) {
                                $right_image_Url = self::userAvatar($right_image_id);
                                $extras['right_image_Url'] = (!empty($right_image_Url)) ? $right_image_Url['thumb'] : null;
                            }
                        } else {
                            $submit = false;
                        }
                        break;

                    case (int) config('api.notification.TYPE_ID.USER.CALL.VOICE.CODE'):
                        $submit = config('api.notification.TYPE_ID.USER.CALL.VOICE.TRIGGER');
                        if ($submit) {
                            //echo '<pre>';print_r($data);die;
                            $title = __('api/notification.user.call.voice.title');

                            $message = str_replace(
                                ['#USER_NAME', '#APP_NAME'],
                                $data['replaced_array'],
                                __('api/notification.user.call.voice.message')
                            );

                            $left_image_id = (!empty($data['left_image_id'])) ? trim($data['left_image_id']) : null;
                            $right_image_id = (!empty($data['right_image_id'])) ? trim($data['right_image_id']) : null;

                            $dbData = [
                                'notifiable_module_id' => config('api.notification.MODULE_ID.USER'), //default
                                'notification_type_id' => config('api.notification.TYPE_ID.USER.CALL.VOICE.CODE'),
                                'notifiable_id' => (!empty($data['notifiable_id'])) ? trim($data['notifiable_id']) : null,
                                'user_id' => (!empty($data['receiver_id'])) ? trim($data['receiver_id']) : null,
                                'notified_by_id' => (!empty($data['sender_id'])) ? trim($data['sender_id']) : null,
                                'title' => $title,
                                'message' => $message,
                                'bold_string' => (!empty($data['bold_string'])) ? trim($data['bold_string']) : null,
                                'left_image_id' => $left_image_id,
                                'right_image_id' => $right_image_id,
                            ];

                            if (!empty($data['room_name'])) {
                                $dbData['room_name'] = $data['room_name'];
                                $dbData['call_type'] = $data['call_type'];
                                $dbData['is_declined'] = false;
                            }

                            $extras['left_image_Url'] = null;
                            $extras['right_image_Url'] = null;

                            if (!empty($right_image_id)) {
                                $right_image_Url = self::userAvatar($right_image_id);
                                $extras['right_image_Url'] = (!empty($right_image_Url)) ? $right_image_Url['thumb'] : null;
                            }
                        } else {
                            $submit = false;
                        }
                        break;
                    case (int) config('api.notification.TYPE_ID.USER.CALL.VOICE_DISCONNECT.CODE'):
                        $submit = config('api.notification.TYPE_ID.USER.CALL.VOICE_DISCONNECT.TRIGGER');
                        if ($submit) {
                            //echo '<pre>';print_r($data);die;
                            $title = __('api/notification.user.call.voice_disconnect.title');

                            $message = str_replace(
                                ['#USER_NAME', '#APP_NAME'],
                                $data['replaced_array'],
                                __('api/notification.user.call.voice_disconnect.message')
                            );

                            $left_image_id = (!empty($data['left_image_id'])) ? trim($data['left_image_id']) : null;
                            $right_image_id = (!empty($data['right_image_id'])) ? trim($data['right_image_id']) : null;

                            $dbData = [
                                'notifiable_module_id' => config('api.notification.MODULE_ID.USER'), //default
                                'notification_type_id' => config('api.notification.TYPE_ID.USER.CALL.VOICE_DISCONNECT.CODE'),
                                'notifiable_id' => (!empty($data['notifiable_id'])) ? trim($data['notifiable_id']) : null,
                                'user_id' => (!empty($data['receiver_id'])) ? trim($data['receiver_id']) : null,
                                'notified_by_id' => (!empty($data['sender_id'])) ? trim($data['sender_id']) : null,
                                'title' => $title,
                                'message' => $message,
                                'bold_string' => (!empty($data['bold_string'])) ? trim($data['bold_string']) : null,
                                'left_image_id' => $left_image_id,
                                'right_image_id' => $right_image_id,
                            ];

                            if (!empty($data['room_name'])) {
                                $dbData['room_name'] = $data['room_name'];
                                $dbData['call_type'] = $data['call_type'];
                                $dbData['is_busy'] = $data['is_busy'];
                                $dbData['is_declined'] = true;
                            }

                            $extras['left_image_Url'] = null;
                            $extras['right_image_Url'] = null;

                            if (!empty($right_image_id)) {
                                $right_image_Url = self::userAvatar($right_image_id);
                                $extras['right_image_Url'] = (!empty($right_image_Url)) ? $right_image_Url['thumb'] : null;
                            }
                        } else {
                            $submit = false;
                        }
                        break;

                    default:
                        return 'Invalid notification type provided.';
                        break;
                }
                if ($submit) {
                    return self::notification($dbData, $extras);
                } else {
                    return true;
                }
            } else {
                return false;
            }
        } catch (\Exception $exception) {
            $dataList = [];
            $obj = new \App\Http\Controllers\Api\V1\BaseController();
            $log = $obj->saveErrorLog($exception);
            throw new \Exception($exception->getMessage());
            //throw new \Exception(__('api/common.PUSH_NOTIFICATION_ERROR'));
        }
    }

    /**
     * Author: NMG
     * Function: notification
     * Description: Utility function actually send push on mobile device as per there fcm token
     * Input: DB data for alerts & payload for push notification
     * Output: true/false
     * Dated: 16/September/2019
     */
    public static function notification($dbData = null, $extraPayload = null)
    {
        try {
            //print_r($dbData);die;
            if (empty($dbData)) {
                return false;
            }
            \DB::beginTransaction();

            $tokens = FcmToken::where('user_id', $dbData['user_id'])->pluck('fcm_token')->toArray();

            if (!empty($tokens)) {
                $payload = [];
                self::deleteDuplicateNotification($dbData['title'], $dbData['notifiable_id'], $dbData['user_id'], $dbData['notified_by_id']);
                $opts = [
                    'notifiable_module_id' => (int) $dbData['notifiable_module_id'],
                    'notification_type_id' => (int) $dbData['notification_type_id'],
                    'notifiable_id' => (int) $dbData['notifiable_id'],
                    'user_id' => (int) $dbData['user_id'],
                    'notified_by_id' => (int) $dbData['notified_by_id'],
                    'title' => $dbData['title'],
                    'message' => $dbData['message'],
                    'bold_string' => $dbData['bold_string'],
                    'left_image_id' => (int) $dbData['left_image_id'],
                    'right_image_id' => (int) $dbData['right_image_id'],
                ];

                //echo '<pre>';print_r($opts);die;
                //\DB::enableQueryLog();
                $notification = Notification::create($opts);
                //print_r(\DB::getQueryLog());
                if ($notification->id) {

                    $payload['id'] = $notification->id;
                    $payload['notification_type'] = $notification->notification_type_id;
                    $payload['reference_id'] = $notification->notifiable_id;
                    $payload['title'] = $notification->title;
                    $payload['message'] = $notification->description;
                    $payload['bold_string'] = $notification->bold_string;
                    $payload['left_image_Url'] = $extraPayload['left_image_Url'];
                    $payload['right_image_Url'] = $extraPayload['right_image_Url'];
                    $payload['created_at'] = date("Y-m-d H:i:s", strtotime($notification->created_at));

                    if (!empty($dbData['room_name'])) {

                        if (!empty($dbData['is_declined']) && $dbData['is_declined']) {
                            if (!empty($dbData['is_busy']) && $dbData['is_busy']) {

                                $payload = User::userProfileInfo($dbData['notified_by_id']);
                                $payload['is_busy'] = $dbData['is_busy'];
                                $payload['call_type'] = $dbData['call_type'];
                                $payload['room_name'] = $dbData['room_name'];
                            } else {
                                $payload = User::userProfileInfo($dbData['notified_by_id']);
                                $payload['is_declined'] = $dbData['is_declined'];
                                $payload['call_type'] = $dbData['call_type'];
                                $payload['room_name'] = $dbData['room_name'];
                            }
                        } else {
                            $payload = User::userProfileInfo($dbData['notified_by_id']);
                            $payload['call_type'] = $dbData['call_type'];
                            $payload['room_name'] = $dbData['room_name'];
                        }
                    }

                    $voipTokens = FcmToken::where('user_id', $dbData['user_id'])->first();

                    if (!empty($voipTokens->voip_token)) {
                        $voipToken = $voipTokens->voip_token;

                        $payload['voip_token'] = $voipToken;

                        if (!empty($dbData['is_declined']) && $dbData['is_declined']) {

                            $res = self::androidNotification($tokens, $dbData, $payload);
                        } else {
                            $res = self::iosNotification($voipToken, $dbData, $payload);
                        }

                        if (!empty($res)) {
                            \DB::commit();
                            return true;
                        } else {
                            \DB::rollBack();
                        }
                    } else {

                        if (!empty($dbData['click_action'])) {
                            //$payload = User::userProfileInfo($dbData['notified_by_id']);
                            $payload['space_id'] = $dbData['space_id'];
                            $payload['user'] = $dbData['sender'];
                        }

                        $res = self::androidNotification($tokens, $dbData, $payload);

                        if (!empty($res)) {
                            \DB::commit();
                            return true;
                        } else {
                            \DB::rollBack();
                        }
                    }
                }
            }
            return false;
        } catch (\Exception $exception) {
            $dataList = [];
            $obj = new \App\Http\Controllers\Api\V1\BaseController();
            $log = $obj->saveErrorLog($exception);
            throw new \Exception($exception->getMessage());
            //throw new \Exception(__('api/common.PUSH_NOTIFICATION_ERROR'));
        }
    }

    /**
     * Author: NMG
     * Function: androidNotification
     * Description: send notification to android device
     * Input: null
     * Output: retrun string name
     * Dated: 05/02/2020
     */
    public static function androidNotification($tokens, $dbData, $payload)
    {
        $fcmUrl = 'https://fcm.googleapis.com/fcm/send';
        $tokenList = $tokens;
        $serverKey = env('FCM_API_KEY', 'AAAAnM94IMc:APA91bFWLOdq3zm7WHV9vZBn_zg_qunnXGAvRyWLB9R4lt3zczjZpK4UDjLLoTwbsBYST7j2hOuqi8VRyaETPY0p3TFtewttXBO5PUOMCI2SY36fy1KuPmKXjR7NCeyVwikhA1PmKMtG');
        $badge = 0;
        if (!empty($dbData['user_id'])) {
            $badge = Notification::unreadCount($dbData['user_id']);
        }
        $notification = [
            'title' => !empty($dbData['title']) ? $dbData['title'] :  env('APP_NAME', 'NMG Technologies'),
            'body' => $dbData['message'],
            'sound' => true,
            'badge' => $badge,
        ];

        if (!empty($dbData['room_name'])) {
            $notification['badge'] = 0; //no need to required will implement later
        }

        if (!empty($dbData['click_action'])) {

            $notification['click_action'] = $dbData['click_action']; //no need to required will implement later
            $payload['title'] = !empty($dbData['title']) ? $dbData['title'] :  env('APP_NAME', 'NMG Technologies');
            //$payload['body'] = !empty($dbData['message']) ? $dbData['message'] : '';
        }

        $fcmNotification = [
            'registration_ids' => $tokenList, //multple token array
            //'to'        => $token, //single token
            'notification' => $notification,
            'priority' => 'high',
            'time_to_live' => 0,
            'data' => $payload,
        ];

        if (!empty($dbData['room_name'])) {
            $fcmNotification['content_available'] = true;
            unset($fcmNotification['notification']); //no need to required for call
        }

        $headers = [
            'Authorization: key=' . $serverKey,
            'Content-Type: application/json',
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $fcmUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fcmNotification));
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        $result = curl_exec($ch);
        if ($result === false) {
            die('Curl failed: ' . curl_error($ch));
        }
        curl_close($ch);
        $res = json_decode($result);
        if (!empty($res->failure)) {
            \DB::rollBack();
        } else {
            \DB::commit();
            return $res->success;
        }
    }

    /**
     * Author: NMG
     * Function: iosNotification
     * Description: send notification to ios device
     * Input: null
     * Output: retrun string name
     * Dated: 05/02/2020
     */
    public static function iosNotification($voipToken, $dbData, $payload)
    {
        $passphrase = "";
        $message = "";

        // Put the full path to your .pem file
        $urlPublic = explode("/", public_path());
        $lastKey = array_key_last($urlPublic);
        unset($urlPublic[$lastKey]);
        $urlPublic = implode("/", $urlPublic);

        $pemPath = $urlPublic . '/synAppVP.pem';

        $ctx = stream_context_create();
        stream_context_set_option($ctx, 'ssl', 'local_cert', $pemPath);
        stream_context_set_option($ctx, 'ssl', 'passphrase', $passphrase);

        // Open a connection to the APNS server
        $voipUrl = env('APPLE_VOIP_URL', 'ssl://gateway.sandbox.push.apple.com:2195');
        $fp = stream_socket_client(
            $voipUrl,
            $err,
            $errstr,
            60,
            STREAM_CLIENT_CONNECT | STREAM_CLIENT_PERSISTENT,
            $ctx
        );

        if (!$fp) {
            exit("Failed to connect: $err $errstr" . PHP_EOL);
        }

        //echo 'Connected to APNS' . PHP_EOL;

        //Create the payload body
        $body['aps'] = array(
            'alert' => $message,
            'sound' => 'default',
        );

        $body['payload'] = $payload;
        //Encode the payload as JSON
        $payload = json_encode($body);

        //Build the binary notification
        $msg = chr(0) . pack('n', 32) . pack('H*', $voipToken) . pack('n', strlen($payload)) . $payload;

        //Send it to the server
        $result = fwrite($fp, $msg, strlen($msg));

        if (!$result) {
            return false;
            //return 'Message not delivered' . PHP_EOL;
        } else {
            return true;
            //return 'Message successfully delivered' . PHP_EOL;
        }

        //Close the connection to the server
        fclose($fp);
    }

    /**
     * Author: NMG
     * Function: firebaseNotification
     * Description: send notification to ios or android device
     * Input: null
     * Output: retrun string name
     * Dated: 27/02/2020
     */
    public static function firebaseNotification($payload)
    {

        $serverKey = env('FCM_API_KEY', 'AAAAnM94IMc:APA91bFWLOdq3zm7WHV9vZBn_zg_qunnXGAvRyWLB9R4lt3zczjZpK4UDjLLoTwbsBYST7j2hOuqi8VRyaETPY0p3TFtewttXBO5PUOMCI2SY36fy1KuPmKXjR7NCeyVwikhA1PmKMtG');

        $headers = [
            'Authorization: key=' . $serverKey,
            'Content-Type: application/json'
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

        //finally executing the curl request
        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($ch));
        }
        //Now close the connection
        curl_close($ch);

        $res = json_decode($result);

        if (!empty($res->failure)) {
            \DB::rollBack();
        } else {
            \DB::commit();
            return $res->success;
        }
    }


    /**
     * Author: Jaidev
     * Function: sendNotification
     * Description: send notification to ios or android device using fcm
     * Input: null
     * Output: retrun string name
     * Dated: 06/09/2021
     */

    public static function sendNotification($userId, $notificationData, $orderId = null)
    {
        if (!empty($userId)) {
            $token = FcmToken::select('fcm_tokens.user_id', 'fcm_tokens.fcm_token', 'users.notification_status', 'fcm_tokens.device_type')
                ->join('users', 'fcm_tokens.user_id', '=', 'users.id')
                ->where('fcm_tokens.user_id', $userId)
                ->where('users.notification_status', '1')->first();
            if (!empty($token)) {
                $SERVER_API_KEY = env('FCM_API_KEY');
                if (!empty($SERVER_API_KEY)) {

                    if ($token->device_type == 1) {
                        $payload = array('to' => $token->fcm_token, 'notification' => $notificationData, 'priority' => 'high');
                    } else {
                        $payload = array('to' => $token->fcm_token, 'data' => $notificationData, 'priority' => 'high');
                    }

                    $json = json_encode($payload);
                    $headers = [
                        'Authorization: key=' . $SERVER_API_KEY,
                        'Content-Type: application/json',
                    ];
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
                    $response = curl_exec($ch);
                    $x = json_decode($response);
                    //save into db
                    $notificationDB = ['user_id' => $userId, 'title' => $notificationData['title'], 'description' => $notificationData['body'], 'order_id' => $orderId, 'is_read' => 0, 'action_id' => $notificationData['actionId']];
                    Notification::create($notificationDB);
                    \DB::commit();
                    return true;
                } else {
                    $message = "Please add FCM_API_KEY key";
                    return $message;
                }
            }
        }
    }


    /**
     * Author: Jaidev
     * Function: broadcastNotification
     * Description: broadcast notification to ios or android device using fcm
     * Input: null
     * Output: retrun string name
     * Dated: 06/09/2021
     */

    public static function broadcastNotification($notificationData)
    {
        $userTokenList = FcmToken::select('fcm_tokens.user_id', 'fcm_tokens.fcm_token', 'users.notification_status')
            ->join('users', 'fcm_tokens.user_id', '=', 'users.id')
            ->where('users.notification_status', '1')
            ->where('users.status', '1')
            ->get();
        $token = [];
        foreach ($userTokenList as $fcmToken) {
            $token[] = $fcmToken->fcm_token;
        }

        if (!empty($token)) {
            $SERVER_API_KEY = env('FCM_API_KEY');
            if (!empty($SERVER_API_KEY)) {

                $payload = array('registration_ids' => $token, 'data' => $notificationData, 'priority' => 'high');
                $json = json_encode($payload);
                $headers = [
                    'Authorization: key=' . $SERVER_API_KEY,
                    'Content-Type: application/json',
                ];
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
                $response = curl_exec($ch);
                // $x = json_decode($response);
                // dd($json);
                return true;
            } else {
                $message = "Please add FCM_API_KEY key";
                return $message;
            }
        }
    }
}
