<?php
/**
 * Listing: Cards
 *
 * @since 2.0.0
 *
 * @package Listify
 * @category Widget
 * @author Astoundify
 */
class Listify_Custom_Widget_Cards extends Listify_Widget {

	/**
	 * Register widget settings.
	 *
	 * @since 2.0.0
	 */
	public function __construct() {
		$this->widget_description = __( 'Display the accepted cards.', 'listify' );
		$this->widget_id          = 'listify_widget_cards';
		$this->widget_name        = __( 'Listify - Listing: Cards', 'listify' );
		$this->widget_areas       = array( 'single-job_listing-widget-area', 'single-job_listing' );
		$this->widget_notice      = __( 'Add this widget only in "Single Listing" widget areas.', 'listify' );

		$this->settings = array(
			'title' => array(
				'type'  => 'text',
				'std'   => '',
				'label' => __( 'Title:', 'listify' ),
			),
		);

		parent::__construct();
	}

	/**
	 * Echoes the widget content.
	 *
	 * @since 2.0.0
	 *
	 * @param array $args     Display arguments including 'before_title', 'after_title',
	 *                        'before_widget', and 'after_widget'.
	 * @param array $instance The settings for the particular instance of the widget.
	 */
	function widget( $args, $instance ) {
		global $job_preview, $job_manager, $post;

		if ( ! is_singular( 'job_listing' ) && ! $job_preview ) {
			echo $this->widget_areas_notice(); // WPCS: XSS ok.
			return false;
		}

		extract( $args );

		$title = apply_filters( 'widget_title', isset( $instance['title'] ) ? $instance['title'] : '', $instance, $this->id_base );

		$visa = get_post_meta( $post->ID, '_visa', true );
		$paypal = get_post_meta( $post->ID, '_paypal', true );
		$mastercard = get_post_meta( $post->ID, '_mastercard', true );
		$discover = get_post_meta( $post->ID, '_discover', true );
		$amex = get_post_meta( $post->ID, '_amex', true );
		
		ob_start();

		echo $before_widget; // WPCS: XSS ok.

		if ( $title ) {
			echo $before_title . $title . $after_title; // WPCS: XSS ok.
		}

		do_action( 'listify_widget_job_cards_before' );
		
		echo '<div class="job_listing_card-list">';

		if ( $visa ) {
			echo '<img src="'. get_stylesheet_directory_uri().'/images/visa.svg" />';
		}

		if ( $paypal ) {
			echo '<img src="'. get_stylesheet_directory_uri().'/images/paypal.svg" />';
		}

		if ( $mastercard ) {
			echo '<img src="'. get_stylesheet_directory_uri().'/images/mastercard.svg" />';
		}
		
		if ( $discover ) {
			echo '<img src="'. get_stylesheet_directory_uri().'/images/discover.svg" />';
		}	

		if ( $amex ) {
			echo '<img src="'. get_stylesheet_directory_uri().'/images/amex.svg" />';
		}

		echo '</div>';

		do_action( 'listify_widget_job_cards_after' );

		echo $after_widget; // WPCS: XSS ok.

		echo apply_filters( $this->widget_id, ob_get_clean() ); // WPCS: XSS ok.
	}

}
