<?php
/**
 * Template Name: Layout: US State
 *
 * @package Listify
 */

get_header(); 

global $wpdb;

$page_title = get_the_title();


$pagetitle = get_field("page_title");
$job_result = $wpdb->get_results( "SELECT DISTINCT post_id FROM $wpdb->postmeta WHERE meta_key LIKE 'geolocation_state_long' and meta_value != '' ", ARRAY_N );
$string = '0';
foreach($job_result as $data){
	 $string =$string.",".$data[0];
}
//echo "SELECT DISTINCT meta_value FROM $wpdb->postmeta WHERE meta_key LIKE 'geolocation_state_long' and meta_value!='' and post_id IN (".$string.")";
//$results = $wpdb->get_results( "SELECT DISTINCT meta_value FROM $wpdb->postmeta WHERE meta_key LIKE 'geolocation_state_long' and meta_value!='' and post_id IN (".$string.") order by meta_value", OBJECT );
$total_job = count($job_result);
?>
	<div <?php echo apply_filters( 'listify_cover', 'homepage-cover page-cover entry-cover entry-cover--home entry-cover--' . get_theme_mod( 'home-hero-overlay-style', 'default' ), array( 'size' => 'full' ) ); ?>>
                <div class="cover-wrapper container">
                    <?php
                    the_widget(
                        'Listify_Widget_Search_Listings',
                        apply_filters(
                            'listify_widget_search_listings_default',
                            array(
                                'title'       => $pagetitle,
                            )
                        ),
                        array(
                            'before_widget' => '<div class="listify_widget_search_listings">',
                            'after_widget'  => '</div>',
                            'before_title'  => '<div class="home-widget-section-title"><h1 class="home-widget-title">',
                            'after_title'   => '</h1></div>',
                            'widget_id'     => 'search-12391',
                            'id'            => 'widget-area-home',
                        )
                    ); ?>
                </div>
 </div>

<section class="breadcrumb">
	<div class="container">
		<?php if( function_exists( 'aioseo_breadcrumbs' ) ) aioseo_breadcrumbs(); ?>
	</div>
</section>

<section class="towing-services">
  <div class="container">
    <h2 class="section-heading"><?php echo $pagetitle;?></h2>
    <div class="grid-container">
		<?php $counter =0;
		foreach($job_result as $data){
			$counter++;
			if($counter>6)
				break;
			$post_id 	= $data[0];
			$post   = get_post( $post_id );
			$telephone 	= listify_get_listing( $post )->get_telephone();
			$link      	= listify_get_listing( $post )->get_telephone( true );
			//$list_category =  get_listing_category($post_id);
		?>
		
			<div class="grid-item">
				<a href="<?php echo esc_url( get_permalink($post_id ) ); ?>">
			  <figure><?php echo get_the_post_thumbnail( $post_id,  array( 300, 240),array( 'class' => 'alignnone size-medium wp-image-2620' )  );?></figure>
			   </a>
			  <div class="cnt">
				<a href="<?php echo esc_url( get_permalink($post_id ) ); ?>">
					<h3><?php echo get_the_title( $post_id );?></h3>
				</a>
				<!--<p>Services – <?php //echo implode(", ",$list_category); ?></p> -->
				<p><?php echo get_the_job_location( $post_id );?></p>
				<p><a href="tel:<?php echo esc_attr( $link ); ?>"><?php echo $telephone?></a></p>
			  </div>
			 
			</div>
			
		<?php }
		wp_reset_postdata();
		?>
    </div>
   
	<div id="show_more_main" class="grid-container"></div>
    <input type="hidden" id="listing_content" value="state-0">
    <input type="hidden" id="listing_row" value="1">
    <input type="hidden" id="list_count" value="<?php echo ($total_job-6);?>">
    <?php if($counter>6){?>
		<div class="lode-more"><a href="javascript:void(0)" class="show_more">Load More(<?php echo ($total_job-6);?>)</a></div>    

    <?php } ?>
  </div>
</section>

<section class="all-areas">
  <div class="container">
  <?php
	if( have_rows('content_section') ):

    while ( have_rows('content_section') ) : the_row();?>
		<h2 class="section-heading"><?php echo get_sub_field('section_heading');?></h2>
		<div class="list-main-bx">
		<?php echo get_sub_field('section_content');?>
		</div>
	<?php
		endwhile; 
	endif;
  ?>

    
  </div>
  
</section>

<section class="truck-services">
 
   <div class="container">
    <h2 class="section-heading"><?php the_field('other_truck_services_heading', 'option'); ?></h2>
    <div class="grid-container">
    <?php  if( have_rows('other_truck_services','option') ):
		while ( have_rows('other_truck_services','option') ) : the_row();
		$service_title = get_sub_field('title');
			$service_url = get_sub_field('page_url');
		?>
			<div class="grid-item">
				<a href="<?php echo $service_url;?>">
					<?php $image = get_sub_field('ican'); ?>
					<?php if( !empty( $image ) ): ?>
					<figure><img src="<?php echo esc_url($image['url']); ?>" alt="" class="alignnone size-medium wp-image-216" /></figure>
					<?php endif; ?>
					<div class="cnt">
					<h3><?php the_sub_field('title');?></h3>
					<p><?php the_sub_field('content');?></p>
					</div>
				</a>
			</div>
        <?php 
        endwhile;
        endif;
       ?>
      
    </div>
	<div class="lode-more view-all"><a href="<?php echo site_url("services");?>">View All Services</a></div>
  
  </div>


</section>

<?php
$page_content = get_the_content();
if(!empty($page_content)){?>
<section class="angeles-service">
  <div class="container">
    <h2 class="section-heading">
		<?php echo "Truck Service In US";?>
	</h2>
    <p>
		<?php echo the_content();?>
    </p>
  </div>
  </section>
<?php } ?>


<?php site_before_footer();?>


<?php get_footer(); ?>
