<?php
/**
 * Template Name: Layout: State Service
 *
 * @package Listify
 */

get_header(); 

global $wpdb;
//$page_title = get_the_title();
$page_title = get_field("page_title");

?>
	<div <?php echo apply_filters( 'listify_cover', 'homepage-cover page-cover entry-cover entry-cover--home entry-cover--' . get_theme_mod( 'home-hero-overlay-style', 'default' ), array( 'size' => 'full' ) ); ?>>
                <div class="cover-wrapper container">
                    <?php
                    the_widget(
                        'Listify_Widget_Search_Listings',
                        apply_filters(
                            'listify_widget_search_listings_default',
                            array(
                                'title'       => $page_title,
                            )
                        ),
                        array(
                            'before_widget' => '<div class="listify_widget_search_listings">',
                            'after_widget'  => '</div>',
                            'before_title'  => '<div class="home-widget-section-title"><h1 class="home-widget-title">',
                            'after_title'   => '</h1></div>',
                            'widget_id'     => 'search-12391',
                            'id'            => 'widget-area-home',
                        )
                    ); ?>
                </div>
 </div>

<section class="breadcrumb">
	<div class="container">
		<?php if( function_exists( 'aioseo_breadcrumbs' ) ) aioseo_breadcrumbs(); ?>
	</div>
</section>

<?php
	if( have_rows('content_section') ):
		while ( have_rows('content_section') ) : the_row();?>
			<section class="all-areas city-list-page">
				<div class="container">
					<h2 class="section-heading"><?php echo get_sub_field('section_heading');?> </h2>
					<div class="list-main-bx">
						<?php echo get_sub_field('section_content');?>
					</div>
				</div>
			</section>
		<?php
		endwhile; 
	endif;
	?>

<?php
$page_content = get_the_content();
if(!empty($page_content)){?>
<section class="angeles-service">
  <div class="container">
    <h2 class="section-heading">
		<?php echo "Truck Service In US";?>
	</h2>
    <p>
		<?php echo the_content();?>
    </p>
  </div>
  </section>
<?php } ?>


	<?php site_before_footer();?>

<?php get_footer(); ?>
