<?php
/**
 * Template Name: Service Template
 *
 * @package Listify
 */

if ( ! listify_has_integration( 'wp-job-manager' ) ) {
	return locate_template( array( 'page.php' ), true );
}

get_header();
$page_title = get_the_title();

$cat_id = get_field('service_category');

global $wpdb;

$job_result = $wpdb->get_results( "SELECT SQL_CALC_FOUND_ROWS  $wpdb->posts.ID FROM $wpdb->posts  LEFT JOIN $wpdb->term_relationships ON ($wpdb->posts.ID = $wpdb->term_relationships.object_id) WHERE 1=1  AND ( 
  $wpdb->term_relationships.term_taxonomy_id IN ($cat_id)
) AND $wpdb->posts.post_type = 'job_listing' AND (($wpdb->posts.post_status = 'publish' OR $wpdb->posts.post_status = 'expired')) GROUP BY $wpdb->posts.ID ORDER BY $wpdb->posts.post_date DESC",ARRAY_N );
$string = '0';
foreach($job_result as $data){
	 $string =$string.",".$data[0];
}

//echo "SELECT DISTINCT meta_value FROM $wpdb->postmeta WHERE meta_key LIKE 'geolocation_state_long' and post_id IN (".$string.")";
$results = $wpdb->get_results( "SELECT DISTINCT meta_value FROM $wpdb->postmeta WHERE meta_key LIKE 'geolocation_state_long' and meta_value!='' and post_id IN (".$string.") order by meta_value", OBJECT );

$total_job = count($job_result);
while ( have_posts() ) : the_post();
	$style = 'image';

	if ( 'none' !== $style ) {

		if ( in_array( $style, array( 'image', 'video' ) ) ) { ?>

			<div <?php echo apply_filters( 'listify_cover', 'homepage-cover page-cover entry-cover entry-cover--home entry-cover--' . get_theme_mod( 'home-hero-overlay-style', 'default' ), array( 'size' => 'full' ) ); ?>>
				<div class="cover-wrapper container">
					<?php
					the_widget(
						'Listify_Widget_Search_Listings',
						apply_filters(
							'listify_widget_search_listings_default',
							array(
								'title'       => $page_title,
								'description' => strip_shortcodes( get_the_content() ),
							)
						),
						array(
							'before_widget' => '<div class="listify_widget_search_listings">',
							'after_widget'  => '</div>',
							'before_title'  => '<div class="home-widget-section-title"><h1 class="home-widget-title">',
							'after_title'   => '</h1></div>',
							'widget_id'     => 'search-12391',
							'id'            => 'widget-area-home',
						)
					); ?>
				</div>

				

			</div>

		<?php } 

	}
endwhile;
?>
<section class="breadcrumb">
	<div class="container">
		<?php if( function_exists( 'aioseo_breadcrumbs' ) ) aioseo_breadcrumbs(); ?>
	</div>
</section>

<section class="towing-services">
  <div class="container">
    <h2 class="section-heading"><?php echo 'Top '. $page_title.' Companies';?></h2>
    <div class="grid-container">
		<?php //do_action( 'listify_output_results' ); 
		//do_action( 'listify_output_results', get_the_content() ); 
		?>
		<?php $counter =0;
		foreach($job_result as $data){
			$counter++;
			if($counter>6)
				break;
			$post_id 	= $data[0];
			$post   = get_post( $post_id );
			$telephone 	= listify_get_listing( $post )->get_telephone();
			$link      	= listify_get_listing( $post )->get_telephone( true );
			//$list_category =  get_listing_category($post_id);
			/*$post_type = get_post_type($post_id);   
    $taxonomies = get_object_taxonomies($post_type);   
    $taxonomy_names = wp_get_object_terms($post_id, $taxonomies,  array("fields" => "names")); 
echo '<pre>';
print_r($taxonomy_names);
echo '</pre>';*/
		?>
		
			<div class="grid-item">
				<a href="<?php echo esc_url( get_permalink($post_id ) ); ?>">
				<figure><?php echo get_the_post_thumbnail( $post_id,  array( 300, 240),array( 'class' => 'alignnone size-medium wp-image-2620' )  );?></figure>
				</a>
			  <div class="cnt">
				  <a href="<?php echo esc_url( get_permalink($post_id ) ); ?>">
				<h3><?php echo get_the_title( $post_id );?></h3>
				</a>
				<!--<p>Services – <?php //echo implode(", ",$list_category); ?></p> -->
				<p><?php echo get_the_job_location( $post_id );?></p>
				<p><a href="tel:<?php echo esc_attr( $link ); ?>"><?php echo $telephone?></a></p>
			  </div>
			</div>
			
		<?php }
		wp_reset_postdata();
		?>
		
    </div>
    <div id="show_more_main" class="grid-container"></div>
    <input type="hidden" id="listing_content" value="service-<?php echo $cat_id; ?>">
    <input type="hidden" id="listing_row" value="1">
    <input type="hidden" id="list_count" value="<?php echo ($total_job-6);?>">
   
    <?php if($total_job>6){?>
    <div class="lode-more"><a href="javascript:void(0)" class="show_more">Load More(<?php echo ($total_job-6);?>)</a></div>    
    <?php } ?>
  </div>
</section>
<section class="all-areas">
  <div class="container">
    <h2 class="section-heading">All Areas Served</h2>
    <ul>
		<?php
		foreach( $results as $author ) :
			if(!empty($author->meta_value)):
				$city_name = strtolower($author->meta_value);
				$url = site_url( '/us/'.$city_name, 'https' );
				echo'<li><a href="'.$url.'">'; echo $author->meta_value; echo '</a></li>';
			endif;
		endforeach;
		wp_reset_postdata();
		?>
    </ul>
  </div>
  
</section>

<section class="truck-services">
 
   <div class="container">
    <h2 class="section-heading"><?php the_field('other_truck_services_heading', 'option'); ?></h2>
    <div class="grid-container">
     <?php  if( have_rows('other_truck_services','option') ):
    while ( have_rows('other_truck_services','option') ) : the_row();?>
		<div class="grid-item">
			<a href="<?php the_sub_field('page_url');?>">
				<?php $image = get_sub_field('ican'); ?>
				<?php if( !empty( $image ) ): ?>
				<figure><img src="<?php echo esc_url($image['url']); ?>" alt="" class="alignnone size-medium wp-image-216" /></figure>
				<?php endif; ?>
				<div class="cnt">
				<h3><?php the_sub_field('title');?></h3>
				<p><?php the_sub_field('content');?></p>
				</div>
			</a>
		</div>
        <?php 
        endwhile;
        endif;
       ?>
      
    </div>
	<div class="lode-more view-all"><a href="<?php echo site_url("services");?>">View All Services</a></div>
  </div>
</section>

<section class="angeles-service">
  <div class="container">
    <h2 class="section-heading">
		<?php echo $page_title;?>
	</h2>
    <p><?php echo get_field('service_description');?></p>
  </div>
  </section>

<section class="faq-section">
  <div class="container">
	<h2 class="section-heading">
		<?php echo "FAQs About ".$page_title;?>
	</h2>
	<div id="accordion" class="accordion-container">
		<?php echo do_shortcode('[wp-faq-schema title="" accordion=1]'); ?>
	</div>
    
  </div>
</section>

<?php site_before_footer();?>


<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script type="text/javascript">
  //Accordion 
    $(function() {
      var Accordion = function(el, multiple) {
        this.el = el || {};
        this.multiple = multiple || false;
        var links = this.el.find('.article-title');
        links.on('click', {
          el: this.el,
          multiple: this.multiple
        }, this.dropdown)
      }
      Accordion.prototype.dropdown = function(e) {
        var $el = e.data.el;
        $this = $(this),
        $next = $this.next();
        $next.slideToggle();
        $this.parent().toggleClass('open');
        if (!e.data.multiple) {
        $el.find('.accordion-content').not($next).slideUp().parent().removeClass('open');
        };
      }
      var accordion = new Accordion($('.accordion-container'), false);
    }); 
</script>
<?php get_footer(); ?>


