<?php
/**
 * Template Name: Service List Template
 *
 * @package Listify
 */

if ( ! listify_has_integration( 'wp-job-manager' ) ) {
	return locate_template( array( 'page.php' ), true );
}

get_header();
$page_title = get_the_title();
		
global $wpdb;
//$query = "SELECT DISTINCT meta_value FROM $wpdb->postmeta WHERE meta_key = 'geolocation_state_long' and meta_value!='' ORDER BY meta_value;";
//$results = $wpdb->get_results( $query );
//$pages = get_pages(array( 'post_type' => 'page', 'meta_key' => '_wp_page_template', 'meta_value' => 'page-templates/template-service.php' ) );

while ( have_posts() ) : the_post();
	$style = 'image';

	if ( 'none' !== $style ) {

		if ( in_array( $style, array( 'image', 'video' ) ) ) { ?>

			<div <?php echo apply_filters( 'listify_cover', 'homepage-cover page-cover entry-cover entry-cover--home entry-cover--' . get_theme_mod( 'home-hero-overlay-style', 'default' ), array( 'size' => 'full' ) ); ?>>
				<div class="cover-wrapper container">
					<?php
					the_widget(
						'Listify_Widget_Search_Listings',
						apply_filters(
							'listify_widget_search_listings_default',
							array(
								'title'       => $page_title,
								
							)
						),
						array(
							'before_widget' => '<div class="listify_widget_search_listings">',
							'after_widget'  => '</div>',
							'before_title'  => '<div class="home-widget-section-title"><h1 class="home-widget-title">',
							'after_title'   => '</h1></div>',
							'widget_id'     => 'search-12391',
							'id'            => 'widget-area-home',
						)
					); ?>
				</div>

				

			</div>

		<?php } 

	}
endwhile;
?>
<section class="breadcrumb">
	<div class="container">
		<?php if( function_exists( 'aioseo_breadcrumbs' ) ) aioseo_breadcrumbs(); ?>
	</div>
</section>

<section class="truck-services">
 
   <div class="container">
    <h2 class="section-heading">Truck Services</h2>
    <div class="grid-container">
     <?php  
     wp_reset_query();
		$query = new WP_Query( array(
			'post_type'  => 'page',
			'nopaging' 	=> true,
			//'posts_per_page' => 100,
			//'offset'         => 0,
			'order' => 'ASC',
			'orderby' => 'title',
			'post_status'    => 'publish',
			'meta_key'   => '_wp_page_template',
			'meta_value' => 'page-templates/template-service.php'
		) );
		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) : $query->the_post(); // WP loop
				
				?>
				<div class="grid-item">
			<a href="<?php echo get_permalink();?>">
				<?php $image = get_field('service_logo'); ?>
				<?php if( !empty( $image ) ): ?>
				<figure>
					<?php echo wp_get_attachment_image( $image['ID'],  array( 300, 240),array( 'class' => 'alignnone size-medium wp-image-216' )  );?>
					</figure>
				<?php endif; ?>
				<div class="cnt">
				<h3><?php the_title();?></h3>
				<p><?php the_field('short_description');?></p>
				</div>
			</a>
		</div>
				<?php
			endwhile; // end of the loop.
		} else { // in case there are no pages with this template
			echo 'No Service available';
		}
		wp_reset_query();
       ?>
      
    </div>
  </div>


</section>
<?php dynamic_sidebar( 'widget-area-footer-top' ); ?>

<?php site_before_footer();?>


<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script type="text/javascript">
  //Accordion 
    $(function() {
      var Accordion = function(el, multiple) {
        this.el = el || {};
        this.multiple = multiple || false;
        var links = this.el.find('.article-title');
        links.on('click', {
          el: this.el,
          multiple: this.multiple
        }, this.dropdown)
      }
      Accordion.prototype.dropdown = function(e) {
        var $el = e.data.el;
        $this = $(this),
        $next = $this.next();
        $next.slideToggle();
        $this.parent().toggleClass('open');
        if (!e.data.multiple) {
        $el.find('.accordion-content').not($next).slideUp().parent().removeClass('open');
        };
      }
      var accordion = new Accordion($('.accordion-container'), false);
    }); 
</script>
<?php get_footer(); ?>


