<?php
/**
 * Template Name: Layout: city
 *
 * @package Listify
 */

get_header(); 

$request_url = str_replace("https://","", $_SERVER['REQUEST_URI']);
$orig_URL = explode("?",$request_url);
$stripped = ltrim(rtrim($orig_URL[0],'/'),'/');
$stripped = explode('/',$stripped);
$query_count =  count($stripped );
$laststate = end($stripped);

$state_count = 3;
$city_count = 4;
function replace_url_name($content){
	$string = str_replace('-',' ',$content);
	return $string;
}
if( $laststate == 'cities')
{
	 get_template_part( 'modules/cities'); 
}
else
{	
	//echo "<br/>";
	global $wpdb;
	$error_data=false;
	$reportstate = ucwords(str_replace("-"," ", $laststate));
	$check_city = '';
	//echo "--".$query_count."--";
	if($query_count==2)
	{
		$states1	= get_state();
		$key = array_search($reportstate, $states1);
		if($key>=0)
			$check_city= 'state';
	}
	if($query_count==3){
		$states1	= get_city();
		$key = array_search($reportstate, $states1);
		if($key>=0)
			$check_city= 'city';
	}
	
	$states	= get_state_city();
	
	/*$key = array_search_id($reportstate, $states, array('$'));
	//strpos("$ --> STATE_NAME --> 0","STATE_NAME")
	if(preg_match('/\STATE_NAME\b/', $key)){
		$check_city= 'state';
	}elseif(preg_match('/\CITY_NAME\b/', $key)){
		$check_city= 'city';
	}*/
/*	echo '<pre>';
	print_r($states);
	echo '</pre>';*/
//echo "==".$check_city."==".$key ."==".$reportstate."==";
//die();

	$service_name = $pagetitle =$pagetitle2 = '';
	$str_to_replace = $service_to_replace = '';
	$pagetitle = "[SERVICE] in [NAME]";
	$pagetitle2 = "[SERVICE] in [NAME]";
	switch ($check_city) {
		case "state":
			if($query_count!= $state_count)
			{
				$error_data = true;
				break;
			}else{
				$str_to_replace = $reportstate;
				$state_name = $reportstate;
				$search_param = "state_service-".$laststate;
				$pagetitle = str_replace('[NAME]',$reportstate,$pagetitle);
				$pagetitle2 = str_replace('[SERVICE]','Top Truck Service Companies',$pagetitle);
				$pagetitle = str_replace('[SERVICE]','Top Truck Services',$pagetitle);
				
				$service_type= 'state_service';
				$job_result = $wpdb->get_results( "SELECT DISTINCT post_id FROM $wpdb->postmeta WHERE meta_key LIKE 'geolocation_state_long' and meta_value = '".$reportstate."' ", ARRAY_N );
				
				foreach($states as $data){
					if($data['STATE_NAME']==ucwords($reportstate))
					{
						$final_state_name=$reportstate;
						$results = $data['CITY_NAME'];
						break;
					}
				}
			}
			break;
		case "city":	
			if($query_count!= $city_count)
			{
				$error_data = true;
				break;
			}
			else{
				$str_to_replace = $reportstate;
				$search_param = "city_service-".$laststate;
				$pagetitle = str_replace('[NAME]',$reportstate,$pagetitle);
				$pagetitle2 = str_replace('[SERVICE]','Top Truck Service Companies',$pagetitle);
				$pagetitle = str_replace('[SERVICE]','Top Truck Services',$pagetitle);
				$service_type= 'city_service';
				$state_name = replace_url_name($stripped[($state_count-1)]);
				$city_name = $reportstate;
				
				$job_result = $wpdb->get_results( "SELECT DISTINCT post_id FROM $wpdb->postmeta WHERE meta_key LIKE 'geolocation_city' and meta_value = '".$reportstate."' ", ARRAY_N );
				foreach($states as $data){
					if($data['STATE_NAME']== ucwords($state_name))
					{
						$final_state_name=$state_name;
						$results = $data['CITY_NAME'];
						break;
					}
				}
			}
			break;
		default:
			$services = get_services();
			$count=0;
			/*echo '<pre>';
			print_r($services);
			echo '</pre>';*/
			while ( $services->have_posts() ) :
				$services->the_post();
				$service_arr[$count]['name']= get_the_title(); 
				$service_arr[$count]['id']= get_the_ID(); 
				$count++;
			endwhile;
			
			foreach($service_arr as $services)
			{
				if($services['name'] == $reportstate)
				{
					$error_data=false;
					$service_name = $services['name'];
					$cat_id = get_field('service_category',$services['id']);
					$check_city= 'service';
					//echo "==".$query_count."==".$city_count."==".$state_count."==";
					$service_max= ($city_count+1);
					if($query_count==$city_count)
						$service_type= 'state_service';
					if($query_count== $service_max)
						$service_type= 'city_service';
					
					
					if($service_type ==  'city_service')
					{
						$str_to_replace = $service_name;
						$search_param = "sc_service-".$laststate;
						$city_name = replace_url_name($stripped[($city_count-1)]);
						$state_name = replace_url_name($stripped[($state_count-1)]);
						$pagetitle = str_replace('[NAME]',ucwords($city_name),$pagetitle);
						$pagetitle2 = str_replace('[SERVICE]','Top '.ucwords($service_name).' Companies',$pagetitle);
						$pagetitle = str_replace('[SERVICE]',ucwords($service_name),$pagetitle);
						
						$str_to_replace = $city_name;
						$service_to_replace = $service_name;
						$job_result = $wpdb->get_results( "SELECT SQL_CALC_FOUND_ROWS  $wpdb->posts.ID FROM $wpdb->posts  LEFT JOIN $wpdb->term_relationships ON ($wpdb->posts.ID = $wpdb->term_relationships.object_id) WHERE 1=1  AND ( 
  $wpdb->term_relationships.term_taxonomy_id IN ($cat_id)
) AND $wpdb->posts.post_type = 'job_listing' AND (($wpdb->posts.post_status = 'publish' OR $wpdb->posts.post_status = 'expired')) GROUP BY $wpdb->posts.ID ORDER BY $wpdb->posts.post_date DESC",ARRAY_N );
						

					}
					if($service_type ==  'state_service')
					{
						$str_to_replace = $service_name;
						$search_param = "s_service-".$laststate;
						$city_name = replace_url_name($stripped[($city_count-1)]);
						$state_name = replace_url_name($stripped[($state_count-1)]);
						$pagetitle = str_replace('[NAME]',ucwords($state_name),$pagetitle);
						$pagetitle2 = str_replace('[SERVICE]','Top '.ucwords($service_name).' Companies',$pagetitle);
						$pagetitle = str_replace('[SERVICE]',ucwords($service_name),$pagetitle);
						
						$str_to_replace = $state_name;
						$service_to_replace = $service_name;
						$job_result = $wpdb->get_results( "SELECT SQL_CALC_FOUND_ROWS  $wpdb->posts.ID FROM $wpdb->posts  LEFT JOIN $wpdb->term_relationships ON ($wpdb->posts.ID = $wpdb->term_relationships.object_id) WHERE 1=1  AND ( 
  $wpdb->term_relationships.term_taxonomy_id IN ($cat_id)
) AND $wpdb->posts.post_type = 'job_listing' AND (($wpdb->posts.post_status = 'publish' OR $wpdb->posts.post_status = 'expired')) GROUP BY $wpdb->posts.ID ORDER BY $wpdb->posts.post_date DESC",ARRAY_N );
					}
					
					foreach($states as $data){
						//echo "<br/>==".$data['STATE_NAME']."==<br/>";
						 if($data['STATE_NAME']==ucwords($state_name))
						 {
							$final_state_name=$state_name;
							$results = $data['CITY_NAME'];
							break;
						}
					}
					break;
					
				}
				else
				{
					$error_data=true;
				}
			};
		break;
	}
	if($error_data)
	{
		$page_url = site_url("us");
		header('Location: '.$page_url);
		exit();
	}	
	
	$total_job = count($job_result);

	function replace_city_name($content,$city_name){
		$city_name = ucwords($city_name);
		$string = str_replace("[NAME]",$city_name,$content);
		return $string;
	}

	function replace_city_service_name($content,$city_name,$service_name){
		$city_name = ucwords($city_name);
		$service_name = ucwords($service_name);
		$string = str_replace("[NAME]",$city_name,$content);
		$string = str_replace("[SERVICE]",$service_name,$string);
		return $string;
	}
	function get_custom_url($name)
	{
		$url = preg_replace('/\s+/','-',(site_url( '/us/'.$name.'/' )));
		return $url;
	}
	?>
	<div <?php echo apply_filters( 'listify_cover', 'homepage-cover page-cover entry-cover entry-cover--home entry-cover--' . get_theme_mod( 'home-hero-overlay-style', 'default' ), array( 'size' => 'full' ) ); ?>>
		<div class="cover-wrapper container">
			<?php
			the_widget(
				'Listify_Widget_Search_Listings',
				apply_filters(
					'listify_widget_search_listings_default',
					array(
						'title'       => $pagetitle,
					)
				),
				array(
					'before_widget' => '<div class="listify_widget_search_listings">',
					'after_widget'  => '</div>',
					'before_title'  => '<div class="home-widget-section-title"><h1 class="home-widget-title">',
					'after_title'   => '</h1></div>',
					'widget_id'     => 'search-12391',
					'id'            => 'widget-area-home',
				)
			); ?>
		</div>
	</div>

	<section class="breadcrumb">
		<div class="container">
			<div class="aioseo-breadcrumbs">
				<span class="aioseo-breadcrumb"><a href="<?php echo home_url("/");?>" title="Home">Home</a></span>
				<span class="aioseo-breadcrumb-separator">&gt;</span>
				<span class="aioseo-breadcrumb"><a href="<?php echo site_url("us/");?>" title="US">US</a></span>
				<span class="aioseo-breadcrumb-separator">&gt;</span>
				<?php
				if($check_city=='state'){?>
					<span class="aioseo-breadcrumb"><?php echo ucwords($state_name);?></span>
				<?php }else{?>
					<span class="aioseo-breadcrumb"><a href="<?php echo get_custom_url($state_name);?>"><?php echo ucwords($state_name);?></a></span>
					<?php } ?>
				<?php
				if($check_city=='city')
				{
					echo '<span class="aioseo-breadcrumb-separator">&gt;</span>';
					echo '<span class="aioseo-breadcrumb">'. ucwords($city_name).'</span>';
				}
				if($check_city=='service')
				{
					if($service_type ==  'city_service')
					{
						echo '<span class="aioseo-breadcrumb-separator">&gt;</span>';
						echo '<span class="aioseo-breadcrumb"><a href="'. get_custom_url($state_name."/".$city_name).'">'. ucwords($city_name).'</a></span>';
					}
					echo '<span class="aioseo-breadcrumb-separator">&gt;</span>';
					echo '<span class="aioseo-breadcrumb">'. ucwords($service_to_replace).'</span>';
				}?>
			</div>
		</div>
	</section>

	<section class="towing-services">				
	  <div class="container">
		<h2 class="section-heading"><?php echo $pagetitle2;?></h2>
		<div class="grid-container">
			<?php $counter =0;
			if(!empty($job_result))
			{
			foreach($job_result as $data){
				$counter++;
				if($counter>6)
					break;
				$post_id 	= $data[0];
				$post   = get_post( $post_id );
				$telephone 	= listify_get_listing( $post )->get_telephone();
				$link      	= listify_get_listing( $post )->get_telephone( true );
				//$list_category =  get_listing_category($post_id);
			?>
			
				<div class="grid-item">
					<a href="<?php echo esc_url( get_permalink($post_id ) ); ?>">
				  <figure><?php echo get_the_post_thumbnail( $post_id,  array( 300, 240),array( 'class' => 'alignnone size-medium wp-image-2620' )  );?></figure>
				   </a>
				  <div class="cnt">
					<a href="<?php echo esc_url( get_permalink($post_id ) ); ?>">
						<h3><?php echo get_the_title( $post_id );?></h3>
					</a>
					<!--<p>Services – <?php //echo implode(", ",$list_category); ?></p>  -->
					<p><?php echo get_the_job_location( $post_id );?></p>
					<p><a href="tel:<?php echo esc_attr( $link ); ?>"><?php echo $telephone?></a></p>
				  </div>
				 
				</div>
				
			<?php }
			}
			else{
				echo '<div style="text-align:center;width: 100%;">Sorry! Currently No Truck Service Available.		</div>';
			}
			wp_reset_postdata();
			?>
		</div>
		<div id="show_more_main" class="grid-container"></div>
		<input type="hidden" id="listing_content" value="<?php echo $search_param; ?>">
		<input type="hidden" id="listing_row" value="1">
		<input type="hidden" id="list_count" value="<?php echo ($total_job-6);?>">
		<?php if($counter>6){?>
			<div class="lode-more"><a href="javascript:void(0)" class="show_more">Load More(<?php echo ($total_job-6);?>)</a></div>    

		<?php } ?>
	  </div>
	</section>
	<section class="all-areas">
	  <div class="container">
		<h2 class="section-heading">All Areas Served In <?php echo ucwords($final_state_name);?> </h2>
		<div class="list-main-bx">
		  <?php
			$total_count= count($results);
			$col_limit = ceil($total_count/5);
			$row_count =0;
			foreach( $results as $author ) :
				if($row_count==0)							
					echo '<ul>';
				$row_count++;
				$serve_url	=  '/us/'.$final_state_name.'/'.$author .'/' ;
				if($check_city=='service')
					$serve_url	.= $service_to_replace.'/';
				$url = strtolower(preg_replace('/\s+/','-',(site_url( $serve_url ))));
				echo'<li><a href="'.$url.'">'; echo $author; echo '</a></li>';
				if ($row_count== $col_limit)
				{
					$row_count=0;
					echo '</ul>';
				}
			endforeach;
			wp_reset_postdata();
			?>
			</div>
	  </div>
	  
	</section>

	<section class="truck-services">
	 
	   <div class="container">
		<h2 class="section-heading"><?php the_field('other_truck_services_heading', 'option'); ?></h2>
		<div class="grid-container">
			<?php  
			$query = get_services();
		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) : $query->the_post(); // WP loop
				$service_title = get_the_title();
				$final_ser_title=  '/us/'.$state_name.'/';
				if($service_type ==  'city_service')
					$final_ser_title .=  $city_name.'/';
				$final_ser_title .=  $service_title.'/';
				$service_url = strtolower(preg_replace('/\s+/','-',(site_url( $final_ser_title))));
				?>
				<div class="grid-item">
			<a href="<?php echo $service_url;?>">
				<?php $image = get_field('service_logo'); ?>
				<?php if( !empty( $image ) ): ?>
				<figure>
					<?php echo wp_get_attachment_image( $image['ID'],  array( 300, 240),array( 'class' => 'alignnone size-medium wp-image-216' )  );?>
					</figure>
				<?php endif; ?>
				<div class="cnt">
				<h3><?php the_title();?></h3>
				<p><?php the_field('short_description');?></p>
				</div>
			</a>
		</div>
				<?php
			endwhile; // end of the loop.
		} else { // in case there are no pages with this template
			echo 'No Service available';
		}
		wp_reset_query();
       ?>
       
		
		  
		</div>
		<!--<div class="lode-more view-all"><a href="<?php //echo site_url("services/");?>">View All Services</a></div> -->
	  </div>


	</section>


	<section class="angeles-service">
	  <div class="container">
		<h2 class="section-heading">
			<?php 
			if($check_city=='service')
				$towing_service_title = get_field('towing_service_heading', 'option'); 
			else
				$towing_service_title = get_field('towing_service', 'option'); 
			echo replace_city_service_name($towing_service_title,$str_to_replace,$service_to_replace);
			?>
		</h2>
		<p>
			<?php 
			if($check_city == 'service')
				$service_text = get_field('towing_service_text_service', 'option'); 
			else
				$service_text = get_field('towing_service_text', 'option'); 
			echo replace_city_service_name($service_text,$str_to_replace,$service_to_replace);?>
		</p>
		<!--<h4><?php //the_field('sub_heading_towing_service', 'option'); ?></h4>
		<p><?php //the_field('sub_heading_towing_content', 'option'); ?></p>-->
	  </div>
	  </section>

	<section class="faq-section">
	  <div class="container">
		<h2 class="section-heading">
			<?php 
			if($check_city=='service')
				$faq_section_title = get_field('faqs_about_towing_heading_service', 'option');
			else
				$faq_section_title = get_field('faqs_about_towing_heading', 'option');
			echo replace_city_service_name($faq_section_title,$str_to_replace,$service_to_replace); ?>
		</h2>

		<?php
		if($check_city=='service'){
			if( have_rows('faqs_tab_service','option') ):
				while ( have_rows('faqs_tab_service','option') ) : the_row();?>
					<div id="accordion" class="accordion-container">
					<article class="content-entry">
						<h4 class="article-title">
							<?php $faq_title = get_sub_field('title');
							echo replace_city_service_name($faq_title,$str_to_replace,$service_to_replace);?>
						</h4>
						<div class="accordion-content">                                 
						<p>
							<?php $faq_content = get_sub_field('content');
							echo replace_city_service_name($faq_content,$str_to_replace,$service_to_replace);?>
						</p>

					  </div>
					  </article>

					</div> 
				<?php 
				endwhile;
			endif;
		}
		else{
		
			if( have_rows('faqs_tab','option') ):
				while ( have_rows('faqs_tab','option') ) : the_row();?>
					<div id="accordion" class="accordion-container">
						<article class="content-entry">
							<h4 class="article-title">
								<?php $faq_title = get_sub_field('title');
								echo replace_city_service_name($faq_title,$str_to_replace,$service_to_replace);?>
							</h4>
							<div class="accordion-content">                                 
							<p>
								<?php $faq_content = get_sub_field('content');
								echo replace_city_service_name($faq_content,$str_to_replace,$service_to_replace);?>
							</p>

						  </div>
						  </article>
					</div> 
				<?php 
				endwhile;
			endif;
		}
		?>
	 
	  </div>
	</section>

<?php site_before_footer();?>

<?php
}
?>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script type="text/javascript">
  //Accordion 
    $(function() {
      var Accordion = function(el, multiple) {
        this.el = el || {};
        this.multiple = multiple || false;
        var links = this.el.find('.article-title');
        links.on('click', {
          el: this.el,
          multiple: this.multiple
        }, this.dropdown)
      }
      Accordion.prototype.dropdown = function(e) {
        var $el = e.data.el;
        $this = $(this),
        $next = $this.next();
        $next.slideToggle();
        $this.parent().toggleClass('open');
        if (!e.data.multiple) {
        $el.find('.accordion-content').not($next).slideUp().parent().removeClass('open');
        };
      }
      var accordion = new Accordion($('.accordion-container'), false);
    }); 
</script>

<?php get_footer(); ?>
