<?php
/**
 * Template Name: Layout: City Service
 *
 * @package Listify
 */

get_header(); 

global $wpdb;
//$page_title = get_the_title();
$page_title = get_field("page_title");

?>
	<div <?php echo apply_filters( 'listify_cover', 'homepage-cover page-cover entry-cover entry-cover--home entry-cover--' . get_theme_mod( 'home-hero-overlay-style', 'default' ), array( 'size' => 'full' ) ); ?>>
                <div class="cover-wrapper container">
                    <?php
                    the_widget(
                        'Listify_Widget_Search_Listings',
                        apply_filters(
                            'listify_widget_search_listings_default',
                            array(
                                'title'       => $page_title,
                            )
                        ),
                        array(
                            'before_widget' => '<div class="listify_widget_search_listings">',
                            'after_widget'  => '</div>',
                            'before_title'  => '<div class="home-widget-section-title"><h1 class="home-widget-title">',
                            'after_title'   => '</h1></div>',
                            'widget_id'     => 'search-12391',
                            'id'            => 'widget-area-home',
                        )
                    ); ?>
                </div>
 </div>

<section class="breadcrumb">
	<div class="container">
		<?php if( function_exists( 'aioseo_breadcrumbs' ) ) aioseo_breadcrumbs(); ?>
	</div>
</section>

<?php
$state_arr	= get_state_city();
$query = get_services();
		while ( $query->have_posts() ) : $query->the_post(); 
			$service_name= get_the_title();
		//$url = site_url( '/us/'.$city_name, 'https' );
						$state_counter =0;
			foreach( $state_arr as $state ) {
				$state_counter++;
			?>
			<section class="all-areas city-list-page">
				<div class="container">
					<h2 class="section-heading"><?php echo $service_name;?> in <?php echo $state['STATE_NAME'];?></h2>
					<div class="list-main-bx">
						<?php
						
						$total_count= count($state['CITY_NAME']);
						$col_limit = ceil($total_count/5);
						$row_count =0;
						foreach( $state['CITY_NAME'] as $cities ) {
							if($row_count==0)							
								echo '<ul>';
							$row_count++;
							$url = strtolower(preg_replace('/\s+/','-',(site_url( '/us/'.$state['STATE_NAME'].'/'.$cities.'/'.$service_name, 'https' ))));
							?>	
							<li><a href="<?php echo $url;?>"><?php echo $cities;?></a></li>
							<?php
							if ($row_count== $col_limit)
							{
								$row_count=0;
								echo '</ul>';
							}
						}
						?>
					</div>
			</div>
		</section>
		<?php 
		if($state_counter>3)
			break;
		}
		endwhile;
		wp_reset_postdata();
	?>

<?php
$page_content = get_the_content();
if(!empty($page_content)){?>
<section class="angeles-service">
  <div class="container">
    <h2 class="section-heading">
		<?php //echo "Truck Service In US";?>
	</h2>
    <p>
		<?php //echo the_content();?>
    </p>
  </div>
  </section>
<?php } ?>


<?php site_before_footer();?>


<?php get_footer(); ?>
