<?php

/**
 * Template Name: Layout: City Service search
 *
 * @package Listify
 */

get_header();

global $wpdb;

?>
<section class="breadcrumb">
  <div class="container">
    <?php if (function_exists('aioseo_breadcrumbs')) aioseo_breadcrumbs(); ?>
  </div>
</section>

<div class="alphabetic-bx">
  <ul id="mycity">
    <li id="A"><a href="javascript:void(0)" class="active">A</a></li>
    <li id="B"><a href="javascript:void(0)"> B </a></li>
    <li id="C"><a href="javascript:void(0)"> C </a></li>
    <li id="D"><a href="javascript:void(0)"> D </a></li>
    <li id="E"><a href="javascript:void(0)"> E </a></li>
    <li id="F"><a href="javascript:void(0)"> F </a></li>
    <li id="G"><a href="javascript:void(0)"> G </a></li>
    <li id="H"><a href="javascript:void(0)"> H </a></li>
    <li id="I"><a href="javascript:void(0)"> I </a></li>
    <li id="J"><a href="javascript:void(0)"> J </a></li>
    <li id="K"><a href="javascript:void(0)"> K </a></li>
    <li id="L"><a href="javascript:void(0)"> L </a></li>
    <li id="M"><a href="javascript:void(0)"> M </a></li>
    <li id="N"><a href="javascript:void(0)"> N </a></li>
    <li id="O"><a href="javascript:void(0)"> O </a> </li>
    <li id="P"><a href="javascript:void(0)"> P </a></li>
    <li id="Q"><a href="javascript:void(0)"> Q </a></li>
    <li id="R"><a href="javascript:void(0)"> R </a></li>
    <li id="S"><a href="javascript:void(0)"> S </a></li>
    <li id="T"><a href="javascript:void(0)"> T </a></li>
    <li id="U"><a href="javascript:void(0)"> U </a></li>
    <li id="V"><a href="javascript:void(0)"> V </a></li>
    <li id="W"><a href="javascript:void(0)"> W </a></li>
    <li id="X"><a href="javascript:void(0)"> X </a></li>
    <li id="Y"><a href="javascript:void(0)"> Y </a></li>
    <li id="Z"><a href="javascript:void(0)"> Z </a></li>

  </ul>

</div>

<div class="not-found-text">
  <div id="city-list"></div>
</div>

<div id="loader" class="lode-more ld-mr">
  <a href="javascript:void(0)" class="show_more">Loading...</a>
 
  </div>



<script>
  jQuery(document).ready(function($) {

    $(window).load(function() {
      $("#mycity li#A").click();
    });

    $("#mycity li").click(function() {


      var id = $(this).attr('id');
      
      var ajaxurl = '<?php echo admin_url("admin-ajax.php"); ?>';

      jQuery.ajax({
        type: "post",
        //dataType : "json",
        url: ajaxurl,
        data: {
          action: "search_city",
          value: id
        },
        beforeSend: function(){
           $("#city-list").hide();     
           $("#loader").show();
        },
        success: function(data) {
          $("#city-list").html(data.slice(0,-1));
        },
        complete:function(data){
          $("#city-list").show();
          $("#loader").hide();
         }
      })

      $('.alphabetic-bx a').click(function() {
      	$('.alphabetic-bx a.active').removeClass('active');
      	$(this).addClass('active');
      })



    });

  });
</script>



<?php site_before_footer(); ?>


<?php get_footer(); ?>