<?php
/**
 * Listify child theme.
 */
function listify_child_styles() {
    wp_enqueue_style( 'listify-child', get_stylesheet_uri() );
}
add_action( 'wp_enqueue_scripts', 'listify_child_styles', 999 );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'child-theme-css', get_stylesheet_directory_uri() . '/style.css' );

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles' );

/** Place any new code below this line */

/** Register custom widgets. */
function custom_widgets_init() {
	include_once( dirname( __FILE__ ) . '/widgets/class-widget-job_listing-custom-listing-labels.php' );
	include_once( dirname( __FILE__ ) . '/widgets/class-widget-job_listing-custom-cards.php' );
	include_once( dirname( __FILE__ ) . '/widgets/class-widget-job_listing-custom-short-desc.php' );
	include_once( dirname( __FILE__ ) . '/widgets/class-widget-job_listing-custom-social-profiles.php' );
	include_once( dirname( __FILE__ ) . '/widgets/class-widget-job_listing-custom-map.php' );
	include_once( dirname( __FILE__ ) . '/widgets/class-widget-home-custom_features.php' );

	register_widget( 'Listify_Custom_Widget_Listing_Labels' );
	register_widget( 'Listify_Custom_Widget_Cards' );
	register_widget( 'Listify_Custom_Widget_Short_Description' );
	register_widget( 'Listify_Custom_Widget_Listing_Social_Profiles' );
	register_widget( 'Listify_Custom_Widget_Listing_Map' );
	register_widget( 'Listify_Widget_Custom_Features' );
}
add_action( 'widgets_init', 'custom_widgets_init', 20 );

/** Classes Extend */
/*function custom_includes() {
	include_once( dirname( __FILE__ ) . '/includes/class-wp-job-manager-custom-template-filters.php' );
	include_once( dirname( __FILE__ ) . '/includes/class-wp-custom-job-manager.php' );
	
	new Listify_WP_Job_Manager_Custom_Template_Filters();
}
add_action( 'after_setup_theme', 'custom_includes' );*/


function filter_by_labels_field() {
/*


		wp_enqueue_script( 'astoundify-wp-job-manager-listing-labels' );
?>

<div class="filter_wide filter_by_tag astoundify-listing-labels">
	<?php esc_html_e( 'Filter by label:', 'wp-job-manager-listing-labels' ); ?>
	<span class="filter_by_tag_cloud astoundify-listing-labels-cloud"></span>

	<?php
	$labels = get_terms('job_listing_tag' );
		foreach ( $labels as $label ) {
			//$term = get_term_by( 'name', esc_attr( trim( $label ) ), astoundify_wpjmll_taxonomy() );

			if ( $label ) { // Make sure labels exists.
				echo '<input type="hidden" name="listing_label[]" value="' . esc_attr( $label->name ) . '" />';
			}
		}
	
	?>
</div>


<?php*/
	$dropdown_args = apply_filters(
			'listify_wp_job_manager_filters_dropdown_label',
			array(
				'taxonomy'        => 'job_listing_tag',
				'hierarchical'    => 1,
				'show_option_all' => __( 'What are you looking for?', 'listify' ),
				'name'            => 'search_labels',
				'orderby'         => 'name',
				'multiple'        => $atts['show_category_multiselect'] ? true : false,
				'selected'        => $atts['selected_label'],
			),
			$atts
		);
		?>
	
	<div class="search_labels search_labels--multiselect">
		<?php job_manager_dropdown_categories( $dropdown_args ); ?>
	</div>
	<?php
}
add_action( 'job_manager_job_filters_search_jobs_start', 'filter_by_labels_field' );

function dequeue_scripts_for_customization() {
		wp_dequeue_script( 'listify-results' );
		wp_dequeue_script( 'listify-listings' );
}
add_action( 'job_manager_job_filters_before', 'dequeue_scripts_for_customization' );


/**
 * This code gets your posted field and modifies the job search query
 */
function filter_by_salary_field_query_args( $query_args, $args ) {
	if ( isset( $_POST['form_data'] ) ) {
		parse_str( $_POST['form_data'], $form_data );

		// If this is set, we are filtering by salary
		if ( ! empty( $form_data['filter_by_salary'] ) ) {
			$selected_range = sanitize_text_field( $form_data['filter_by_salary'] );
			switch ( $selected_range ) {
				case 'upto20' :
					$query_args['meta_query'][] = array(
						'key'     => '_job_salary',
						'value'   => '20000',
						'compare' => '<',
						'type'    => 'NUMERIC'
					);
				break;
				case 'over60' :
					$query_args['meta_query'][] = array(
						'key'     => '_job_salary',
						'value'   => '60000',
						'compare' => '>=',
						'type'    => 'NUMERIC'
					);
				break;
				default :
					$query_args['meta_query'][] = array(
						'key'     => '_job_salary',
						'value'   => array_map( 'absint', explode( '-', $selected_range ) ),
						'compare' => 'BETWEEN',
						'type'    => 'NUMERIC'
					);
				break;
			}

			// This will show the 'reset' link
			add_filter( 'job_manager_get_listings_custom_filter', '__return_true' );
		}
	}
	return $query_args;
}
add_filter( 'job_manager_get_listings', 'filter_by_salary_field_query_args', 10, 2 );

/** Plugin Name: Listify - Remove "Add Photos" Link */

function custom_listify_remove_action_links() { 
	global $listify_job_manager;
 
	remove_action( 'listify_single_job_listing_actions_start', array( $listify_job_manager->gallery, 'add_link' ) );
	add_rewrite_rule('^bigrig411/us/([^/]*)/?','bigrig411/index.php?page_id=2600','top');

}
add_action( 'init', 'custom_listify_remove_action_links' );

add_filter( 'listify_has_ratings', '__return_false' );

function custom_radius_of_service() {
	$emergency_road_service = get_post_meta( get_the_ID(), '_emergency_road_service', true );
	if($emergency_road_service) {
		echo '<p class="radius">'.$emergency_road_service.'<p>';
	}
}
add_filter( 'single_job_listing_meta_start', 'custom_radius_of_service', 25 );

add_filter( 'facetwp_facet_dropdown_show_counts', '__return_false' );

function admin_add_card_fields( $fields ) {
  /*$fields['_visa'] = array(
    'label'       => __( 'Visa', 'wp-job-manager' ),
    'type'        => 'checkbox',
	'data_type'   => 'integer',
    'description' => ''
  );
  $fields['_paypal'] = array(
    'label'       => __( 'PayPal', 'wp-job-manager' ),
    'type'        => 'checkbox',
	'data_type'   => 'integer',
    'description' => ''
  );
  $fields['_mastercard'] = array(
    'label'       => __( 'Master Card', 'wp-job-manager' ),
    'type'        => 'checkbox',
	'data_type'   => 'integer',
    'description' => ''
  );
  $fields['_discover'] = array(
    'label'       => __( 'Discover', 'wp-job-manager' ),
    'type'        => 'checkbox',
	'data_type'   => 'integer',
    'description' => ''
  );
  $fields['_amex'] = array(
    'label'       => __( 'American Express', 'wp-job-manager' ),
    'type'        => 'checkbox',
	'data_type'   => 'integer',
    'description' => ''
  ); 
  $fields['_short_desc'] = array(
    'label'       => __( 'Short Description', 'wp-job-manager' ),
    'type'        => 'textarea',
    'description' => ''
  );*/
  $fields['_emergency_road_service'] = array(
    'label'       => __( '24/7 Emergency Road Services', 'wp-job-manager' ),
    'type'        => 'text',
    'description' => ''
  );
  $fields['_second_phone'] = array(
    'label'       => __( 'Additional phone:', 'wp-job-manager' ),
    'type'        => 'text',
    'description' => ''
  );
  return $fields;
}
add_filter( 'job_manager_job_listing_data_fields', 'admin_add_card_fields' );

add_action( 'widgets_init', 'listify_widgets_init_child' );
function listify_widgets_init_child() {
	//footer Top widget
	register_sidebar( listify_register_sidebar_arguments( 'widget-area-footer-top' ) );
}
function listify_register_sidebar_arguments( $sidebar ) {
	global $listify_strings;
	$args = array();
	if ( 'widget-area-footer-top' === $sidebar ) {
		$args = array(
			'name'          => __( 'Footer Top Widget', 'listify' ),
			'description'   => __( 'Widgets that appear on top of footer', 'listify' ),
			'id'            => 'widget-area-footer-top',
			'before_widget' => '<aside id="%1$s" class="top-widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h2 class="widget-title %s">',
			'after_title'   => '</h2>',
			
		);
	}
	return apply_filters( 'listify_register_' . $sidebar, $args, $sidebar );
}
function get_state()
{
	global $wpdb;
	$result_state = $wpdb->get_results( "SELECT ID,STATE_NAME FROM US_STATES order by STATE_NAME", ARRAY_A );
	$state_arr = array();
	foreach( $result_state as $state ) {
		$state_arr[]=$state['STATE_NAME'];
	}
	return $state_arr;
	
}
function get_city()
{
	global $wpdb;
	
		$results = $wpdb->get_results( "SELECT CITY FROM US_CITIES order by CITY", ARRAY_A );
		foreach($results as $city )
		{
			$state_arr[]=$city['CITY'];
		}
		
	return $state_arr;
	
}

function get_state_city()
{
	global $wpdb;
	$result_state = $wpdb->get_results( "SELECT ID,STATE_NAME FROM US_STATES order by STATE_NAME", ARRAY_A );
	$state_arr = array();
	foreach( $result_state as $state ) {
		$state_arr[$state['ID']]['STATE_NAME']=$state['STATE_NAME'];
		$results = $wpdb->get_results( "SELECT CITY FROM US_CITIES where ID_STATE = ".$state['ID']." order by CITY", ARRAY_A );
		foreach($results as $city )
		{
			$state_arr[$state['ID']]['CITY_NAME'][]=$city['CITY'];
		}
		//return $state_arr;
	}
	return $state_arr;
	
}
// PHP program to carry out multidimensional array search


// Function to recursively search for a given value
function array_search_id($search_value, $array, $id_path) {
	
	if(is_array($array) && count($array) > 0) {
		
		foreach($array as $key => $value) {

			$temp_path = $id_path;
			
			// Adding current key to search path
			array_push($temp_path, $key);

			// Check if this value is an array
			// with atleast one element
			if(is_array($value) && count($value) > 0) {
				$res_path = array_search_id(
						$search_value, $value, $temp_path);

				if ($res_path != null) {
					return $res_path;
				}
			}
			else if($value == $search_value) {
				return join(" --> ", $temp_path);
			}
		}
	}
	
	return null;
}

function get_services(){
	$query = new WP_Query( array(
			'post_type'  => 'page',
			'nopaging' 	=> true,
			//'posts_per_page' => 100,
			//'offset'         => 0,
			'order' => 'ASC',
			'orderby' => 'title',
			'post_status'    => 'publish',
			'meta_key'   => '_wp_page_template',
			'meta_value' => 'page-templates/template-service.php'
		) );
		return $query ;
}

function check_state_city($value)
{
	$value = ucwords($value);
	$states	= get_state_city();
	$key = array_search_id($value, $states, array('$'));
	//strpos("$ --> STATE_NAME --> 0","STATE_NAME")
	if(preg_match('/\STATE_NAME\b/', $key)){
		return 'state';
	}elseif(preg_match('/\CITY_NAME\b/', $key)){
		return 'city';
	}
	
}
function site_before_footer()
{
	ob_start();
	?>
	<aside id="listify_call_to_action-1" class="listify_call_to_action">
		<div class="call-to-action">
			<div class="container">
				<div class="row">
					<div class="col-sm-12 col-md-8 col-lg-9">
						<h2 class="cta-title">Start Your Search Now</h2>
						<div class="cta-description"><p>BigRig411 helps truck drivers, owner-operators and commercial trucking fleets locate expert service providers nationwide quickly and easily.</p>
						</div>
					</div>
					<div class="cta-button-wrapper col-sm-12 col-md-4 col-lg-3">
						<a class="button" href="<?php echo site_url();?>/listing-category/repair-tow/">Search Providers </a>
						<small class="cta-subtext"></small>
					</div>

				</div>
			</div>
		</div>

		<style>
		#listify_call_to_action-1 .call-to-action {
		color: #242424;
		background-color: #e5bf13;
		}

		#listify_call_to_action-1:after {
		background-color: #e5bf13;
		}

		#listify_call_to_action-1 .cta-description p,
		#listify_call_to_action-1 .cta-subtext {
		color: #2e2e2e}
		</style>

	</aside>
	<?php echo $content =  ob_get_clean();
		
}

add_action('rewrite_rules_array', 'new_rewrite_rules');

function new_rewrite_rules($rules){
        $newrules = array();
      //  $newrules[ '^us/([^/]*)/([^/]*)/?'] = 'index.php?page_id=2600&lists=$matches[1]&post=$matches[2]';
        $newrules[ '^us/([^/]*)/?'] = 'index.php?page_id=2600&lists=$matches[1]';
        return $newrules + $rules;
    }

function hook_schema() {
	if(is_page_template( 'page-templates/template-city.php' ))
	{
		$orig_URL = explode("?",$_SERVER['REQUEST_URI']);
		$stripped = ltrim(rtrim($orig_URL[0],'/'),'/');
		$stripped = explode('/',$stripped);
		$query_count =  count($stripped );
		$reportstate = end($stripped);
		$state_count =3;
		$city_count = 4;
		$state_name = '';
		if(isset($stripped[($state_count-1)]))
			$state_name = str_replace('-',' ',$stripped[($state_count-1)]);
		$city_name = str_replace('-',' ',$reportstate);
		if( $reportstate == 'cities')
		{
			 $city_name = 'US Cities';
		}
		
		$towing_service_title = get_field('faq_schema_for_citystate', 'option'); 		
		$city_name = ucwords($city_name);
		$towing_service_title = str_replace("[NAME]",$city_name,$towing_service_title);
		echo $formatted_text = str_replace(['<p>', '</p>'], '', $towing_service_title);
	}
}
add_action('wp_head', 'hook_schema');


add_filter( 'aioseo_canonical_url', 'aioseo_filter_canonical_url' );

function aioseo_filter_canonical_url( $url ) {
  if(is_page_template( 'page-templates/template-city.php' ))
	{
		$orig_URL = explode("?",$_SERVER['REQUEST_URI']);
		//$url = $orig_URL[0];
		$url = site_url( strtolower( str_replace('bigrig411/','',$orig_URL[0])), 'https' );
	}
   return $url;
}

add_filter( 'aioseo_title', 'aioseo_filter_title' );

function aioseo_filter_title( $title ) {
	if(is_page_template( 'page-templates/template-city.php' ))
	{
		$orig_URL = explode("?",$_SERVER['REQUEST_URI']);
		$stripped = ltrim(rtrim($orig_URL[0],'/'),'/');
		$stripped = explode('/',$stripped);
		$reportstate = str_replace("-"," ",end($stripped));
		
		$len	= count($stripped );
		if( $reportstate == 'cities')
		{
			 $city_name = 'US Cities';
			 $title = str_replace("[NAME]",$city_name,$title);
		}else{
			//$states	= get_state_city();
			$check_city = check_state_city($reportstate);
			switch ($check_city) {
			  case "state":
				$title = str_replace("[NAME]",ucwords(str_replace("-"," ", $reportstate)),$title);
				break;
			  case "city":
				$state_name = $stripped[($len-2)];
				$title = str_replace("[NAME]",ucwords(str_replace("-"," ", ($reportstate.", ".$state_name))),$title);
				break;
			  default:
				$meta_title_for_service_page = get_field('meta_title_for_service_page', 'option'); 
				$title = str_replace("[SERVICE]",ucwords($reportstate),$meta_title_for_service_page);
				$title = str_replace("[NAME]",ucwords(str_replace("-"," ", $stripped[($len-2)])),$title);
				break;
			}
		}
	}
   return $title;
}

add_filter( 'aioseo_schema_output', 'aioseo_filter_schema_output' );

function aioseo_filter_schema_output( $graphs ) {
    foreach ( $graphs as $index => $graph ) {
		if ( 'BreadcrumbList' === $graph['@type'] ) {
			unset( $graphs[ $index ] );
		}

		foreach ( $graph as $key => $value ) {
			if ( 'breadcrumb' === $key ) {
				unset( $graphs[ $index ][ $key ] );
			}
		}
	}
	return $graphs;
}

add_filter( 'aioseo_description', 'aioseo_filter_description' );

function aioseo_filter_description( $description ) {
  
   if(is_page_template( 'page-templates/template-city.php' ))
	{
		$orig_URL = explode("?",$_SERVER['REQUEST_URI']);
		$stripped = ltrim(rtrim($orig_URL[0],'/'),'/');
		$stripped = explode('/',$stripped);
		$reportstate = str_replace("-"," ",end($stripped));
		
		$len	= count($stripped );
		if( $reportstate == 'cities')
		{
			 $city_name = 'US Cities';
			 $description = str_replace("[NAME]",$city_name,$description);
		}else{
			//$states	= get_state_city();
			$check_city = check_state_city($reportstate);
			switch ($check_city) {
			  case "state":
				$description = str_replace("[NAME]",$reportstate,$description);
				break;
			  case "city":
				$description = str_replace("[NAME]",$reportstate,$description);
				break;
			  default:
				$meta_title_for_service_page = get_field('meta_description_for_service_page', 'option'); 
				$description = str_replace("[SERVICE]",$reportstate,$meta_title_for_service_page);
				$description = str_replace("[NAME]",$stripped[($len-2)],$description);
				break;
			}
		}
	}
   
   return $description;
}

function filter_wpseo_term_description_for_recalculation( $description, $item ) { 
    if(is_page_template( 'page-templates/template-city.php' ))
	{
		$orig_URL = explode("?",$_SERVER['REQUEST_URI']);
		$stripped = ltrim(rtrim($orig_URL[0],'/'),'/');
		$stripped = explode('/',$stripped);
		$reportstate = str_replace("-"," ",end($stripped));
		
		$len	= count($stripped );
		if( $reportstate == 'cities')
		{
			 $city_name = 'US Cities';
			 $description = str_replace("[NAME]",$city_name,$description);
		}else{
			//$states	= get_state_city();
			$check_city = check_state_city($reportstate);
			switch ($check_city) {
			  case "state":
				$description = str_replace("[NAME]",$reportstate,$description);
				break;
			  case "city":
				$description = str_replace("[NAME]",$reportstate,$description);
				break;
			  default:
				$meta_title_for_service_page = get_field('meta_description_for_service_page', 'option'); 
				$description = str_replace("[SERVICE]",$reportstate,$meta_title_for_service_page);
				$description = str_replace("[NAME]",$stripped[($len-2)],$description);
				break;
			}
		}
	}
    return $description; 
}; 
         
// add the filter 
//add_filter( 'wpseo_term_description_for_recalculation', 'filter_wpseo_term_description_for_recalculation', 10, 2 );


function add_ajaxurl_cdata_to_front(){ ?>
<script type="text/javascript">
    ajaxurl = '<?php echo admin_url( "admin-ajax.php"); ?>'
</script>

<?php }
 add_action( 'wp_head', 'add_ajaxurl_cdata_to_front', 1);
 add_action( 'wp_footer', 'add_js_to_wp_footer' );
  function add_js_to_wp_footer() { ?>
    <script type="text/javascript">
	  jQuery(document).on('click','.show_more',function(e){
     // jQuery("#field_6_17 select").on('change', function() {

       var product_line = jQuery(this).val();
       var post_id = jQuery('#listing_content').val().split('-');
       var post_row = parseInt(jQuery('#listing_row').val());
       var list_count = parseInt(jQuery('#list_count').val());
       
jQuery('.show_more').html('Loading...');
        jQuery.ajax({
         type: 'POST',
         url: ajaxurl,
         data: {
          "action": "view_site_description",
          post_row : post_row,
          post_page : post_id[0], 
          post_id : post_id[1],           // PHP: $_POST['first_name']
         }, success: function(data){
			jQuery('#listing_row').val((post_row+1));
			console.log((post_row+1));
			var remain_count =list_count-6;
			console.log('remain_count=='+remain_count);
			jQuery('#list_count').val(remain_count);
			if(remain_count<=0)
			{
				jQuery('.lode-more').hide();
			}
			else
			{
				jQuery('.show_more').html('Load More('+remain_count+')');
			}
			//var show more = (int)jQuery('#list_count').html();
			
			console.log('data=='+data);
			jQuery('#show_more_main').append(data);
        }
    });
    return false;
});
</script>
<?php } 
function view_site_description(){
	global $wpdb;
	 ob_start();
	$post_page = isset( $_POST['post_page'] ) ? $_POST['post_page'] : '';
	$post_id = isset( $_POST['post_id'] ) ? $_POST['post_id'] : 'N/A';
	$post_row = isset( $_POST['post_row'] ) ? (($_POST['post_row']*6)+1) : '7';
	if($post_page=='service')
	{
		$job_result = $wpdb->get_results( "SELECT SQL_CALC_FOUND_ROWS  $wpdb->posts.ID FROM $wpdb->posts  LEFT JOIN $wpdb->term_relationships ON ($wpdb->posts.ID = $wpdb->term_relationships.object_id) WHERE 1=1  AND ( 
  $wpdb->term_relationships.term_taxonomy_id IN ($post_id)
) AND $wpdb->posts.post_type = 'job_listing' AND (($wpdb->posts.post_status = 'publish' OR $wpdb->posts.post_status = 'expired')) GROUP BY $wpdb->posts.ID ORDER BY $wpdb->posts.post_date DESC Limit $post_row,6",ARRAY_N );
	}
	elseif($post_page=='state'){
		$job_result = $wpdb->get_results( "SELECT DISTINCT post_id FROM $wpdb->postmeta WHERE meta_key LIKE 'geolocation_state_long' and meta_value != '' Limit $post_row,6", ARRAY_N );

	}
	elseif($post_page=='state_service'){
		$job_result = $wpdb->get_results( "SELECT DISTINCT post_id FROM $wpdb->postmeta WHERE meta_key LIKE 'geolocation_state_long' and meta_value = '".$post_id."' Limit $post_row,6", ARRAY_N );
	}
	elseif($post_page=='city_service'){
		$job_result = $wpdb->get_results( "SELECT DISTINCT post_id FROM $wpdb->postmeta WHERE meta_key LIKE 'geolocation_city' and meta_value = '".$post_id."' Limit $post_row,6", ARRAY_N );
	}
	elseif($post_page=='sc_service'){
		$job_result = $wpdb->get_results( "SELECT DISTINCT post_id FROM $wpdb->postmeta WHERE meta_key LIKE 'geolocation_city' and meta_value = '".$post_id."' Limit $post_row,6", ARRAY_N );
	}
	else
	{
		echo "No Service Avaiable In This Area.";
	}
	if(!empty($job_result)){
		foreach($job_result as $jobdata){		
			$cur_post_id 	= $jobdata[0];
			$cur_post   = get_post( $cur_post_id );
			$telephone 	= listify_get_listing( $cur_post )->get_telephone();
			$link      	= listify_get_listing( $cur_post )->get_telephone( true );
			//$list_category =  get_listing_category($cur_post_id);
			?>
			<div class="grid-item">
				<a href="<?php echo esc_url( get_permalink($cur_post_id ) ); ?>">
				<figure><?php echo get_the_post_thumbnail( $cur_post_id,  array( 300, 240),array( 'class' => 'alignnone size-medium wp-image-2620' )  );?></figure>
				</a>
			  <div class="cnt">
				  <a href="<?php echo esc_url( get_permalink($cur_post_id ) ); ?>">
				<h3><?php echo get_the_title( $cur_post_id );?></h3>
				</a>
				<!--<p>Services – <?php //echo implode(",",$list_category); ?></p> -->
				<p><?php echo get_the_job_location( $cur_post_id );?></p>
				<p><a href="tel:<?php echo esc_attr( $link ); ?>"><?php echo $telephone?></a></p>
			  </div>
			</div>
		<?php }
	}
		wp_reset_postdata();
        wp_reset_query();?>
    <?php echo $content =  ob_get_clean();
  die();
  }
  add_action( 'wp_ajax_view_site_description', 'view_site_description' );
  add_action( 'wp_ajax_nopriv_view_site_description', 'view_site_description' );


  function get_listing_category($post_id)
  {
	$post_type = get_post_type($post_id);   
    $taxonomies = get_object_taxonomies($post_type);   
    $taxonomy_names = wp_get_object_terms($post_id, $taxonomies,  array("fields" => "names")); 
    $categories = array();
    $pattern = "/Start Your Heavy Duty Repair/i";
    if(!empty($taxonomy_names)) :
       foreach($taxonomy_names as $tax_name) :  
			if(!(preg_match($pattern, $tax_name)))
				$categories[] = $tax_name; 
		endforeach;
    endif;
    $categories = array_unique($categories);
    
    return $categories;
  }

add_action( 'wp_ajax_search_city', 'search_city' );
add_action( 'wp_ajax_nopriv_search_city', 'search_city' );

function search_city(){
global $wpdb;
$id = $_POST['value'];
$query = get_services();
ob_clean();
$data = '';

$results = $wpdb->get_results("SELECT * FROM US_STATES WHERE STATE_NAME LIKE '$id%'");
if(!empty($results)){
while ( $query->have_posts() ) : $query->the_post();
$service_name= get_the_title();
foreach($results as $result){
$city = $wpdb->get_results("SELECT CITY FROM US_CITIES WHERE ID_STATE = $result->ID");
$data .= '<section class="all-areas city-list-page">';
$data	.= '<div class="container">';
$data	.= '<h2 class="section-heading"> '.$service_name.' in '.$result->STATE_NAME.' </h2>';
$data	.=	'<div class="list-main-bx">';
$count = count($city);
$total = ceil($count/5);

$row = 0;

foreach($city as $citis){
if($row == 0){
	$data .= '<ul>';
}
	
$data .= '<li>'.$citis->CITY.'</li>';
$row++;
if($row == $total){
  $row = 0;
	$data .= '</ul>';
}

}
$data .= '</div>';
$data .= '</div>';
$data .= '</section>';
}
endwhile;
echo $data;
}else{

	echo 'There is no matching service available';
}


}