/*!

 * Chart.js

 * http://chartjs.org/

 * Version: 2.2.1

 *

 * Copyright 2016 Nick Downie

 * Released under the MIT license

 * https://github.com/chartjs/Chart.js/blob/master/LICENSE.md

 */

!function(t){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=t();else if("function"==typeof define&&define.amd)define([],t);else{("undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this).Chart=t()}}(function(){return function t(e,i,a){function n(r,l){if(!i[r]){if(!e[r]){var s="function"==typeof require&&require;if(!l&&s)return s(r,!0);if(o)return o(r,!0);var d=new Error("Cannot find module '"+r+"'");throw d.code="MODULE_NOT_FOUND",d}var u=i[r]={exports:{}};e[r][0].call(u.exports,function(t){var i=e[r][1][t];return n(i||t)},u,u.exports,t,e,i,a)}return i[r].exports}for(var o="function"==typeof require&&require,r=0;r<a.length;r++)n(a[r]);return n}({1:[function(t,e,i){},{}],2:[function(t,e,i){var a=t(6);function n(t){if(t){var e=[0,0,0],i=1,n=t.match(/^#([a-fA-F0-9]{3})$/);if(n){n=n[1];for(var o=0;o<e.length;o++)e[o]=parseInt(n[o]+n[o],16)}else if(n=t.match(/^#([a-fA-F0-9]{6})$/)){n=n[1];for(o=0;o<e.length;o++)e[o]=parseInt(n.slice(2*o,2*o+2),16)}else if(n=t.match(/^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/)){for(o=0;o<e.length;o++)e[o]=parseInt(n[o+1]);i=parseFloat(n[4])}else if(n=t.match(/^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/)){for(o=0;o<e.length;o++)e[o]=Math.round(2.55*parseFloat(n[o+1]));i=parseFloat(n[4])}else if(n=t.match(/(\w+)/)){if("transparent"==n[1])return[0,0,0,0];if(!(e=a[n[1]]))return}for(o=0;o<e.length;o++)e[o]=u(e[o],0,255);return i=i||0==i?u(i,0,1):1,e[3]=i,e}}function o(t){if(t){var e=t.match(/^hsla?\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/);if(e){var i=parseFloat(e[4]);return[u(parseInt(e[1]),0,360),u(parseFloat(e[2]),0,100),u(parseFloat(e[3]),0,100),u(isNaN(i)?1:i,0,1)]}}}function r(t){if(t){var e=t.match(/^hwb\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/);if(e){var i=parseFloat(e[4]);return[u(parseInt(e[1]),0,360),u(parseFloat(e[2]),0,100),u(parseFloat(e[3]),0,100),u(isNaN(i)?1:i,0,1)]}}}function l(t,e){return void 0===e&&(e=void 0!==t[3]?t[3]:1),"rgba("+t[0]+", "+t[1]+", "+t[2]+", "+e+")"}function s(t,e){return"rgba("+Math.round(t[0]/255*100)+"%, "+Math.round(t[1]/255*100)+"%, "+Math.round(t[2]/255*100)+"%, "+(e||t[3]||1)+")"}function d(t,e){return void 0===e&&(e=void 0!==t[3]?t[3]:1),"hsla("+t[0]+", "+t[1]+"%, "+t[2]+"%, "+e+")"}function u(t,e,i){return Math.min(Math.max(e,t),i)}function c(t){var e=t.toString(16).toUpperCase();return e.length<2?"0"+e:e}e.exports={getRgba:n,getHsla:o,getRgb:function(t){var e=n(t);return e&&e.slice(0,3)},getHsl:function(t){var e=o(t);return e&&e.slice(0,3)},getHwb:r,getAlpha:function(t){var e=n(t);if(e)return e[3];if(e=o(t))return e[3];if(e=r(t))return e[3]},hexString:function(t){return"#"+c(t[0])+c(t[1])+c(t[2])},rgbString:function(t,e){if(e<1||t[3]&&t[3]<1)return l(t,e);return"rgb("+t[0]+", "+t[1]+", "+t[2]+")"},rgbaString:l,percentString:function(t,e){if(e<1||t[3]&&t[3]<1)return s(t,e);var i=Math.round(t[0]/255*100),a=Math.round(t[1]/255*100),n=Math.round(t[2]/255*100);return"rgb("+i+"%, "+a+"%, "+n+"%)"},percentaString:s,hslString:function(t,e){if(e<1||t[3]&&t[3]<1)return d(t,e);return"hsl("+t[0]+", "+t[1]+"%, "+t[2]+"%)"},hslaString:d,hwbString:function(t,e){void 0===e&&(e=void 0!==t[3]?t[3]:1);return"hwb("+t[0]+", "+t[1]+"%, "+t[2]+"%"+(void 0!==e&&1!==e?", "+e:"")+")"},keyword:function(t){return h[t.slice(0,3)]}};var h={};for(var f in a)h[a[f]]=f},{6:6}],3:[function(t,e,i){var a=t(5),n=t(2),o=function(t){if(t instanceof o)return t;if(!(this instanceof o))return new o(t);var e;if(this.values={rgb:[0,0,0],hsl:[0,0,0],hsv:[0,0,0],hwb:[0,0,0],cmyk:[0,0,0,0],alpha:1},"string"==typeof t)if(e=n.getRgba(t))this.setValues("rgb",e);else if(e=n.getHsla(t))this.setValues("hsl",e);else{if(!(e=n.getHwb(t)))throw new Error('Unable to parse color from string "'+t+'"');this.setValues("hwb",e)}else if("object"==typeof t)if(void 0!==(e=t).r||void 0!==e.red)this.setValues("rgb",e);else if(void 0!==e.l||void 0!==e.lightness)this.setValues("hsl",e);else if(void 0!==e.v||void 0!==e.value)this.setValues("hsv",e);else if(void 0!==e.w||void 0!==e.whiteness)this.setValues("hwb",e);else{if(void 0===e.c&&void 0===e.cyan)throw new Error("Unable to parse color from object "+JSON.stringify(t));this.setValues("cmyk",e)}};o.prototype={rgb:function(){return this.setSpace("rgb",arguments)},hsl:function(){return this.setSpace("hsl",arguments)},hsv:function(){return this.setSpace("hsv",arguments)},hwb:function(){return this.setSpace("hwb",arguments)},cmyk:function(){return this.setSpace("cmyk",arguments)},rgbArray:function(){return this.values.rgb},hslArray:function(){return this.values.hsl},hsvArray:function(){return this.values.hsv},hwbArray:function(){var t=this.values;return 1!==t.alpha?t.hwb.concat([t.alpha]):t.hwb},cmykArray:function(){return this.values.cmyk},rgbaArray:function(){var t=this.values;return t.rgb.concat([t.alpha])},hslaArray:function(){var t=this.values;return t.hsl.concat([t.alpha])},alpha:function(t){return void 0===t?this.values.alpha:(this.setValues("alpha",t),this)},red:function(t){return this.setChannel("rgb",0,t)},green:function(t){return this.setChannel("rgb",1,t)},blue:function(t){return this.setChannel("rgb",2,t)},hue:function(t){return t&&(t=(t%=360)<0?360+t:t),this.setChannel("hsl",0,t)},saturation:function(t){return this.setChannel("hsl",1,t)},lightness:function(t){return this.setChannel("hsl",2,t)},saturationv:function(t){return this.setChannel("hsv",1,t)},whiteness:function(t){return this.setChannel("hwb",1,t)},blackness:function(t){return this.setChannel("hwb",2,t)},value:function(t){return this.setChannel("hsv",2,t)},cyan:function(t){return this.setChannel("cmyk",0,t)},magenta:function(t){return this.setChannel("cmyk",1,t)},yellow:function(t){return this.setChannel("cmyk",2,t)},black:function(t){return this.setChannel("cmyk",3,t)},hexString:function(){return n.hexString(this.values.rgb)},rgbString:function(){return n.rgbString(this.values.rgb,this.values.alpha)},rgbaString:function(){return n.rgbaString(this.values.rgb,this.values.alpha)},percentString:function(){return n.percentString(this.values.rgb,this.values.alpha)},hslString:function(){return n.hslString(this.values.hsl,this.values.alpha)},hslaString:function(){return n.hslaString(this.values.hsl,this.values.alpha)},hwbString:function(){return n.hwbString(this.values.hwb,this.values.alpha)},keyword:function(){return n.keyword(this.values.rgb,this.values.alpha)},rgbNumber:function(){var t=this.values.rgb;return t[0]<<16|t[1]<<8|t[2]},luminosity:function(){for(var t=this.values.rgb,e=[],i=0;i<t.length;i++){var a=t[i]/255;e[i]=a<=.03928?a/12.92:Math.pow((a+.055)/1.055,2.4)}return.2126*e[0]+.7152*e[1]+.0722*e[2]},contrast:function(t){var e=this.luminosity(),i=t.luminosity();return e>i?(e+.05)/(i+.05):(i+.05)/(e+.05)},level:function(t){var e=this.contrast(t);return e>=7.1?"AAA":e>=4.5?"AA":""},dark:function(){var t=this.values.rgb;return(299*t[0]+587*t[1]+114*t[2])/1e3<128},light:function(){return!this.dark()},negate:function(){for(var t=[],e=0;e<3;e++)t[e]=255-this.values.rgb[e];return this.setValues("rgb",t),this},lighten:function(t){var e=this.values.hsl;return e[2]+=e[2]*t,this.setValues("hsl",e),this},darken:function(t){var e=this.values.hsl;return e[2]-=e[2]*t,this.setValues("hsl",e),this},saturate:function(t){var e=this.values.hsl;return e[1]+=e[1]*t,this.setValues("hsl",e),this},desaturate:function(t){var e=this.values.hsl;return e[1]-=e[1]*t,this.setValues("hsl",e),this},whiten:function(t){var e=this.values.hwb;return e[1]+=e[1]*t,this.setValues("hwb",e),this},blacken:function(t){var e=this.values.hwb;return e[2]+=e[2]*t,this.setValues("hwb",e),this},greyscale:function(){var t=this.values.rgb,e=.3*t[0]+.59*t[1]+.11*t[2];return this.setValues("rgb",[e,e,e]),this},clearer:function(t){var e=this.values.alpha;return this.setValues("alpha",e-e*t),this},opaquer:function(t){var e=this.values.alpha;return this.setValues("alpha",e+e*t),this},rotate:function(t){var e=this.values.hsl,i=(e[0]+t)%360;return e[0]=i<0?360+i:i,this.setValues("hsl",e),this},mix:function(t,e){var i=t,a=void 0===e?.5:e,n=2*a-1,o=this.alpha()-i.alpha(),r=((n*o==-1?n:(n+o)/(1+n*o))+1)/2,l=1-r;return this.rgb(r*this.red()+l*i.red(),r*this.green()+l*i.green(),r*this.blue()+l*i.blue()).alpha(this.alpha()*a+i.alpha()*(1-a))},toJSON:function(){return this.rgb()},clone:function(){var t,e,i=new o,a=this.values,n=i.values;for(var r in a)a.hasOwnProperty(r)&&(t=a[r],"[object Array]"===(e={}.toString.call(t))?n[r]=t.slice(0):"[object Number]"===e?n[r]=t:console.error("unexpected color value:",t));return i}},o.prototype.spaces={rgb:["red","green","blue"],hsl:["hue","saturation","lightness"],hsv:["hue","saturation","value"],hwb:["hue","whiteness","blackness"],cmyk:["cyan","magenta","yellow","black"]},o.prototype.maxes={rgb:[255,255,255],hsl:[360,100,100],hsv:[360,100,100],hwb:[360,100,100],cmyk:[100,100,100,100]},o.prototype.getValues=function(t){for(var e=this.values,i={},a=0;a<t.length;a++)i[t.charAt(a)]=e[t][a];return 1!==e.alpha&&(i.a=e.alpha),i},o.prototype.setValues=function(t,e){var i,n,o=this.values,r=this.spaces,l=this.maxes,s=1;if("alpha"===t)s=e;else if(e.length)o[t]=e.slice(0,t.length),s=e[t.length];else if(void 0!==e[t.charAt(0)]){for(i=0;i<t.length;i++)o[t][i]=e[t.charAt(i)];s=e.a}else if(void 0!==e[r[t][0]]){var d=r[t];for(i=0;i<t.length;i++)o[t][i]=e[d[i]];s=e.alpha}if(o.alpha=Math.max(0,Math.min(1,void 0===s?o.alpha:s)),"alpha"===t)return!1;for(i=0;i<t.length;i++)n=Math.max(0,Math.min(l[t][i],o[t][i])),o[t][i]=Math.round(n);for(var u in r)u!==t&&(o[u]=a[t][u](o[t]));return!0},o.prototype.setSpace=function(t,e){var i=e[0];return void 0===i?this.getValues(t):("number"==typeof i&&(i=Array.prototype.slice.call(e)),this.setValues(t,i),this)},o.prototype.setChannel=function(t,e,i){var a=this.values[t];return void 0===i?a[e]:i===a[e]?this:(a[e]=i,this.setValues(t,a),this)},"undefined"!=typeof window&&(window.Color=o),e.exports=o},{2:2,5:5}],4:[function(t,e,i){function a(t){var e,i,a=t[0]/255,n=t[1]/255,o=t[2]/255,r=Math.min(a,n,o),l=Math.max(a,n,o),s=l-r;return l==r?e=0:a==l?e=(n-o)/s:n==l?e=2+(o-a)/s:o==l&&(e=4+(a-n)/s),(e=Math.min(60*e,360))<0&&(e+=360),i=(r+l)/2,[e,100*(l==r?0:i<=.5?s/(l+r):s/(2-l-r)),100*i]}function n(t){var e,i,a=t[0],n=t[1],o=t[2],r=Math.min(a,n,o),l=Math.max(a,n,o),s=l-r;return i=0==l?0:s/l*1e3/10,l==r?e=0:a==l?e=(n-o)/s:n==l?e=2+(o-a)/s:o==l&&(e=4+(a-n)/s),(e=Math.min(60*e,360))<0&&(e+=360),[e,i,l/255*1e3/10]}function o(t){var e=t[0],i=t[1],n=t[2];return[a(t)[0],100*(1/255*Math.min(e,Math.min(i,n))),100*(n=1-1/255*Math.max(e,Math.max(i,n)))]}function l(t){var e,i=t[0]/255,a=t[1]/255,n=t[2]/255;return[100*((1-i-(e=Math.min(1-i,1-a,1-n)))/(1-e)||0),100*((1-a-e)/(1-e)||0),100*((1-n-e)/(1-e)||0),100*e]}function s(t){return M[JSON.stringify(t)]}function d(t){var e=t[0]/255,i=t[1]/255,a=t[2]/255;return[100*(.4124*(e=e>.04045?Math.pow((e+.055)/1.055,2.4):e/12.92)+.3576*(i=i>.04045?Math.pow((i+.055)/1.055,2.4):i/12.92)+.1805*(a=a>.04045?Math.pow((a+.055)/1.055,2.4):a/12.92)),100*(.2126*e+.7152*i+.0722*a),100*(.0193*e+.1192*i+.9505*a)]}function u(t){var e=d(t),i=e[0],a=e[1],n=e[2];return a/=100,n/=108.883,i=(i/=95.047)>.008856?Math.pow(i,1/3):7.787*i+16/116,[116*(a=a>.008856?Math.pow(a,1/3):7.787*a+16/116)-16,500*(i-a),200*(a-(n=n>.008856?Math.pow(n,1/3):7.787*n+16/116))]}function c(t){var e,i,a,n,o,r=t[0]/360,l=t[1]/100,s=t[2]/100;if(0==l)return[o=255*s,o,o];e=2*s-(i=s<.5?s*(1+l):s+l-s*l),n=[0,0,0];for(var d=0;d<3;d++)(a=r+1/3*-(d-1))<0&&a++,a>1&&a--,o=6*a<1?e+6*(i-e)*a:2*a<1?i:3*a<2?e+(i-e)*(2/3-a)*6:e,n[d]=255*o;return n}function h(t){var e=t[0]/60,i=t[1]/100,a=t[2]/100,n=Math.floor(e)%6,o=e-Math.floor(e),r=255*a*(1-i),l=255*a*(1-i*o),s=255*a*(1-i*(1-o));a*=255;switch(n){case 0:return[a,s,r];case 1:return[l,a,r];case 2:return[r,a,s];case 3:return[r,l,a];case 4:return[s,r,a];case 5:return[a,r,l]}}function f(t){var e,i,a,n,o=t[0]/360,l=t[1]/100,s=t[2]/100,d=l+s;switch(d>1&&(l/=d,s/=d),a=6*o-(e=Math.floor(6*o)),0!=(1&e)&&(a=1-a),n=l+a*((i=1-s)-l),e){default:case 6:case 0:r=i,g=n,b=l;break;case 1:r=n,g=i,b=l;break;case 2:r=l,g=i,b=n;break;case 3:r=l,g=n,b=i;break;case 4:r=n,g=l,b=i;break;case 5:r=i,g=l,b=n}return[255*r,255*g,255*b]}function p(t){var e=t[0]/100,i=t[1]/100,a=t[2]/100,n=t[3]/100;return[255*(1-Math.min(1,e*(1-n)+n)),255*(1-Math.min(1,i*(1-n)+n)),255*(1-Math.min(1,a*(1-n)+n))]}function m(t){var e,i,a,n=t[0]/100,o=t[1]/100,r=t[2]/100;return i=-.9689*n+1.8758*o+.0415*r,a=.0557*n+-.204*o+1.057*r,e=(e=3.2406*n+-1.5372*o+-.4986*r)>.0031308?1.055*Math.pow(e,1/2.4)-.055:e*=12.92,i=i>.0031308?1.055*Math.pow(i,1/2.4)-.055:i*=12.92,a=a>.0031308?1.055*Math.pow(a,1/2.4)-.055:a*=12.92,[255*(e=Math.min(Math.max(0,e),1)),255*(i=Math.min(Math.max(0,i),1)),255*(a=Math.min(Math.max(0,a),1))]}function v(t){var e=t[0],i=t[1],a=t[2];return i/=100,a/=108.883,e=(e/=95.047)>.008856?Math.pow(e,1/3):7.787*e+16/116,[116*(i=i>.008856?Math.pow(i,1/3):7.787*i+16/116)-16,500*(e-i),200*(i-(a=a>.008856?Math.pow(a,1/3):7.787*a+16/116))]}function x(t){var e,i,a,n,o=t[0],r=t[1],l=t[2];return o<=8?n=(i=100*o/903.3)/100*7.787+16/116:(i=100*Math.pow((o+16)/116,3),n=Math.pow(i/100,1/3)),[e=e/95.047<=.008856?e=95.047*(r/500+n-16/116)/7.787:95.047*Math.pow(r/500+n,3),i,a=a/108.883<=.008859?a=108.883*(n-l/200-16/116)/7.787:108.883*Math.pow(n-l/200,3)]}function y(t){var e,i=t[0],a=t[1],n=t[2];return(e=360*Math.atan2(n,a)/2/Math.PI)<0&&(e+=360),[i,Math.sqrt(a*a+n*n),e]}function k(t){return m(x(t))}function S(t){var e,i=t[0],a=t[1];return e=t[2]/360*2*Math.PI,[i,a*Math.cos(e),a*Math.sin(e)]}function w(t){return C[t]}e.exports={rgb2hsl:a,rgb2hsv:n,rgb2hwb:o,rgb2cmyk:l,rgb2keyword:s,rgb2xyz:d,rgb2lab:u,rgb2lch:function(t){return y(u(t))},hsl2rgb:c,hsl2hsv:function(t){var e=t[0],i=t[1]/100,a=t[2]/100;if(0===a)return[0,0,0];return[e,100*(2*(i*=(a*=2)<=1?a:2-a)/(a+i)),100*((a+i)/2)]},hsl2hwb:function(t){return o(c(t))},hsl2cmyk:function(t){return l(c(t))},hsl2keyword:function(t){return s(c(t))},hsv2rgb:h,hsv2hsl:function(t){var e,i,a=t[0],n=t[1]/100,o=t[2]/100;return e=n*o,[a,100*(e=(e/=(i=(2-n)*o)<=1?i:2-i)||0),100*(i/=2)]},hsv2hwb:function(t){return o(h(t))},hsv2cmyk:function(t){return l(h(t))},hsv2keyword:function(t){return s(h(t))},hwb2rgb:f,hwb2hsl:function(t){return a(f(t))},hwb2hsv:function(t){return n(f(t))},hwb2cmyk:function(t){return l(f(t))},hwb2keyword:function(t){return s(f(t))},cmyk2rgb:p,cmyk2hsl:function(t){return a(p(t))},cmyk2hsv:function(t){return n(p(t))},cmyk2hwb:function(t){return o(p(t))},cmyk2keyword:function(t){return s(p(t))},keyword2rgb:w,keyword2hsl:function(t){return a(w(t))},keyword2hsv:function(t){return n(w(t))},keyword2hwb:function(t){return o(w(t))},keyword2cmyk:function(t){return l(w(t))},keyword2lab:function(t){return u(w(t))},keyword2xyz:function(t){return d(w(t))},xyz2rgb:m,xyz2lab:v,xyz2lch:function(t){return y(v(t))},lab2xyz:x,lab2rgb:k,lab2lch:y,lch2lab:S,lch2xyz:function(t){return x(S(t))},lch2rgb:function(t){return k(S(t))}};var C={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},M={};for(var D in C)M[JSON.stringify(C[D])]=D},{}],5:[function(t,e,i){var a=t(4),n=function(){return new d};for(var o in a){n[o+"Raw"]=function(t){return function(e){return"number"==typeof e&&(e=Array.prototype.slice.call(arguments)),a[t](e)}}(o);var r=/(\w+)2(\w+)/.exec(o),l=r[1],s=r[2];(n[l]=n[l]||{})[s]=n[o]=function(t){return function(e){"number"==typeof e&&(e=Array.prototype.slice.call(arguments));var i=a[t](e);if("string"==typeof i||void 0===i)return i;for(var n=0;n<i.length;n++)i[n]=Math.round(i[n]);return i}}(o)}var d=function(){this.convs={}};d.prototype.routeSpace=function(t,e){var i=e[0];return void 0===i?this.getValues(t):("number"==typeof i&&(i=Array.prototype.slice.call(e)),this.setValues(t,i))},d.prototype.setValues=function(t,e){return this.space=t,this.convs={},this.convs[t]=e,this},d.prototype.getValues=function(t){var e=this.convs[t];if(!e){var i=this.space,a=this.convs[i];e=n[i][t](a),this.convs[t]=e}return e},["rgb","hsl","hsv","cmyk","keyword"].forEach(function(t){d.prototype[t]=function(e){return this.routeSpace(t,arguments)}}),e.exports=n},{4:4}],6:[function(t,e,i){e.exports={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}},{}],7:[function(t,e,i){var a=t(27)();t(26)(a),t(22)(a),t(25)(a),t(21)(a),t(23)(a),t(24)(a),t(28)(a),t(32)(a),t(30)(a),t(31)(a),t(33)(a),t(29)(a),t(34)(a),t(35)(a),t(36)(a),t(37)(a),t(38)(a),t(41)(a),t(39)(a),t(40)(a),t(42)(a),t(43)(a),t(44)(a),t(15)(a),t(16)(a),t(17)(a),t(18)(a),t(19)(a),t(20)(a),t(8)(a),t(9)(a),t(10)(a),t(11)(a),t(12)(a),t(13)(a),t(14)(a),window.Chart=e.exports=a},{10:10,11:11,12:12,13:13,14:14,15:15,16:16,17:17,18:18,19:19,20:20,21:21,22:22,23:23,24:24,25:25,26:26,27:27,28:28,29:29,30:30,31:31,32:32,33:33,34:34,35:35,36:36,37:37,38:38,39:39,40:40,41:41,42:42,43:43,44:44,8:8,9:9}],8:[function(t,e,i){"use strict";e.exports=function(t){t.Bar=function(e,i){return i.type="bar",new t(e,i)}}},{}],9:[function(t,e,i){"use strict";e.exports=function(t){t.Bubble=function(e,i){return i.type="bubble",new t(e,i)}}},{}],10:[function(t,e,i){"use strict";e.exports=function(t){t.Doughnut=function(e,i){return i.type="doughnut",new t(e,i)}}},{}],11:[function(t,e,i){"use strict";e.exports=function(t){t.Line=function(e,i){return i.type="line",new t(e,i)}}},{}],12:[function(t,e,i){"use strict";e.exports=function(t){t.PolarArea=function(e,i){return i.type="polarArea",new t(e,i)}}},{}],13:[function(t,e,i){"use strict";e.exports=function(t){t.Radar=function(e,i){return i.options=t.helpers.configMerge({aspectRatio:1},i.options),i.type="radar",new t(e,i)}}},{}],14:[function(t,e,i){"use strict";e.exports=function(t){t.defaults.scatter={hover:{mode:"single"},scales:{xAxes:[{type:"linear",position:"bottom",id:"x-axis-1"}],yAxes:[{type:"linear",position:"left",id:"y-axis-1"}]},tooltips:{callbacks:{title:function(){return""},label:function(t){return"("+t.xLabel+", "+t.yLabel+")"}}}},t.controllers.scatter=t.controllers.line,t.Scatter=function(e,i){return i.type="scatter",new t(e,i)}}},{}],15:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;t.defaults.bar={hover:{mode:"label"},scales:{xAxes:[{type:"category",categoryPercentage:.8,barPercentage:.9,gridLines:{offsetGridLines:!0}}],yAxes:[{type:"linear"}]}},t.controllers.bar=t.DatasetController.extend({dataElementType:t.elements.Rectangle,initialize:function(e,i){t.DatasetController.prototype.initialize.call(this,e,i),this.getMeta().bar=!0},getBarCount:function(){var t=this,i=0;return e.each(t.chart.data.datasets,function(e,a){t.chart.getDatasetMeta(a).bar&&t.chart.isDatasetVisible(a)&&++i},t),i},update:function(t){var i=this;e.each(i.getMeta().data,function(e,a){i.updateElement(e,a,t)},i)},updateElement:function(t,i,a){var n=this,o=n.getMeta(),r=n.getScaleForId(o.xAxisID),l=n.getScaleForId(o.yAxisID),s=l.getBasePixel(),d=n.chart.options.elements.rectangle,u=t.custom||{},c=n.getDataset();e.extend(t,{_xScale:r,_yScale:l,_datasetIndex:n.index,_index:i,_model:{x:n.calculateBarX(i,n.index),y:a?s:n.calculateBarY(i,n.index),label:n.chart.data.labels[i],datasetLabel:c.label,base:a?s:n.calculateBarBase(n.index,i),width:n.calculateBarWidth(i),backgroundColor:u.backgroundColor?u.backgroundColor:e.getValueAtIndexOrDefault(c.backgroundColor,i,d.backgroundColor),borderSkipped:u.borderSkipped?u.borderSkipped:d.borderSkipped,borderColor:u.borderColor?u.borderColor:e.getValueAtIndexOrDefault(c.borderColor,i,d.borderColor),borderWidth:u.borderWidth?u.borderWidth:e.getValueAtIndexOrDefault(c.borderWidth,i,d.borderWidth)}}),t.pivot()},calculateBarBase:function(t,e){var i=this.getMeta(),a=this.getScaleForId(i.yAxisID),n=0;if(a.options.stacked){for(var o=this.chart,r=o.data.datasets,l=Number(r[t].data[e]),s=0;s<t;s++){var d=r[s],u=o.getDatasetMeta(s);if(u.bar&&u.yAxisID===a.id&&o.isDatasetVisible(s)){var c=Number(d.data[e]);n+=l<0?Math.min(c,0):Math.max(c,0)}}return a.getPixelForValue(n)}return a.getBasePixel()},getRuler:function(t){var e,i=this,a=i.getMeta(),n=i.getScaleForId(a.xAxisID),o=i.getBarCount(),r=(e="category"===n.options.type?n.getPixelForTick(t+1)-n.getPixelForTick(t):n.width/n.ticks.length)*n.options.categoryPercentage,l=(e-e*n.options.categoryPercentage)/2,s=r/o;n.ticks.length!==i.chart.data.labels.length&&(s*=n.ticks.length/i.chart.data.labels.length);return{datasetCount:o,tickWidth:e,categoryWidth:r,categorySpacing:l,fullBarWidth:s,barWidth:s*n.options.barPercentage,barSpacing:s-s*n.options.barPercentage}},calculateBarWidth:function(t){var e=this.getScaleForId(this.getMeta().xAxisID);if(e.options.barThickness)return e.options.barThickness;var i=this.getRuler(t);return e.options.stacked?i.categoryWidth:i.barWidth},getBarIndex:function(t){var e,i=0;for(e=0;e<t;++e)this.chart.getDatasetMeta(e).bar&&this.chart.isDatasetVisible(e)&&++i;return i},calculateBarX:function(t,e){var i=this,a=i.getMeta(),n=i.getScaleForId(a.xAxisID),o=i.getBarIndex(e),r=i.getRuler(t),l=n.getPixelForValue(null,t,e,i.chart.isCombo);return l-=i.chart.isCombo?r.tickWidth/2:0,n.options.stacked?l+r.categoryWidth/2+r.categorySpacing:l+r.barWidth/2+r.categorySpacing+r.barWidth*o+r.barSpacing/2+r.barSpacing*o},calculateBarY:function(t,e){var i=this,a=i.getMeta(),n=i.getScaleForId(a.yAxisID),o=Number(i.getDataset().data[t]);if(n.options.stacked){for(var r=0,l=0,s=0;s<e;s++){var d=i.chart.data.datasets[s],u=i.chart.getDatasetMeta(s);if(u.bar&&u.yAxisID===n.id&&i.chart.isDatasetVisible(s)){var c=Number(d.data[t]);c<0?l+=c||0:r+=c||0}}return o<0?n.getPixelForValue(l+o):n.getPixelForValue(r+o)}return n.getPixelForValue(o)},draw:function(t){var i=this,a=t||1;e.each(i.getMeta().data,function(t,e){var n=i.getDataset().data[e];null==n||isNaN(n)||t.transition(a).draw()},i)},setHoverStyle:function(t){var i=this.chart.data.datasets[t._datasetIndex],a=t._index,n=t.custom||{},o=t._model;o.backgroundColor=n.hoverBackgroundColor?n.hoverBackgroundColor:e.getValueAtIndexOrDefault(i.hoverBackgroundColor,a,e.getHoverColor(o.backgroundColor)),o.borderColor=n.hoverBorderColor?n.hoverBorderColor:e.getValueAtIndexOrDefault(i.hoverBorderColor,a,e.getHoverColor(o.borderColor)),o.borderWidth=n.hoverBorderWidth?n.hoverBorderWidth:e.getValueAtIndexOrDefault(i.hoverBorderWidth,a,o.borderWidth)},removeHoverStyle:function(t){var i=this.chart.data.datasets[t._datasetIndex],a=t._index,n=t.custom||{},o=t._model,r=this.chart.options.elements.rectangle;o.backgroundColor=n.backgroundColor?n.backgroundColor:e.getValueAtIndexOrDefault(i.backgroundColor,a,r.backgroundColor),o.borderColor=n.borderColor?n.borderColor:e.getValueAtIndexOrDefault(i.borderColor,a,r.borderColor),o.borderWidth=n.borderWidth?n.borderWidth:e.getValueAtIndexOrDefault(i.borderWidth,a,r.borderWidth)}}),t.defaults.horizontalBar={hover:{mode:"label"},scales:{xAxes:[{type:"linear",position:"bottom"}],yAxes:[{position:"left",type:"category",categoryPercentage:.8,barPercentage:.9,gridLines:{offsetGridLines:!0}}]},elements:{rectangle:{borderSkipped:"left"}},tooltips:{callbacks:{title:function(t,e){var i="";return t.length>0&&(t[0].yLabel?i=t[0].yLabel:e.labels.length>0&&t[0].index<e.labels.length&&(i=e.labels[t[0].index])),i},label:function(t,e){return(e.datasets[t.datasetIndex].label||"")+": "+t.xLabel}}}},t.controllers.horizontalBar=t.controllers.bar.extend({updateElement:function(t,i,a){var n=this,o=n.getMeta(),r=n.getScaleForId(o.xAxisID),l=n.getScaleForId(o.yAxisID),s=r.getBasePixel(),d=t.custom||{},u=n.getDataset(),c=n.chart.options.elements.rectangle;e.extend(t,{_xScale:r,_yScale:l,_datasetIndex:n.index,_index:i,_model:{x:a?s:n.calculateBarX(i,n.index),y:n.calculateBarY(i,n.index),label:n.chart.data.labels[i],datasetLabel:u.label,base:a?s:n.calculateBarBase(n.index,i),height:n.calculateBarHeight(i),backgroundColor:d.backgroundColor?d.backgroundColor:e.getValueAtIndexOrDefault(u.backgroundColor,i,c.backgroundColor),borderSkipped:d.borderSkipped?d.borderSkipped:c.borderSkipped,borderColor:d.borderColor?d.borderColor:e.getValueAtIndexOrDefault(u.borderColor,i,c.borderColor),borderWidth:d.borderWidth?d.borderWidth:e.getValueAtIndexOrDefault(u.borderWidth,i,c.borderWidth)},draw:function(){var t=this._chart.ctx,e=this._view,i=e.height/2,a=e.y-i,n=e.y+i,o=e.base-(e.base-e.x),r=e.borderWidth/2;e.borderWidth&&(a+=r,n-=r,o+=r),t.beginPath(),t.fillStyle=e.backgroundColor,t.strokeStyle=e.borderColor,t.lineWidth=e.borderWidth;var l=[[e.base,n],[e.base,a],[o,a],[o,n]],s=["bottom","left","top","right"].indexOf(e.borderSkipped,0);function d(t){return l[(s+t)%4]}-1===s&&(s=0),t.moveTo.apply(t,d(0));for(var u=1;u<4;u++)t.lineTo.apply(t,d(u));t.fill(),e.borderWidth&&t.stroke()},inRange:function(t,e){var i=this._view,a=!1;return i&&(a=i.x<i.base?e>=i.y-i.height/2&&e<=i.y+i.height/2&&t>=i.x&&t<=i.base:e>=i.y-i.height/2&&e<=i.y+i.height/2&&t>=i.base&&t<=i.x),a}}),t.pivot()},calculateBarBase:function(t,e){var i=this.getMeta(),a=this.getScaleForId(i.xAxisID),n=0;if(a.options.stacked){for(var o=this.chart,r=o.data.datasets,l=Number(r[t].data[e]),s=0;s<t;s++){var d=r[s],u=o.getDatasetMeta(s);if(u.bar&&u.xAxisID===a.id&&o.isDatasetVisible(s)){var c=Number(d.data[e]);n+=l<0?Math.min(c,0):Math.max(c,0)}}return a.getPixelForValue(n)}return a.getBasePixel()},getRuler:function(t){var e,i=this,a=i.getMeta(),n=i.getScaleForId(a.yAxisID),o=i.getBarCount(),r=(e="category"===n.options.type?n.getPixelForTick(t+1)-n.getPixelForTick(t):n.width/n.ticks.length)*n.options.categoryPercentage,l=(e-e*n.options.categoryPercentage)/2,s=r/o;n.ticks.length!==i.chart.data.labels.length&&(s*=n.ticks.length/i.chart.data.labels.length);return{datasetCount:o,tickHeight:e,categoryHeight:r,categorySpacing:l,fullBarHeight:s,barHeight:s*n.options.barPercentage,barSpacing:s-s*n.options.barPercentage}},calculateBarHeight:function(t){var e=this.getScaleForId(this.getMeta().yAxisID);if(e.options.barThickness)return e.options.barThickness;var i=this.getRuler(t);return e.options.stacked?i.categoryHeight:i.barHeight},calculateBarX:function(t,e){var i=this,a=i.getMeta(),n=i.getScaleForId(a.xAxisID),o=Number(i.getDataset().data[t]);if(n.options.stacked){for(var r=0,l=0,s=0;s<e;s++){var d=i.chart.data.datasets[s],u=i.chart.getDatasetMeta(s);if(u.bar&&u.xAxisID===n.id&&i.chart.isDatasetVisible(s)){var c=Number(d.data[t]);c<0?l+=c||0:r+=c||0}}return o<0?n.getPixelForValue(l+o):n.getPixelForValue(r+o)}return n.getPixelForValue(o)},calculateBarY:function(t,e){var i=this,a=i.getMeta(),n=i.getScaleForId(a.yAxisID),o=i.getBarIndex(e),r=i.getRuler(t),l=n.getPixelForValue(null,t,e,i.chart.isCombo);return l-=i.chart.isCombo?r.tickHeight/2:0,n.options.stacked?l+r.categoryHeight/2+r.categorySpacing:l+r.barHeight/2+r.categorySpacing+r.barHeight*o+r.barSpacing/2+r.barSpacing*o}})}},{}],16:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;t.defaults.bubble={hover:{mode:"single"},scales:{xAxes:[{type:"linear",position:"bottom",id:"x-axis-0"}],yAxes:[{type:"linear",position:"left",id:"y-axis-0"}]},tooltips:{callbacks:{title:function(){return""},label:function(t,e){var i=e.datasets[t.datasetIndex].label||"",a=e.datasets[t.datasetIndex].data[t.index];return i+": ("+a.x+", "+a.y+", "+a.r+")"}}}},t.controllers.bubble=t.DatasetController.extend({dataElementType:t.elements.Point,update:function(t){var i=this,a=i.getMeta().data;e.each(a,function(e,a){i.updateElement(e,a,t)})},updateElement:function(i,a,n){var o=this,r=o.getMeta(),l=o.getScaleForId(r.xAxisID),s=o.getScaleForId(r.yAxisID),d=i.custom||{},u=o.getDataset(),c=u.data[a],h=o.chart.options.elements.point,f=o.index;e.extend(i,{_xScale:l,_yScale:s,_datasetIndex:f,_index:a,_model:{x:n?l.getPixelForDecimal(.5):l.getPixelForValue("object"==typeof c?c:NaN,a,f,o.chart.isCombo),y:n?s.getBasePixel():s.getPixelForValue(c,a,f),radius:n?0:d.radius?d.radius:o.getRadius(c),hitRadius:d.hitRadius?d.hitRadius:e.getValueAtIndexOrDefault(u.hitRadius,a,h.hitRadius)}}),t.DatasetController.prototype.removeHoverStyle.call(o,i,h);var g=i._model;g.skip=d.skip?d.skip:isNaN(g.x)||isNaN(g.y),i.pivot()},getRadius:function(t){return t.r||this.chart.options.elements.point.radius},setHoverStyle:function(i){t.DatasetController.prototype.setHoverStyle.call(this,i);var a=this.chart.data.datasets[i._datasetIndex],n=i._index,o=i.custom||{};i._model.radius=o.hoverRadius?o.hoverRadius:e.getValueAtIndexOrDefault(a.hoverRadius,n,this.chart.options.elements.point.hoverRadius)+this.getRadius(a.data[n])},removeHoverStyle:function(e){t.DatasetController.prototype.removeHoverStyle.call(this,e,this.chart.options.elements.point);var i=this.chart.data.datasets[e._datasetIndex].data[e._index],a=e.custom||{};e._model.radius=a.radius?a.radius:this.getRadius(i)}})}},{}],17:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers,i=t.defaults;i.doughnut={animation:{animateRotate:!0,animateScale:!1},aspectRatio:1,hover:{mode:"single"},legendCallback:function(t){var e=[];e.push('<ul class="'+t.id+'-legend">');var i=t.data,a=i.datasets,n=i.labels;if(a.length)for(var o=0;o<a[0].data.length;++o)e.push('<li><span style="background-color:'+a[0].backgroundColor[o]+'"></span>'),n[o]&&e.push(n[o]),e.push("</li>");return e.push("</ul>"),e.join("")},legend:{labels:{generateLabels:function(t){var i=t.data;return i.labels.length&&i.datasets.length?i.labels.map(function(a,n){var o=t.getDatasetMeta(0),r=i.datasets[0],l=o.data[n],s=l&&l.custom||{},d=e.getValueAtIndexOrDefault,u=t.options.elements.arc;return{text:a,fillStyle:s.backgroundColor?s.backgroundColor:d(r.backgroundColor,n,u.backgroundColor),strokeStyle:s.borderColor?s.borderColor:d(r.borderColor,n,u.borderColor),lineWidth:s.borderWidth?s.borderWidth:d(r.borderWidth,n,u.borderWidth),hidden:isNaN(r.data[n])||o.data[n].hidden,index:n}}):[]}},onClick:function(t,e){var i,a,n,o=e.index,r=this.chart;for(i=0,a=(r.data.datasets||[]).length;i<a;++i)(n=r.getDatasetMeta(i)).data[o].hidden=!n.data[o].hidden;r.update()}},cutoutPercentage:50,rotation:-.5*Math.PI,circumference:2*Math.PI,tooltips:{callbacks:{title:function(){return""},label:function(t,e){return e.labels[t.index]+": "+e.datasets[t.datasetIndex].data[t.index]}}}},i.pie=e.clone(i.doughnut),e.extend(i.pie,{cutoutPercentage:0}),t.controllers.doughnut=t.controllers.pie=t.DatasetController.extend({dataElementType:t.elements.Arc,linkScales:e.noop,getRingIndex:function(t){for(var e=0,i=0;i<t;++i)this.chart.isDatasetVisible(i)&&++e;return e},update:function(t){var i=this,a=i.chart,n=a.chartArea,o=a.options,r=o.elements.arc,l=n.right-n.left-r.borderWidth,s=n.bottom-n.top-r.borderWidth,d=Math.min(l,s),u={x:0,y:0},c=i.getMeta(),h=o.cutoutPercentage,f=o.circumference;if(f<2*Math.PI){var g=o.rotation%(2*Math.PI),p=(g+=2*Math.PI*(g>=Math.PI?-1:g<-Math.PI?1:0))+f,m={x:Math.cos(g),y:Math.sin(g)},b={x:Math.cos(p),y:Math.sin(p)},v=g<=0&&0<=p||g<=2*Math.PI&&2*Math.PI<=p,x=g<=.5*Math.PI&&.5*Math.PI<=p||g<=2.5*Math.PI&&2.5*Math.PI<=p,y=g<=-Math.PI&&-Math.PI<=p||g<=Math.PI&&Math.PI<=p,k=g<=.5*-Math.PI&&.5*-Math.PI<=p||g<=1.5*Math.PI&&1.5*Math.PI<=p,S=h/100,w={x:y?-1:Math.min(m.x*(m.x<0?1:S),b.x*(b.x<0?1:S)),y:k?-1:Math.min(m.y*(m.y<0?1:S),b.y*(b.y<0?1:S))},C={x:v?1:Math.max(m.x*(m.x>0?1:S),b.x*(b.x>0?1:S)),y:x?1:Math.max(m.y*(m.y>0?1:S),b.y*(b.y>0?1:S))},M={width:.5*(C.x-w.x),height:.5*(C.y-w.y)};d=Math.min(l/M.width,s/M.height),u={x:-.5*(C.x+w.x),y:-.5*(C.y+w.y)}}a.borderWidth=i.getMaxBorderWidth(c.data),a.outerRadius=Math.max((d-a.borderWidth)/2,0),a.innerRadius=Math.max(h?a.outerRadius/100*h:1,0),a.radiusLength=(a.outerRadius-a.innerRadius)/a.getVisibleDatasetCount(),a.offsetX=u.x*a.outerRadius,a.offsetY=u.y*a.outerRadius,c.total=i.calculateTotal(),i.outerRadius=a.outerRadius-a.radiusLength*i.getRingIndex(i.index),i.innerRadius=i.outerRadius-a.radiusLength,e.each(c.data,function(e,a){i.updateElement(e,a,t)})},updateElement:function(t,i,a){var n=this,o=n.chart,r=o.chartArea,l=o.options,s=l.animation,d=(r.left+r.right)/2,u=(r.top+r.bottom)/2,c=l.rotation,h=l.rotation,f=n.getDataset(),g=a&&s.animateRotate?0:t.hidden?0:n.calculateCircumference(f.data[i])*(l.circumference/(2*Math.PI)),p=a&&s.animateScale?0:n.innerRadius,m=a&&s.animateScale?0:n.outerRadius,b=e.getValueAtIndexOrDefault;e.extend(t,{_datasetIndex:n.index,_index:i,_model:{x:d+o.offsetX,y:u+o.offsetY,startAngle:c,endAngle:h,circumference:g,outerRadius:m,innerRadius:p,label:b(f.label,i,o.data.labels[i])}});var v=t._model;this.removeHoverStyle(t),a&&s.animateRotate||(v.startAngle=0===i?l.rotation:n.getMeta().data[i-1]._model.endAngle,v.endAngle=v.startAngle+v.circumference),t.pivot()},removeHoverStyle:function(e){t.DatasetController.prototype.removeHoverStyle.call(this,e,this.chart.options.elements.arc)},calculateTotal:function(){var t,i=this.getDataset(),a=this.getMeta(),n=0;return e.each(a.data,function(e,a){t=i.data[a],isNaN(t)||e.hidden||(n+=Math.abs(t))}),n},calculateCircumference:function(t){var e=this.getMeta().total;return e>0&&!isNaN(t)?2*Math.PI*(t/e):0},getMaxBorderWidth:function(t){for(var e,i,a=0,n=this.index,o=t.length,r=0;r<o;r++)e=t[r]._model?t[r]._model.borderWidth:0,a=(i=t[r]._chart?t[r]._chart.config.data.datasets[n].hoverBorderWidth:0)>(a=e>a?e:a)?i:a;return a}})}},{}],18:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;function i(t,i){return e.getValueOrDefault(t.showLine,i.showLines)}t.defaults.line={showLines:!0,spanGaps:!1,hover:{mode:"label"},scales:{xAxes:[{type:"category",id:"x-axis-0"}],yAxes:[{type:"linear",id:"y-axis-0"}]}},t.controllers.line=t.DatasetController.extend({datasetElementType:t.elements.Line,dataElementType:t.elements.Point,addElementAndReset:function(e){var a=this,n=a.chart.options,o=a.getMeta();t.DatasetController.prototype.addElementAndReset.call(a,e),i(a.getDataset(),n)&&0!==o.dataset._model.tension&&a.updateBezierControlPoints()},update:function(t){var a,n,o,r=this,l=r.getMeta(),s=l.dataset,d=l.data||[],u=r.chart.options,c=u.elements.line,h=r.getScaleForId(l.yAxisID),f=r.getDataset(),g=i(f,u);for(g&&(o=s.custom||{},void 0!==f.tension&&void 0===f.lineTension&&(f.lineTension=f.tension),s._scale=h,s._datasetIndex=r.index,s._children=d,s._model={spanGaps:f.spanGaps?f.spanGaps:u.spanGaps,tension:o.tension?o.tension:e.getValueOrDefault(f.lineTension,c.tension),backgroundColor:o.backgroundColor?o.backgroundColor:f.backgroundColor||c.backgroundColor,borderWidth:o.borderWidth?o.borderWidth:f.borderWidth||c.borderWidth,borderColor:o.borderColor?o.borderColor:f.borderColor||c.borderColor,borderCapStyle:o.borderCapStyle?o.borderCapStyle:f.borderCapStyle||c.borderCapStyle,borderDash:o.borderDash?o.borderDash:f.borderDash||c.borderDash,borderDashOffset:o.borderDashOffset?o.borderDashOffset:f.borderDashOffset||c.borderDashOffset,borderJoinStyle:o.borderJoinStyle?o.borderJoinStyle:f.borderJoinStyle||c.borderJoinStyle,fill:o.fill?o.fill:void 0!==f.fill?f.fill:c.fill,steppedLine:o.steppedLine?o.steppedLine:e.getValueOrDefault(f.steppedLine,c.stepped),scaleTop:h.top,scaleBottom:h.bottom,scaleZero:h.getBasePixel()},s.pivot()),a=0,n=d.length;a<n;++a)r.updateElement(d[a],a,t);for(g&&0!==s._model.tension&&r.updateBezierControlPoints(),a=0,n=d.length;a<n;++a)d[a].pivot()},getPointBackgroundColor:function(t,i){var a=this.chart.options.elements.point.backgroundColor,n=this.getDataset(),o=t.custom||{};return o.backgroundColor?a=o.backgroundColor:n.pointBackgroundColor?a=e.getValueAtIndexOrDefault(n.pointBackgroundColor,i,a):n.backgroundColor&&(a=n.backgroundColor),a},getPointBorderColor:function(t,i){var a=this.chart.options.elements.point.borderColor,n=this.getDataset(),o=t.custom||{};return o.borderColor?a=o.borderColor:n.pointBorderColor?a=e.getValueAtIndexOrDefault(n.pointBorderColor,i,a):n.borderColor&&(a=n.borderColor),a},getPointBorderWidth:function(t,i){var a=this.chart.options.elements.point.borderWidth,n=this.getDataset(),o=t.custom||{};return o.borderWidth?a=o.borderWidth:n.pointBorderWidth?a=e.getValueAtIndexOrDefault(n.pointBorderWidth,i,a):n.borderWidth&&(a=n.borderWidth),a},updateElement:function(t,i,a){var n,o,r=this,l=r.getMeta(),s=t.custom||{},d=r.getDataset(),u=r.index,c=d.data[i],h=r.getScaleForId(l.yAxisID),f=r.getScaleForId(l.xAxisID),g=r.chart.options.elements.point;void 0!==d.radius&&void 0===d.pointRadius&&(d.pointRadius=d.radius),void 0!==d.hitRadius&&void 0===d.pointHitRadius&&(d.pointHitRadius=d.hitRadius),n=f.getPixelForValue("object"==typeof c?c:NaN,i,u,r.chart.isCombo),o=a?h.getBasePixel():r.calculatePointY(c,i,u),t._xScale=f,t._yScale=h,t._datasetIndex=u,t._index=i,t._model={x:n,y:o,skip:s.skip||isNaN(n)||isNaN(o),radius:s.radius||e.getValueAtIndexOrDefault(d.pointRadius,i,g.radius),pointStyle:s.pointStyle||e.getValueAtIndexOrDefault(d.pointStyle,i,g.pointStyle),backgroundColor:r.getPointBackgroundColor(t,i),borderColor:r.getPointBorderColor(t,i),borderWidth:r.getPointBorderWidth(t,i),tension:l.dataset._model?l.dataset._model.tension:0,steppedLine:!!l.dataset._model&&l.dataset._model.steppedLine,hitRadius:s.hitRadius||e.getValueAtIndexOrDefault(d.pointHitRadius,i,g.hitRadius)}},calculatePointY:function(t,e,i){var a,n,o,r=this.chart,l=this.getMeta(),s=this.getScaleForId(l.yAxisID),d=0,u=0;if(s.options.stacked){for(a=0;a<i;a++)if(n=r.data.datasets[a],"line"===(o=r.getDatasetMeta(a)).type&&o.yAxisID===s.id&&r.isDatasetVisible(a)){var c=Number(s.getRightValue(n.data[e]));c<0?u+=c||0:d+=c||0}var h=Number(s.getRightValue(t));return h<0?s.getPixelForValue(u+h):s.getPixelForValue(d+h)}return s.getPixelForValue(t)},updateBezierControlPoints:function(){var t,i,a,n,o=this.getMeta(),r=this.chart.chartArea,l=(o.data||[]).filter(function(t){return!t._model.skip}),s=this.chart.options.elements.line.capBezierPoints;function d(t,e,i){return s?Math.max(Math.min(t,i),e):t}for(t=0,i=l.length;t<i;++t)a=l[t]._model,n=e.splineCurve(e.previousItem(l,t)._model,a,e.nextItem(l,t)._model,o.dataset._model.tension),a.controlPointPreviousX=d(n.previous.x,r.left,r.right),a.controlPointPreviousY=d(n.previous.y,r.top,r.bottom),a.controlPointNextX=d(n.next.x,r.left,r.right),a.controlPointNextY=d(n.next.y,r.top,r.bottom)},draw:function(t){var e,a,n=this.getMeta(),o=n.data||[],r=t||1;for(e=0,a=o.length;e<a;++e)o[e].transition(r);for(i(this.getDataset(),this.chart.options)&&n.dataset.transition(r).draw(),e=0,a=o.length;e<a;++e)o[e].draw()},setHoverStyle:function(t){var i=this.chart.data.datasets[t._datasetIndex],a=t._index,n=t.custom||{},o=t._model;o.radius=n.hoverRadius||e.getValueAtIndexOrDefault(i.pointHoverRadius,a,this.chart.options.elements.point.hoverRadius),o.backgroundColor=n.hoverBackgroundColor||e.getValueAtIndexOrDefault(i.pointHoverBackgroundColor,a,e.getHoverColor(o.backgroundColor)),o.borderColor=n.hoverBorderColor||e.getValueAtIndexOrDefault(i.pointHoverBorderColor,a,e.getHoverColor(o.borderColor)),o.borderWidth=n.hoverBorderWidth||e.getValueAtIndexOrDefault(i.pointHoverBorderWidth,a,o.borderWidth)},removeHoverStyle:function(t){var i=this,a=i.chart.data.datasets[t._datasetIndex],n=t._index,o=t.custom||{},r=t._model;void 0!==a.radius&&void 0===a.pointRadius&&(a.pointRadius=a.radius),r.radius=o.radius||e.getValueAtIndexOrDefault(a.pointRadius,n,i.chart.options.elements.point.radius),r.backgroundColor=i.getPointBackgroundColor(t,n),r.borderColor=i.getPointBorderColor(t,n),r.borderWidth=i.getPointBorderWidth(t,n)}})}},{}],19:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;t.defaults.polarArea={scale:{type:"radialLinear",lineArc:!0,ticks:{beginAtZero:!0}},animation:{animateRotate:!0,animateScale:!0},startAngle:-.5*Math.PI,aspectRatio:1,legendCallback:function(t){var e=[];e.push('<ul class="'+t.id+'-legend">');var i=t.data,a=i.datasets,n=i.labels;if(a.length)for(var o=0;o<a[0].data.length;++o)e.push('<li><span style="background-color:'+a[0].backgroundColor[o]+'">'),n[o]&&e.push(n[o]),e.push("</span></li>");return e.push("</ul>"),e.join("")},legend:{labels:{generateLabels:function(t){var i=t.data;return i.labels.length&&i.datasets.length?i.labels.map(function(a,n){var o=t.getDatasetMeta(0),r=i.datasets[0],l=o.data[n].custom||{},s=e.getValueAtIndexOrDefault,d=t.options.elements.arc;return{text:a,fillStyle:l.backgroundColor?l.backgroundColor:s(r.backgroundColor,n,d.backgroundColor),strokeStyle:l.borderColor?l.borderColor:s(r.borderColor,n,d.borderColor),lineWidth:l.borderWidth?l.borderWidth:s(r.borderWidth,n,d.borderWidth),hidden:isNaN(r.data[n])||o.data[n].hidden,index:n}}):[]}},onClick:function(t,e){var i,a,n,o=e.index,r=this.chart;for(i=0,a=(r.data.datasets||[]).length;i<a;++i)(n=r.getDatasetMeta(i)).data[o].hidden=!n.data[o].hidden;r.update()}},tooltips:{callbacks:{title:function(){return""},label:function(t,e){return e.labels[t.index]+": "+t.yLabel}}}},t.controllers.polarArea=t.DatasetController.extend({dataElementType:t.elements.Arc,linkScales:e.noop,update:function(t){var i=this,a=i.chart,n=a.chartArea,o=i.getMeta(),r=a.options,l=r.elements.arc,s=Math.min(n.right-n.left,n.bottom-n.top);a.outerRadius=Math.max((s-l.borderWidth/2)/2,0),a.innerRadius=Math.max(r.cutoutPercentage?a.outerRadius/100*r.cutoutPercentage:1,0),a.radiusLength=(a.outerRadius-a.innerRadius)/a.getVisibleDatasetCount(),i.outerRadius=a.outerRadius-a.radiusLength*i.index,i.innerRadius=i.outerRadius-a.radiusLength,o.count=i.countVisibleElements(),e.each(o.data,function(e,a){i.updateElement(e,a,t)})},updateElement:function(t,i,a){for(var n=this,o=n.chart,r=n.getDataset(),l=o.options,s=l.animation,d=o.scale,u=e.getValueAtIndexOrDefault,c=o.data.labels,h=n.calculateCircumference(r.data[i]),f=d.xCenter,g=d.yCenter,p=0,m=n.getMeta(),b=0;b<i;++b)isNaN(r.data[b])||m.data[b].hidden||++p;var v=l.startAngle,x=t.hidden?0:d.getDistanceFromCenterForValue(r.data[i]),y=v+h*p,k=y+(t.hidden?0:h),S=s.animateScale?0:d.getDistanceFromCenterForValue(r.data[i]);e.extend(t,{_datasetIndex:n.index,_index:i,_scale:d,_model:{x:f,y:g,innerRadius:0,outerRadius:a?S:x,startAngle:a&&s.animateRotate?v:y,endAngle:a&&s.animateRotate?v:k,label:u(c,i,c[i])}}),n.removeHoverStyle(t),t.pivot()},removeHoverStyle:function(e){t.DatasetController.prototype.removeHoverStyle.call(this,e,this.chart.options.elements.arc)},countVisibleElements:function(){var t=this.getDataset(),i=this.getMeta(),a=0;return e.each(i.data,function(e,i){isNaN(t.data[i])||e.hidden||a++}),a},calculateCircumference:function(t){var e=this.getMeta().count;return e>0&&!isNaN(t)?2*Math.PI/e:0}})}},{}],20:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;t.defaults.radar={scale:{type:"radialLinear"},elements:{line:{tension:0}}},t.controllers.radar=t.DatasetController.extend({datasetElementType:t.elements.Line,dataElementType:t.elements.Point,linkScales:e.noop,addElementAndReset:function(e){t.DatasetController.prototype.addElementAndReset.call(this,e),this.updateBezierControlPoints()},update:function(t){var i=this,a=i.getMeta(),n=a.dataset,o=a.data,r=n.custom||{},l=i.getDataset(),s=i.chart.options.elements.line,d=i.chart.scale;void 0!==l.tension&&void 0===l.lineTension&&(l.lineTension=l.tension),e.extend(a.dataset,{_datasetIndex:i.index,_children:o,_loop:!0,_model:{tension:r.tension?r.tension:e.getValueOrDefault(l.lineTension,s.tension),backgroundColor:r.backgroundColor?r.backgroundColor:l.backgroundColor||s.backgroundColor,borderWidth:r.borderWidth?r.borderWidth:l.borderWidth||s.borderWidth,borderColor:r.borderColor?r.borderColor:l.borderColor||s.borderColor,fill:r.fill?r.fill:void 0!==l.fill?l.fill:s.fill,borderCapStyle:r.borderCapStyle?r.borderCapStyle:l.borderCapStyle||s.borderCapStyle,borderDash:r.borderDash?r.borderDash:l.borderDash||s.borderDash,borderDashOffset:r.borderDashOffset?r.borderDashOffset:l.borderDashOffset||s.borderDashOffset,borderJoinStyle:r.borderJoinStyle?r.borderJoinStyle:l.borderJoinStyle||s.borderJoinStyle,scaleTop:d.top,scaleBottom:d.bottom,scaleZero:d.getBasePosition()}}),a.dataset.pivot(),e.each(o,function(e,a){i.updateElement(e,a,t)},i),i.updateBezierControlPoints()},updateElement:function(t,i,a){var n=this,o=t.custom||{},r=n.getDataset(),l=n.chart.scale,s=n.chart.options.elements.point,d=l.getPointPositionForValue(i,r.data[i]);e.extend(t,{_datasetIndex:n.index,_index:i,_scale:l,_model:{x:a?l.xCenter:d.x,y:a?l.yCenter:d.y,tension:o.tension?o.tension:e.getValueOrDefault(r.tension,n.chart.options.elements.line.tension),radius:o.radius?o.radius:e.getValueAtIndexOrDefault(r.pointRadius,i,s.radius),backgroundColor:o.backgroundColor?o.backgroundColor:e.getValueAtIndexOrDefault(r.pointBackgroundColor,i,s.backgroundColor),borderColor:o.borderColor?o.borderColor:e.getValueAtIndexOrDefault(r.pointBorderColor,i,s.borderColor),borderWidth:o.borderWidth?o.borderWidth:e.getValueAtIndexOrDefault(r.pointBorderWidth,i,s.borderWidth),pointStyle:o.pointStyle?o.pointStyle:e.getValueAtIndexOrDefault(r.pointStyle,i,s.pointStyle),hitRadius:o.hitRadius?o.hitRadius:e.getValueAtIndexOrDefault(r.hitRadius,i,s.hitRadius)}}),t._model.skip=o.skip?o.skip:isNaN(t._model.x)||isNaN(t._model.y)},updateBezierControlPoints:function(){var t=this.chart.chartArea,i=this.getMeta();e.each(i.data,function(a,n){var o=a._model,r=e.splineCurve(e.previousItem(i.data,n,!0)._model,o,e.nextItem(i.data,n,!0)._model,o.tension);o.controlPointPreviousX=Math.max(Math.min(r.previous.x,t.right),t.left),o.controlPointPreviousY=Math.max(Math.min(r.previous.y,t.bottom),t.top),o.controlPointNextX=Math.max(Math.min(r.next.x,t.right),t.left),o.controlPointNextY=Math.max(Math.min(r.next.y,t.bottom),t.top),a.pivot()})},draw:function(t){var i=this.getMeta(),a=t||1;e.each(i.data,function(t){t.transition(a)}),i.dataset.transition(a).draw(),e.each(i.data,function(t){t.draw()})},setHoverStyle:function(t){var i=this.chart.data.datasets[t._datasetIndex],a=t.custom||{},n=t._index,o=t._model;o.radius=a.hoverRadius?a.hoverRadius:e.getValueAtIndexOrDefault(i.pointHoverRadius,n,this.chart.options.elements.point.hoverRadius),o.backgroundColor=a.hoverBackgroundColor?a.hoverBackgroundColor:e.getValueAtIndexOrDefault(i.pointHoverBackgroundColor,n,e.getHoverColor(o.backgroundColor)),o.borderColor=a.hoverBorderColor?a.hoverBorderColor:e.getValueAtIndexOrDefault(i.pointHoverBorderColor,n,e.getHoverColor(o.borderColor)),o.borderWidth=a.hoverBorderWidth?a.hoverBorderWidth:e.getValueAtIndexOrDefault(i.pointHoverBorderWidth,n,o.borderWidth)},removeHoverStyle:function(t){var i=this.chart.data.datasets[t._datasetIndex],a=t.custom||{},n=t._index,o=t._model,r=this.chart.options.elements.point;o.radius=a.radius?a.radius:e.getValueAtIndexOrDefault(i.radius,n,r.radius),o.backgroundColor=a.backgroundColor?a.backgroundColor:e.getValueAtIndexOrDefault(i.pointBackgroundColor,n,r.backgroundColor),o.borderColor=a.borderColor?a.borderColor:e.getValueAtIndexOrDefault(i.pointBorderColor,n,r.borderColor),o.borderWidth=a.borderWidth?a.borderWidth:e.getValueAtIndexOrDefault(i.pointBorderWidth,n,r.borderWidth)}})}},{}],21:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;t.defaults.global.animation={duration:1e3,easing:"easeOutQuart",onProgress:e.noop,onComplete:e.noop},t.Animation=t.Element.extend({currentStep:null,numSteps:60,easing:"",render:null,onAnimationProgress:null,onAnimationComplete:null}),t.animationService={frameDuration:17,animations:[],dropFrames:0,request:null,addAnimation:function(t,e,i,a){var n=this;a||(t.animating=!0);for(var o=0;o<n.animations.length;++o)if(n.animations[o].chartInstance===t)return void(n.animations[o].animationObject=e);n.animations.push({chartInstance:t,animationObject:e}),1===n.animations.length&&n.requestAnimationFrame()},cancelAnimation:function(t){var i=e.findIndex(this.animations,function(e){return e.chartInstance===t});-1!==i&&(this.animations.splice(i,1),t.animating=!1)},requestAnimationFrame:function(){var t=this;null===t.request&&(t.request=e.requestAnimFrame.call(window,function(){t.request=null,t.startDigest()}))},startDigest:function(){var t=this,e=Date.now(),i=0;t.dropFrames>1&&(i=Math.floor(t.dropFrames),t.dropFrames=t.dropFrames%1);for(var a=0;a<t.animations.length;)null===t.animations[a].animationObject.currentStep&&(t.animations[a].animationObject.currentStep=0),t.animations[a].animationObject.currentStep+=1+i,t.animations[a].animationObject.currentStep>t.animations[a].animationObject.numSteps&&(t.animations[a].animationObject.currentStep=t.animations[a].animationObject.numSteps),t.animations[a].animationObject.render(t.animations[a].chartInstance,t.animations[a].animationObject),t.animations[a].animationObject.onAnimationProgress&&t.animations[a].animationObject.onAnimationProgress.call&&t.animations[a].animationObject.onAnimationProgress.call(t.animations[a].chartInstance,t.animations[a]),t.animations[a].animationObject.currentStep===t.animations[a].animationObject.numSteps?(t.animations[a].animationObject.onAnimationComplete&&t.animations[a].animationObject.onAnimationComplete.call&&t.animations[a].animationObject.onAnimationComplete.call(t.animations[a].chartInstance,t.animations[a]),t.animations[a].chartInstance.animating=!1,t.animations.splice(a,1)):++a;var n=(Date.now()-e)/t.frameDuration;t.dropFrames+=n,t.animations.length>0&&t.requestAnimationFrame()}}}},{}],22:[function(t,e,i){"use strict";e.exports=function(t){(t.canvasHelpers={}).drawPoint=function(t,e,i,a,n){var o,r,l,s,d,u;if("object"!=typeof e||"[object HTMLImageElement]"!==(o=e.toString())&&"[object HTMLCanvasElement]"!==o){if(!(isNaN(i)||i<=0)){switch(e){default:t.beginPath(),t.arc(a,n,i,0,2*Math.PI),t.closePath(),t.fill();break;case"triangle":t.beginPath(),d=(r=3*i/Math.sqrt(3))*Math.sqrt(3)/2,t.moveTo(a-r/2,n+d/3),t.lineTo(a+r/2,n+d/3),t.lineTo(a,n-2*d/3),t.closePath(),t.fill();break;case"rect":u=1/Math.SQRT2*i,t.beginPath(),t.fillRect(a-u,n-u,2*u,2*u),t.strokeRect(a-u,n-u,2*u,2*u);break;case"rectRot":u=1/Math.SQRT2*i,t.beginPath(),t.moveTo(a-u,n),t.lineTo(a,n+u),t.lineTo(a+u,n),t.lineTo(a,n-u),t.closePath(),t.fill();break;case"cross":t.beginPath(),t.moveTo(a,n+i),t.lineTo(a,n-i),t.moveTo(a-i,n),t.lineTo(a+i,n),t.closePath();break;case"crossRot":t.beginPath(),l=Math.cos(Math.PI/4)*i,s=Math.sin(Math.PI/4)*i,t.moveTo(a-l,n-s),t.lineTo(a+l,n+s),t.moveTo(a-l,n+s),t.lineTo(a+l,n-s),t.closePath();break;case"star":t.beginPath(),t.moveTo(a,n+i),t.lineTo(a,n-i),t.moveTo(a-i,n),t.lineTo(a+i,n),l=Math.cos(Math.PI/4)*i,s=Math.sin(Math.PI/4)*i,t.moveTo(a-l,n-s),t.lineTo(a+l,n+s),t.moveTo(a-l,n+s),t.lineTo(a+l,n-s),t.closePath();break;case"line":t.beginPath(),t.moveTo(a-i,n),t.lineTo(a+i,n),t.closePath();break;case"dash":t.beginPath(),t.moveTo(a,n),t.lineTo(a+i,n),t.closePath()}t.stroke()}}else t.drawImage(e,a-e.width/2,n-e.height/2)}}},{}],23:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;t.types={},t.instances={},t.controllers={},t.Controller=function(i){return this.chart=i,this.config=i.config,this.options=this.config.options=e.configMerge(t.defaults.global,t.defaults[this.config.type],this.config.options||{}),this.id=e.uid(),Object.defineProperty(this,"data",{get:function(){return this.config.data}}),t.instances[this.id]=this,this.options.responsive&&this.resize(!0),this.initialize(),this},e.extend(t.Controller.prototype,{initialize:function(){var e=this;return t.plugins.notify("beforeInit",[e]),e.bindEvents(),e.ensureScalesHaveIDs(),e.buildOrUpdateControllers(),e.buildScales(),e.updateLayout(),e.resetElements(),e.initToolTip(),e.update(),t.plugins.notify("afterInit",[e]),e},clear:function(){return e.clear(this.chart),this},stop:function(){return t.animationService.cancelAnimation(this),this},resize:function(i){var a=this,n=a.chart,o=n.canvas,r=e.getMaximumWidth(o),l=n.aspectRatio,s=a.options.maintainAspectRatio&&!1===isNaN(l)&&isFinite(l)&&0!==l?r/l:e.getMaximumHeight(o);if(!(n.width!==r||n.height!==s))return a;o.width=n.width=r,o.height=n.height=s,e.retinaScale(n);var d={width:r,height:s};return t.plugins.notify("resize",[a,d]),a.options.onResize&&a.options.onResize(a,d),i||(a.stop(),a.update(a.options.responsiveAnimationDuration)),a},ensureScalesHaveIDs:function(){var t=this.options,i=t.scales||{},a=t.scale;e.each(i.xAxes,function(t,e){t.id=t.id||"x-axis-"+e}),e.each(i.yAxes,function(t,e){t.id=t.id||"y-axis-"+e}),a&&(a.id=a.id||"scale")},buildScales:function(){var i=this,a=i.options,n=i.scales={},o=[];a.scales&&(o=o.concat((a.scales.xAxes||[]).map(function(t){return{options:t,dtype:"category"}}),(a.scales.yAxes||[]).map(function(t){return{options:t,dtype:"linear"}}))),a.scale&&o.push({options:a.scale,dtype:"radialLinear",isDefault:!0}),e.each(o,function(a){var o=a.options,r=e.getValueOrDefault(o.type,a.dtype),l=t.scaleService.getScaleConstructor(r);if(l){var s=new l({id:o.id,options:o,ctx:i.chart.ctx,chart:i});n[s.id]=s,a.isDefault&&(i.scale=s)}}),t.scaleService.addScalesToLayout(this)},updateLayout:function(){t.layoutService.update(this,this.chart.width,this.chart.height)},buildOrUpdateControllers:function(){var i=this,a=[],n=[];if(e.each(i.data.datasets,function(e,o){var r=i.getDatasetMeta(o);r.type||(r.type=e.type||i.config.type),a.push(r.type),r.controller?r.controller.updateIndex(o):(r.controller=new t.controllers[r.type](i,o),n.push(r.controller))},i),a.length>1)for(var o=1;o<a.length;o++)if(a[o]!==a[o-1]){i.isCombo=!0;break}return n},resetElements:function(){var t=this;e.each(t.data.datasets,function(e,i){t.getDatasetMeta(i).controller.reset()},t)},update:function(i,a){var n=this;t.plugins.notify("beforeUpdate",[n]),n.tooltip._data=n.data;var o=n.buildOrUpdateControllers();e.each(n.data.datasets,function(t,e){n.getDatasetMeta(e).controller.buildOrUpdateElements()},n),t.layoutService.update(n,n.chart.width,n.chart.height),t.plugins.notify("afterScaleUpdate",[n]),e.each(o,function(t){t.reset()}),n.updateDatasets(),t.plugins.notify("afterUpdate",[n]),n.render(i,a)},updateDatasets:function(){var e,i;if(t.plugins.notify("beforeDatasetsUpdate",[this])){for(e=0,i=this.data.datasets.length;e<i;++e)this.getDatasetMeta(e).controller.update();t.plugins.notify("afterDatasetsUpdate",[this])}},render:function(i,a){var n=this;t.plugins.notify("beforeRender",[n]);var o=n.options.animation;if(o&&(void 0!==i&&0!==i||void 0===i&&0!==o.duration)){var r=new t.Animation;r.numSteps=(i||o.duration)/16.66,r.easing=o.easing,r.render=function(t,i){var a=e.easingEffects[i.easing],n=i.currentStep/i.numSteps,o=a(n);t.draw(o,n,i.currentStep)},r.onAnimationProgress=o.onProgress,r.onAnimationComplete=o.onComplete,t.animationService.addAnimation(n,r,i,a)}else n.draw(),o&&o.onComplete&&o.onComplete.call&&o.onComplete.call(n);return n},draw:function(i){var a=this,n=i||1;a.clear(),t.plugins.notify("beforeDraw",[a,n]),e.each(a.boxes,function(t){t.draw(a.chartArea)},a),a.scale&&a.scale.draw(),t.plugins.notify("beforeDatasetsDraw",[a,n]),e.each(a.data.datasets,function(t,e){a.isDatasetVisible(e)&&a.getDatasetMeta(e).controller.draw(i)},a,!0),t.plugins.notify("afterDatasetsDraw",[a,n]),a.tooltip.transition(n).draw(),t.plugins.notify("afterDraw",[a,n])},getElementAtEvent:function(t){var i=this,a=e.getRelativePosition(t,i.chart),n=[];return e.each(i.data.datasets,function(t,o){if(i.isDatasetVisible(o)){var r=i.getDatasetMeta(o);e.each(r.data,function(t){if(t.inRange(a.x,a.y))return n.push(t),n})}}),n.slice(0,1)},getElementsAtEvent:function(t){var i=this,a=e.getRelativePosition(t,i.chart),n=[],o=function(){if(i.data.datasets)for(var t=0;t<i.data.datasets.length;t++){var e=i.getDatasetMeta(t);if(i.isDatasetVisible(t))for(var n=0;n<e.data.length;n++)if(e.data[n].inRange(a.x,a.y))return e.data[n]}}.call(i);return o?(e.each(i.data.datasets,function(t,e){if(i.isDatasetVisible(e)){var a=i.getDatasetMeta(e).data[o._index];a&&!a._view.skip&&n.push(a)}},i),n):n},getElementsAtXAxis:function(t){var i=this,a=e.getRelativePosition(t,i.chart),n=[],o=function(){if(i.data.datasets)for(var t=0;t<i.data.datasets.length;t++){var e=i.getDatasetMeta(t);if(i.isDatasetVisible(t))for(var n=0;n<e.data.length;n++)if(e.data[n].inLabelRange(a.x,a.y))return e.data[n]}}.call(i);return o?(e.each(i.data.datasets,function(t,a){if(i.isDatasetVisible(a)){var r=i.getDatasetMeta(a),l=e.findIndex(r.data,function(t){return o._model.x===t._model.x});-1===l||r.data[l]._view.skip||n.push(r.data[l])}},i),n):n},getElementsAtEventForMode:function(t,e){switch(e){case"single":return this.getElementAtEvent(t);case"label":return this.getElementsAtEvent(t);case"dataset":return this.getDatasetAtEvent(t);case"x-axis":return this.getElementsAtXAxis(t);default:return t}},getDatasetAtEvent:function(t){var e=this.getElementAtEvent(t);return e.length>0&&(e=this.getDatasetMeta(e[0]._datasetIndex).data),e},getDatasetMeta:function(t){var e=this.data.datasets[t];e._meta||(e._meta={});var i=e._meta[this.id];return i||(i=e._meta[this.id]={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null}),i},getVisibleDatasetCount:function(){for(var t=0,e=0,i=this.data.datasets.length;e<i;++e)this.isDatasetVisible(e)&&t++;return t},isDatasetVisible:function(t){var e=this.getDatasetMeta(t);return"boolean"==typeof e.hidden?!e.hidden:!this.data.datasets[t].hidden},generateLegend:function(){return this.options.legendCallback(this)},destroy:function(){var i=this;i.stop(),i.clear(),e.unbindEvents(i,i.events),e.removeResizeListener(i.chart.canvas.parentNode);var a=i.chart.canvas;a.width=i.chart.width,a.height=i.chart.height,void 0!==i.chart.originalDevicePixelRatio&&i.chart.ctx.scale(1/i.chart.originalDevicePixelRatio,1/i.chart.originalDevicePixelRatio),a.style.width=i.chart.originalCanvasStyleWidth,a.style.height=i.chart.originalCanvasStyleHeight,t.plugins.notify("destroy",[i]),delete t.instances[i.id]},toBase64Image:function(){return this.chart.canvas.toDataURL.apply(this.chart.canvas,arguments)},initToolTip:function(){var e=this;e.tooltip=new t.Tooltip({_chart:e.chart,_chartInstance:e,_data:e.data,_options:e.options.tooltips},e)},bindEvents:function(){var t=this;e.bindEvents(t,t.options.events,function(e){t.eventHandler(e)})},updateHoverStyle:function(t,e,i){var a,n,o,r=i?"setHoverStyle":"removeHoverStyle";switch(e){case"single":t=[t[0]];break;case"label":case"dataset":case"x-axis":break;default:return}for(n=0,o=t.length;n<o;++n)(a=t[n])&&this.getDatasetMeta(a._datasetIndex).controller[r](a)},eventHandler:function(t){var i=this,a=i.tooltip,n=i.options||{},o=n.hover,r=n.tooltips;return i.lastActive=i.lastActive||[],i.lastTooltipActive=i.lastTooltipActive||[],"mouseout"===t.type?(i.active=[],i.tooltipActive=[]):(i.active=i.getElementsAtEventForMode(t,o.mode),i.tooltipActive=i.getElementsAtEventForMode(t,r.mode)),o.onHover&&o.onHover.call(i,i.active),"mouseup"!==t.type&&"click"!==t.type||(n.onClick&&n.onClick.call(i,t,i.active),i.legend&&i.legend.handleEvent&&i.legend.handleEvent(t)),i.lastActive.length&&i.updateHoverStyle(i.lastActive,o.mode,!1),i.active.length&&o.mode&&i.updateHoverStyle(i.active,o.mode,!0),(r.enabled||r.custom)&&(a.initialize(),a._active=i.tooltipActive,a.update(!0)),a.pivot(),i.animating||e.arrayEquals(i.active,i.lastActive)&&e.arrayEquals(i.tooltipActive,i.lastTooltipActive)||(i.stop(),(r.enabled||r.custom)&&a.update(!0),i.render(o.animationDuration,!0)),i.lastActive=i.active,i.lastTooltipActive=i.tooltipActive,i}})}},{}],24:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers,i=e.noop;t.DatasetController=function(t,e){this.initialize.call(this,t,e)},e.extend(t.DatasetController.prototype,{datasetElementType:null,dataElementType:null,initialize:function(t,e){this.chart=t,this.index=e,this.linkScales(),this.addElements()},updateIndex:function(t){this.index=t},linkScales:function(){var t=this.getMeta(),e=this.getDataset();null===t.xAxisID&&(t.xAxisID=e.xAxisID||this.chart.options.scales.xAxes[0].id),null===t.yAxisID&&(t.yAxisID=e.yAxisID||this.chart.options.scales.yAxes[0].id)},getDataset:function(){return this.chart.data.datasets[this.index]},getMeta:function(){return this.chart.getDatasetMeta(this.index)},getScaleForId:function(t){return this.chart.scales[t]},reset:function(){this.update(!0)},createMetaDataset:function(){var t=this.datasetElementType;return t&&new t({_chart:this.chart.chart,_datasetIndex:this.index})},createMetaData:function(t){var e=this.dataElementType;return e&&new e({_chart:this.chart.chart,_datasetIndex:this.index,_index:t})},addElements:function(){var t,e,i=this.getMeta(),a=this.getDataset().data||[],n=i.data;for(t=0,e=a.length;t<e;++t)n[t]=n[t]||this.createMetaData(i,t);i.dataset=i.dataset||this.createMetaDataset()},addElementAndReset:function(t){var e=this.createMetaData(t);this.getMeta().data.splice(t,0,e),this.updateElement(e,t,!0)},buildOrUpdateElements:function(){var t=this.getMeta().data,e=this.getDataset().data.length,i=t.length;if(e<i)t.splice(e,i-e);else if(e>i)for(var a=i;a<e;++a)this.addElementAndReset(a)},update:i,draw:function(t){var i=t||1;e.each(this.getMeta().data,function(t){t.transition(i).draw()})},removeHoverStyle:function(t,i){var a=this.chart.data.datasets[t._datasetIndex],n=t._index,o=t.custom||{},r=e.getValueAtIndexOrDefault,l=t._model;l.backgroundColor=o.backgroundColor?o.backgroundColor:r(a.backgroundColor,n,i.backgroundColor),l.borderColor=o.borderColor?o.borderColor:r(a.borderColor,n,i.borderColor),l.borderWidth=o.borderWidth?o.borderWidth:r(a.borderWidth,n,i.borderWidth)},setHoverStyle:function(t){var i=this.chart.data.datasets[t._datasetIndex],a=t._index,n=t.custom||{},o=e.getValueAtIndexOrDefault,r=e.getHoverColor,l=t._model;l.backgroundColor=n.hoverBackgroundColor?n.hoverBackgroundColor:o(i.hoverBackgroundColor,a,r(l.backgroundColor)),l.borderColor=n.hoverBorderColor?n.hoverBorderColor:o(i.hoverBorderColor,a,r(l.borderColor)),l.borderWidth=n.hoverBorderWidth?n.hoverBorderWidth:o(i.hoverBorderWidth,a,l.borderWidth)}}),t.DatasetController.extend=e.inherits}},{}],25:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;t.elements={},t.Element=function(t){e.extend(this,t),this.initialize.apply(this,arguments)},e.extend(t.Element.prototype,{initialize:function(){this.hidden=!1},pivot:function(){var t=this;return t._view||(t._view=e.clone(t._model)),t._start=e.clone(t._view),t},transition:function(t){var i=this;return i._view||(i._view=e.clone(i._model)),1===t?(i._view=i._model,i._start=null,i):(i._start||i.pivot(),e.each(i._model,function(a,n){if("_"===n[0]);else if(i._view.hasOwnProperty(n))if(a===i._view[n]);else if("string"==typeof a)try{var o=e.color(i._model[n]).mix(e.color(i._start[n]),t);i._view[n]=o.rgbString()}catch(t){i._view[n]=a}else if("number"==typeof a){var r=void 0!==i._start[n]&&!1===isNaN(i._start[n])?i._start[n]:0;i._view[n]=(i._model[n]-r)*t+r}else i._view[n]=a;else"number"!=typeof a||isNaN(i._view[n])?i._view[n]=a:i._view[n]=a*t},i),i)},tooltipPosition:function(){return{x:this._model.x,y:this._model.y}},hasValue:function(){return e.isNumber(this._model.x)&&e.isNumber(this._model.y)}}),t.Element.extend=e.inherits}},{}],26:[function(t,e,i){"use strict";var a=t(3);e.exports=function(t){var e,i=t.helpers={};i.each=function(t,e,a,n){var o,r;if(i.isArray(t))if(r=t.length,n)for(o=r-1;o>=0;o--)e.call(a,t[o],o);else for(o=0;o<r;o++)e.call(a,t[o],o);else if("object"==typeof t){var l=Object.keys(t);for(r=l.length,o=0;o<r;o++)e.call(a,t[l[o]],l[o])}},i.clone=function(t){var e={};return i.each(t,function(t,a){i.isArray(t)?e[a]=t.slice(0):e[a]="object"==typeof t&&null!==t?i.clone(t):t}),e},i.extend=function(t){for(var e=function(e,i){t[i]=e},a=1,n=arguments.length;a<n;a++)i.each(arguments[a],e);return t},i.configMerge=function(e){var a=i.clone(e);return i.each(Array.prototype.slice.call(arguments,1),function(e){i.each(e,function(e,n){if("scales"===n)a[n]=i.scaleMerge(a.hasOwnProperty(n)?a[n]:{},e);else if("scale"===n)a[n]=i.configMerge(a.hasOwnProperty(n)?a[n]:{},t.scaleService.getScaleDefaults(e.type),e);else if(a.hasOwnProperty(n)&&i.isArray(a[n])&&i.isArray(e)){var o=a[n];i.each(e,function(t,e){e<o.length?"object"==typeof o[e]&&null!==o[e]&&"object"==typeof t&&null!==t?o[e]=i.configMerge(o[e],t):o[e]=t:o.push(t)})}else a.hasOwnProperty(n)&&"object"==typeof a[n]&&null!==a[n]&&"object"==typeof e?a[n]=i.configMerge(a[n],e):a[n]=e})}),a},i.scaleMerge=function(e,a){var n=i.clone(e);return i.each(a,function(e,a){"xAxes"===a||"yAxes"===a?n.hasOwnProperty(a)?i.each(e,function(e,o){var r=i.getValueOrDefault(e.type,"xAxes"===a?"category":"linear"),l=t.scaleService.getScaleDefaults(r);o>=n[a].length||!n[a][o].type?n[a].push(i.configMerge(l,e)):e.type&&e.type!==n[a][o].type?n[a][o]=i.configMerge(n[a][o],l,e):n[a][o]=i.configMerge(n[a][o],e)}):(n[a]=[],i.each(e,function(e){var o=i.getValueOrDefault(e.type,"xAxes"===a?"category":"linear");n[a].push(i.configMerge(t.scaleService.getScaleDefaults(o),e))})):n.hasOwnProperty(a)&&"object"==typeof n[a]&&null!==n[a]&&"object"==typeof e?n[a]=i.configMerge(n[a],e):n[a]=e}),n},i.getValueAtIndexOrDefault=function(t,e,a){return null==t?a:i.isArray(t)?e<t.length?t[e]:a:t},i.getValueOrDefault=function(t,e){return void 0===t?e:t},i.indexOf=Array.prototype.indexOf?function(t,e){return t.indexOf(e)}:function(t,e){for(var i=0,a=t.length;i<a;++i)if(t[i]===e)return i;return-1},i.where=function(t,e){if(i.isArray(t)&&Array.prototype.filter)return t.filter(e);var a=[];return i.each(t,function(t){e(t)&&a.push(t)}),a},i.findIndex=Array.prototype.findIndex?function(t,e,i){return t.findIndex(e,i)}:function(t,e,i){i=void 0===i?t:i;for(var a=0,n=t.length;a<n;++a)if(e.call(i,t[a],a,t))return a;return-1},i.findNextWhere=function(t,e,i){null==i&&(i=-1);for(var a=i+1;a<t.length;a++){var n=t[a];if(e(n))return n}},i.findPreviousWhere=function(t,e,i){null==i&&(i=t.length);for(var a=i-1;a>=0;a--){var n=t[a];if(e(n))return n}},i.inherits=function(t){var e=this,a=t&&t.hasOwnProperty("constructor")?t.constructor:function(){return e.apply(this,arguments)},n=function(){this.constructor=a};return n.prototype=e.prototype,a.prototype=new n,a.extend=i.inherits,t&&i.extend(a.prototype,t),a.__super__=e.prototype,a},i.noop=function(){},i.uid=(e=0,function(){return e++}),i.isNumber=function(t){return!isNaN(parseFloat(t))&&isFinite(t)},i.almostEquals=function(t,e,i){return Math.abs(t-e)<i},i.max=function(t){return t.reduce(function(t,e){return isNaN(e)?t:Math.max(t,e)},Number.NEGATIVE_INFINITY)},i.min=function(t){return t.reduce(function(t,e){return isNaN(e)?t:Math.min(t,e)},Number.POSITIVE_INFINITY)},i.sign=Math.sign?function(t){return Math.sign(t)}:function(t){return 0===(t=+t)||isNaN(t)?t:t>0?1:-1},i.log10=Math.log10?function(t){return Math.log10(t)}:function(t){return Math.log(t)/Math.LN10},i.toRadians=function(t){return t*(Math.PI/180)},i.toDegrees=function(t){return t*(180/Math.PI)},i.getAngleFromPoint=function(t,e){var i=e.x-t.x,a=e.y-t.y,n=Math.sqrt(i*i+a*a),o=Math.atan2(a,i);return o<-.5*Math.PI&&(o+=2*Math.PI),{angle:o,distance:n}},i.aliasPixel=function(t){return t%2==0?0:.5},i.splineCurve=function(t,e,i,a){var n=t.skip?e:t,o=e,r=i.skip?e:i,l=Math.sqrt(Math.pow(o.x-n.x,2)+Math.pow(o.y-n.y,2)),s=Math.sqrt(Math.pow(r.x-o.x,2)+Math.pow(r.y-o.y,2)),d=l/(l+s),u=s/(l+s),c=a*(d=isNaN(d)?0:d),h=a*(u=isNaN(u)?0:u);return{previous:{x:o.x-c*(r.x-n.x),y:o.y-c*(r.y-n.y)},next:{x:o.x+h*(r.x-n.x),y:o.y+h*(r.y-n.y)}}},i.nextItem=function(t,e,i){return i?e>=t.length-1?t[0]:t[e+1]:e>=t.length-1?t[t.length-1]:t[e+1]},i.previousItem=function(t,e,i){return i?e<=0?t[t.length-1]:t[e-1]:e<=0?t[0]:t[e-1]},i.niceNum=function(t,e){var a=Math.floor(i.log10(t)),n=t/Math.pow(10,a);return(e?n<1.5?1:n<3?2:n<7?5:10:n<=1?1:n<=2?2:n<=5?5:10)*Math.pow(10,a)};var n=i.easingEffects={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return-1*t*(t-2)},easeInOutQuad:function(t){return(t/=.5)<1?.5*t*t:-.5*(--t*(t-2)-1)},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return 1*((t=t/1-1)*t*t+1)},easeInOutCubic:function(t){return(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2)},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return-1*((t=t/1-1)*t*t*t-1)},easeInOutQuart:function(t){return(t/=.5)<1?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2)},easeInQuint:function(t){return 1*(t/=1)*t*t*t*t},easeOutQuint:function(t){return 1*((t=t/1-1)*t*t*t*t+1)},easeInOutQuint:function(t){return(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2)},easeInSine:function(t){return-1*Math.cos(t/1*(Math.PI/2))+1},easeOutSine:function(t){return 1*Math.sin(t/1*(Math.PI/2))},easeInOutSine:function(t){return-.5*(Math.cos(Math.PI*t/1)-1)},easeInExpo:function(t){return 0===t?1:1*Math.pow(2,10*(t/1-1))},easeOutExpo:function(t){return 1===t?1:1*(1-Math.pow(2,-10*t/1))},easeInOutExpo:function(t){return 0===t?0:1===t?1:(t/=.5)<1?.5*Math.pow(2,10*(t-1)):.5*(2-Math.pow(2,-10*--t))},easeInCirc:function(t){return t>=1?t:-1*(Math.sqrt(1-(t/=1)*t)-1)},easeOutCirc:function(t){return 1*Math.sqrt(1-(t=t/1-1)*t)},easeInOutCirc:function(t){return(t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)},easeInElastic:function(t){var e=1.70158,i=0,a=1;return 0===t?0:1==(t/=1)?1:(i||(i=.3),a<Math.abs(1)?(a=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/a),-a*Math.pow(2,10*(t-=1))*Math.sin((1*t-e)*(2*Math.PI)/i))},easeOutElastic:function(t){var e=1.70158,i=0,a=1;return 0===t?0:1==(t/=1)?1:(i||(i=.3),a<Math.abs(1)?(a=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/a),a*Math.pow(2,-10*t)*Math.sin((1*t-e)*(2*Math.PI)/i)+1)},easeInOutElastic:function(t){var e=1.70158,i=0,a=1;return 0===t?0:2==(t/=.5)?1:(i||(i=.3*1.5*1),a<Math.abs(1)?(a=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/a),t<1?a*Math.pow(2,10*(t-=1))*Math.sin((1*t-e)*(2*Math.PI)/i)*-.5:a*Math.pow(2,-10*(t-=1))*Math.sin((1*t-e)*(2*Math.PI)/i)*.5+1)},easeInBack:function(t){var e=1.70158;return 1*(t/=1)*t*((e+1)*t-e)},easeOutBack:function(t){var e=1.70158;return 1*((t=t/1-1)*t*((e+1)*t+e)+1)},easeInOutBack:function(t){var e=1.70158;return(t/=.5)<1?t*t*((1+(e*=1.525))*t-e)*.5:.5*((t-=2)*t*((1+(e*=1.525))*t+e)+2)},easeInBounce:function(t){return 1-n.easeOutBounce(1-t)},easeOutBounce:function(t){return(t/=1)<1/2.75?7.5625*t*t*1:t<2/2.75?1*(7.5625*(t-=1.5/2.75)*t+.75):t<2.5/2.75?1*(7.5625*(t-=2.25/2.75)*t+.9375):1*(7.5625*(t-=2.625/2.75)*t+.984375)},easeInOutBounce:function(t){return t<.5?.5*n.easeInBounce(2*t):.5*n.easeOutBounce(2*t-1)+.5}};function o(t,e,i){var a;return"string"==typeof t?(a=parseInt(t,10),-1!=t.indexOf("%")&&(a=a/100*e.parentNode[i])):a=t,a}function r(t){return null!=t&&"none"!==t}function l(t,e,i){var a=document.defaultView,n=t.parentNode,l=a.getComputedStyle(t)[e],s=a.getComputedStyle(n)[e],d=r(l),u=r(s),c=Number.POSITIVE_INFINITY;return d||u?Math.min(d?o(l,t,i):c,u?o(s,n,i):c):"none"}i.requestAnimFrame=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(t){return window.setTimeout(t,1e3/60)},i.cancelAnimFrame=window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.mozCancelAnimationFrame||window.oCancelAnimationFrame||window.msCancelAnimationFrame||function(t){return window.clearTimeout(t,1e3/60)},i.getRelativePosition=function(t,e){var a,n,o=t.originalEvent||t,r=t.currentTarget||t.srcElement,l=r.getBoundingClientRect(),s=o.touches;s&&s.length>0?(a=s[0].clientX,n=s[0].clientY):(a=o.clientX,n=o.clientY);var d=parseFloat(i.getStyle(r,"padding-left")),u=parseFloat(i.getStyle(r,"padding-top")),c=parseFloat(i.getStyle(r,"padding-right")),h=parseFloat(i.getStyle(r,"padding-bottom")),f=l.right-l.left-d-c,g=l.bottom-l.top-u-h;return{x:a=Math.round((a-l.left-d)/f*r.width/e.currentDevicePixelRatio),y:n=Math.round((n-l.top-u)/g*r.height/e.currentDevicePixelRatio)}},i.addEvent=function(t,e,i){t.addEventListener?t.addEventListener(e,i):t.attachEvent?t.attachEvent("on"+e,i):t["on"+e]=i},i.removeEvent=function(t,e,a){t.removeEventListener?t.removeEventListener(e,a,!1):t.detachEvent?t.detachEvent("on"+e,a):t["on"+e]=i.noop},i.bindEvents=function(t,e,a){var n=t.events=t.events||{};i.each(e,function(e){n[e]=function(){a.apply(t,arguments)},i.addEvent(t.chart.canvas,e,n[e])})},i.unbindEvents=function(t,e){var a=t.chart.canvas;i.each(e,function(t,e){i.removeEvent(a,e,t)})},i.getConstraintWidth=function(t){return l(t,"max-width","clientWidth")},i.getConstraintHeight=function(t){return l(t,"max-height","clientHeight")},i.getMaximumWidth=function(t){var e=t.parentNode,a=parseInt(i.getStyle(e,"padding-left"))+parseInt(i.getStyle(e,"padding-right")),n=e.clientWidth-a,o=i.getConstraintWidth(t);return isNaN(o)?n:Math.min(n,o)},i.getMaximumHeight=function(t){var e=t.parentNode,a=parseInt(i.getStyle(e,"padding-top"))+parseInt(i.getStyle(e,"padding-bottom")),n=e.clientHeight-a,o=i.getConstraintHeight(t);return isNaN(o)?n:Math.min(n,o)},i.getStyle=function(t,e){return t.currentStyle?t.currentStyle[e]:document.defaultView.getComputedStyle(t,null).getPropertyValue(e)},i.retinaScale=function(t){var e=t.ctx,i=t.canvas,a=i.width,n=i.height,o=t.currentDevicePixelRatio=window.devicePixelRatio||1;1!==o&&(i.height=n*o,i.width=a*o,e.scale(o,o),t.originalDevicePixelRatio=t.originalDevicePixelRatio||o),i.style.width=a+"px",i.style.height=n+"px"},i.clear=function(t){t.ctx.clearRect(0,0,t.width,t.height)},i.fontString=function(t,e,i){return e+" "+t+"px "+i},i.longestText=function(t,e,a,n){var o=(n=n||{}).data=n.data||{},r=n.garbageCollect=n.garbageCollect||[];n.font!==e&&(o=n.data={},r=n.garbageCollect=[],n.font=e),t.font=e;var l=0;i.each(a,function(e){null!=e&&!0!==i.isArray(e)?l=i.measureText(t,o,r,l,e):i.isArray(e)&&i.each(e,function(e){null==e||i.isArray(e)||(l=i.measureText(t,o,r,l,e))})});var s=r.length/2;if(s>a.length){for(var d=0;d<s;d++)delete o[r[d]];r.splice(0,s)}return l},i.measureText=function(t,e,i,a,n){var o=e[n];return o||(o=e[n]=t.measureText(n).width,i.push(n)),o>a&&(a=o),a},i.numberOfLabelLines=function(t){var e=1;return i.each(t,function(t){i.isArray(t)&&t.length>e&&(e=t.length)}),e},i.drawRoundedRectangle=function(t,e,i,a,n,o){t.beginPath(),t.moveTo(e+o,i),t.lineTo(e+a-o,i),t.quadraticCurveTo(e+a,i,e+a,i+o),t.lineTo(e+a,i+n-o),t.quadraticCurveTo(e+a,i+n,e+a-o,i+n),t.lineTo(e+o,i+n),t.quadraticCurveTo(e,i+n,e,i+n-o),t.lineTo(e,i+o),t.quadraticCurveTo(e,i,e+o,i),t.closePath()},i.color=function(e){return a?e instanceof CanvasGradient?a(t.defaults.global.defaultColor):a(e):(console.log("Color.js not found!"),e)},i.addResizeListener=function(t,e){var i=document.createElement("iframe");i.classlist?i.classlist.add("chartjs-hidden-iframe"):i.setAttribute("class","chartjs-hidden-iframe");var a=i.style;a.width="100%",a.display="block",a.border=0,a.height=0,a.margin=0,a.position="absolute",a.left=0,a.right=0,a.top=0,a.bottom=0,t.insertBefore(i,t.firstChild),(i.contentWindow||i).onresize=function(){e&&e()}},i.removeResizeListener=function(t){var e=t.querySelector(".chartjs-hidden-iframe");e&&e.parentNode.removeChild(e)},i.isArray=Array.isArray?function(t){return Array.isArray(t)}:function(t){return"[object Array]"===Object.prototype.toString.call(t)},i.arrayEquals=function(t,e){var a,n,o,r;if(!t||!e||t.length!=e.length)return!1;for(a=0,n=t.length;a<n;++a)if(o=t[a],r=e[a],o instanceof Array&&r instanceof Array){if(!i.arrayEquals(o,r))return!1}else if(o!=r)return!1;return!0},i.callCallback=function(t,e,i){t&&"function"==typeof t.call&&t.apply(i,e)},i.getHoverColor=function(t){return t instanceof CanvasPattern?t:i.color(t).saturate(.5).darken(.1).rgbString()}}},{3:3}],27:[function(t,e,i){"use strict";e.exports=function(){var t=function(e,i){var a=this,n=t.helpers;return a.config=i||{data:{datasets:[]}},e.length&&e[0].getContext&&(e=e[0]),e.getContext&&(e=e.getContext("2d")),a.ctx=e,a.canvas=e.canvas,e.canvas.style.display=e.canvas.style.display||"block",a.width=e.canvas.width||parseInt(n.getStyle(e.canvas,"width"),10)||n.getMaximumWidth(e.canvas),a.height=e.canvas.height||parseInt(n.getStyle(e.canvas,"height"),10)||n.getMaximumHeight(e.canvas),a.aspectRatio=a.width/a.height,(isNaN(a.aspectRatio)||!1===isFinite(a.aspectRatio))&&(a.aspectRatio=void 0!==i.aspectRatio?i.aspectRatio:2),a.originalCanvasStyleWidth=e.canvas.style.width,a.originalCanvasStyleHeight=e.canvas.style.height,n.retinaScale(a),a.controller=new t.Controller(a),n.addResizeListener(e.canvas.parentNode,function(){a.controller&&a.controller.config.options.responsive&&a.controller.resize()}),a.controller?a.controller:a};return t.defaults={global:{responsive:!0,responsiveAnimationDuration:0,maintainAspectRatio:!0,events:["mousemove","mouseout","click","touchstart","touchmove"],hover:{onHover:null,mode:"single",animationDuration:400},onClick:null,defaultColor:"rgba(0,0,0,0.1)",defaultFontColor:"#666",defaultFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",defaultFontSize:12,defaultFontStyle:"normal",showLines:!0,elements:{},legendCallback:function(t){var e=[];e.push('<ul class="'+t.id+'-legend">');for(var i=0;i<t.data.datasets.length;i++)e.push('<li><span style="background-color:'+t.data.datasets[i].backgroundColor+'"></span>'),t.data.datasets[i].label&&e.push(t.data.datasets[i].label),e.push("</li>");return e.push("</ul>"),e.join("")}}},t.Chart=t,t}},{}],28:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;t.layoutService={defaults:{},addBox:function(t,e){t.boxes||(t.boxes=[]),t.boxes.push(e)},removeBox:function(t,e){t.boxes&&t.boxes.splice(t.boxes.indexOf(e),1)},update:function(t,i,a){if(t){var n=0,o=e.where(t.boxes,function(t){return"left"===t.options.position}),r=e.where(t.boxes,function(t){return"right"===t.options.position}),l=e.where(t.boxes,function(t){return"top"===t.options.position}),s=e.where(t.boxes,function(t){return"bottom"===t.options.position}),d=e.where(t.boxes,function(t){return"chartArea"===t.options.position});l.sort(function(t,e){return(e.options.fullWidth?1:0)-(t.options.fullWidth?1:0)}),s.sort(function(t,e){return(t.options.fullWidth?1:0)-(e.options.fullWidth?1:0)});var u=i-2*n,c=a-0,h=c/2,f=(i-u/2)/(o.length+r.length),g=(a-h)/(l.length+s.length),p=u,m=c,b=[];e.each(o.concat(r,l,s),function(t){var e,i=t.isHorizontal();i?(e=t.update(t.options.fullWidth?u:p,g),m-=e.height):(e=t.update(f,h),p-=e.width);b.push({horizontal:i,minSize:e,box:t})});var v=n,x=n,y=0,k=0;e.each(o.concat(r),D),e.each(o,function(t){v+=t.width}),e.each(r,function(t){x+=t.width}),e.each(l.concat(s),D),e.each(l,function(t){y+=t.height}),e.each(s,function(t){k+=t.height}),e.each(o.concat(r),function(t){var i=e.findNextWhere(b,function(e){return e.box===t}),a={left:0,right:0,top:y,bottom:k};i&&t.update(i.minSize.width,m,a)}),v=n,x=n,y=0,k=0,e.each(o,function(t){v+=t.width}),e.each(r,function(t){x+=t.width}),e.each(l,function(t){y+=t.height}),e.each(s,function(t){k+=t.height});var S=a-y-k,w=i-v-x;w===p&&S===m||(e.each(o,function(t){t.height=S}),e.each(r,function(t){t.height=S}),e.each(l,function(t){t.options.fullWidth||(t.width=w)}),e.each(s,function(t){t.options.fullWidth||(t.width=w)}),m=S,p=w);var C=n,M=0;e.each(o.concat(l),A),C+=p,M+=m,e.each(r,A),e.each(s,A),t.chartArea={left:v,top:y,right:v+p,bottom:y+m},e.each(d,function(e){e.left=t.chartArea.left,e.top=t.chartArea.top,e.right=t.chartArea.right,e.bottom=t.chartArea.bottom,e.update(p,m)})}function D(t){var i=e.findNextWhere(b,function(e){return e.box===t});if(i)if(t.isHorizontal()){var a={left:v,right:x,top:0,bottom:0};t.update(t.options.fullWidth?u:p,c/2,a)}else t.update(i.minSize.width,m)}function A(t){t.isHorizontal()?(t.left=t.options.fullWidth?n:v,t.right=t.options.fullWidth?i-n:v+p,t.top=M,t.bottom=M+t.height,M=t.bottom):(t.left=C,t.right=C+t.width,t.top=y,t.bottom=y+m,C=t.right)}}}}},{}],29:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers,i=e.noop;t.defaults.global.legend={display:!0,position:"top",fullWidth:!0,reverse:!1,onClick:function(t,e){var i=e.datasetIndex,a=this.chart,n=a.getDatasetMeta(i);n.hidden=null===n.hidden?!a.data.datasets[i].hidden:null,a.update()},labels:{boxWidth:40,padding:10,generateLabels:function(t){var i=t.data;return e.isArray(i.datasets)?i.datasets.map(function(i,a){return{text:i.label,fillStyle:e.isArray(i.backgroundColor)?i.backgroundColor[0]:i.backgroundColor,hidden:!t.isDatasetVisible(a),lineCap:i.borderCapStyle,lineDash:i.borderDash,lineDashOffset:i.borderDashOffset,lineJoin:i.borderJoinStyle,lineWidth:i.borderWidth,strokeStyle:i.borderColor,pointStyle:i.pointStyle,datasetIndex:a}},this):[]}}},t.Legend=t.Element.extend({initialize:function(t){e.extend(this,t),this.legendHitBoxes=[],this.doughnutMode=!1},beforeUpdate:i,update:function(t,e,i){var a=this;return a.beforeUpdate(),a.maxWidth=t,a.maxHeight=e,a.margins=i,a.beforeSetDimensions(),a.setDimensions(),a.afterSetDimensions(),a.beforeBuildLabels(),a.buildLabels(),a.afterBuildLabels(),a.beforeFit(),a.fit(),a.afterFit(),a.afterUpdate(),a.minSize},afterUpdate:i,beforeSetDimensions:i,setDimensions:function(){var t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height),t.paddingLeft=0,t.paddingTop=0,t.paddingRight=0,t.paddingBottom=0,t.minSize={width:0,height:0}},afterSetDimensions:i,beforeBuildLabels:i,buildLabels:function(){var t=this;t.legendItems=t.options.labels.generateLabels.call(t,t.chart),t.options.reverse&&t.legendItems.reverse()},afterBuildLabels:i,beforeFit:i,fit:function(){var i=this,a=i.options,n=a.labels,o=a.display,r=i.ctx,l=t.defaults.global,s=e.getValueOrDefault,d=s(n.fontSize,l.defaultFontSize),u=s(n.fontStyle,l.defaultFontStyle),c=s(n.fontFamily,l.defaultFontFamily),h=e.fontString(d,u,c),f=i.legendHitBoxes=[],g=i.minSize,p=i.isHorizontal();if(p?(g.width=i.maxWidth,g.height=o?10:0):(g.width=o?10:0,g.height=i.maxHeight),o)if(r.font=h,p){var m=i.lineWidths=[0],b=i.legendItems.length?d+n.padding:0;r.textAlign="left",r.textBaseline="top",e.each(i.legendItems,function(t,e){var a=(n.usePointStyle?d*Math.sqrt(2):n.boxWidth)+d/2+r.measureText(t.text).width;m[m.length-1]+a+n.padding>=i.width&&(b+=d+n.padding,m[m.length]=i.left),f[e]={left:0,top:0,width:a,height:d},m[m.length-1]+=a+n.padding}),g.height+=b}else{var v=n.padding,x=i.columnWidths=[],y=n.padding,k=0,S=0,w=d+v;e.each(i.legendItems,function(t,e){var i=(n.usePointStyle?2*n.boxWidth:n.boxWidth)+d/2+r.measureText(t.text).width;S+w>g.height&&(y+=k+n.padding,x.push(k),k=0,S=0),k=Math.max(k,i),S+=w,f[e]={left:0,top:0,width:i,height:d}}),y+=k,x.push(k),g.width+=y}i.width=g.width,i.height=g.height},afterFit:i,isHorizontal:function(){return"top"===this.options.position||"bottom"===this.options.position},draw:function(){var i=this,a=i.options,n=a.labels,o=t.defaults.global,r=o.elements.line,l=i.width,s=i.lineWidths;if(a.display){var d,u=i.ctx,c=e.getValueOrDefault,h=c(n.fontColor,o.defaultFontColor),f=c(n.fontSize,o.defaultFontSize),g=c(n.fontStyle,o.defaultFontStyle),p=c(n.fontFamily,o.defaultFontFamily),m=e.fontString(f,g,p);u.textAlign="left",u.textBaseline="top",u.lineWidth=.5,u.strokeStyle=h,u.fillStyle=h,u.font=m;var b=n.boxWidth,v=i.legendHitBoxes,x=i.isHorizontal();d=x?{x:i.left+(l-s[0])/2,y:i.top+n.padding,line:0}:{x:i.left+n.padding,y:i.top+n.padding,line:0};var y=f+n.padding;e.each(i.legendItems,function(e,h){var g=u.measureText(e.text).width,p=n.usePointStyle?f+f/2+g:b+f/2+g,m=d.x,k=d.y;x?m+p>=l&&(k=d.y+=y,d.line++,m=d.x=i.left+(l-s[d.line])/2):k+y>i.bottom&&(m=d.x=m+i.columnWidths[d.line]+n.padding,k=d.y=i.top,d.line++),function(e,i,n){if(!(isNaN(b)||b<=0)){if(u.save(),u.fillStyle=c(n.fillStyle,o.defaultColor),u.lineCap=c(n.lineCap,r.borderCapStyle),u.lineDashOffset=c(n.lineDashOffset,r.borderDashOffset),u.lineJoin=c(n.lineJoin,r.borderJoinStyle),u.lineWidth=c(n.lineWidth,r.borderWidth),u.strokeStyle=c(n.strokeStyle,o.defaultColor),u.setLineDash&&u.setLineDash(c(n.lineDash,r.borderDash)),a.labels&&a.labels.usePointStyle){var l=f*Math.SQRT2/2,s=l/Math.SQRT2,d=e+s,h=i+s;t.canvasHelpers.drawPoint(u,n.pointStyle,l,d,h)}else u.strokeRect(e,i,b,f),u.fillRect(e,i,b,f);u.restore()}}(m,k,e),v[h].left=m,v[h].top=k,function(t,e,i,a){u.fillText(i.text,b+f/2+t,e),i.hidden&&(u.beginPath(),u.lineWidth=2,u.moveTo(b+f/2+t,e+f/2),u.lineTo(b+f/2+t+a,e+f/2),u.stroke())}(m,k,e,g),x?d.x+=p+n.padding:d.y+=y})}},handleEvent:function(t){var i=this,a=e.getRelativePosition(t,i.chart.chart),n=a.x,o=a.y,r=i.options;if(n>=i.left&&n<=i.right&&o>=i.top&&o<=i.bottom)for(var l=i.legendHitBoxes,s=0;s<l.length;++s){var d=l[s];if(n>=d.left&&n<=d.left+d.width&&o>=d.top&&o<=d.top+d.height){r.onClick&&r.onClick.call(i,t,i.legendItems[s]);break}}}}),t.plugins.register({beforeInit:function(e){var i=e.options.legend;i&&(e.legend=new t.Legend({ctx:e.chart.ctx,options:i,chart:e}),t.layoutService.addBox(e,e.legend))}})}},{}],30:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers.noop;t.plugins={_plugins:[],register:function(t){var e=this._plugins;[].concat(t).forEach(function(t){-1===e.indexOf(t)&&e.push(t)})},unregister:function(t){var e=this._plugins;[].concat(t).forEach(function(t){var i=e.indexOf(t);-1!==i&&e.splice(i,1)})},clear:function(){this._plugins=[]},count:function(){return this._plugins.length},getAll:function(){return this._plugins},notify:function(t,e){var i,a,n=this._plugins,o=n.length;for(i=0;i<o;++i)if("function"==typeof(a=n[i])[t]&&!1===a[t].apply(a,e||[]))return!1;return!0}},t.PluginBase=t.Element.extend({beforeInit:e,afterInit:e,beforeUpdate:e,afterUpdate:e,beforeDraw:e,afterDraw:e,destroy:e}),t.pluginService=t.plugins}},{}],31:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;t.defaults.scale={display:!0,position:"left",gridLines:{display:!0,color:"rgba(0, 0, 0, 0.1)",lineWidth:1,drawBorder:!0,drawOnChartArea:!0,drawTicks:!0,tickMarkLength:10,zeroLineWidth:1,zeroLineColor:"rgba(0,0,0,0.25)",offsetGridLines:!1},scaleLabel:{labelString:"",display:!1},ticks:{beginAtZero:!1,minRotation:0,maxRotation:50,mirror:!1,padding:10,reverse:!1,display:!0,autoSkip:!0,autoSkipPadding:0,labelOffset:0,callback:function(t){return e.isArray(t)?t:""+t}}},t.Scale=t.Element.extend({beforeUpdate:function(){e.callCallback(this.options.beforeUpdate,[this])},update:function(t,i,a){var n=this;return n.beforeUpdate(),n.maxWidth=t,n.maxHeight=i,n.margins=e.extend({left:0,right:0,top:0,bottom:0},a),n.beforeSetDimensions(),n.setDimensions(),n.afterSetDimensions(),n.beforeDataLimits(),n.determineDataLimits(),n.afterDataLimits(),n.beforeBuildTicks(),n.buildTicks(),n.afterBuildTicks(),n.beforeTickToLabelConversion(),n.convertTicksToLabels(),n.afterTickToLabelConversion(),n.beforeCalculateTickRotation(),n.calculateTickRotation(),n.afterCalculateTickRotation(),n.beforeFit(),n.fit(),n.afterFit(),n.afterUpdate(),n.minSize},afterUpdate:function(){e.callCallback(this.options.afterUpdate,[this])},beforeSetDimensions:function(){e.callCallback(this.options.beforeSetDimensions,[this])},setDimensions:function(){var t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height),t.paddingLeft=0,t.paddingTop=0,t.paddingRight=0,t.paddingBottom=0},afterSetDimensions:function(){e.callCallback(this.options.afterSetDimensions,[this])},beforeDataLimits:function(){e.callCallback(this.options.beforeDataLimits,[this])},determineDataLimits:e.noop,afterDataLimits:function(){e.callCallback(this.options.afterDataLimits,[this])},beforeBuildTicks:function(){e.callCallback(this.options.beforeBuildTicks,[this])},buildTicks:e.noop,afterBuildTicks:function(){e.callCallback(this.options.afterBuildTicks,[this])},beforeTickToLabelConversion:function(){e.callCallback(this.options.beforeTickToLabelConversion,[this])},convertTicksToLabels:function(){var t=this;t.ticks=t.ticks.map(function(e,i,a){return t.options.ticks.userCallback?t.options.ticks.userCallback(e,i,a):t.options.ticks.callback(e,i,a)},t)},afterTickToLabelConversion:function(){e.callCallback(this.options.afterTickToLabelConversion,[this])},beforeCalculateTickRotation:function(){e.callCallback(this.options.beforeCalculateTickRotation,[this])},calculateTickRotation:function(){var i=this,a=i.ctx,n=t.defaults.global,o=i.options.ticks,r=e.getValueOrDefault(o.fontSize,n.defaultFontSize),l=e.getValueOrDefault(o.fontStyle,n.defaultFontStyle),s=e.getValueOrDefault(o.fontFamily,n.defaultFontFamily),d=e.fontString(r,l,s);a.font=d;var u,c=a.measureText(i.ticks[0]).width,h=a.measureText(i.ticks[i.ticks.length-1]).width;if(i.labelRotation=o.minRotation||0,i.paddingRight=0,i.paddingLeft=0,i.options.display&&i.isHorizontal()){i.paddingRight=h/2+3,i.paddingLeft=c/2+3,i.longestTextCache||(i.longestTextCache={});for(var f,g,p=e.longestText(a,d,i.ticks,i.longestTextCache),m=p,b=i.getPixelForTick(1)-i.getPixelForTick(0)-6;m>b&&i.labelRotation<o.maxRotation;){if(f=Math.cos(e.toRadians(i.labelRotation)),g=Math.sin(e.toRadians(i.labelRotation)),(u=f*c)+r/2>i.yLabelWidth&&(i.paddingLeft=u+r/2),i.paddingRight=r/2,g*p>i.maxHeight){i.labelRotation--;break}i.labelRotation++,m=f*p}}i.margins&&(i.paddingLeft=Math.max(i.paddingLeft-i.margins.left,0),i.paddingRight=Math.max(i.paddingRight-i.margins.right,0))},afterCalculateTickRotation:function(){e.callCallback(this.options.afterCalculateTickRotation,[this])},beforeFit:function(){e.callCallback(this.options.beforeFit,[this])},fit:function(){var i=this,a=i.minSize={width:0,height:0},n=i.options,o=t.defaults.global,r=n.ticks,l=n.scaleLabel,s=n.display,d=i.isHorizontal(),u=e.getValueOrDefault(r.fontSize,o.defaultFontSize),c=e.getValueOrDefault(r.fontStyle,o.defaultFontStyle),h=e.getValueOrDefault(r.fontFamily,o.defaultFontFamily),f=e.fontString(u,c,h),g=e.getValueOrDefault(l.fontSize,o.defaultFontSize),p=n.gridLines.tickMarkLength;if(a.width=d?i.isFullWidth()?i.maxWidth-i.margins.left-i.margins.right:i.maxWidth:s?p:0,a.height=d?s?p:0:i.maxHeight,l.display&&s&&(d?a.height+=1.5*g:a.width+=1.5*g),r.display&&s){i.longestTextCache||(i.longestTextCache={});var m=e.longestText(i.ctx,f,i.ticks,i.longestTextCache),b=e.numberOfLabelLines(i.ticks),v=.5*u;if(d){i.longestLabelWidth=m;var x=Math.sin(e.toRadians(i.labelRotation))*i.longestLabelWidth+u*b+v*b;a.height=Math.min(i.maxHeight,a.height+x),i.ctx.font=f;var y=i.ctx.measureText(i.ticks[0]).width,k=i.ctx.measureText(i.ticks[i.ticks.length-1]).width,S=Math.cos(e.toRadians(i.labelRotation)),w=Math.sin(e.toRadians(i.labelRotation));i.paddingLeft=0!==i.labelRotation?S*y+3:y/2+3,i.paddingRight=0!==i.labelRotation?w*(u/2)+3:k/2+3}else{var C=i.maxWidth-a.width;r.mirror?m=0:m+=i.options.ticks.padding,m<C?a.width+=m:a.width=i.maxWidth,i.paddingTop=u/2,i.paddingBottom=u/2}}i.margins&&(i.paddingLeft=Math.max(i.paddingLeft-i.margins.left,0),i.paddingTop=Math.max(i.paddingTop-i.margins.top,0),i.paddingRight=Math.max(i.paddingRight-i.margins.right,0),i.paddingBottom=Math.max(i.paddingBottom-i.margins.bottom,0)),i.width=a.width,i.height=a.height},afterFit:function(){e.callCallback(this.options.afterFit,[this])},isHorizontal:function(){return"top"===this.options.position||"bottom"===this.options.position},isFullWidth:function(){return this.options.fullWidth},getRightValue:function(t){return null==t?NaN:"number"==typeof t&&isNaN(t)?NaN:"object"==typeof t?t instanceof Date||t.isValid?t:this.getRightValue(this.isHorizontal()?t.x:t.y):t},getLabelForIndex:e.noop,getPixelForValue:e.noop,getValueForPixel:e.noop,getPixelForTick:function(t,e){var i=this;if(i.isHorizontal()){var a=(i.width-(i.paddingLeft+i.paddingRight))/Math.max(i.ticks.length-(i.options.gridLines.offsetGridLines?0:1),1),n=a*t+i.paddingLeft;e&&(n+=a/2);var o=i.left+Math.round(n);return o+=i.isFullWidth()?i.margins.left:0}var r=i.height-(i.paddingTop+i.paddingBottom);return i.top+t*(r/(i.ticks.length-1))},getPixelForDecimal:function(t){var e=this;if(e.isHorizontal()){var i=(e.width-(e.paddingLeft+e.paddingRight))*t+e.paddingLeft,a=e.left+Math.round(i);return a+=e.isFullWidth()?e.margins.left:0}return e.top+t*e.height},getBasePixel:function(){var t=this.min,e=this.max;return this.getPixelForValue(this.beginAtZero?0:t<0&&e<0?e:t>0&&e>0?t:0)},draw:function(i){var a=this,n=a.options;if(n.display){var o,r,l=a.ctx,s=t.defaults.global,d=n.ticks,u=n.gridLines,c=n.scaleLabel,h=0!==a.labelRotation,f=d.autoSkip,g=a.isHorizontal();d.maxTicksLimit&&(r=d.maxTicksLimit);var p=e.getValueOrDefault(d.fontColor,s.defaultFontColor),m=e.getValueOrDefault(d.fontSize,s.defaultFontSize),b=e.getValueOrDefault(d.fontStyle,s.defaultFontStyle),v=e.getValueOrDefault(d.fontFamily,s.defaultFontFamily),x=e.fontString(m,b,v),y=u.tickMarkLength,k=e.getValueOrDefault(c.fontColor,s.defaultFontColor),S=e.getValueOrDefault(c.fontSize,s.defaultFontSize),w=e.getValueOrDefault(c.fontStyle,s.defaultFontStyle),C=e.getValueOrDefault(c.fontFamily,s.defaultFontFamily),M=e.fontString(S,w,C),D=e.toRadians(a.labelRotation),A=Math.cos(D),I=a.longestLabelWidth*A;l.fillStyle=p;var T=[];if(g){if(o=!1,h&&(I/=2),(I+d.autoSkipPadding)*a.ticks.length>a.width-(a.paddingLeft+a.paddingRight)&&(o=1+Math.floor((I+d.autoSkipPadding)*a.ticks.length/(a.width-(a.paddingLeft+a.paddingRight)))),r&&a.ticks.length>r)for(;!o||a.ticks.length/(o||1)>r;)o||(o=1),o+=1;f||(o=!1)}var F="right"===n.position?a.left:a.right-y,P="right"===n.position?a.left+y:a.right,R="bottom"===n.position?a.top:a.bottom-y,_="bottom"===n.position?a.top+y:a.bottom;if(e.each(a.ticks,function(t,r){if(null!=t){var l=a.ticks.length===r+1;if((!(o>1&&r%o>0||r%o==0&&r+o>=a.ticks.length)||l)&&null!=t){var s,c,f,p,m,b,v,x,k,S,w,C;r===(void 0!==a.zeroLineIndex?a.zeroLineIndex:0)?(s=u.zeroLineWidth,c=u.zeroLineColor):(s=e.getValueAtIndexOrDefault(u.lineWidth,r),c=e.getValueAtIndexOrDefault(u.color,r));var M,A="middle";if(g){h||(A="top"===n.position?"bottom":"top"),M=h?"right":"center";var I=a.getPixelForTick(r)+e.aliasPixel(s);w=a.getPixelForTick(r,u.offsetGridLines)+d.labelOffset,C=h?a.top+12:"top"===n.position?a.bottom-y:a.top+y,f=m=v=k=I,p=R,b=_,x=i.top,S=i.bottom}else{"left"===n.position?d.mirror?(w=a.right+d.padding,M="left"):(w=a.right-d.padding,M="right"):d.mirror?(w=a.left-d.padding,M="right"):(w=a.left+d.padding,M="left");var V=a.getPixelForTick(r);V+=e.aliasPixel(s),C=a.getPixelForTick(r,u.offsetGridLines),f=F,m=P,v=i.left,k=i.right,p=b=x=S=V}T.push({tx1:f,ty1:p,tx2:m,ty2:b,x1:v,y1:x,x2:k,y2:S,labelX:w,labelY:C,glWidth:s,glColor:c,rotation:-1*D,label:t,textBaseline:A,textAlign:M})}}}),e.each(T,function(t){if(u.display&&(l.lineWidth=t.glWidth,l.strokeStyle=t.glColor,l.beginPath(),u.drawTicks&&(l.moveTo(t.tx1,t.ty1),l.lineTo(t.tx2,t.ty2)),u.drawOnChartArea&&(l.moveTo(t.x1,t.y1),l.lineTo(t.x2,t.y2)),l.stroke()),d.display){l.save(),l.translate(t.labelX,t.labelY),l.rotate(t.rotation),l.font=x,l.textBaseline=t.textBaseline,l.textAlign=t.textAlign;var i=t.label;if(e.isArray(i))for(var a=0,n=0;a<i.length;++a)l.fillText(""+i[a],0,n),n+=1.5*m;else l.fillText(i,0,0);l.restore()}}),c.display){var V,L,O=0;if(g)V=a.left+(a.right-a.left)/2,L="bottom"===n.position?a.bottom-S/2:a.top+S/2;else{var B="left"===n.position;V=B?a.left+S/2:a.right-S/2,L=a.top+(a.bottom-a.top)/2,O=B?-.5*Math.PI:.5*Math.PI}l.save(),l.translate(V,L),l.rotate(O),l.textAlign="center",l.textBaseline="middle",l.fillStyle=k,l.font=M,l.fillText(c.labelString,0,0),l.restore()}if(u.drawBorder){l.lineWidth=e.getValueAtIndexOrDefault(u.lineWidth,0),l.strokeStyle=e.getValueAtIndexOrDefault(u.color,0);var W=a.left,z=a.right,N=a.top,H=a.bottom,E=e.aliasPixel(l.lineWidth);g?(N=H="top"===n.position?a.bottom:a.top,N+=E,H+=E):(W=z="left"===n.position?a.right:a.left,W+=E,z+=E),l.beginPath(),l.moveTo(W,N),l.lineTo(z,H),l.stroke()}}}})}},{}],32:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;t.scaleService={constructors:{},defaults:{},registerScaleType:function(t,i,a){this.constructors[t]=i,this.defaults[t]=e.clone(a)},getScaleConstructor:function(t){return this.constructors.hasOwnProperty(t)?this.constructors[t]:void 0},getScaleDefaults:function(i){return this.defaults.hasOwnProperty(i)?e.scaleMerge(t.defaults.scale,this.defaults[i]):{}},updateScaleDefaults:function(t,i){var a=this.defaults;a.hasOwnProperty(t)&&(a[t]=e.extend(a[t],i))},addScalesToLayout:function(i){e.each(i.scales,function(e){t.layoutService.addBox(i,e)})}}}},{}],33:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;t.defaults.global.title={display:!1,position:"top",fullWidth:!0,fontStyle:"bold",padding:10,text:""};var i=e.noop;t.Title=t.Element.extend({initialize:function(i){e.extend(this,i),this.options=e.configMerge(t.defaults.global.title,i.options),this.legendHitBoxes=[]},beforeUpdate:function(){var i=this.chart.options;i&&i.title&&(this.options=e.configMerge(t.defaults.global.title,i.title))},update:function(t,e,i){var a=this;return a.beforeUpdate(),a.maxWidth=t,a.maxHeight=e,a.margins=i,a.beforeSetDimensions(),a.setDimensions(),a.afterSetDimensions(),a.beforeBuildLabels(),a.buildLabels(),a.afterBuildLabels(),a.beforeFit(),a.fit(),a.afterFit(),a.afterUpdate(),a.minSize},afterUpdate:i,beforeSetDimensions:i,setDimensions:function(){var t=this;t.isHorizontal()?(t.width=t.maxWidth,t.left=0,t.right=t.width):(t.height=t.maxHeight,t.top=0,t.bottom=t.height),t.paddingLeft=0,t.paddingTop=0,t.paddingRight=0,t.paddingBottom=0,t.minSize={width:0,height:0}},afterSetDimensions:i,beforeBuildLabels:i,buildLabels:i,afterBuildLabels:i,beforeFit:i,fit:function(){var i=this,a=e.getValueOrDefault,n=i.options,o=t.defaults.global,r=n.display,l=a(n.fontSize,o.defaultFontSize),s=i.minSize;i.isHorizontal()?(s.width=i.maxWidth,s.height=r?l+2*n.padding:0):(s.width=r?l+2*n.padding:0,s.height=i.maxHeight),i.width=s.width,i.height=s.height},afterFit:i,isHorizontal:function(){var t=this.options.position;return"top"===t||"bottom"===t},draw:function(){var i=this,a=i.ctx,n=e.getValueOrDefault,o=i.options,r=t.defaults.global;if(o.display){var l,s,d=n(o.fontSize,r.defaultFontSize),u=n(o.fontStyle,r.defaultFontStyle),c=n(o.fontFamily,r.defaultFontFamily),h=e.fontString(d,u,c),f=0,g=i.top,p=i.left,m=i.bottom,b=i.right;a.fillStyle=n(o.fontColor,r.defaultFontColor),a.font=h,i.isHorizontal()?(l=p+(b-p)/2,s=g+(m-g)/2):(l="left"===o.position?p+d/2:b-d/2,s=g+(m-g)/2,f=Math.PI*("left"===o.position?-.5:.5)),a.save(),a.translate(l,s),a.rotate(f),a.textAlign="center",a.textBaseline="middle",a.fillText(o.text,0,0),a.restore()}}}),t.plugins.register({beforeInit:function(e){var i=e.options.title;i&&(e.titleBlock=new t.Title({ctx:e.chart.ctx,options:i,chart:e}),t.layoutService.addBox(e,e.titleBlock))}})}},{}],34:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers;function i(t,i){return i&&(e.isArray(i)?Array.prototype.push.apply(t,i):t.push(i)),t}t.defaults.global.tooltips={enabled:!0,custom:null,mode:"single",backgroundColor:"rgba(0,0,0,0.8)",titleFontStyle:"bold",titleSpacing:2,titleMarginBottom:6,titleFontColor:"#fff",titleAlign:"left",bodySpacing:2,bodyFontColor:"#fff",bodyAlign:"left",footerFontStyle:"bold",footerSpacing:2,footerMarginTop:6,footerFontColor:"#fff",footerAlign:"left",yPadding:6,xPadding:6,yAlign:"center",xAlign:"center",caretSize:5,cornerRadius:6,multiKeyBackground:"#fff",callbacks:{beforeTitle:e.noop,title:function(t,e){var i="",a=e.labels,n=a?a.length:0;if(t.length>0){var o=t[0];o.xLabel?i=o.xLabel:n>0&&o.index<n&&(i=a[o.index])}return i},afterTitle:e.noop,beforeBody:e.noop,beforeLabel:e.noop,label:function(t,e){return(e.datasets[t.datasetIndex].label||"")+": "+t.yLabel},labelColor:function(t,e){var i=e.getDatasetMeta(t.datasetIndex).data[t.index]._view;return{borderColor:i.borderColor,backgroundColor:i.backgroundColor}},afterLabel:e.noop,afterBody:e.noop,beforeFooter:e.noop,footer:e.noop,afterFooter:e.noop}},t.Tooltip=t.Element.extend({initialize:function(){var i=t.defaults.global,a=this._options,n=e.getValueOrDefault;e.extend(this,{_model:{xPadding:a.xPadding,yPadding:a.yPadding,xAlign:a.xAlign,yAlign:a.yAlign,bodyFontColor:a.bodyFontColor,_bodyFontFamily:n(a.bodyFontFamily,i.defaultFontFamily),_bodyFontStyle:n(a.bodyFontStyle,i.defaultFontStyle),_bodyAlign:a.bodyAlign,bodyFontSize:n(a.bodyFontSize,i.defaultFontSize),bodySpacing:a.bodySpacing,titleFontColor:a.titleFontColor,_titleFontFamily:n(a.titleFontFamily,i.defaultFontFamily),_titleFontStyle:n(a.titleFontStyle,i.defaultFontStyle),titleFontSize:n(a.titleFontSize,i.defaultFontSize),_titleAlign:a.titleAlign,titleSpacing:a.titleSpacing,titleMarginBottom:a.titleMarginBottom,footerFontColor:a.footerFontColor,_footerFontFamily:n(a.footerFontFamily,i.defaultFontFamily),_footerFontStyle:n(a.footerFontStyle,i.defaultFontStyle),footerFontSize:n(a.footerFontSize,i.defaultFontSize),_footerAlign:a.footerAlign,footerSpacing:a.footerSpacing,footerMarginTop:a.footerMarginTop,caretSize:a.caretSize,cornerRadius:a.cornerRadius,backgroundColor:a.backgroundColor,opacity:0,legendColorBackground:a.multiKeyBackground}})},getTitle:function(){var t=this._options.callbacks,e=t.beforeTitle.apply(this,arguments),a=t.title.apply(this,arguments),n=t.afterTitle.apply(this,arguments),o=[];return o=i(o,e),o=i(o,a),o=i(o,n)},getBeforeBody:function(){var t=this._options.callbacks.beforeBody.apply(this,arguments);return e.isArray(t)?t:void 0!==t?[t]:[]},getBody:function(t,a){var n=this,o=n._options.callbacks,r=[];return e.each(t,function(t){var e={before:[],lines:[],after:[]};i(e.before,o.beforeLabel.call(n,t,a)),i(e.lines,o.label.call(n,t,a)),i(e.after,o.afterLabel.call(n,t,a)),r.push(e)}),r},getAfterBody:function(){var t=this._options.callbacks.afterBody.apply(this,arguments);return e.isArray(t)?t:void 0!==t?[t]:[]},getFooter:function(){var t=this._options.callbacks,e=t.beforeFooter.apply(this,arguments),a=t.footer.apply(this,arguments),n=t.afterFooter.apply(this,arguments),o=[];return o=i(o,e),o=i(o,a),o=i(o,n)},update:function(t){var i,a,n,o,r,l,s,d=this,u=d._options,c=d._model,h=d._active,f=d._data,g=d._chartInstance;if(h.length){c.opacity=1;var p=[],m=function(t){if(!t.length)return!1;var e,i,a=[],n=[];for(e=0,i=t.length;e<i;++e){var o=t[e];if(o&&o.hasValue()){var r=o.tooltipPosition();a.push(r.x),n.push(r.y)}}var l=0,s=0;for(e=0;e<a.length;++e)a[e]&&(l+=a[e],s+=n[e]);return{x:Math.round(l/a.length),y:Math.round(s/a.length)}}(h),b=[];for(i=0,a=h.length;i<a;++i)b.push((n=h[i],o=void 0,r=void 0,l=void 0,s=void 0,o=n._xScale,r=n._yScale||n._scale,l=n._index,s=n._datasetIndex,{xLabel:o?o.getLabelForIndex(l,s):"",yLabel:r?r.getLabelForIndex(l,s):"",index:l,datasetIndex:s}));u.itemSort&&(b=b.sort(u.itemSort)),h.length>1&&e.each(b,function(t){p.push(u.callbacks.labelColor.call(d,t,g))}),e.extend(c,{title:d.getTitle(b,f),beforeBody:d.getBeforeBody(b,f),body:d.getBody(b,f),afterBody:d.getAfterBody(b,f),footer:d.getFooter(b,f),x:Math.round(m.x),y:Math.round(m.y),caretPadding:e.getValueOrDefault(m.padding,2),labelColors:p});var v=d.getTooltipSize(c);d.determineAlignment(v),e.extend(c,d.getBackgroundPoint(c,v))}else d._model.opacity=0;return t&&u.custom&&u.custom.call(d,c),d},getTooltipSize:function(t){var i=this._chart.ctx,a={height:2*t.yPadding,width:0},n=t.body,o=n.reduce(function(t,e){return t+e.before.length+e.lines.length+e.after.length},0);o+=t.beforeBody.length+t.afterBody.length;var r=t.title.length,l=t.footer.length,s=t.titleFontSize,d=t.bodyFontSize,u=t.footerFontSize;a.height+=r*s,a.height+=(r-1)*t.titleSpacing,a.height+=r?t.titleMarginBottom:0,a.height+=o*d,a.height+=o?(o-1)*t.bodySpacing:0,a.height+=l?t.footerMarginTop:0,a.height+=l*u,a.height+=l?(l-1)*t.footerSpacing:0;var c=0,h=function(t){a.width=Math.max(a.width,i.measureText(t).width+c)};return i.font=e.fontString(s,t._titleFontStyle,t._titleFontFamily),e.each(t.title,h),i.font=e.fontString(d,t._bodyFontStyle,t._bodyFontFamily),e.each(t.beforeBody.concat(t.afterBody),h),c=n.length>1?d+2:0,e.each(n,function(t){e.each(t.before,h),e.each(t.lines,h),e.each(t.after,h)}),c=0,i.font=e.fontString(u,t._footerFontStyle,t._footerFontFamily),e.each(t.footer,h),a.width+=2*t.xPadding,a},determineAlignment:function(t){var e,i,a,n,o,r=this._model,l=this._chart,s=this._chartInstance.chartArea;r.y<t.height?r.yAlign="top":r.y>l.height-t.height&&(r.yAlign="bottom");var d=(s.left+s.right)/2,u=(s.top+s.bottom)/2;"center"===r.yAlign?(e=function(t){return t<=d},i=function(t){return t>d}):(e=function(e){return e<=t.width/2},i=function(e){return e>=l.width-t.width/2}),a=function(e){return e+t.width>l.width},n=function(e){return e-t.width<0},o=function(t){return t<=u?"top":"bottom"},e(r.x)?(r.xAlign="left",a(r.x)&&(r.xAlign="center",r.yAlign=o(r.y))):i(r.x)&&(r.xAlign="right",n(r.x)&&(r.xAlign="center",r.yAlign=o(r.y)))},getBackgroundPoint:function(t,e){var i={x:t.x,y:t.y},a=t.caretSize,n=t.caretPadding,o=t.cornerRadius,r=t.xAlign,l=t.yAlign,s=a+n,d=o+n;return"right"===r?i.x-=e.width:"center"===r&&(i.x-=e.width/2),"top"===l?i.y+=s:i.y-="bottom"===l?e.height+s:e.height/2,"center"===l?"left"===r?i.x+=s:"right"===r&&(i.x-=s):"left"===r?i.x-=d:"right"===r&&(i.x+=d),i},drawCaret:function(t,i,a){var n,o,r,l,s,d,u=this._view,c=this._chart.ctx,h=u.caretSize,f=u.cornerRadius,g=u.xAlign,p=u.yAlign,m=t.x,b=t.y,v=i.width,x=i.height;"center"===p?("left"===g?(o=(n=m)-h,r=n):(o=(n=m+v)+h,r=n),l=(s=b+x/2)-h,d=s+h):("left"===g?r=(o=(n=m+f)+h)+h:"right"===g?r=(o=(n=m+v-f)-h)-h:(n=(o=m+v/2)-h,r=o+h),"top"===p?(s=(l=b)-h,d=l):(s=(l=b+x)+h,d=l));var y=e.color(u.backgroundColor);c.fillStyle=y.alpha(a*y.alpha()).rgbString(),c.beginPath(),c.moveTo(n,l),c.lineTo(o,s),c.lineTo(r,d),c.closePath(),c.fill()},drawTitle:function(t,i,a,n){var o=i.title;if(o.length){a.textAlign=i._titleAlign,a.textBaseline="top";var r,l,s=i.titleFontSize,d=i.titleSpacing,u=e.color(i.titleFontColor);for(a.fillStyle=u.alpha(n*u.alpha()).rgbString(),a.font=e.fontString(s,i._titleFontStyle,i._titleFontFamily),r=0,l=o.length;r<l;++r)a.fillText(o[r],t.x,t.y),t.y+=s+d,r+1===o.length&&(t.y+=i.titleMarginBottom-d)}},drawBody:function(t,i,a,n){var o=i.bodyFontSize,r=i.bodySpacing,l=i.body;a.textAlign=i._bodyAlign,a.textBaseline="top";var s=e.color(i.bodyFontColor),d=s.alpha(n*s.alpha()).rgbString();a.fillStyle=d,a.font=e.fontString(o,i._bodyFontStyle,i._bodyFontFamily);var u=0,c=function(e){a.fillText(e,t.x+u,t.y),t.y+=o+r};e.each(i.beforeBody,c);var h=l.length>1;u=h?o+2:0,e.each(l,function(r,l){e.each(r.before,c),e.each(r.lines,function(r){h&&(a.fillStyle=e.color(i.legendColorBackground).alpha(n).rgbaString(),a.fillRect(t.x,t.y,o,o),a.strokeStyle=e.color(i.labelColors[l].borderColor).alpha(n).rgbaString(),a.strokeRect(t.x,t.y,o,o),a.fillStyle=e.color(i.labelColors[l].backgroundColor).alpha(n).rgbaString(),a.fillRect(t.x+1,t.y+1,o-2,o-2),a.fillStyle=d),c(r)}),e.each(r.after,c)}),u=0,e.each(i.afterBody,c),t.y-=r},drawFooter:function(t,i,a,n){var o=i.footer;if(o.length){t.y+=i.footerMarginTop,a.textAlign=i._footerAlign,a.textBaseline="top";var r=e.color(i.footerFontColor);a.fillStyle=r.alpha(n*r.alpha()).rgbString(),a.font=e.fontString(i.footerFontSize,i._footerFontStyle,i._footerFontFamily),e.each(o,function(e){a.fillText(e,t.x,t.y),t.y+=i.footerFontSize+i.footerSpacing})}},draw:function(){var t=this._chart.ctx,i=this._view;if(0!==i.opacity){var a=this.getTooltipSize(i),n={x:i.x,y:i.y},o=Math.abs(i.opacity<.001)?0:i.opacity;if(this._options.enabled){var r=e.color(i.backgroundColor);t.fillStyle=r.alpha(o*r.alpha()).rgbString(),e.drawRoundedRectangle(t,n.x,n.y,a.width,a.height,i.cornerRadius),t.fill(),this.drawCaret(n,a,o),n.x+=i.xPadding,n.y+=i.yPadding,this.drawTitle(n,i,t,o),this.drawBody(n,i,t,o),this.drawFooter(n,i,t,o)}}}})}},{}],35:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers,i=t.defaults.global;i.elements.arc={backgroundColor:i.defaultColor,borderColor:"#fff",borderWidth:2},t.elements.Arc=t.Element.extend({inLabelRange:function(t){var e=this._view;return!!e&&Math.pow(t-e.x,2)<Math.pow(e.radius+e.hoverRadius,2)},inRange:function(t,i){var a=this._view;if(a){for(var n=e.getAngleFromPoint(a,{x:t,y:i}),o=n.angle,r=n.distance,l=a.startAngle,s=a.endAngle;s<l;)s+=2*Math.PI;for(;o>s;)o-=2*Math.PI;for(;o<l;)o+=2*Math.PI;var d=o>=l&&o<=s,u=r>=a.innerRadius&&r<=a.outerRadius;return d&&u}return!1},tooltipPosition:function(){var t=this._view,e=t.startAngle+(t.endAngle-t.startAngle)/2,i=(t.outerRadius-t.innerRadius)/2+t.innerRadius;return{x:t.x+Math.cos(e)*i,y:t.y+Math.sin(e)*i}},draw:function(){var t=this._chart.ctx,e=this._view,i=e.startAngle,a=e.endAngle;t.beginPath(),t.arc(e.x,e.y,e.outerRadius,i,a),t.arc(e.x,e.y,e.innerRadius,a,i,!0),t.closePath(),t.strokeStyle=e.borderColor,t.lineWidth=e.borderWidth,t.fillStyle=e.backgroundColor,t.fill(),t.lineJoin="bevel",e.borderWidth&&t.stroke()}})}},{}],36:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers,i=t.defaults.global;t.defaults.global.elements.line={tension:.4,backgroundColor:i.defaultColor,borderWidth:3,borderColor:i.defaultColor,borderCapStyle:"butt",borderDash:[],borderDashOffset:0,borderJoinStyle:"miter",capBezierPoints:!0,fill:!0},t.elements.Line=t.Element.extend({draw:function(){var t=this._view,a=t.spanGaps,n=t.scaleZero,o=this._loop,r=this._chart.ctx;function l(t,e){var i=e._view;!0===e._view.steppedLine?(r.lineTo(e._view.x,t._view.y),r.lineTo(e._view.x,e._view.y)):0===e._view.tension?r.lineTo(i.x,i.y):r.bezierCurveTo(t._view.controlPointNextX,t._view.controlPointNextY,i.controlPointPreviousX,i.controlPointPreviousY,i.x,i.y)}r.save();var s,d,u,c,h=this._children.slice(),f=-1;if(o&&h.length&&h.push(h[0]),h.length&&t.fill){for(r.beginPath(),s=0;s<h.length;++s)d=h[s],u=e.previousItem(h,s),c=d._view,0===s?(o?r.moveTo(n.x,n.y):r.moveTo(c.x,n),c.skip||(f=s,r.lineTo(c.x,c.y))):(u=-1===f?u:h[f],c.skip?a||f!==s-1||(o?r.lineTo(n.x,n.y):r.lineTo(u._view.x,n)):(f!==s-1?a&&-1!==f?l(u,d):o?r.lineTo(c.x,c.y):(r.lineTo(c.x,n),r.lineTo(c.x,c.y)):l(u,d),f=s));o||r.lineTo(h[f]._view.x,n),r.fillStyle=t.backgroundColor||i.defaultColor,r.closePath(),r.fill()}var g=i.elements.line;for(r.lineCap=t.borderCapStyle||g.borderCapStyle,r.setLineDash&&r.setLineDash(t.borderDash||g.borderDash),r.lineDashOffset=t.borderDashOffset||g.borderDashOffset,r.lineJoin=t.borderJoinStyle||g.borderJoinStyle,r.lineWidth=t.borderWidth||g.borderWidth,r.strokeStyle=t.borderColor||i.defaultColor,r.beginPath(),f=-1,s=0;s<h.length;++s)d=h[s],u=e.previousItem(h,s),c=d._view,0===s?c.skip||(r.moveTo(c.x,c.y),f=s):(u=-1===f?u:h[f],c.skip||(f!==s-1&&!a||-1===f?r.moveTo(c.x,c.y):l(u,d),f=s));r.stroke(),r.restore()}})}},{}],37:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers,i=t.defaults.global,a=i.defaultColor;i.elements.point={radius:3,pointStyle:"circle",backgroundColor:a,borderWidth:1,borderColor:a,hitRadius:1,hoverRadius:4,hoverBorderWidth:1},t.elements.Point=t.Element.extend({inRange:function(t,e){var i=this._view;return!!i&&Math.pow(t-i.x,2)+Math.pow(e-i.y,2)<Math.pow(i.hitRadius+i.radius,2)},inLabelRange:function(t){var e=this._view;return!!e&&Math.pow(t-e.x,2)<Math.pow(e.radius+e.hitRadius,2)},tooltipPosition:function(){var t=this._view;return{x:t.x,y:t.y,padding:t.radius+t.borderWidth}},draw:function(){var n=this._view,o=this._chart.ctx,r=n.pointStyle,l=n.radius,s=n.x,d=n.y;n.skip||(o.strokeStyle=n.borderColor||a,o.lineWidth=e.getValueOrDefault(n.borderWidth,i.elements.point.borderWidth),o.fillStyle=n.backgroundColor||a,t.canvasHelpers.drawPoint(o,r,l,s,d))}})}},{}],38:[function(t,e,i){"use strict";e.exports=function(t){var e=t.defaults.global;e.elements.rectangle={backgroundColor:e.defaultColor,borderWidth:0,borderColor:e.defaultColor,borderSkipped:"bottom"},t.elements.Rectangle=t.Element.extend({draw:function(){var t=this._chart.ctx,e=this._view,i=e.width/2,a=e.x-i,n=e.x+i,o=e.base-(e.base-e.y),r=e.borderWidth/2;e.borderWidth&&(a+=r,n-=r,o+=r),t.beginPath(),t.fillStyle=e.backgroundColor,t.strokeStyle=e.borderColor,t.lineWidth=e.borderWidth;var l=[[a,e.base],[a,o],[n,o],[n,e.base]],s=["bottom","left","top","right"].indexOf(e.borderSkipped,0);function d(t){return l[(s+t)%4]}-1===s&&(s=0),t.moveTo.apply(t,d(0));for(var u=1;u<4;u++)t.lineTo.apply(t,d(u));t.fill(),e.borderWidth&&t.stroke()},height:function(){var t=this._view;return t.base-t.y},inRange:function(t,e){var i=this._view;return!!i&&(i.y<i.base?t>=i.x-i.width/2&&t<=i.x+i.width/2&&e>=i.y&&e<=i.base:t>=i.x-i.width/2&&t<=i.x+i.width/2&&e>=i.base&&e<=i.y)},inLabelRange:function(t){var e=this._view;return!!e&&(t>=e.x-e.width/2&&t<=e.x+e.width/2)},tooltipPosition:function(){var t=this._view;return{x:t.x,y:t.y}}})}},{}],39:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers,i=t.Scale.extend({getLabels:function(){var t=this.chart.data;return(this.isHorizontal()?t.xLabels:t.yLabels)||t.labels},determineDataLimits:function(){var t,i=this,a=i.getLabels();i.minIndex=0,i.maxIndex=a.length-1,void 0!==i.options.ticks.min&&(t=e.indexOf(a,i.options.ticks.min),i.minIndex=-1!==t?t:i.minIndex),void 0!==i.options.ticks.max&&(t=e.indexOf(a,i.options.ticks.max),i.maxIndex=-1!==t?t:i.maxIndex),i.min=a[i.minIndex],i.max=a[i.maxIndex]},buildTicks:function(){var t=this,e=t.getLabels();t.ticks=0===t.minIndex&&t.maxIndex===e.length-1?e:e.slice(t.minIndex,t.maxIndex+1)},getLabelForIndex:function(t){return this.ticks[t]},getPixelForValue:function(t,e,i,a){var n=this,o=Math.max(n.maxIndex+1-n.minIndex-(n.options.gridLines.offsetGridLines?0:1),1);if(void 0!==t){var r=n.getLabels().indexOf(t);e=-1!==r?r:e}if(n.isHorizontal()){var l=(n.width-(n.paddingLeft+n.paddingRight))/o,s=l*(e-n.minIndex)+n.paddingLeft;return n.options.gridLines.offsetGridLines&&a&&(s+=l/2),n.left+Math.round(s)}var d=(n.height-(n.paddingTop+n.paddingBottom))/o,u=d*(e-n.minIndex)+n.paddingTop;return n.options.gridLines.offsetGridLines&&a&&(u+=d/2),n.top+Math.round(u)},getPixelForTick:function(t,e){return this.getPixelForValue(this.ticks[t],t+this.minIndex,null,e)},getValueForPixel:function(t){var e=this,i=Math.max(e.ticks.length-(e.options.gridLines.offsetGridLines?0:1),1),a=e.isHorizontal(),n=(a?e.width-(e.paddingLeft+e.paddingRight):e.height-(e.paddingTop+e.paddingBottom))/i;return t-=a?e.left:e.top,e.options.gridLines.offsetGridLines&&(t-=n/2),(t-=a?e.paddingLeft:e.paddingTop)<=0?0:Math.round(t/n)},getBasePixel:function(){return this.bottom}});t.scaleService.registerScaleType("category",i,{position:"bottom"})}},{}],40:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers,i={position:"left",ticks:{callback:function(t,i,a){var n=a.length>3?a[2]-a[1]:a[1]-a[0];Math.abs(n)>1&&t!==Math.floor(t)&&(n=t-Math.floor(t));var o=e.log10(Math.abs(n)),r="";if(0!==t){var l=-1*Math.floor(o);l=Math.max(Math.min(l,20),0),r=t.toFixed(l)}else r="0";return r}}},a=t.LinearScaleBase.extend({determineDataLimits:function(){var t=this,i=t.options,a=t.chart,n=a.data.datasets,o=t.isHorizontal();function r(e){return o?e.xAxisID===t.id:e.yAxisID===t.id}if(t.min=null,t.max=null,i.stacked){var l={};e.each(n,function(n,o){var s=a.getDatasetMeta(o);void 0===l[s.type]&&(l[s.type]={positiveValues:[],negativeValues:[]});var d=l[s.type].positiveValues,u=l[s.type].negativeValues;a.isDatasetVisible(o)&&r(s)&&e.each(n.data,function(e,a){var n=+t.getRightValue(e);isNaN(n)||s.data[a].hidden||(d[a]=d[a]||0,u[a]=u[a]||0,i.relativePoints?d[a]=100:n<0?(!0,u[a]+=n):(!0,d[a]+=n))})}),e.each(l,function(i){var a=i.positiveValues.concat(i.negativeValues),n=e.min(a),o=e.max(a);t.min=null===t.min?n:Math.min(t.min,n),t.max=null===t.max?o:Math.max(t.max,o)})}else e.each(n,function(i,n){var o=a.getDatasetMeta(n);a.isDatasetVisible(n)&&r(o)&&e.each(i.data,function(e,i){var a=+t.getRightValue(e);isNaN(a)||o.data[i].hidden||(null===t.min?t.min=a:a<t.min&&(t.min=a),null===t.max?t.max=a:a>t.max&&(t.max=a))})});this.handleTickRangeOptions()},getTickLimit:function(){var i,a=this.options.ticks;if(this.isHorizontal())i=Math.min(a.maxTicksLimit?a.maxTicksLimit:11,Math.ceil(this.width/50));else{var n=e.getValueOrDefault(a.fontSize,t.defaults.global.defaultFontSize);i=Math.min(a.maxTicksLimit?a.maxTicksLimit:11,Math.ceil(this.height/(2*n)))}return i},handleDirectionalChanges:function(){this.isHorizontal()||this.ticks.reverse()},getLabelForIndex:function(t,e){return+this.getRightValue(this.chart.data.datasets[e].data[t])},getPixelForValue:function(t){var e,i,a=this,n=a.paddingLeft,o=a.paddingBottom,r=a.start,l=+a.getRightValue(t),s=a.end-r;return a.isHorizontal()?(i=a.width-(n+a.paddingRight),e=a.left+i/s*(l-r),Math.round(e+n)):(i=a.height-(a.paddingTop+o),e=a.bottom-o-i/s*(l-r),Math.round(e))},getValueForPixel:function(t){var e=this,i=e.isHorizontal(),a=e.paddingLeft,n=e.paddingBottom,o=i?e.width-(a+e.paddingRight):e.height-(e.paddingTop+n),r=(i?t-e.left-a:e.bottom-n-t)/o;return e.start+(e.end-e.start)*r},getPixelForTick:function(t){return this.getPixelForValue(this.ticksAsNumbers[t])}});t.scaleService.registerScaleType("linear",a,i)}},{}],41:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers,i=e.noop;t.LinearScaleBase=t.Scale.extend({handleTickRangeOptions:function(){var t=this,i=t.options.ticks;if(i.beginAtZero){var a=e.sign(t.min),n=e.sign(t.max);a<0&&n<0?t.max=0:a>0&&n>0&&(t.min=0)}void 0!==i.min?t.min=i.min:void 0!==i.suggestedMin&&(t.min=Math.min(t.min,i.suggestedMin)),void 0!==i.max?t.max=i.max:void 0!==i.suggestedMax&&(t.max=Math.max(t.max,i.suggestedMax)),t.min===t.max&&(t.max++,i.beginAtZero||t.min--)},getTickLimit:i,handleDirectionalChanges:i,buildTicks:function(){var t,i=this,a=i.options,n=i.ticks=[],o=a.ticks,r=e.getValueOrDefault,l=i.getTickLimit();if(l=Math.max(2,l),o.fixedStepSize&&o.fixedStepSize>0||o.stepSize&&o.stepSize>0)t=r(o.fixedStepSize,o.stepSize);else{var s=e.niceNum(i.max-i.min,!1);t=e.niceNum(s/(l-1),!0)}var d=Math.floor(i.min/t)*t,u=Math.ceil(i.max/t)*t,c=(u-d)/t;c=e.almostEquals(c,Math.round(c),t/1e3)?Math.round(c):Math.ceil(c),n.push(void 0!==o.min?o.min:d);for(var h=1;h<c;++h)n.push(d+h*t);n.push(void 0!==o.max?o.max:u),i.handleDirectionalChanges(),i.max=e.max(n),i.min=e.min(n),o.reverse?(n.reverse(),i.start=i.max,i.end=i.min):(i.start=i.min,i.end=i.max)},convertTicksToLabels:function(){var e=this;e.ticksAsNumbers=e.ticks.slice(),e.zeroLineIndex=e.ticks.indexOf(0),t.Scale.prototype.convertTicksToLabels.call(e)}})}},{}],42:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers,i={position:"left",ticks:{callback:function(t,i,a){var n=t/Math.pow(10,Math.floor(e.log10(t)));return 1===n||2===n||5===n||0===i||i===a.length-1?t.toExponential():""}}},a=t.Scale.extend({determineDataLimits:function(){var t=this,i=t.options,a=i.ticks,n=t.chart,o=n.data.datasets,r=e.getValueOrDefault,l=t.isHorizontal();function s(e){return l?e.xAxisID===t.id:e.yAxisID===t.id}if(t.min=null,t.max=null,i.stacked){var d={};e.each(o,function(a,o){var r=n.getDatasetMeta(o);n.isDatasetVisible(o)&&s(r)&&(void 0===d[r.type]&&(d[r.type]=[]),e.each(a.data,function(e,a){var n=d[r.type],o=+t.getRightValue(e);isNaN(o)||r.data[a].hidden||(n[a]=n[a]||0,i.relativePoints?n[a]=100:n[a]+=o)}))}),e.each(d,function(i){var a=e.min(i),n=e.max(i);t.min=null===t.min?a:Math.min(t.min,a),t.max=null===t.max?n:Math.max(t.max,n)})}else e.each(o,function(i,a){var o=n.getDatasetMeta(a);n.isDatasetVisible(a)&&s(o)&&e.each(i.data,function(e,i){var a=+t.getRightValue(e);isNaN(a)||o.data[i].hidden||(null===t.min?t.min=a:a<t.min&&(t.min=a),null===t.max?t.max=a:a>t.max&&(t.max=a))})});t.min=r(a.min,t.min),t.max=r(a.max,t.max),t.min===t.max&&(0!==t.min&&null!==t.min?(t.min=Math.pow(10,Math.floor(e.log10(t.min))-1),t.max=Math.pow(10,Math.floor(e.log10(t.max))+1)):(t.min=1,t.max=10))},buildTicks:function(){for(var t=this,i=t.options.ticks,a=e.getValueOrDefault,n=t.ticks=[],o=a(i.min,Math.pow(10,Math.floor(e.log10(t.min))));o<t.max;){n.push(o);var r=Math.floor(e.log10(o)),l=Math.floor(o/Math.pow(10,r))+1;10===l&&(l=1,++r),o=l*Math.pow(10,r)}var s=a(i.max,o);n.push(s),t.isHorizontal()||n.reverse(),t.max=e.max(n),t.min=e.min(n),i.reverse?(n.reverse(),t.start=t.max,t.end=t.min):(t.start=t.min,t.end=t.max)},convertTicksToLabels:function(){this.tickValues=this.ticks.slice(),t.Scale.prototype.convertTicksToLabels.call(this)},getLabelForIndex:function(t,e){return+this.getRightValue(this.chart.data.datasets[e].data[t])},getPixelForTick:function(t){return this.getPixelForValue(this.tickValues[t])},getPixelForValue:function(t){var i,a,n=this,o=n.start,r=+n.getRightValue(t),l=e.log10(n.end)-e.log10(o),s=n.paddingTop,d=n.paddingBottom,u=n.paddingLeft;return n.isHorizontal()?0===r?a=n.left+u:(i=n.width-(u+n.paddingRight),a=n.left+i/l*(e.log10(r)-e.log10(o)),a+=u):0===r?a=n.top+s:(i=n.height-(s+d),a=n.bottom-d-i/l*(e.log10(r)-e.log10(o))),a},getValueForPixel:function(t){var i,a,n=this,o=e.log10(n.end)-e.log10(n.start);return n.isHorizontal()?(a=n.width-(n.paddingLeft+n.paddingRight),i=n.start*Math.pow(10,(t-n.left-n.paddingLeft)*o/a)):(a=n.height-(n.paddingTop+n.paddingBottom),i=Math.pow(10,(n.bottom-n.paddingBottom-t)*o/a)/n.start),i}});t.scaleService.registerScaleType("logarithmic",a,i)}},{}],43:[function(t,e,i){"use strict";e.exports=function(t){var e=t.helpers,i=t.defaults.global,a=t.LinearScaleBase.extend({getValueCount:function(){return this.chart.data.labels.length},setDimensions:function(){var t=this,a=t.options,n=a.ticks;t.width=t.maxWidth,t.height=t.maxHeight,t.xCenter=Math.round(t.width/2),t.yCenter=Math.round(t.height/2);var o=e.min([t.height,t.width]),r=e.getValueOrDefault(n.fontSize,i.defaultFontSize);t.drawingArea=a.display?o/2-(r/2+n.backdropPaddingY):o/2},determineDataLimits:function(){var t=this,i=t.chart;t.min=null,t.max=null,e.each(i.data.datasets,function(a,n){if(i.isDatasetVisible(n)){var o=i.getDatasetMeta(n);e.each(a.data,function(e,i){var a=+t.getRightValue(e);isNaN(a)||o.data[i].hidden||(null===t.min?t.min=a:a<t.min&&(t.min=a),null===t.max?t.max=a:a>t.max&&(t.max=a))})}}),t.handleTickRangeOptions()},getTickLimit:function(){var t=this.options.ticks,a=e.getValueOrDefault(t.fontSize,i.defaultFontSize);return Math.min(t.maxTicksLimit?t.maxTicksLimit:11,Math.ceil(this.drawingArea/(1.5*a)))},convertTicksToLabels:function(){var e=this;t.LinearScaleBase.prototype.convertTicksToLabels.call(e),e.pointLabels=e.chart.data.labels.map(e.options.pointLabels.callback,e)},getLabelForIndex:function(t,e){return+this.getRightValue(this.chart.data.datasets[e].data[t])},fit:function(){var t,a,n,o,r,l,s,d,u,c,h,f,g=this.options.pointLabels,p=e.getValueOrDefault(g.fontSize,i.defaultFontSize),m=e.getValueOrDefault(g.fontStyle,i.defaultFontStyle),b=e.getValueOrDefault(g.fontFamily,i.defaultFontFamily),v=e.fontString(p,m,b),x=e.min([this.height/2-p-5,this.width/2]),y=this.width,k=0;for(this.ctx.font=v,a=0;a<this.getValueCount();a++){t=this.getPointPosition(a,x),n=this.ctx.measureText(this.pointLabels[a]?this.pointLabels[a]:"").width+5;var S=360*(this.getIndexAngle(a)+Math.PI/2)/(2*Math.PI)%360;0===S||180===S?(o=n/2,t.x+o>y&&(y=t.x+o,r=a),t.x-o<k&&(k=t.x-o,s=a)):S<180?t.x+n>y&&(y=t.x+n,r=a):t.x-n<k&&(k=t.x-n,s=a)}u=k,c=Math.ceil(y-this.width),l=this.getIndexAngle(r),d=this.getIndexAngle(s),h=c/Math.sin(l+Math.PI/2),f=u/Math.sin(d+Math.PI/2),h=e.isNumber(h)?h:0,f=e.isNumber(f)?f:0,this.drawingArea=Math.round(x-(f+h)/2),this.setCenterPoint(f,h)},setCenterPoint:function(t,e){var i=this,a=i.width-e-i.drawingArea,n=t+i.drawingArea;i.xCenter=Math.round((n+a)/2+i.left),i.yCenter=Math.round(i.height/2+i.top)},getIndexAngle:function(t){var e=2*Math.PI/this.getValueCount(),i=(this.chart.options&&this.chart.options.startAngle?this.chart.options.startAngle:0)*Math.PI*2/360;return t*e-Math.PI/2+i},getDistanceFromCenterForValue:function(t){var e=this;if(null===t)return 0;var i=e.drawingArea/(e.max-e.min);return e.options.reverse?(e.max-t)*i:(t-e.min)*i},getPointPosition:function(t,e){var i=this.getIndexAngle(t);return{x:Math.round(Math.cos(i)*e)+this.xCenter,y:Math.round(Math.sin(i)*e)+this.yCenter}},getPointPositionForValue:function(t,e){return this.getPointPosition(t,this.getDistanceFromCenterForValue(e))},getBasePosition:function(){var t=this.min,e=this.max;return this.getPointPositionForValue(0,this.beginAtZero?0:t<0&&e<0?e:t>0&&e>0?t:0)},draw:function(){var t=this,a=t.options,n=a.gridLines,o=a.ticks,r=a.angleLines,l=a.pointLabels,s=e.getValueOrDefault;if(a.display){var d=t.ctx,u=s(o.fontSize,i.defaultFontSize),c=s(o.fontStyle,i.defaultFontStyle),h=s(o.fontFamily,i.defaultFontFamily),f=e.fontString(u,c,h);if(e.each(t.ticks,function(r,l){if(l>0||a.reverse){var c=t.getDistanceFromCenterForValue(t.ticksAsNumbers[l]),h=t.yCenter-c;if(n.display&&0!==l)if(d.strokeStyle=e.getValueAtIndexOrDefault(n.color,l-1),d.lineWidth=e.getValueAtIndexOrDefault(n.lineWidth,l-1),a.lineArc)d.beginPath(),d.arc(t.xCenter,t.yCenter,c,0,2*Math.PI),d.closePath(),d.stroke();else{d.beginPath();for(var g=0;g<t.getValueCount();g++){var p=t.getPointPosition(g,c);0===g?d.moveTo(p.x,p.y):d.lineTo(p.x,p.y)}d.closePath(),d.stroke()}if(o.display){var m=s(o.fontColor,i.defaultFontColor);if(d.font=f,o.showLabelBackdrop){var b=d.measureText(r).width;d.fillStyle=o.backdropColor,d.fillRect(t.xCenter-b/2-o.backdropPaddingX,h-u/2-o.backdropPaddingY,b+2*o.backdropPaddingX,u+2*o.backdropPaddingY)}d.textAlign="center",d.textBaseline="middle",d.fillStyle=m,d.fillText(r,t.xCenter,h)}}}),!a.lineArc){d.lineWidth=r.lineWidth,d.strokeStyle=r.color;for(var g=t.getDistanceFromCenterForValue(a.reverse?t.min:t.max),p=s(l.fontSize,i.defaultFontSize),m=s(l.fontStyle,i.defaultFontStyle),b=s(l.fontFamily,i.defaultFontFamily),v=e.fontString(p,m,b),x=t.getValueCount()-1;x>=0;x--){if(r.display){var y=t.getPointPosition(x,g);d.beginPath(),d.moveTo(t.xCenter,t.yCenter),d.lineTo(y.x,y.y),d.stroke(),d.closePath()}var k=t.getPointPosition(x,g+5),S=s(l.fontColor,i.defaultFontColor);d.font=v,d.fillStyle=S;var w=t.pointLabels,C=360*(this.getIndexAngle(x)+Math.PI/2)/(2*Math.PI)%360;d.textAlign=0===C||180===C?"center":C<180?"left":"right",d.textBaseline=90===C||270===C?"middle":C>270||C<90?"bottom":"top",d.fillText(w[x]?w[x]:"",k.x,k.y)}}}}});t.scaleService.registerScaleType("radialLinear",a,{display:!0,animate:!0,lineArc:!1,position:"chartArea",angleLines:{display:!0,color:"rgba(0, 0, 0, 0.1)",lineWidth:1},ticks:{showLabelBackdrop:!0,backdropColor:"rgba(255,255,255,0.75)",backdropPaddingY:2,backdropPaddingX:2},pointLabels:{fontSize:10,callback:function(t){return t}}})}},{}],44:[function(t,e,i){"use strict";var a=t(1);a="function"==typeof a?a:window.moment,e.exports=function(t){var e=t.helpers,i={units:[{name:"millisecond",steps:[1,2,5,10,20,50,100,250,500]},{name:"second",steps:[1,2,5,10,30]},{name:"minute",steps:[1,2,5,10,30]},{name:"hour",steps:[1,2,3,6,12]},{name:"day",steps:[1,2,5]},{name:"week",maxStep:4},{name:"month",maxStep:3},{name:"quarter",maxStep:4},{name:"year",maxStep:!1}]},n=t.Scale.extend({initialize:function(){if(!a)throw new Error("Chart.js - Moment.js could not be found! You must include it before Chart.js to use the time scale. Download at https://momentjs.com");t.Scale.prototype.initialize.call(this)},getLabelMoment:function(t,e){return void 0!==this.labelMoments[t]?this.labelMoments[t][e]:null},getMomentStartOf:function(t){return"week"===this.options.time.unit&&!1!==this.options.time.isoWeekday?t.clone().startOf("isoWeek").isoWeekday(this.options.time.isoWeekday):t.clone().startOf(this.tickUnit)},determineDataLimits:function(){var t=this;t.labelMoments=[];var i=[];t.chart.data.labels&&t.chart.data.labels.length>0?(e.each(t.chart.data.labels,function(e){var a=t.parseTime(e);a.isValid()&&(t.options.time.round&&a.startOf(t.options.time.round),i.push(a))},t),t.firstTick=a.min.call(t,i),t.lastTick=a.max.call(t,i)):(t.firstTick=null,t.lastTick=null),e.each(t.chart.data.datasets,function(n,o){var r=[],l=t.chart.isDatasetVisible(o);"object"==typeof n.data[0]&&null!==n.data[0]?e.each(n.data,function(e){var i=t.parseTime(t.getRightValue(e));i.isValid()&&(t.options.time.round&&i.startOf(t.options.time.round),r.push(i),l&&(t.firstTick=null!==t.firstTick?a.min(t.firstTick,i):i,t.lastTick=null!==t.lastTick?a.max(t.lastTick,i):i))},t):r=i,t.labelMoments.push(r)},t),t.options.time.min&&(t.firstTick=t.parseTime(t.options.time.min)),t.options.time.max&&(t.lastTick=t.parseTime(t.options.time.max)),t.firstTick=(t.firstTick||a()).clone(),t.lastTick=(t.lastTick||a()).clone()},buildTicks:function(){var a=this;a.ctx.save();var n,o=e.getValueOrDefault(a.options.ticks.fontSize,t.defaults.global.defaultFontSize),r=e.getValueOrDefault(a.options.ticks.fontStyle,t.defaults.global.defaultFontStyle),l=e.getValueOrDefault(a.options.ticks.fontFamily,t.defaults.global.defaultFontFamily),s=e.fontString(o,r,l);if(a.ctx.font=s,a.ticks=[],a.unitScale=1,a.scaleSizeInUnits=0,a.options.time.unit)a.tickUnit=a.options.time.unit||"day",a.displayFormat=a.options.time.displayFormats[a.tickUnit],a.scaleSizeInUnits=a.lastTick.diff(a.firstTick,a.tickUnit,!0),a.unitScale=e.getValueOrDefault(a.options.time.unitStepSize,1);else{var d=a.isHorizontal()?a.width-(a.paddingLeft+a.paddingRight):a.height-(a.paddingTop+a.paddingBottom),u=a.tickFormatFunction(a.firstTick,0,[]),c=a.ctx.measureText(u).width,h=d/(c=c*Math.cos(e.toRadians(a.options.ticks.maxRotation))+o*Math.sin(e.toRadians(a.options.ticks.maxRotation)));a.tickUnit="millisecond",a.scaleSizeInUnits=a.lastTick.diff(a.firstTick,a.tickUnit,!0),a.displayFormat=a.options.time.displayFormats[a.tickUnit];for(var f=0,g=i.units[f];f<i.units.length;){if(a.unitScale=1,e.isArray(g.steps)&&Math.ceil(a.scaleSizeInUnits/h)<e.max(g.steps)){for(var p=0;p<g.steps.length;++p)if(g.steps[p]>=Math.ceil(a.scaleSizeInUnits/h)){a.unitScale=e.getValueOrDefault(a.options.time.unitStepSize,g.steps[p]);break}break}if(!1===g.maxStep||Math.ceil(a.scaleSizeInUnits/h)<g.maxStep){a.unitScale=e.getValueOrDefault(a.options.time.unitStepSize,Math.ceil(a.scaleSizeInUnits/h));break}g=i.units[++f],a.tickUnit=g.name;var m=a.firstTick.diff(a.getMomentStartOf(a.firstTick),a.tickUnit,!0),b=a.getMomentStartOf(a.lastTick.clone().add(1,a.tickUnit)).diff(a.lastTick,a.tickUnit,!0);a.scaleSizeInUnits=a.lastTick.diff(a.firstTick,a.tickUnit,!0)+m+b,a.displayFormat=a.options.time.displayFormats[g.name]}}if(a.options.time.min?n=a.getMomentStartOf(a.firstTick):(a.firstTick=a.getMomentStartOf(a.firstTick),n=a.firstTick),!a.options.time.max){var v=a.getMomentStartOf(a.lastTick),x=v.diff(a.lastTick,a.tickUnit,!0);x<0?a.lastTick=a.getMomentStartOf(a.lastTick.add(1,a.tickUnit)):x>=0&&(a.lastTick=v),a.scaleSizeInUnits=a.lastTick.diff(a.firstTick,a.tickUnit,!0)}a.smallestLabelSeparation=a.width,e.each(a.chart.data.datasets,function(t,e){for(var i=1;i<a.labelMoments[e].length;i++)a.smallestLabelSeparation=Math.min(a.smallestLabelSeparation,a.labelMoments[e][i].diff(a.labelMoments[e][i-1],a.tickUnit,!0))},a),a.options.time.displayFormat&&(a.displayFormat=a.options.time.displayFormat),a.ticks.push(a.firstTick.clone());for(var y=1;y<=a.scaleSizeInUnits;++y){var k=n.clone().add(y,a.tickUnit);if(a.options.time.max&&k.diff(a.lastTick,a.tickUnit,!0)>=0)break;y%a.unitScale==0&&a.ticks.push(k)}0===a.ticks[a.ticks.length-1].diff(a.lastTick,a.tickUnit)&&0!==a.scaleSizeInUnits||(a.options.time.max?(a.ticks.push(a.lastTick.clone()),a.scaleSizeInUnits=a.lastTick.diff(a.ticks[0],a.tickUnit,!0)):(a.ticks.push(a.lastTick.clone()),a.scaleSizeInUnits=a.lastTick.diff(a.firstTick,a.tickUnit,!0))),a.ctx.restore()},getLabelForIndex:function(t,e){var i=this,a=i.chart.data.labels&&t<i.chart.data.labels.length?i.chart.data.labels[t]:"";return"object"==typeof i.chart.data.datasets[e].data[0]&&(a=i.getRightValue(i.chart.data.datasets[e].data[t])),i.options.time.tooltipFormat&&(a=i.parseTime(a).format(i.options.time.tooltipFormat)),a},tickFormatFunction:function(t,i,a){var n=t.format(this.displayFormat),o=this.options.ticks,r=e.getValueOrDefault(o.callback,o.userCallback);return r?r(n,i,a):n},convertTicksToLabels:function(){var t=this;t.tickMoments=t.ticks,t.ticks=t.ticks.map(t.tickFormatFunction,t)},getPixelForValue:function(t,e,i){var n=this;t&&t.isValid||(t=a(n.getRightValue(t)));var o=t&&t.isValid&&t.isValid()?t:n.getLabelMoment(i,e);if(o){var r=o.diff(n.firstTick,n.tickUnit,!0),l=0!==r?r/n.scaleSizeInUnits:r;if(n.isHorizontal()){var s=(n.width-(n.paddingLeft+n.paddingRight))*l+n.paddingLeft;return n.left+Math.round(s)}var d=(n.height-(n.paddingTop+n.paddingBottom))*l+n.paddingTop;return n.top+Math.round(d)}},getPixelForTick:function(t){return this.getPixelForValue(this.tickMoments[t],null,null)},getValueForPixel:function(t){var e=this,i=e.isHorizontal()?e.width-(e.paddingLeft+e.paddingRight):e.height-(e.paddingTop+e.paddingBottom),n=(t-(e.isHorizontal()?e.left+e.paddingLeft:e.top+e.paddingTop))/i;return n*=e.scaleSizeInUnits,e.firstTick.clone().add(a.duration(n,e.tickUnit).asSeconds(),"seconds")},parseTime:function(t){var e=this;return"string"==typeof e.options.time.parser?a(t,e.options.time.parser):"function"==typeof e.options.time.parser?e.options.time.parser(t):"function"==typeof t.getMonth||"number"==typeof t?a(t):t.isValid&&t.isValid()?t:"string"!=typeof e.options.time.format&&e.options.time.format.call?(console.warn("options.time.format is deprecated and replaced by options.time.parser. See http://nnnick.github.io/Chart.js/docs-v2/#scales-time-scale"),e.options.time.format(t)):a(t,e.options.time.format)}});t.scaleService.registerScaleType("time",n,{position:"bottom",time:{parser:!1,format:!1,unit:!1,round:!1,displayFormat:!1,isoWeekday:!1,displayFormats:{millisecond:"h:mm:ss.SSS a",second:"h:mm:ss a",minute:"h:mm:ss a",hour:"MMM D, hA",day:"ll",week:"ll",month:"MMM YYYY",quarter:"[Q]Q - YYYY",year:"YYYY"}},ticks:{autoSkip:!1}})}},{1:1}]},{},[7])(7)});