<?php
header('Content-Type: application/xml; charset=utf-8');
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

require_once( 'wp-config.php' );
require_once( 'wp-load.php' );
global $wpdb; 

$result = $wpdb->get_results( "SELECT ID,STATE_NAME FROM US_STATES order by STATE_NAME", ARRAY_A );

$query = new WP_Query( array(
			'post_type'  => 'page',
			'nopaging' 	=> true,
			//'posts_per_page' => 100,
			//'offset'         => 0,
			'order' => 'ASC',
			'orderby' => 'title',
			'post_status'    => 'publish',
			'meta_key'   => '_wp_page_template',
			'meta_value' => 'page-templates/template-service.php'
		) );
		
$xml = '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">'."\n";

if(count($result) > 0)
{
	foreach($result as $row){
		$cityname = strtolower($row['STATE_NAME']);
		while ( $query->have_posts() ) : $query->the_post(); 
			$service_name= get_the_title();
		
			$url = strtolower( preg_replace('/\s+/','-',(site_url( '/us/'.$cityname."/".$service_name."/" ))));
			$xml .= '<url>'."\n";
			$xml .= '<loc>'.$url .'</loc>'."\n";
			$xml .= '<changefreq>weekly</changefreq>'."\n";
			$xml .= '<priority>0.6</priority>'."\n";
			$xml .= '</url>'."\n";	
		endwhile;
		wp_reset_postdata();
	}
}
echo $xml .= '</urlset>'."\n";die;
