<?php
/***
 * Template Name: Testimonials
 ***/
get_header();
?>
<div id="core" class="container_home_page article-template <?php if(empty(get_the_post_thumbnail()) ) { echo "no_feature";} ?>">
    <div class="main_img">
        <?php the_post_thumbnail( 'full' ); ?>
    </div>
    <?php
$menu = get_term( $locations['primary'], 'nav_menu' );
$array_menu = wp_get_nav_menu_items(2);
$menu = array();
foreach ($array_menu as $m) {
	if (empty($m->menu_item_parent)) {
		$menu[$m->ID] = array();
		$menu[$m->ID]['ID'] = $m->ID;
		$menu[$m->ID]['title'] = $m->title;
		$menu[$m->ID]['url'] = $m->url;
		$menu[$m->ID]['children'] = array();
	}
}
$submenu = array();
foreach ($array_menu as $m) {
	if ($m->menu_item_parent) {
		$submenu[$m->ID] = array();
		$submenu[$m->ID]['ID'] = $m->ID;
		$submenu[$m->ID]['title'] = $m->title;
		$submenu[$m->ID]['url'] = $m->url;
		$menu[$m->menu_item_parent]['children'][$m->ID] = $submenu[$m->ID];
	}
}
   /*echo '<pre>';
   print_r($menu);
   echo '</pre>';  */
global $wp;
$current_url = home_url(add_query_arg(array($_GET), $wp->request));
$results = searcharray($current_url."/", 'url', $menu);
function searcharray($value, $key, $array) {
   foreach ($array as $k => $val) {
	    foreach ($val['children'] as $sub_k => $sub_val) {
		   if ($sub_val[$key] == $value) {
			   return $k;
		   }
	   }
   }
   return null;
}
?>
<div class="inner-page-section2 relative">
    <div class="showall-news">View More</div>
        <div class="container page template_page">
            <div class="news-detail-bx">
        <div class="left_column">
            <span class="gen_heading">
        <?php echo $menu[$results]['title']; ?></span>
        <div class="mid-panel">
            <span class="gen_txt">Also in this section</span>
           <div class="testimonalpage">
            <ul class="submenu">
                <?php global $post;
                $parent_id = wp_get_post_parent_id( $post->ID );
                $top_parent = $post->ID;
                while( $parent_id ){
                if( $parent_id > 0 ){
                    $top_parent = $parent_id;  }
                    $parent_id = wp_get_post_parent_id( $parent_id );
                    }
                    $args = array(
                    'sort_column' => 'menu_order',
                    'sort_order' => 'asc',
                    'title_li' => '',
                    'child_of' => $top_parent,
                    'echo' => 1
                        );
                    $children = wp_list_pages($args); ?>
            </ul><!-- .sub-menu -->
        </div>
      </div>
    </div>
    <?php $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
            $args = array(
                'post_type' => 'testimonial',
                'posts_per_page' => '4',
                'post_status'=> 'publish',
            'paged' => $paged,
            );
            $count_posts = wp_count_posts( 'news' )->publish;
            $my_posts = new WP_Query( $args );?>
                <div class="right_column">
                    <h1 class="page-title"><?php the_title();?></h1>
                    <ul class="thumbnail-list">
                        <?php if ( $my_posts->have_posts() ) :?>
                        <?php while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
                            <li>
                                <figure><?php the_post_thumbnail( 'auto' );?></figure>
                                <div class="cnt">
                                    <h2><?php  echo get_the_title();?></h2>
                                    <p><?php  echo get_the_content();?></p>
                                    <h3><?php echo get_field('client_name');?></h3>
                                </div>
                        </li>
                    <?php endwhile;
                    wp_reset_query();?>
                </ul>
                <?php $page_url	=  site_url(); ?>
                <div class="pagination-bx testimonail-pagination">
                    <div class="pagination bottom">
                        <?php $total_pages = $my_posts->max_num_pages;?>
                        <?php if ($total_pages > 1){?>
                        <a class="first page button" href="<?php echo get_pagenum_link(1)?>">&laquo;</a>
                        <?php $current_page = max(1, get_query_var('paged'));
                        $image_path	= get_bloginfo('template_url');
                        echo paginate_links(array(
                        'base' => get_pagenum_link(1) . '%_%',
                        'format' => '/page/%#%',
                        'mid-size' => 2,
                        'current' => $current_page,
                        'total' => $total_pages,
                        'prev_text'    => __('<img src="'. $image_path.'/assets/images/arrow-right.svg"> Prev'),
                        'next_text'    => __('Next  <img src="'. $image_path.'/assets/images/arrow-right.svg">'),
                        ));?>
                        <a class="last page button" href="<?php echo get_pagenum_link($my_posts->max_num_pages);?>">&raquo;</a>
                        <?php }   ?>
                    </div>
                </div>
                <?php endif ; ?>
            </div>
        </div>
        </div>
   </div>
</div>
<?php get_footer();?>