<?php
/*
Template Name:Home-template
*/
?>
<?php get_header(); ?>
<link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/scrollbar/jquery.mCustomScrollbar.css" type="text/css" media="screen" />
<script src="<?php bloginfo('template_url'); ?>/scrollbar/CustomScrollbar.js" type="text/javascript"></script>
<script>
	(function($){
		$(window).load(function(){
			$(".events-scroll, .tiva-events-calendar-wrap").mCustomScrollbar({
				scrollButtons:{
					enable:true
				}
			});
		});
	})(jQuery);
</script>
<?php $page_url    =  site_url();?>
<div id="core" class="container_home_page">
<div class="home-banner">
		<div class="hero-slider">
			<?php
		        if ( have_rows('slider_images') ) {
		            while ( have_rows('slider_images') ) {
		            the_row();
		           	$slide_image = get_sub_field('slide_image'); ?>
		            <div>
		             	<img src="<?php echo esc_url($slide_image['url']); ?>" alt="<?php echo esc_attr($slide_image['name']); ?>" />
		             	<div class="slider-caption">
		             		<div class="container">
							 <div class="title"><?php the_sub_field('sub_title'); ?></div>
			             		<div class="slidedesc"><?php the_sub_field('slider_title'); ?></div>
			             		<div class="slidedesc"><?php the_sub_field('slider_tag'); ?></div>
			             	</div>
		             	</div>
		            </div>
		            <?php
		            }
		        }
		          else{
		           the_post_thumbnail( 'full' );
		        }
		      ?>
		</div>
	</div>
	<?php $show_banner =  get_field( "show_banner" );
	$bg_color =  get_field( "background_color" );
	if($show_banner=='1'){?>
	<div class="home_banner" style="background-color:<?php echo $bg_color;?>">
		<div class="container" >
		<?php $link = get_field('banner_link');?>
			<div class="inner-bx">
				<div class="cnt">
					<h3 class="common-heading"><?php echo get_field( "banner_title" );?></h3>
				</div>
				<?php if( $link ):
				$link_url = $link['url'];
				$link_title = $link['title'];
				$link_target = $link['target'] ? $link['target'] : '_self';?>
				<a class="text-link" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo $link_title;?></a>
				<?php endif;  ?>
			</div>
			</div>
		</div>
  <?php } ?>
  <div class="quick-access-section">
	<div class="container">
		<ul>
			<?php
				if( have_rows('menu_sectionss','option') ):
				while( have_rows('menu_sectionss','option') ) : the_row();
				$link = get_sub_field('name_with_links');
				$link_url = $link['url'];
				$link_title = $link['title'];
				$link_target = $link['target'] ? $link['target'] : '_self';
				$image = get_sub_field('imagess'); ?>
				<li>
					<a  href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>" title="<?php echo esc_attr( $link_title ); ?>">
						<figure><?php echo wp_get_attachment_image($image, 'thumbnail');?></figure>
						<span><?php echo esc_html( $link_title ); ?></span>
					</a>
				</li>
				<?php
				endwhile;
				endif;?>
			</ul>
		</div>
	</div><!---->
  <div class="school_description">
  	<div class="container">
  		<div class="inner-bx">
  			<div class="left-part">
  				<div class="image"><?php $image= get_field( "image" );?>
					<img src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" class="top_dots" />
				</div>
  			</div>
  			<div class="right-part">
  				<div class="content_school"><p><?php echo get_field( "content_description" );?></p></div>
  				<div class="address-btn">
				<?php $link = get_field('button');
				   if( $link ):
					$link_url = $link['url'];
					$link_title = $link['title'];
					$link_target = $link['target'] ? $link['target'] : '_self';?>
					<a href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"> <?php echo $link_title;?></a>
					<?php endif; ?>
		  			</div>
  			</div>
  		</div>
  	</div>
  </div>
 <div class="about_school">
	<div class="container">
		<div class="inner-bx">
		<div class="left-part">
	  		<div class="image"><?php $principalImage = get_field( "principal_image" );?>
		<img src="<?php echo esc_url($principalImage['url']); ?>" alt="<?php echo esc_attr($principalImage['alt']); ?>" class="top_dots" />
	</div>
 </div>
 <div class="about-left">
		<h2 class="common-heading"><?php echo get_field( "title" );?></h2>
		<p><?php echo get_field( "content" );?></p>
		<span class="gallery-btn">
			<?php $link = get_field('button_link');
			if( $link ):
				$link_url = $link['url'];
				$link_title = $link['title'];
				$link_target = $link['target'] ? $link['target'] : '_self';?>
				<a class="explore-btn" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"> <?php echo $link_title;?></a>
				<?php endif; ?>
		</span>
	</div>
  </div>
  </div>
</div>
<?php $sectionHeading = get_field('students_say_section_heading');
	$url_link = get_field('link_to_testimonail__page');?>
	<div class="students-say">
		<div class="container">
			<h2 class="common-heading"><?php echo $sectionHeading; ?></h2>
				<ul>
					<?php
						$args = array(
						'post_type' => 'testimonial',
						'posts_per_page' => '4',
						'post_status'=> 'publish',
						);
						$count_posts = wp_count_posts()->publish;
						$my_posts = new WP_Query( $args );
						 while ( $my_posts->have_posts() ) : $my_posts->the_post() ?>
							<li>
							<a href="<?php echo $url_link; ?>">
								<figure><?php the_post_thumbnail();?></figure>
										<?php $content = get_the_content(); echo '<p>'. wp_trim_words( get_the_content(), 3, '...' ) .'</p>';?>
										<div class="more"><span>More</span></div>
									</a>
							</li>
							<?php
							endwhile;
							wp_reset_postdata();?>
				 </ul>
			</div>
	</div><!---->
	<div class="achievement-section">
		<div class="container">
			<h2 class="common-heading"><?php echo get_field('achievement_section');?></h2>
			<div class="achievement-logo">
				<?php
					if( have_rows('achievement_logo') ):
					while( have_rows('achievement_logo') ) : the_row();
					$image = get_sub_field('logos'); ?>
					<div><figure><?php echo wp_get_attachment_image($image, 'auto');?></figure></div>
					<?php
					endwhile;
					endif;
				?>
			</div>
		</div>
	</div><!---->
<div class="our-activity">
<ul>
	<?php while( have_rows('learning_pages') ): the_row();
	 $learning_pages= get_sub_field('cms_pages');
	 $page_id	= $learning_pages->ID;
	 $imge_new = get_sub_field('banner_image');
	 $sub_title = get_sub_field('page_sub_title');?>
	 <li>
		<a href="<?php echo esc_url( get_page_link( $page_id ) ); ?>">
			<figure>
				<img src="<?php echo $imge_new; ?>" alt=""/>
			</figure>
			<div class="activity-title"><span><?php echo $sub_title; ?></span></div>
		</a>
	</li>
	<?php endwhile; ?>
	</ul>
</div><!---->
<div class="instagram-section">
	<div class="container">
		<?php $instgram_icon = get_field('instgram_icon');?>
			<h2 class="common-heading d-flex">
				<div class="insta-icon"><?php echo wp_get_attachment_image($instgram_icon, 'auto');?></div>
				<?php echo get_field('follow_us_on_instagram');?>
			</h2>
		<?php echo get_field('instagram_shortcode');?>
	</div>
</div><!---->
<div class="community-section">
	<div class="container">
		<h2 class="common-heading"><?php echo get_field('section_heading'); ?></h2>
			<ul id="counter">
				<?php
				if( have_rows('ccs_in_number_section') ):
					while( have_rows('ccs_in_number_section') ) : the_row();
						$heading_of_numbers = get_sub_field('heading_of_numbers');
						$numbers = get_sub_field('numbers');
				?>
				<li>
					<div class="count-bx"><div class="count" data-count="<?php echo $numbers; ?>" ></div></div>
					<span class="count-title"><?php echo $heading_of_numbers; ?></span>
				</li>
				<?php // End loop.
					endwhile;
				endif; ?>
			</ul>
		</div>
</div><!---->
<div class="register_now">
  	<div class="container">
  		<div class="inner-bx">
  			<div class="left-part">
  				<h3 class="common-heading white-color"><?php echo get_field( "text" );?></h3>
  				<p><?php echo get_field( "content_register" );?></p>
  			</div>
			<div class="right-part">
  				<div class="link_register">
				  <?php $link = get_field('link');
				   if( $link ):
				    $link_url = $link['url'];
				    $link_title = $link['title'];
				    $link_target = $link['target'] ? $link['target'] : '_self';
				    ?>
				    <a class="button" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
				   <?php endif; ?>
				</div>
  			</div>
  		</div>
  	</div>
</div>
<div class="contact_info" id="contact" style="display:none;">
   	<div class="container">
   		<div class="inner-bx">
	   		<div class="left-part">
	   			<h3 class="gen-heading">Get in Touch</h3>
	   			<div class="address-detail-bx">
	   				<ul>
	   					<li class="call">
	   						<div class="image">
	   							<img src="<?php echo bloginfo('template_url');?>/images/mobile-image.png" alt="mobile-image">
	   						</div>
							<div class="text">
	   							<h4 class="sub-heading">Call</h4>
								<p><a href="tel:<?php echo get_field('phone','option' ); ?>"><?php echo get_field('phone','option' ); ?></a></p>
	   						</div>
						</li>
						<li class="email">
	   						<div class="image">
	   							<img src="<?php echo bloginfo('template_url');?>/images/icon-pen.png" alt="icon-pen">
	   						</div>
							<div class="text">
	   							<h4 class="sub-heading">Email</h4>
								<p><a href="mailto:<?php echo get_field('email','option' ); ?>"><?php echo get_field('email','option' ); ?></a></p>
	   						</div>
	   					</li>
	   					<li class="find_us">
	   						<div class="image">
	   							<img src="<?php echo bloginfo('template_url');?>/images/icon-flag.png" alt="icon-flag">
	   						</div>
	   						<div class="text">
	   							<h4 class="sub-heading">Find us</h4>
								<p><?php echo get_field('address','option' ); ?></p>
	   						</div>
	   					</li>
					</ul>
				</div>
			</div>
			<div class="middle-part">
	   			<div class="timing-bx">
					<div class="text">
						<h4 class="sub-heading">Our School Day</h4>
						<div><?php echo get_field('opening_times','option' ); ?></div>
					</div>
				</div>
	   		</div>
	   		<div class="right-part">
	   			<div class="map">
					<?php echo get_field('google_map', 'option'); ?>
				</div>
	   		</div>
		</div>
	</div>
  </div>
</div>
<div class="clearfix"></div>
<script>
$('.home_gallery').slick({
	dots: true,
   infinite: true,
  slidesToShow: 1,
  slidesToScroll: 1,
 responsive: [
    {
      breakpoint: 768,
      settings: {
        arrows: false,
        dots: true,
   		infinite: true,
  		slidesToShow: 1,
  		slidesToScroll: 1,
      }
    },
    {
      breakpoint: 480,
      settings: {
        dots: true,
  	    infinite: true,
  		slidesToShow: 1,
  		slidesToScroll: 1,
      }
    }
  ]
});
</script>
<script>
	$('.caledar_select').on('change', function() {
		var category = $(this).find(":selected").val();
		$.ajax({
			method: "POST",
			url: "<?php echo admin_url('admin-ajax.php')?>",
			dataType: "json",
			data: {
				action: "myfilter_event",
				filter_req: category
			},
			success: function(response) {
				if(typeof response != "undefined")
					$('#events_list').html(response.html_text);
			}
		});
	});
    $('.hero-slider').slick({
    dots: false,
    infinite: false,
    fade: true,
    autoplay:true,
    arrows:true,
    speed: 900,
    slidesToShow: 1,
    slidesToScroll: 1
});
$('.achievement-logo').slick({
  slidesToShow: 6,
  arrows:true,
  responsive: [
    {
      breakpoint:1300,
      settings: {
       slidesToShow: 4
      }
    },
    {
      breakpoint: 1000,
      settings: {
       slidesToShow: 3,
      }
    },
  ]
});
</script>
<script>
var counted = 0;
$(window).scroll(function() {
var oTop = $('#counter').offset().top - window.innerHeight;
if (counted == 0 && $(window).scrollTop() > oTop) {
    $('.count').each(function() {
    var $this = $(this),
        countTo = $this.attr('data-count');
        sign = $this.attr('data-sign');
    $({
        countNum: $this.text()
    }).animate({
            countNum: countTo
        },
        {
            duration: 2000,
            easing: 'swing',
            step: function() {
              var countVal =Math.floor(this.countNum);
                $this.text(countVal.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, '$1,')) ;
            },
            complete: function() {
              $this.text(countVal.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, '$1,'));
            }
        });
});
counted = 1;
}
});
</script>
 <?php get_footer(); ?>
