<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Zigcy Lite
 */

get_header();

$zigcy_lite_archive_post_layout_sidebars = get_theme_mod('sml_single_post_layout_sidebars','right-sidebar-enabled');
?>

	<div class="container ss">
		<div class="sml-archive-wrapper <?php echo esc_attr($zigcy_lite_archive_post_layout_sidebars); ?>">
		<div id="primary" class="content-area">
			<main id="main" class="site-main">

			<?php //if ( have_posts() ) : ?>

				<?php
				/* Start the Loop */
				while ( have_posts() ) :
					the_post();
					get_template_part( 'template-parts/content', 'archive');

				endwhile;

		//	endif;
			?>

			</main><!-- #main -->
		</div><!-- #primary -->
		<div class="latest-posts">
				<h2>Latest Posts</h2>
				<ul>
				<?php

					$recentPosts= array(
						'post_type'       => 'post',
						'post_status'     => 'publish',
						'orderby'         => 'DESC',
						'posts_per_page'  => 3,

					);
					$post_query = new WP_Query($recentPosts);
					if ( $post_query->have_posts() ) :
						while($post_query->have_posts()) : $post_query->the_post(); ?>

					<li><a href="<?php the_permalink();?>">

					<?php   /* grab the url for the full size featured image */
	                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full');

					if($featured_img_url){ ?>
						<figure>
						<?php the_post_thumbnail('thumbnail'); ?>
						</figure>
						<?php } else { ?>
	                        <figure><img src="<?php echo get_stylesheet_directory_uri() ?>/assets/images/placeholder.png"></figure>
							<?php } ?>
						<h3><a href="<?php echo get_permalink( $post_query->ID ); ?>"><?php echo get_the_title(); ?></a></h3>
						<div class="name"><?php the_author()?></div>
						<div class="date"><?php echo get_the_date(); ?> • <?php display_reading_time();?></div>
					</li>
					<?php endwhile; endif; wp_reset_postdata(); ?>

				</ul>
			</div>
						</div>
	</div>

<?php
get_footer();
