<?php
defined( 'ABSPATH' ) || exit;
global $product;
if ( ! $product->is_purchasable() ) { return; }
echo wc_get_stock_html( $product ); // WPCS: XSS ok.
if ( $product->is_in_stock() ) : ?>
	<?php do_action( 'woocommerce_before_add_to_cart_form' ); ?>
		<form class="cart" action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>" method="post" enctype='multipart/form-data'>
				<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>
				<div class="product-qty number">
					<span class="minus" value="<?php echo esc_attr( $product->get_id() ); ?>" >-</span>
					<div class="total-qty">
						<span>Qty:</span>
						<?php woocommerce_quantity_input(
						array(
							'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
							'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
							'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( wp_unslash( $_POST['quantity'] ) ) : $product->get_min_purchase_quantity(),
						));?>
					</div>
					<span class="plus" value="<?php echo esc_attr( $product->get_id() ); ?>" >+</span>
				</div>
				<?php do_action( 'woocommerce_after_add_to_cart_quantity' ); ?>
				<div class="action-btn">
					<button type="submit" name="add-to-cart" value="<?php echo esc_attr( $product->get_id() ); ?>" class="single_add_to_cart_button double-arrow btn-red-outline <?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>">
						<span><?php echo esc_html( $product->single_add_to_cart_text() ); ?></span>
					</button>
					<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>
				</div>
			<?php add_social_share_buttons();?>
		</form>
	<?php do_action( 'woocommerce_after_add_to_cart_form' ); ?>
<?php endif; ?>
