<?php
  /*
   * Template name: Registration Form
   */
?>
<?php if(is_user_logged_in()){
  wp_redirect(get_permalink(get_option('woocommerce_myaccount_page_id')));
} ?>
<html <?php language_attributes(); ?> itemscope itemtype="http://schema.org/WebPage">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php
if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
}?>
	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'zigcy-lite' ); ?></a>
		<?php
		/**
        * Mobile navigation 
        */
        do_action('zigcy_lite_mob_nav');
		$zigcy_lite_header = get_theme_mod('zigcy_lite_header_type','layout1');
        /*
        * Gets header layout dynamically from customizer value
        */
        get_template_part('template-parts/header-layouts/header',$zigcy_lite_header); ?>


    </div>
    <?php 
    if( is_front_page() ){
    	do_action('zigcy_lite_slider_promo_section');
    }else{
    	zigcy_lite_header_title_display();
    }
    ?>

    <div id="content new" class="site-content">
<?php do_action( 'woocommerce_before_customer_login_form' ); ?>
<div class="container">
	
<div class="custom-registration">
	<div class=" login-bx">
<h1><?php esc_html_e( 'Register', 'woocommerce' ); ?></h1>
<p class="subtitle">please provide the mandatory details</p>

<form method="post" class="woocommerce-form woocommerce-form-register register form-section" id="register-form" <?php do_action( 'woocommerce_register_form_tag' ); ?> >

	<?php do_action( 'woocommerce_register_form_start' ); ?>

	<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

		<div class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
			
			<div class="input-bx">
					<div class="svg-icon">
						<svg xmlns="http://www.w3.org/2000/svg" width="17.627" height="17.627" viewBox="0 0 17.627 17.627">
						  <path id="Icon_awesome-user-circle" data-name="Icon awesome-user-circle" d="M8.813.563a8.813,8.813,0,1,0,8.813,8.813A8.812,8.812,0,0,0,8.813.563Zm0,3.412A3.127,3.127,0,1,1,5.686,7.1,3.127,3.127,0,0,1,8.813,3.974Zm0,12.225a6.81,6.81,0,0,1-5.206-2.424,3.962,3.962,0,0,1,3.5-2.125.87.87,0,0,1,.252.039,4.705,4.705,0,0,0,1.454.245,4.687,4.687,0,0,0,1.454-.245.87.87,0,0,1,.252-.039,3.962,3.962,0,0,1,3.5,2.125A6.81,6.81,0,0,1,8.813,16.2Z" transform="translate(0 -0.563)" fill="#b1aa1c"/>
						</svg>
					</div>
				<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" placeholder="Username*" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
			</div>
		</div>

	<?php endif; ?>

	<div class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
		<div class="input-bx">
				<div class="svg-icon">
					<svg xmlns="http://www.w3.org/2000/svg" width="16.551" height="13.241" viewBox="0 0 16.551 13.241">
				  <path id="Icon_material-email" data-name="Icon material-email" d="M17.9,6H4.655A1.653,1.653,0,0,0,3.008,7.655L3,17.586a1.66,1.66,0,0,0,1.655,1.655H17.9a1.66,1.66,0,0,0,1.655-1.655V7.655A1.66,1.66,0,0,0,17.9,6Zm0,3.31-6.62,4.138L4.655,9.31V7.655l6.62,4.138L17.9,7.655Z" transform="translate(-3 -6)" fill="#b1aa1c"/>
				</svg>
				</div>
			<input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" placeholder="Email address*" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
		</div>
	</div>

	<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

		<div class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
			<div class="input-bx">
				<div class="svg-icon">
					<svg xmlns="http://www.w3.org/2000/svg" width="16.551" height="20.229" viewBox="0 0 16.551 20.229">
				  <path id="Icon_material-security" data-name="Icon material-security" d="M12.775,1.5,4.5,5.178v5.517c0,5.1,3.531,9.875,8.275,11.034,4.745-1.159,8.275-5.931,8.275-11.034V5.178Zm0,10.105h6.436a9.843,9.843,0,0,1-6.436,8.22V11.614H6.339V6.373l6.436-2.86Z" transform="translate(-4.5 -1.5)" fill="#b1aa1c"/>
				</svg>

				</div>
				<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" placeholder="Password*" id="reg_password" autocomplete="new-password" />
				<span class="input-group-text" id="show_password">
                  <i class="fa fa-eye"></i>
                  
                </span>
			</div>
		</div>

	<?php else : ?>
		

		<p><?php esc_html_e( 'A link to set a new password will be sent to your email address.', 'woocommerce' ); ?></p>

	<?php endif; ?>

	<?php do_action( 'woocommerce_register_form' ); ?>
  
	<div class="woocommerce-form-row form-row btn-section">
		<?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
		<button type="submit" class="woocommerce-Button woocommerce-button button double-arrow btn-red<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?> woocommerce-form-register__submit" name="register" value="<?php esc_attr_e( 'Sign Up Now', 'woocommerce' ); ?>">
			Register &nbsp;&nbsp;<i class="fa fa-angle-double-right" aria-hidden="true"></i>
		</button>
	</div>

	<?php do_action( 'woocommerce_register_form_end' ); ?>
  
</form>
<div class="login-bottm">
	<p>Already have an account?</span> <a href="<?php the_permalink('9')?>" class="text-link"> Sign In</a></p>
	<p  class="by-agree">By continuing you agree to our 
		<a class="text-link" href="<?php echo site_url();?>/terms-conditions/">Terms &amp; Conditions </a> and 
		<a  class="text-link" href="<?php echo site_url(); ?>/privacy-policy/">Privacy Policy </a>.</p>
</div>
</div>
</div>
</div>
<?php do_action( 'woocommerce_after_customer_login_form' ); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/font-awesome@4.7.0/css/font-awesome.css">
<script> 
	jQuery(document).ready(function() {
	jQuery('#show_password').click(function() {
    var passwordField = jQuery('#reg_password');
    var passwordFieldType = passwordField.attr('type');
    if (passwordFieldType === 'password') {
      passwordField.attr('type', 'text');
      jQuery(this).html('<i class="fa fa-eye-slash"></i>');
    } else {
      passwordField.attr('type', 'password');
      jQuery(this).html('<i class="fa fa-eye"></i>');
    }
  });
  jQuery('#show_password2').click(function() {
    var passwordField = jQuery('#reg_password2');
    var passwordFieldType = passwordField.attr('type');
    if (passwordFieldType === 'password') {
      passwordField.attr('type', 'text');
      jQuery(this).html('<i class="fa fa-eye-slash"></i>');
    } else {
      passwordField.attr('type', 'password');
      jQuery(this).html('<i class="fa fa-eye"></i>');
    }
  });
});

</script>
<?php get_footer();?>