<?php
/**
 * Lost password form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-lost-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

do_action( 'woocommerce_before_lost_password_form' );
?>
<div class=" login-bx">
	
	<h1>Forget Password</h1>
	<p class="subtitle"><?php echo apply_filters( 'woocommerce_lost_password_message', esc_html__( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'woocommerce' ) ); ?></p>
	<form method="post" class="woocommerce-ResetPassword lost_reset_password  form-section">

		<?php // @codingStandardsIgnoreLine ?>

		<p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
			<!-- <label for="user_login"><?php //esc_html_e( 'Username or email', 'woocommerce' ); ?></label> -->
			<div class="input-bx">
				<div class="svg-icon">
					<svg xmlns="http://www.w3.org/2000/svg" width="16.551" height="13.241" viewBox="0 0 16.551 13.241">
					  <path id="Icon_material-email" data-name="Icon material-email" d="M17.9,6H4.655A1.653,1.653,0,0,0,3.008,7.655L3,17.586a1.66,1.66,0,0,0,1.655,1.655H17.9a1.66,1.66,0,0,0,1.655-1.655V7.655A1.66,1.66,0,0,0,17.9,6Zm0,3.31-6.62,4.138L4.655,9.31V7.655l6.62,4.138L17.9,7.655Z" transform="translate(-3 -6)" fill="#b1aa1c"/>
					</svg>
				</div>
				<input class="woocommerce-Input woocommerce-Input--text input-text" type="text" name="user_login" id="user_login" autocomplete="username"  placeholder="Username or email*"  />
			</div>
		</p>

		<div class="clear"></div>

		<?php do_action( 'woocommerce_lostpassword_form' ); ?>

		<p class="woocommerce-form-row form-row  btn-section">
			<input type="hidden" name="wc_reset_password" value="true" />
			<button type="submit" class="woocommerce-Button button  double-arrow btn-red<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" value="<?php esc_attr_e( 'Reset password', 'woocommerce' ); ?>"><span><?php esc_html_e( 'Reset password', 'woocommerce' ); ?></span></button>
		</p>

		<?php wp_nonce_field( 'lost_password', 'woocommerce-lost-password-nonce' ); ?>

	</form>
	<div class="login-bottm">
		<a href="<?php echo site_url(); ?>/my-account/" class="text-link"> Back To Login</a>
    </div>	
</div>
<?php
do_action( 'woocommerce_after_lost_password_form' );
