<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

do_action( 'woocommerce_before_customer_login_form' ); ?>

<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>

<div class="u-columns col2-set" id="customer_login">

	<div class=" login-bx">

	<?php endif; ?>
    
	<h1><?php esc_html_e( 'Hi, Welcome', 'woocommerce' ); ?></h1>
	<p class="subtitle">Please enter email & password to continue</p>


	<form class="woocommerce-form woocommerce-form-login login form-section" method="post" id="logins-form">

		<?php do_action( 'woocommerce_login_form_start' ); ?>

		<div class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">

			<div class="input-bx">
				<div class="svg-icon">
					<svg xmlns="http://www.w3.org/2000/svg" width="17.627" height="17.627" viewBox="0 0 17.627 17.627">
				  		<path id="Icon_awesome-user-circle" data-name="Icon awesome-user-circle" d="M8.813.563a8.813,8.813,0,1,0,8.813,8.813A8.812,8.812,0,0,0,8.813.563Zm0,3.412A3.127,3.127,0,1,1,5.686,7.1,3.127,3.127,0,0,1,8.813,3.974Zm0,12.225a6.81,6.81,0,0,1-5.206-2.424,3.962,3.962,0,0,1,3.5-2.125.87.87,0,0,1,.252.039,4.705,4.705,0,0,0,1.454.245,4.687,4.687,0,0,0,1.454-.245.87.87,0,0,1,.252-.039,3.962,3.962,0,0,1,3.5,2.125A6.81,6.81,0,0,1,8.813,16.2Z" transform="translate(0 -0.563)" fill="#b1aa1c"/>
					</svg>
				</div>
				<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="username" placeholder="Username or email address*" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" />
				<?php // @codingStandardsIgnoreLine ?>
			</div>
			
		</div>
		<div class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
			
				
				<div class="input-bx">
					<div class="svg-icon">
						<svg xmlns="http://www.w3.org/2000/svg" width="16.551" height="20.229" viewBox="0 0 16.551 20.229">
 						 <path id="Icon_material-security" data-name="Icon material-security" d="M12.775,1.5,4.5,5.178v5.517c0,5.1,3.531,9.875,8.275,11.034,4.745-1.159,8.275-5.931,8.275-11.034V5.178Zm0,10.105h6.436a9.843,9.843,0,0,1-6.436,8.22V11.614H6.339V6.373l6.436-2.86Z" transform="translate(-4.5 -1.5)" fill="#b1aa1c"/>
						</svg>

					</div>
					<input class="woocommerce-Input woocommerce-Input--text input-text" type="password" name="password" placeholder="Password*" id="password" autocomplete="current-password" />
				</div>
		</div>

		<div class="woocommerce-LostPassword lost_password">
			<a class="text-link" href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Forgot Password?', 'woocommerce' ); ?></a>
		</div>

	<?php do_action( 'woocommerce_login_form' ); ?>

	<div class="form-row btn-section">
		
		<button type="submit" class="woocommerce-button button woocommerce-form-login__submit double-arrow btn-red" name="login" value="<?php esc_attr_e( 'Log in', 'woocommerce' ); ?>">Sign In Now &nbsp;&nbsp;<i class="fa fa-angle-double-right" aria-hidden="true"></i>
</button>		
		<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>	
	</div>


	<?php do_action( 'woocommerce_login_form_end' ); ?>

	</form>
	<div class="login-bottm">
		<p>Don't have an account? <a href="<?php echo site_url(); ?>/my-account/sign-up/" class="text-link"> Sign Up</a></p>
		<p class="by-agree">By continuing you agree to our 
			<a href="<?php echo site_url(); ?>/terms-conditions/" class="text-link">Terms &amp; Conditions </a> and 
			<a href="<?php echo site_url(); ?>/privacy-policy/" class="text-link">Privacy Policy </a>.
		</p>
		<?php do_action( 'woocommerce_register_form' ); ?>
		<?php //if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>
	</div>

	</div>

	

</div>
<?php //endif; ?>

<?php do_action( 'woocommerce_after_customer_login_form' ); ?>
