<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */
defined( 'ABSPATH' ) || exit;
global $product;
do_action( 'woocommerce_before_single_product' );
if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
<?php do_action( 'woocommerce_before_single_product_summary' ); ?>
<?php $catTerms = get_the_terms( $post->ID, 'product_cat' );
		$cat_slug = $catTerms[0]->slug;?>
		<div class="summary entry-summary product-summary">
			<?php $sku= $product->get_sku();?>
					<div class="category-name"><?php echo $catTerms[0]->name;
					if($sku){ echo ' SKU : '; } echo $product->get_sku(); ?></div>
					<h1><?php the_title(); ?></h1>
					<?php global $product;
					$rating_count = $product->get_rating_count();
					$review_count = $product->get_review_count();
					$average      = $product->get_average_rating();
					if ( $rating_count >= 0 ) : ?>
						<div class="review">
							<div class="rating-star">
								<span class="star_rating"><span style="width: <?php echo ($average * 20);?>%"></span></span>
							</div>
							<a href="<?php  echo get_permalink(); ?>#tab-reviews" class="total-reviews" tabindex="0"><?php echo $review_count;?> reviews</a>
						</div>
			<?php endif;
				do_action( 'woocommerce_single_product_summary' );
			?>
		</div>
<?php do_action( 'woocommerce_after_single_product_summary' );
 do_action( 'woocommerce_after_single_product' ); ?>
