<?php
/**
 * Checkout Form
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
do_action( 'woocommerce_before_checkout_form', $checkout );
// If checkout registration is disabled and not logged in, the user cannot checkout.
if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
	echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
	return;
}
?>
<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
	<?php if ( $checkout->get_checkout_fields() ) : ?>
		<?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>
		<div class="col2-set" id="customer_details">
			<div class="col-1">
				<?php do_action( 'woocommerce_checkout_billing' ); ?>
				<?php do_action( 'woocommerce_checkout_shipping' ); ?>
			</div>
			<div class="mobile_ordersummy">
				<div class="col-2">
					<?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>
					<h3 id="order_review_heading"><?php esc_html_e( 'Order Summary', 'woocommerce' ); ?></h3>
					<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>
					<div id="order_review" class="woocommerce-checkout-review-order">
						<?php do_action( 'woocommerce_checkout_order_review' ); ?>
					</div>
					<div class="cart-totla-right">
						<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>
						<div class="total-items">
							<?php global $woocommerce;
							echo $woocommerce->cart->cart_contents_count; ?> Items
						</div>
						<div class="item-show" style="display:block">
					<?php
					do_action( 'woocommerce_review_order_before_cart_contents' );
					foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
						$_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
						if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
							?>
							<div class="cart-item">
								<span class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
									<span class="product-name">
										<?php echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) ); ?>
									</span>
								</span>
								<div class="cnt checkoutpage">
									<div class="title"><?php echo $_product->get_name();?></div>
									<div class="quantity">
										<span>
											<?php echo apply_filters( 'woocommerce_checkout_cart_item_quantity', ' <strong class="product-quantity">' . sprintf( 'Quantity&minus;&nbsp;%s', $cart_item['quantity'] ) . '</strong>', $cart_item, $cart_item_key ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
											<?php echo wc_get_formatted_cart_item_data( $cart_item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
										</span>
										<span class="product-total">
											<?php echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
										</span>
									</div>
								</div>
							</div>
							<?php
						}
					}
				do_action( 'woocommerce_review_order_after_cart_contents' );?>
		   </div>
	    </div>
			<?php
			$coupon_code_text = get_field('bank_offer_text','option');
			if(!empty($coupon_code_text)){?> <p class="cct"> <span class="applycoupon"><?php echo $coupon_code_text ;?> </span></p> <?php } ?>
			<p class="delivery-day">Items will be delivered in <strong class="lightgreen">3 - 4 working days.</strong></p>
			<p class="help-blog">Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our privacy policy.</p>
			<h3 class="accept">We Accept:</h3>
			<img src="<?php echo  get_stylesheet_directory_uri();?>/assets/images/master-card.png">
			<div class="shield-alt">
				<svg xmlns="http://www.w3.org/2000/svg" width="26.722" height="28.5" viewBox="0 0 26.722 28.5">
				<path id="Icon_awesome-shield-alt" data-name="Icon awesome-shield-alt" d="M26.2,4.66,15.516.206a2.681,2.681,0,0,0-2.054,0L2.773,4.66A2.669,2.669,0,0,0,1.125,7.126c0,11.05,6.374,18.688,12.331,21.171a2.681,2.681,0,0,0,2.054,0c4.771-1.987,12.336-8.852,12.336-21.171A2.673,2.673,0,0,0,26.2,4.66ZM14.491,24.846l-.006-21.21,9.792,4.081c-.184,8.428-4.57,14.535-9.787,17.13Z" transform="translate(-1.125 -0.002)" fill="#b0ab36"/>
				</svg>
				<span>All the payments are end to end encrypted & are 100% safe and are processed by Razorpay</span>
			</div>
		</div>
	</div>
	<?php do_action( 'woocommerce_checkout_after_customer_details' );
	endif; ?>
</div>
</form>
<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
