<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.9.0
 */

defined( 'ABSPATH' ) || exit;
?>

<?php
do_action( 'woocommerce_before_cart' ); ?>


<div class="mycart-page">
	<form class="woocommerce-cart-form" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
		<?php do_action( 'woocommerce_before_cart_table' ); ?>

		<table class="shop_table shop_table_responsive cart woocommerce-cart-form__contents" cellspacing="0">
			<thead>
				<tr>

					<th class="product-thumbnail"><span class="screen-reader-text"><?php esc_html_e( 'Thumbnail image', 'woocommerce' ); ?></span></th>
					<th class="product-name"><?php esc_html_e( 'Product', 'woocommerce' ); ?></th>
					<!-- <th class="product-price"><?php // esc_html_e( 'Price', 'woocommerce' ); ?></th>
					<th class="product-quantity"><?php // esc_html_e( 'Quantity', 'woocommerce' ); ?></th>
					<th class="product-subtotal"><?php // esc_html_e( 'Subtotal', 'woocommerce' ); ?></th> -->
					<th class="product-remove"><span class="screen-reader-text"><?php esc_html_e( 'Remove item', 'woocommerce' ); ?></span></th>
				</tr>
			</thead>
			<tbody>
				<?php do_action( 'woocommerce_before_cart_contents' ); ?>

				<?php
				foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
					$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
					$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
					/**
					 * Filter the product name.
					 *
					 * @since 2.1.0
					 * @param string $product_name Name of the product in the cart.
					 * @param array $cart_item The product in the cart.
					 * @param string $cart_item_key Key for the product in the cart.
					 */
					$product_name = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );

					if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
						$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
						?>
						<tr class="woocommerce-cart-form__cart-item <?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">



							<td class="product-thumbnail">
							<?php
							$thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

							if ( ! $product_permalink ) {
								echo $thumbnail; // PHPCS: XSS ok.
							} else {
								printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail ); // PHPCS: XSS ok.
							}
							?>
							</td>

							<td class="product-name" data-title="<?php esc_attr_e( 'Product', 'woocommerce' ); ?>">


								<div class="product-info">
									<?php $taxonomy = 'product_cat';
										$primary_cat_id=get_post_meta($cart_item['data']->get_id(),'_yoast_wpseo_primary_' . $taxonomy, true);
											if($primary_cat_id){
											$primary_cat = get_term($primary_cat_id, $taxonomy);

											if(isset($primary_cat->name))
												$catname= $primary_cat->name;
												$cat_id= $primary_cat->term_id;
											} else {

												$catname= $terms[0]->name;
												$cat_id= $terms[0]->term_id;

											} ?>

									<div class="related_category cad_bg" style="background-color:<?php the_field('category_background', 'product_cat_' . $cat_id); ?>">
									<div class="catname"><?php echo $catname;?></div>

									<?php
									if ( ! $product_permalink ) {
										echo wp_kses_post( $product_name . '&nbsp;' );
									} else {
										/**
										 * This filter is documented above.
										 *
										 * @since 2.1.0
										 */
										echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', sprintf( '<a class="product-title" href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key ) );

									}

									do_action( 'woocommerce_after_cart_item_name', $cart_item, $cart_item_key );
									//Custom ratting code
									//global $product;
									$rating_count = $_product->get_rating_count();
									$review_count = $_product->get_review_count();
									$average      = $_product->get_average_rating();

									if ( $rating_count >= 0 ) : ?>
										<div class="review">

											<div class="rating-star">
												<span class="star_rating"><span style="width: <?php echo ($average * 20);?>%"></span></span>
											</div>
											<a href="<?php  echo get_permalink(); ?>#tab-reviews" class="total-reviews" tabindex="0"><?php echo $review_count;?> reviews</a>
										</div>

							        <?php
									endif;
									// Meta data.
									echo wc_get_formatted_cart_item_data( $cart_item ); // PHPCS: XSS ok.

									// Backorder notification.
									if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) ) {
										echo wp_kses_post( apply_filters( 'woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__( 'Available on backorder', 'woocommerce' ) . '</p>', $product_id ) );
									}
									?>

										<?php //echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key ); // PHPCS: XSS ok.
										?>

									<div class="product-price">
										<?php
										echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); // PHPCS: XSS ok.
										?>

									</div>
									<!-- <div class="product-price">
                                    <del aria-hidden="true"><span class="woocommerce-Price-amount amount"><bdi><span class="woocommerce-Price-currencySymbol">$</span><?php //echo $_product->regular_price; ?></bdi></span></del>
								    </div> -->
									<div class="product-qty number">
									<div class="number">


							  <span class="minus cart" onClick="qty_minus(this)">-</span>
							  <div class="total-qty">
											<span>Qty:</span>
								<?php
								if ( $_product->is_sold_individually() ) {
									$product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
								} else {
									$product_quantity = woocommerce_quantity_input(
										array(
											'input_name'   => "cart[{$cart_item_key}][qty]",
											'input_value'  => $cart_item['quantity'],
											'max_value'    => $_product->get_max_purchase_quantity(),
											'min_value'    => '0',
											'product_name' => $_product->get_name(),
										),
										$_product,
										false
									);
								}

								echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
								?>
								</div>
								<span class="plus cart" onClick="qty_plus(this)" >+</span>



								<?php /* <span class="minus" value="<?php echo esc_attr( $_product->get_id() ); ?>" >-</span>
										<div class="total-qty">
											<span>Qty:</span>
										<?php
										if ( $_product->is_sold_individually() ) {
											$min_quantity = 1;
											$max_quantity = 1;
										} else {
											$min_quantity = 0;
											$max_quantity = $_product->get_max_purchase_quantity();
										}

										$product_quantity = woocommerce_quantity_input(
											array(
												'input_name'   => "cart[{$cart_item_key}][qty]",
												'input_value'  => $cart_item['quantity'],
												'max_value'    => $max_quantity,
												'min_value'    => $min_quantity,
												'product_name' => $product_name,
											),
											$_product,
											false
										);

										echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item ); // PHPCS: XSS ok.
										?>
										</div>
						                <span class="plus" value="<?php echo esc_attr( $_product->get_id() ); ?>" >+</span>	<?php */ ?>




							  </div>
									</div>
							</div>
							</td>

							<!---td class="product-price" data-title="<?php //esc_attr_e( 'Price', 'woocommerce' ); ?>">

							</td>

							<td class="product-quantity" data-title="<?php //esc_attr_e( 'Quantity', 'woocommerce' ); ?>">

							</td ---->

							<!-- <td class="product-subtotal" data-title="<?php // esc_attr_e( 'Subtotal', 'woocommerce' ); ?>">

							</td> -->
							<td class="removeproduct">
								<?php
									echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
										'woocommerce_cart_item_remove_link',
										sprintf(
											'<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">
												<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 48 48">
												  <g id="Rectangle_91" data-name="Rectangle 91" fill="#fff" stroke="#c8c8c8" stroke-width="1">
												    <rect width="48" height="48" stroke="none"/>
												    <rect x="0.5" y="0.5" width="47" height="47" fill="none"/>
												  </g>
												  <path id="Icon_material-close" data-name="Icon material-close" d="M20.379,8.8l-1.3-1.3-5.142,5.142L8.8,7.5,7.5,8.8l5.142,5.142L7.5,19.082l1.3,1.3,5.142-5.142,5.142,5.142,1.3-1.3-5.142-5.142Z" transform="translate(10.06 10.061)" fill="#c8c8c8"/>
												</svg>

											</a>',
											esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
											/* translators: %s is the product name */
											esc_attr( sprintf( __( 'Remove %s from cart', 'woocommerce' ), wp_strip_all_tags( $product_name ) ) ),
											esc_attr( $product_id ),
											esc_attr( $_product->get_sku() )
										),
										$cart_item_key
									);
								?>
							</td>
						</tr>
						<?php
					}
				}
				?>

				<?php do_action( 'woocommerce_cart_contents' ); ?>

				<tr style="display: none;">
					<td colspan="6" class="actions">

						<!-- <?php //if ( wc_coupons_enabled() ) { ?>
							<div class="coupon">
								<label for="coupon_code" class="screen-reader-text"><?php //esc_html_e( 'Coupon:', 'woocommerce' ); ?></label> <input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php esc_attr_e( 'Coupon code', 'woocommerce' ); ?>" /> <button type="submit" class="button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="apply_coupon" value="<?php esc_attr_e( 'Apply coupon', 'woocommerce' ); ?>"><?php esc_html_e( 'Apply coupon', 'woocommerce' ); ?></button>
								<?php //do_action( 'woocommerce_cart_coupon' ); ?>
							</div>
						<?php // } ?> -->

						<button type="submit" class="button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="update_cart" value="<?php esc_attr_e( 'Update cart', 'woocommerce' ); ?>"><?php esc_html_e( 'Update cart', 'woocommerce' ); ?></button>

						<?php do_action( 'woocommerce_cart_actions' ); ?>

						<?php wp_nonce_field( 'woocommerce-cart', 'woocommerce-cart-nonce' ); ?>
					</td>
				</tr>

				<?php do_action( 'woocommerce_after_cart_contents' ); ?>
			</tbody>
		</table>
		<?php do_action( 'woocommerce_after_cart_table' ); ?>
		<div class="cart-continue-shopping-row">
		<a class="double-arrow btn-red" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>"><span><?php _e( 'Continue Shopping', 'woocommerce' ) ?></span></a></div> <!-- cart-continue-shopping-row -->
	</form>

	<?php do_action( 'woocommerce_before_cart_collaterals' ); ?>

	<div class="cart-collaterals">
		<?php
			/**
			 * Cart collaterals hook.
			 *
			 * @hooked woocommerce_cross_sell_display
			 * @hooked woocommerce_cart_totals - 10
			 */
			do_action( 'woocommerce_cart_collaterals' );
		?>
	</div>
</div>
<?php do_action( 'woocommerce_after_cart' ); ?>
