<?php
/**
 * Cart totals
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-totals.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.3.6
 */

defined( 'ABSPATH' ) || exit;

?>

<div class="cart_totals kk <?php echo ( WC()->customer->has_calculated_shipping() ) ? 'calculated_shipping' : ''; ?>">

	<?php do_action( 'woocommerce_before_cart_totals' ); ?>

	<h2><?php esc_html_e( 'Order Summary', 'woocommerce' ); ?></h2>

	<table cellspacing="0" class="shop_table shop_table_responsive">

		<tr class="cart-subtotal">
			<th><?php esc_html_e( 'Product total', 'woocommerce' ); ?></th>
			<td data-title="<?php esc_attr_e( 'Product total', 'woocommerce' ); ?>"><?php wc_cart_totals_subtotal_html(); ?></td>
		</tr>

		<?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
			<tr class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
				<th><span class="couponcolor"><?php wc_cart_totals_coupon_label( $coupon ); ?></span></th>
				<td data-title="<?php echo esc_attr( wc_cart_totals_coupon_label( $coupon, false ) ); ?>"><?php wc_cart_totals_coupon_html( $coupon ); ?></td>
			</tr>
		<?php endforeach; ?>
		<?php do_action( 'woocommerce_cart_totals_before_order_total' ); ?>



<?php do_action( 'woocommerce_cart_totals_after_order_total' ); ?>
		<?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>

			<?php do_action( 'woocommerce_cart_totals_before_shipping' ); ?>

			<?php wc_cart_totals_shipping_html(); ?>

			<?php do_action( 'woocommerce_cart_totals_after_shipping' ); ?>

		<?php elseif ( WC()->cart->needs_shipping() && 'yes' === get_option( 'woocommerce_enable_shipping_calc' ) ) : ?>

			<tr class="shipping">
				<th><?php esc_html_e( 'Shipping', 'woocommerce' ); ?></th>
				<td data-title="<?php esc_attr_e( 'Shipping', 'woocommerce' ); ?>"><?php woocommerce_shipping_calculator(); ?></td>
			</tr>

		<?php endif; ?>

		<?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
			<tr class="fee">
				<th><?php echo esc_html( $fee->name ); ?></th>
				<td data-title="<?php echo esc_attr( $fee->name ); ?>"><?php wc_cart_totals_fee_html( $fee ); ?></td>
			</tr>
		<?php endforeach; ?>

		<?php
		if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) {
			$taxable_address = WC()->customer->get_taxable_address();
			$estimated_text  = '';

			if ( WC()->customer->is_customer_outside_base() && ! WC()->customer->has_calculated_shipping() ) {
				/* translators: %s location. */
				$estimated_text = sprintf( ' <small>' . esc_html__( '(estimated for %s)', 'woocommerce' ) . '</small>', WC()->countries->estimated_for_prefix( $taxable_address[0] ) . WC()->countries->countries[ $taxable_address[0] ] );
			}

			if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) {
				foreach ( WC()->cart->get_tax_totals() as $code => $tax ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
					?>
					<tr class="tax-rate tax-rate-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
						<th><?php echo esc_html( $tax->label ) . $estimated_text; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></th>
						<td data-title="<?php echo esc_attr( $tax->label ); ?>"><?php echo wp_kses_post( $tax->formatted_amount ); ?></td>
					</tr>
					<?php
				}
			} else {
				?>
				<tr class="tax-total">
					<th><?php echo esc_html( WC()->countries->tax_or_vat() ) . $estimated_text; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></th>
					<td data-title="<?php echo esc_attr( WC()->countries->tax_or_vat() ); ?>"><?php wc_cart_totals_taxes_total_html(); ?></td>
				</tr>
				<?php
			}
		}
		?>

<tr class="order-total">
	<th><?php esc_html_e( 'Total Order', 'woocommerce' ); ?></th>
	<td data-title="<?php esc_attr_e( 'Total Order', 'woocommerce' ); ?>"><?php wc_cart_totals_order_total_html(); ?></td>
</tr>

	</table>

				<?php //if ( wc_coupons_enabled() ) { ?>
					<!-- <div class="coupon">
						<label for="coupon_code" class="screen-reader-text"><?php //esc_html_e( 'Coupon:', 'woocommerce' ); ?></label> <input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php esc_attr_e( 'Enter Coupon Code', 'woocommerce' ); ?>" /> <button type="submit" class="double-arrow btn-red<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="apply_coupon" value="<?php esc_attr_e( 'Apply Coupon', 'woocommerce' ); ?>"><span><?php esc_html_e( 'Apply coupon', 'woocommerce' ); ?></span></button>
						<?php //do_action( 'woocommerce_cart_coupon' ); ?>
					</div> -->
				<?php //}
				 ?>

				<div class="coupon-field">
					<?php  if ( isset( $_POST['apply_coupon'] ) && empty( $_POST['coupon_code'] ) ) {
        					echo "<p class='error_coupon'>Please enter a coupon code.</p>";
       					}?>
				<form class="form-coupons" method="post">

						<input type="text" name="coupon_code" class="input-text" placeholder="<?php esc_attr_e( 'Enter Coupon code', 'woocommerce' ); ?>" id="coupon_code" value="" />

						<button type="submit" class="btn-red" name="apply_coupon" value="<?php esc_attr_e( 'Apply', 'woocommerce' ); ?>">
							<span><?php esc_html_e( 'Apply', 'woocommerce' ); ?></span>
						</button>
			</form>

		</div>
		<div class="msg_coupon green-text"><?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
			<?php wc_cart_totals_coupon_label( $coupon ); ?> successfully applied
		<?php endforeach; ?></div>
		<?php

				$coupon_code_text = get_field('bank_offer_text','option');
				if(!empty($coupon_code_text)){?> <p class="cct"> <span class="applycoupon"><?php echo $coupon_code_text ;?> </span></p> <?php } ?>

				<div class="wc-proceed-to-checkout">
					<?php do_action( 'woocommerce_proceed_to_checkout' ); ?>
				</div>
				<p class="delivery-day">Items will be delivered in <strong class="lightgreen">3 - 4 working days.</strong></p>
				<p class="help-blog">Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our privacy policy.</p>
				<h3 class="accept">We Accept:</h3>
				<img src="<?php echo  get_stylesheet_directory_uri();?>/assets/images/master-card.png">
				<div class="shield-alt">
					<svg xmlns="http://www.w3.org/2000/svg" width="26.722" height="28.5" viewBox="0 0 26.722 28.5">
					  <path id="Icon_awesome-shield-alt" data-name="Icon awesome-shield-alt" d="M26.2,4.66,15.516.206a2.681,2.681,0,0,0-2.054,0L2.773,4.66A2.669,2.669,0,0,0,1.125,7.126c0,11.05,6.374,18.688,12.331,21.171a2.681,2.681,0,0,0,2.054,0c4.771-1.987,12.336-8.852,12.336-21.171A2.673,2.673,0,0,0,26.2,4.66ZM14.491,24.846l-.006-21.21,9.792,4.081c-.184,8.428-4.57,14.535-9.787,17.13Z" transform="translate(-1.125 -0.002)" fill="#b0ab36"/>
					</svg>
					<span>All the payments are end to end encrypted & are 100% safe and are processed by Razorpay</span>
				</div>


	<?php do_action( 'woocommerce_after_cart_totals' ); ?>

</div>
