<?php
/** Template Name: Testimonials
 *  **/

get_header();

?>
<section class="testimonial-listing">
	<div class="container">
		<div class="section-heading">
			<?php $sub_title_testimonals = get_field('top_headline');
				//$headline_testimonals = get_field('headline_testimonals');?>
				<h1 class="section-title"><?php echo $sub_title_testimonals;?> </h1>

		</div>
		<div class="testimonial-inner">
			<ul div class="cnt-section">
			<?php   $paged = get_query_var("paged") ? get_query_var("paged") : 1;
            $arg = array(
					'post_type'         => 'testimonials',
					'posts_per_page'    => 5,
					'orderby'           => 'date',
					'order'             => 'DESC',
                    'post_status' => 'publish',
                    "paged" => $paged );
					$testimonials = new WP_Query($arg);

                    if($testimonials->have_posts()){?>
					<?php while($testimonials->have_posts()) : $testimonials->the_post(); ?>

					<li>
						<div class="img-box">
                        <?php $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full');
                         if($featured_img_url){ ?>
                            <?php the_post_thumbnail('testi-image-name');
                            }else { ?>
                                <img src="<?php echo get_stylesheet_directory_uri() ?>/assets/images/placeholder.png">
                        <?php } ?>
                        </div>
						<div class="cnt-box">
							<p><?php echo  get_the_content(); ?></p>
							<span class="name"><?php echo get_the_title(); ?></span>
							<span class="designation"><?php echo get_field("testimonials_desgination"); ?></span>
						</div>

					</li><!---div End--->
				<?php endwhile;

                wp_reset_query();

                 ?>
          </ul>
                 <?php $page_url	=  site_url();?>
                 <div class="store-mart-lite-archive-navigation clear">

                        <?php $total_pages = $testimonials->max_num_pages;?>
                        <?php if ($total_pages > 1){?>

                        <?php $current_page = max(1, get_query_var('paged'));

                        $image_path	= get_bloginfo('template_url');
                        echo paginate_links(array(
                        'base' => get_pagenum_link(1) . '%_%',
                        'format' => 'page/%#%',
                        'mid-size' => 2,
                        'current' => $current_page,
                        'total' => $total_pages,
                        'prev_text'    => __('<span class="prevs"> << </span>'),
                        'next_text'    => __('<span class="nexts"> >> </span>'),
                        ));?>

                        <?php }   ?>
                    </div>
                </div>
               <?php }?>
            </div>
		</div>



	</div>

</section>



<?php get_footer(); ?>