<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Zigcy Lite
 */
get_header();
$sml_archive_post_sidebar = get_theme_mod('zigcy_lite_archive_post_layout_sidebars','right-sidebar-enabled');
?>
	<div class="container">
		<div class="sml-archive-wrapper blog-page <?php echo esc_attr($sml_archive_post_sidebar); ?>">
			<div id="primary" class="content-area">
				<div id="main" class="site-main">
					<div class="page-header">
						<div class="lft">
							<h1 class="page-title"><?php single_post_title(); ?></h1>
						</div>
						<div class="rgt">
							<div class="blog-search"><?php echo do_shortcode('[ivory-search id="308" title="Custom Search Form"]'); ?></div>
							<div id="sortby">
								<select class="dropdown-class" name="sort-posts" id="sortbox" onchange="document.location.search=this.options[this.selectedIndex].value;">
									<option disabled>Sort by</option>
									<option <?php if( isset($_GET["orderby"]) && trim($_GET["orderby"]) == 'date' && isset($_GET["order"]) && trim($_GET["order"]) == 'DESC' ){ echo 'selected'; } ?> value="?orderby=date&order=DESC">Newest</option>
									<option <?php if( isset($_GET["orderby"]) && trim($_GET["orderby"]) == 'date' && isset($_GET["order"]) && trim($_GET["order"]) == 'ASC' ){ echo 'selected'; } ?>  value="?orderby=date&order=ASC">Oldest</option>
								</select>
							</div>
						</div>
					</div><!--- page header End--->
<div class="listing-blog">
					<div class="blog-list">
						<?php
						if ( have_posts() ) :
							if ( is_home() && ! is_front_page() ) :
								?>
								<header>
									<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
								</header>
								<?php
							endif;
							/* Start the Loop */
							while ( have_posts() ) :
								the_post();
								/*
								 * Include the Post-Type-specific template for the content.
								 * If you want to override this in a child theme, then include a file
								 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
								 */
								get_template_part( 'template-parts/content', 'archive' );
							endwhile;
?>
</div>
<?php
							zigcy_lite_numeric_posts_nav();
						else :
							get_template_part( 'template-parts/content', 'none' );
						endif;
						?>
					</div><!-- blog list End -->
				</main><!-- #main -->
			</div><!-- #primary -->
		<?php
        // sidebar options
        // $archive_sidebar_explode  =  (explode("-",$sml_archive_post_sidebar));
        // $archive_sidebar          = $archive_sidebar_explode[0];
        // if( $archive_sidebar == 'both'){
        //     get_sidebar('left');
        //     get_sidebar('right');
        // }elseif( $archive_sidebar != 'no'){
        //     get_sidebar( $archive_sidebar );
        // }
        // ?>
</div>
			<div class="latest-posts">
				<h2>Latest Posts</h2>
				<ul>
				<?php
					$recentPosts= array(
						'post_type'       => 'post',
						'post_status'     => 'publish',
						'orderby'         => 'DESC',
						'posts_per_page'  => 3,
					);
					$post_query = new WP_Query($recentPosts);
					if ( $post_query->have_posts() ) :
						while($post_query->have_posts()) : $post_query->the_post(); ?>
					<li><a href="<?php the_permalink();?>">
					<?php   /* grab the url for the full size featured image */
	                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full');
					if($featured_img_url){ ?>
						<figure>
						<?php the_post_thumbnail(); ?>
						</figure>
						<?php } else { ?>
	                        <figure><img src="<?php echo get_stylesheet_directory_uri() ?>/assets/images/placeholder.png"></figure>
							<?php } ?>
						<h3><a href="<?php echo get_permalink( $post_query->ID ); ?>"><?php echo get_the_title(); ?></a></h3>
						<div class="name"> By <?php the_author()?></div>
						<div class="date"><?php echo get_the_date(); ?> • <?php display_reading_time();?></div>
					</li>
					<?php endwhile; endif; wp_reset_postdata(); ?>
				</ul>
			</div>
		</div>
	</div>
<?php
get_footer();
