<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Zigcy Lite
 */

get_header();
$single_sidebars = get_theme_mod('sml_single_post_layout_sidebars','right-sidebar-enabled');

?>
	<div class="container">
		<div class="sml-single-post-wrapper blog-page <?php echo esc_attr($single_sidebars); ?>">
			<div id="primary" class="content-area">
				<main id="main" class="site-main">

				<?php
				while ( have_posts() ) :
					the_post();

					get_template_part( 'template-parts/content', 'single' );

					//the_post_navigation();

				endwhile; // End of the loop.
				?>

				</main><!-- #main -->
			</div><!-- #primary -->

		<div class="latest-posts">
				<h2>Latest Posts</h2>
				<ul>
				<?php

					$recentPosts= array(
						'post_type'       => 'post',
						'post_status'     => 'publish',
						'orderby'         => 'DESC',
						'posts_per_page'  => 3,

					);
					$post_query = new WP_Query($recentPosts);
					if ( $post_query->have_posts() ) :
						while($post_query->have_posts()) : $post_query->the_post(); ?>

					<li><a href="<?php the_permalink();?>">

					<?php   /* grab the url for the full size featured image */
	                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full');

					if($featured_img_url){ ?>
						<figure>
						<?php the_post_thumbnail(); ?>
						</figure>
						<?php } else { ?>
	                        <figure><img src="<?php echo get_stylesheet_directory_uri() ?>/assets/images/placeholder.png"></figure>
							<?php } ?>
						<h3><a href="<?php echo get_permalink( $post_query->ID ); ?>"><?php echo get_the_title(); ?></a></h3>
						<div class="name"> By <?php the_author()?></div>
						<div class="date"><?php echo get_the_date(); ?> • <?php display_reading_time();?></div>
					</li>
					<?php endwhile; endif; wp_reset_postdata(); ?>

				</ul>
			</div>
	</div>
	</div>


<?php
//get_sidebar();
get_footer();
