<?php
/**
 * Template Name: Home New Template
 *
 */
get_header();
// Check value exists.
if( have_rows('homepage_section') ):
	while ( have_rows('homepage_section') ) : the_row();
	if( get_row_layout() == 'top_silder' ):?>
		<section class="home-slider">
			<div class="hero-slider">
				<?php if (have_rows('silder')) {
						while (have_rows('silder')): the_row();
							$slider_images = get_sub_field('slider_image');
							$slider_content = get_sub_field('slider_content');
							$slider_button_link = get_sub_field('slider_button_link');
							 ?>
							<div>
								<div class="slider-box">
									<div class="cnt-bx">
										<?php echo $slider_content;?>
										<div>
											<?php
											if ($slider_button_link):
												$slider_url = $slider_button_link['url'];
												$slider_title = $slider_button_link['title'];
												$slider_target = $slider_button_link['target'] ? $slider_button_link['target'] : '_self';?>
											<a class="btn-red double-arrow" href="<?php echo esc_url($slider_url); ?>" target="<?php echo esc_attr($slider_target); ?>">
												<span> <?php echo esc_html($slider_title); ?> </span>
											</a>
												<?php endif;?>
										</div>
									</div>
									<div class="img-bx">
										<?php $size = 'full';
										if ($slider_images) {
											echo wp_get_attachment_image($slider_images, $size);
										}?>
									</div>
								</div><!--slider-box End-->
							</div><!---->
					<?php endwhile;
					}?>
			</div><!---->
		</section><!---->
	<?php endif;
	if( get_row_layout() == 'most_popular_catagory' ):
		global $wp_query; ?>
		<section class="top-category pb">
			<div class="container">
				<div class="category-carousel">
					<?php if(have_rows('popular_main_categories')) :
							while (have_rows('popular_main_categories')): the_row();
								$term_main = get_sub_field('most_select_catageroy');
								$image = get_field('home_icon_silder',$term_main);
								$cat_color= get_field('background_color',$term_main); ?>
								<div>
									<a href="<?php echo get_category_link($term_main->term_id); ?>" class="category-bx" <?php if(!empty($cat_color)){ ?> style="background-color:<?php echo $cat_color;?>" <?php } else {  ?> style="background-color: #b9b9b9;" <?php } ?>>
										<div class="lft-bx">
											<?php
											if($image){
											echo '<img src="'.$image['url'].'" alt="" />';
											}else { ?>
												<img src="<?php echo get_stylesheet_directory_uri() ?>/assets/images/placeholdercat.png">
											<?php } ?>
										</div>
										<div class="rgt-bx">
											<h3><?php echo $term_main->name; ?></h3>
											<span class="viewmore">View more</span>
										</div>
									</a>
								</div>
						<?php endwhile; endif; ?>
				</div>
			</div>
		</section><!---->
<?php endif;
if( get_row_layout() == 'latest_herbal_products' ): ?>
	<section class="latest-product pb">
		<div class="container">
			<?php $latest_product = get_sub_field('title');
					$sub_title = get_sub_field('sub_title');
					$shortcode = get_sub_field('shortcodenew');?>
						<div class="section-heading">
							<h1 class="section-title"><?php echo $latest_product; ?></h1>
							<p class="sub-title"><?php echo $sub_title; ?></p>
						</div>
						<div class="product-list mobile-silder">
							<?php echo $shortcode; ?>
						</div>
				<div class="align-center mt">
				<a href="<?php echo site_url();?>/shop" class="btn-red-outline double-arrow d-flex btn-big"><span>View more</span></a>
			</div>
		</div>
	</section><!---->
<?php endif;
if( get_row_layout() == 'title_with_shortcode' ): ?>
	<section class="categories-product pb">
		<div class="container">
			<?php $title = get_sub_field('title');
				  $shortcode_code = get_sub_field('shortcode_product'); ?>
					<div class="section-heading">
						<h2 class="section-title"><?php echo $title; ?></h2>
					</div>
					<div class="product-list ">
						<?php echo $shortcode_code; ?>
					</div>
		</div>
	</section><!---->
<?php endif;
if( get_row_layout() == 'checkout_our_popular_sub_categories' ): ?>
	<section class="sub-categorie container pb">
		<div class="section-heading">
			<?php $title_cat = get_sub_field('title_sub_cat');?>
					<h2 class="section-title"><?php echo $title_cat; ?></h2>
		</div>
		<ul class="popular-category">
			<?php if(have_rows('popular_sub_categories')) :
					while (have_rows('popular_sub_categories')): the_row();
					$term = get_sub_field('select_categories');
					if ($term ):
					global $wp_query;?>
				<li>
					<a href="<?php echo get_category_link($term->term_id); ?>">
						<?php $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);
							$image = wp_get_attachment_url($thumbnail_id);
							if (!empty($image)): ?>
								<figure><img src="<?php echo $image; ?>"></figure>
							<?php else: ?>
							<figure><img src="<?php echo get_stylesheet_directory_uri() ?>/assets/images/placeholder.png"></figure>
						<?php endif?>
						<h3><?php echo esc_html($term->name); ?></h3>
						<?php echo "<h4>" . $term->count . ' Products </h4>'; ?>
					</a>
				</li>
			<?php  endif; endwhile;  ?>
			</ul>
		<?php endif;?>
	</section><!---->
<?php
endif;
if( get_row_layout() == 'banner_with_paragraph' ): ?>
	<section class="nature-purity">
		<div class="container">
			<div class="section-heading">
				<?php $title = get_sub_field('title_top');
						$sub_title = get_sub_field('title_bottom');?>
					<h4><?php echo $title; ?></h4>
					<h2 class="section-title"><?php echo $sub_title; ?></h2>
			</div>
		</div>
	</section>
<?php $healing_banner = get_sub_field('background_image');?>
		<section class="healing-banner">
			<div class="container">
				<div class="banner-inner">
					<div class="banner-lft">
						<?php $size = 'single-post-thumbnail';
						if ($healing_banner) { echo wp_get_attachment_image($healing_banner, $size); } ?>
					</div>
					<div class="cnt-bx">
						<?php $sub_title = get_sub_field('sub_title');
							$title = get_sub_field('title');
							$paragraph = get_sub_field('paragraph');
							$button_link = get_sub_field('button_link'); ?>
						<h3><?php echo $sub_title; ?></h3>
						<h2><?php echo $title; ?></h2>
						<?php echo '<p>'.$paragraph. '</p>';
						 if ($button_link):
							$button_url = $button_link['url'];
							$button_title = $button_link['title'];
							$button_target = $button_link['target'] ? $button_link['target'] : '_self'; ?>
							<a class="btn-red double-arrow " href="<?php echo esc_url($button_url); ?>" target="<?php echo esc_attr($button_target); ?>">
									<span> <?php echo esc_html($button_title); ?> </span>
							</a>
						<?php endif;?>
					</div>
				</div><!------>
			</div>
		</section><!--healing-banner--->
<?php endif;
if( get_row_layout() == 'testimonails' ): ?>
<!-- Testimonail-->
<?php $sub_title_testimonals = get_sub_field('sub_title_testimonals');
		$headline_testimonals = get_sub_field('headline_testimonals');
		if($sub_title_testimonals || $headline_testimonals ){ 	?>
<section class="customers-say pb testimonial-section">
	<div class="container">
		<div class="section-heading">
		<?php if($sub_title_testimonals){?>	<h4><?php echo $sub_title_testimonals;?> </h4><?php }?>
		<?php if($headline_testimonals){?>	<h2 class="section-title"><?php echo $headline_testimonals; ?></h2><?php }?>
		</div>
		<ul>
			<?php  $arg = array(
				'post_type'         => 'testimonials',
				'posts_per_page'    => 3,
				'orderby'           => 'date',
				'order'             => 'DESC' );
				$testimonials = new WP_Query($arg); ?>
				<?php while($testimonials->have_posts()) : $testimonials->the_post(); ?>
				<li>
					<div class="img-box">
					<?php    $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'full');
					 if($featured_img_url){ ?>
						<?php the_post_thumbnail('testi-image-name');
						}else { ?>
							<img src="<?php echo get_stylesheet_directory_uri() ?>/assets/images/placeholder.png">
						<?php } ?>
						</div>
					<div class="cnt-box">
						<?php $content = get_the_content();
					if($content){	echo'<p>'. mb_strimwidth($content, 0, 150, '...').'</p>'; }?>
						<span class="name"><?php echo get_the_title(); ?></span>
						<span class="designation"><?php echo get_field("testimonials_desgination"); ?></span>
					</div>
				</li><!---li End--->
			<?php endwhile; wp_reset_query(); ?>
		</ul>
		<?php $button_testi = get_sub_field('see_more');
			if ($button_testi):
				$butto_url = $button_testi['url'];
				$butto_title = $button_testi['title'];
				$butto_target = $button_testi['target'] ? $button_testi['target'] : '_self'; ?>
				<div class="align-center">
					<a class="btn-red double-arrow d-flex" href="<?php echo esc_url($butto_url); ?>" target="<?php echo esc_attr($butto_target); ?>">
						<span> <?php echo esc_html($butto_title); ?> </span>
					</a>
				</div>
		<?php endif;?>
	</div>
</section><!-- end Testimonail-->
<?php }?>
<?php
endif;
if( get_row_layout() == 'blog_section' ): ?>
<section class="container pb">
	<div class="section-heading">
		<?php $sub_title = get_sub_field('sub_title');
				$title = get_sub_field('title'); ?>
		<h4><?php echo $sub_title; ?></h4>
		<h2 class="section-title"><?php echo $title; ?></h2>
	</div>
	<div class="home-blog">
		<div class="lft-box">
			<?php
				$postgn= array(
					'post_type' => 'post',
					'post_status' => 'publish',
					'orderby' => 'DESC',
					'posts_per_page'    => 3,
				);
				$post_query = new WP_Query($postgn);
				if ( $post_query->have_posts() ) :
					$counter = 0;
					while($post_query->have_posts()) : $post_query->the_post();
					$counter++;
					if($counter == 1 ){?>
					<div class="lft">
						<a href="<?php the_permalink();?>">
							<?php $thumb = get_the_post_thumbnail_url(get_the_ID(),'full');
								if($thumb){
									echo '<div class="blog-img"><figure>';  the_post_thumbnail(); echo '</figure></div>';
								}else { ?>
									<div class="blog-img"><figure><img src="<?php echo get_stylesheet_directory_uri() ?>/assets/images/placeholder.png"></figure> </div>
								<?php } ?>
								<h2><?php the_title();?></h2>
								<p><?php echo substr(strip_tags($post->post_content), 0, 60); ?> ... </p>
								<div class="name"> By <?php the_author()?></div>
								<div class="date"><?php echo get_the_date(); ?>  <?php display_reading_time();?></div>
						</a>
				</div>
				<div class="rgt">
				<?php } else{    if($counter==2){?>
						<div class="blog-rgt">
							<?php }?>
							<a href="<?php the_permalink();?>">
								<div class="blog-list">
									<?php $thumb = get_the_post_thumbnail_url(get_the_ID(),'full');
									if($thumb){
										echo '<div class="blog-img"><figure>';  the_post_thumbnail(); echo '</figure></div>';
										}else { ?>
											<div class="blog-img"><figure><img src="<?php echo get_stylesheet_directory_uri() ?>/assets/images/placeholder.png"></figure>
										</div><?php } ?>
										<div class="blog-cnt">
											<h2><?php the_title();?></h2>
											<p><?php echo substr(strip_tags($post->post_content), 0, 60); ?> ... </p>
											<div class="name"> By <?php the_author()?></div>
											<div class="date"><?php echo get_the_date(); ?>  <?php display_reading_time();?></div>
										</div>
								</div><!---->
				 			</a>
						<?php 	if($counter>2){?> </div><!--rgt End--> <?php }
						}
				endwhile;
				wp_reset_postdata();
			else:
				echo "No Blogs found";
			endif;
				$button_link = get_sub_field('buttonurl');
				if ($button_link):
					$button_url = $button_link['url'];
					$button_title = $button_link['title'];
					$button_target = $button_link['target'] ? $button_link['target'] : '_self'; ?>
					<div class="align-center">
						<a class="btn-red double-arrow" href="<?php echo esc_url($button_url); ?>" target="<?php echo esc_attr($button_target); ?>">
							<span> <?php echo esc_html($button_title); ?> </span>
						</a>
					</div>
					<?php endif;?>
		</div>
	</div>
	<div class="rgt-box">
		<h3>Trending</h3>
		<ul class="trending-list">
			<?php
				$postquey= array(
					'post_type' => 'post',
					'post_status' => 'publish',
					'orderby' => 'DESC',
					'posts_per_page'    => 3,
					'orderby' => 'rand'
				);
				$posttrading= new WP_Query($postquey);
				if ( $posttrading->have_posts() ) :
					$counter = 0;
					while($posttrading->have_posts()) : $posttrading->the_post();
					$counter++; ?>
				<li>
					<a href="<?php the_permalink();?>">
						<div class="trending-count"><?php echo $counter; ?>.</div>
						<div class="trending-cnt">
							<h4><?php the_title();?></h4>
							<div class="date"><?php echo get_the_date(); ?> • <?php display_reading_time();?></div>
						</div>
					</a>
				</li>
				<?php endwhile;
				wp_reset_postdata();
				endif;?>
		</ul>
	</div>
</div><!---container--->
</section><!--home-blog End--->
<?php
endif;
/*****/
endwhile;
endif;?>
<?php
session_start();
if( !isset($_SESSION['visited']) ){ // visited has never been set, so set it and show the popup
$_SESSION['visited'] = true; // visited has never been set, so set it and show the popup
?>
<div id="subscribe-popup" class=" modal showpopup">
	<div class="modal-content NEWPOPUP">
		<span class="close btnclose">
			<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21">
			<path id="Icon_material-close" data-name="Icon material-close" d="M28.5,9.615,26.385,7.5,18,15.885,9.615,7.5,7.5,9.615,15.885,18,7.5,26.385,9.615,28.5,18,20.115,26.385,28.5,28.5,26.385,20.115,18Z" transform="translate(-7.5 -7.5)"/>
			</svg>
		</span>
		<div class="modal-body">
			<div class="subscribe-popup">
				<div class="lft-bx">
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/subscribe-bg.jpg">
				</div>
				<div class="rgt-bx">
					<!-- <span>Something healthier is coming!!</span> -->
					<?php if(have_rows('popup_content', 'option')) :
							while(have_rows('popup_content', 'option')): the_row();?>
							<h4><?php echo get_sub_field('top_headline');?></h4>
							<p><?php echo get_sub_field('paragraph');?></p>
							<?php echo get_sub_field('shortcode_popup');?>
						 <?php endwhile;  endif; ?>
					<!-- <div class="align-center"> *<a href="<?php //echo get_permalink(101); ?>" target="_blank" class="text-link">Terms & Conditions</a> apply</div> -->
				</div>
			</div>
		</div>
	</div>
</div>
<?php }
get_footer();