<?php
/**
 * Recommended way to include parent theme styles.
 * (Please see http://codex.wordpress.org/Child_Themes#How_to_Create_a_Child_Theme)
 *
 */
add_theme_support( 'responsive-embeds' );
add_action( 'wp_enqueue_scripts', 'zigcy_lite_child_style' );
function zigcy_lite_child_style() {
	wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array('parent-style') );
	wp_enqueue_style( 'fonts-style', get_stylesheet_directory_uri() . '/assets/css/fonts.css');
	wp_enqueue_style( 'easy-responsive-style', get_stylesheet_directory_uri() . '/assets/css/easy-responsive-tabs.css');
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/assets/css/slick.css');
    wp_enqueue_style( 'select2-style', get_stylesheet_directory_uri() . '/assets/css/select2.css');
}
add_action( 'wp_enqueue_scripts', 'zigcy_lite_child_script' );
function zigcy_lite_child_script() {
wp_enqueue_script( 'slick.js', get_stylesheet_directory_uri() . '/assets/js/slick.js');
wp_enqueue_script( 'easy-responsive.js', get_stylesheet_directory_uri() . '/assets/js/easy-responsive-tabs.js');
wp_enqueue_script( 'script.js', get_stylesheet_directory_uri() . '/assets/js/select2.min.js');
wp_enqueue_script( 'script.js', get_stylesheet_directory_uri() . '/assets/js/script.js');
wp_enqueue_script( 'script.js', get_stylesheet_directory_uri() . '/assets/js/jquery.validate.min.js');
wp_enqueue_script( 'script.js', get_stylesheet_directory_uri() . '/assets/js/custom.js');
}
function responsive_child_enqueue_scripts() {
    wp_dequeue_style( 'responsive' );
    wp_enqueue_style( 'responsive-style', get_stylesheet_directory_uri() . '/assets/css/responsive.css',);
    wp_dequeue_style( 'style' );
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/assets/css/style.css');
}
add_action( 'wp_enqueue_scripts', 'responsive_child_enqueue_scripts', 11 );
register_nav_menus( array(
	'top-menu' => esc_html__( 'Top Menu', 'zigcy-lite' )
) );
if ( function_exists( 'acf_add_options_page' ) ) {
	acf_add_options_page( 'Global Settings' );
}
add_image_size('blog-list', '446', '264', true);
add_image_size('single-post-thumbnail', '446', '264', true);
function custom_product_list_shortcode($atts) {
    $atts = shortcode_atts( array(
        'categories' => '',
        'limit' => '',
    ), $atts, 'product_list' );
    $categories = explode(',', $atts['categories']);
    $args = array(
        'post_type' => 'product',
        'post_status' => 'publish',
        'posts_per_page' => $atts['limit'],
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => $categories,
                'operator' => 'IN',
            ),
        ),
    );
	$products = new WP_Query($args);
	ob_start();
    if ($products->have_posts()) {
		global $product;
        global $post;
        echo '<ul class="product-slider">';
        while ($products->have_posts()) {
        	echo '<li>';
            $products->the_post();
			$product_id = get_the_ID(); // Get the current product ID
			$product_ID = wc_get_product( $product_id );
			$image = wp_get_attachment_image_src( get_post_thumbnail_id( $product ), 'single-post-thumbnail' ); ?>
            <?php
			if($image){?>
           <a href="<?php  echo get_permalink(); ?>" class="img-bx">
               <?php
               if(!$product_ID->is_in_stock()) { ?>
                <span class="sold-out-overlay">Out Of Stock</span>
                <?php } ?>
                <img src="<?php  echo $image[0]; ?>" data-id="<?php echo $post->ID; ?>">
            </a>
			<?php }else {?>
				<a href="<?php  echo get_permalink(); ?>"  class="img-bx"> <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/placeholder.png"></a>
			<?php }
			 $catTerms = get_the_terms( $post->ID, 'product_cat' );
			 $cat_slug = $catTerms[0]->slug; ?>
			 <div class="cnt-bx">
				<span class="category-name">
					<?php echo $catTerms[0]->name;?>
				</span>
				<?php $title_product = get_the_title();
				 echo '<h3><a href="' . get_permalink() . '">' . wp_trim_words( get_the_title(), 8 ) . '</a> </h3>';
					 $rating_count = $product_ID->get_rating_count();
					 $review_count = $product_ID->get_review_count();
					 $average      = $product_ID->get_average_rating();
					 if ( $rating_count >= 0 ) : ?>
						 <div class="review">
							 <div class="rating-star">
								 <span class="star_rating"><span style="width: <?php echo ($average * 20);?>%"></span></span>
							 </div>
							 <a href="<?php  echo get_permalink(); ?>#tab-reviews" id="review-part" class="total-reviews" tabindex="0"><?php echo $review_count;?> reviews</a>
						 </div>
				</div>
				<div class="col-bottom">
					 	<?php endif;
                          if ( $product_ID->is_in_stock() ) {?>
                           <div class="product-price">
                            <?php echo $product_ID->get_price_html(); ?>
                            </div>
                        <?php } ?>
                    <?php if ( !$product_ID->is_in_stock() ) {
			        echo '<span class="text-red unavailable">Currently Unavailable</span>';
		           } else { ?>
                    <div class=" double-arrow btn-red"><span><?php woocommerce_template_loop_add_to_cart(); ?></span></div>
                    <?php } ?>
				</div>
				<?php
				echo '</li>';
        }
       echo '</ul>';
    } else {
        echo 'No products found.';
    }
    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('product_list', 'custom_product_list_shortcode');
add_action('widgets_init', 'Healing_widgets_init');
function Healing_widgets_init()
{
    register_sidebar(array(
        'name'          => esc_html__('soical Share product page', 'Healing'),
        'id'            => 'soical-widget',
        'description'   => esc_html__('Add soical here.', 'Healing'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    ));
    register_sidebar(array(
        'name'          => esc_html__('Footer', 'Healing'),
        'id'            => 'footer-widget',
        'description'   => esc_html__('Add widgets here.', 'Healing'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    ));
    register_sidebar(array(
        'name'          => esc_html__('Footer One', 'Healing'),
        'id'            => 'footer-widget-one',
        'description'   => esc_html__('Add widgets here.', 'Healing'),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    ));
    register_sidebar(array(
        'name'          => esc_html__('Footer Two', 'Healing'),
        'id'            => 'footer-widget-two',
        'description'   => esc_html__('Add widgets here.', 'Healing'),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    ));
    register_sidebar( array(
		'name'          => esc_html__( 'Left Price Sidebar', 'zigcy-lite' ),
		'id'            => 'left-price-sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'zigcy-lite' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
function calculate_reading_time() {
    $content = get_post_field( 'post_content', get_the_ID() );
    $word_count = str_word_count( strip_tags( $content ) );
    $reading_time = ceil( $word_count / 200 ); // Assuming an average reading speed of 200 words per minute
    return $reading_time;
}
function display_reading_time() {
    $reading_time = calculate_reading_time();
    echo '<span class="reading-time">' . $reading_time . ' minute read</span>';
}
// Advance Filter Custom Code Start
function productcategorys_shortcode() {?>
    <div id="accordion" class="accordion-container">
    <?php $cur_cat_id= get_queried_object_id();
        $accordion_cat=0;
        // Taxonomy for product categories
    $taxonomy = 'product_cat';
    // Get parent product categories
    $parent_product_cats = get_terms( $taxonomy, array( 'parent' => 0, 'hide_empty' => false ) );
    // Iterating through each parent categories (WP_Term Objects)
    $newcate = 0;
    foreach ( $parent_product_cats as $product_cat_obj ) {
        $newcate++;
        $term_id = $product_cat_obj->term_id; // term ID
        if($term_id != 15){
    if($term_id == $cur_cat_id )
        $accordion_cat = $newcate;
    $term_name = $product_cat_obj->name; // term Name
    $term_slug = $product_cat_obj->slug; // term slug?>
        <article class="content-entry open">
    <h4 class="article-title acc_sec_<?php echo $newcate; ?>" >
    <a href="<?php echo get_term_link( $product_cat_obj, 'product_cat' ); ?>"><?php echo $term_name; ?></a>
    </h4>
    <?php  $termchildren = get_term_children( $term_id, 'product_cat');
    if($termchildren){?>
    <div class="accordion-content" style="display: block;">
        <div class="newlist<?php echo $newcate; ?>">
    <?php
        foreach ( $termchildren as $child ) {
        $term = get_term_by( 'id', $child, 'product_cat');
        if($term->term_id == $cur_cat_id )
        $accordion_cat = $newcate;
        ?>
        <a  href="<?php echo get_term_link( $child, 'product_cat' ); ?>" id="<?php echo $term->term_id; ?>" class="<?php echo (($term->term_id == $cur_cat_id )?'active':'');?>"><?php echo $term->name; ?> <i></i></a>
        <?php } ?>
    </div>
    </div>
    <?php }?>
        </article>
        <?php
    }
        } ?>
    </div>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            setTimeout(function(){
                var links2 = $('.acc_sec_'+<?php echo $accordion_cat;?>);
                links2.trigger("click");
            }, 1000);
    });
    </script>
    <?php
    }
    // register shortcode
    add_shortcode('Product_Categorys', 'productcategorys_shortcode');
// Advance Filter Custom Code End
add_filter( 'woocommerce_sale_flash', '__return_null' );
function my_wc_hide_in_stock_message( $html, $text, $product ) {
	$availability = $product->get_availability();
	if ( isset( $availability['class'] ) && 'in-stock' === $availability['class'] ) {
		return '';
	}
	return $html;
}
add_filter( 'woocommerce_stock_html', 'my_wc_hide_in_stock_message', 10, 3 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
function woocommerce_template_single_excerpt() {
        return;
}
function zigcy_lite_disable_product_rating() {
    remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
}
add_action( 'woocommerce_init', 'zigcy_lite_disable_product_rating' );
/* Create Buy Now Button dynamically after Add To Cart button */
function add_content_after_addtocart() {
    $current_product_id = get_the_ID();
    $product = wc_get_product( $current_product_id );
    $checkout_url = WC()->cart->get_checkout_url();
    $add_to_cart = WC()->cart->get_cart_url();
    if( $product->is_type( 'simple' ) ){
       echo '<a href="'.$checkout_url.'?add-to-cart='.$current_product_id.'" class="double-arrow btn-red"><span>Buy Now</span></a>';
    }
}
add_action( 'woocommerce_after_add_to_cart_button', 'add_content_after_addtocart' );
/***Cart page cross sell below total table* */
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
add_action( 'woocommerce_after_cart', 'woocommerce_cross_sell_display' );
add_filter( 'woocommerce_cross_sells_columns', 'bbloomer_change_cross_sells_columns' );
function bbloomer_change_cross_sells_columns( $columns ) {
	echo "<div class='also-like recentview'> <div class='up-sells upsells products'>";
return 3;
echo "</div> </div>";
}
add_filter('woocommerce_cross_sells_total', 'cross_sells_limit');
function cross_sells_limit() {
    return 4;
}
// Out of stock single page
add_action('woocommerce_before_shop_loop_item_title', 'loop_product_image_overlay');
function loop_product_image_overlay() {
    // global $product;
    // if ( !$product->is_in_stock() ) {
    //     echo $product->is_in_stock();
    //     echo '<span class="sold-out-overlay">Out Of Stock</span>';
    // }
}
add_filter( 'woocommerce_get_availability', 'wcs_custom_get_availability', 1, 2);
function wcs_custom_get_availability( $availability, $_product ) {
    // Change Out of Stock Text
    if ( ! $_product->is_in_stock() ) {
        $availability['availability'] = __('Currently Unavailable', 'woocommerce');
    }
    return $availability;
}
add_filter('woocommerce_registration_errors', 'registration_errors_validation', 10,3);
function registration_errors_validation($reg_errors, $sanitized_user_login, $user_email) {
    global $woocommerce;
    extract( $_POST );
    if ( strcmp( $password, $password2 ) !== 0 ) {
        return new WP_Error( 'registration-error', __( 'Passwords do not match.', 'woocommerce' ) );
    }
    return $reg_errors;
}
add_action( 'woocommerce_register_form', 'wc_register_form_password_repeat' );
function wc_register_form_password_repeat() {
    if(318 == get_the_ID()) {
    ?>
    <div class="form-row form-row-wide  addtafterpassword">
        <div class="input-bx">
				<div class="svg-icon">
					<svg xmlns="http://www.w3.org/2000/svg" width="16.551" height="20.229" viewBox="0 0 16.551 20.229">
				  <path id="Icon_material-security" data-name="Icon material-security" d="M12.775,1.5,4.5,5.178v5.517c0,5.1,3.531,9.875,8.275,11.034,4.745-1.159,8.275-5.931,8.275-11.034V5.178Zm0,10.105h6.436a9.843,9.843,0,0,1-6.436,8.22V11.614H6.339V6.373l6.436-2.86Z" transform="translate(-4.5 -1.5)" fill="#b1aa1c"/>
				</svg>
				</div>
        <input type="password" class="input-text" name="password2" id="reg_password2" placeholder="Password Repeat*" value="<?php if ( ! empty( $_POST['password2'] ) ) echo esc_attr( $_POST['password2'] ); ?>" />
        <span class="input-group-text" id="show_password2">
                  <i class="fa fa-eye"></i>
        </spanjkjhkhjk>
    </div>
    </div>
    <?php
} }
//add_action('woocommerce_shop_loop_item_title','wps_add_extra_product_thumbs', 5);
function custom_theme_setup() {
    add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'custom_theme_setup' );
/**car page quanity update **/
add_action( 'wp_footer', 'cart_update_qty_script' );
function cart_update_qty_script() {
  if (is_cart()) :
   ?>
    <script>
        jQuery('div.woocommerce').on('change', '.qty', function(){
           jQuery("[name='update_cart']").removeAttr('disabled');
           jQuery("[name='update_cart']").trigger("click");
        });
   </script>
<?php
endif; ?>
<script>
jQuery('.flex-control-thumbs').slick({
	infinite: false,
	speed: 900,
	slidesToShow: 4,
	slidesToScroll: 1,
		 responsive: [
	{
	  breakpoint: 1200,
	  settings: {
	    slidesToShow: 3,
	  },
	},
	{
	  breakpoint: 769,
	  settings: {
	    slidesToShow: 2,
	   // arrows : false,
	  },
	},
	{
	  breakpoint:500,
	  settings: {
	    slidesToShow: 1,
	   // arrows : false,
	  },
	},
	],
});
	</script>
<?php
}
// change country class
add_filter( 'woocommerce_default_address_fields' , 'country_class_change' );
function country_class_change( $address_fields ) {
    // change country class
    $address_fields['company']['class'] = array('my-field-class form-row-first');
    $address_fields['country']['class'] = array('my-field-class form-row-last');
    $address_fields['city']['class'] = array('my-field-class form-row-first');
    $address_fields['state']['class'] = array('my-field-class form-row-last');
    return $address_fields;
}
//remove download menu form user profile
function custom_my_account_menu_items( $items ) {
    unset($items['downloads']);
    return $items;
}
add_filter( 'woocommerce_account_menu_items', 'custom_my_account_menu_items' );
//remove download menu form user profile
function custom_my_account_coupon_menu_items( $items ) {
    unset($items['wt-smart-coupon']);
    return $items;
}
add_filter( 'woocommerce_account_menu_items', 'custom_my_account_coupon_menu_items' );
// Remove the payment options form from default location
remove_action( 'woocommerce_checkout_order_review', 'woocommerce_checkout_payment', 20 );
add_action( 'woocommerce_after_order_notes', 'woocommerce_checkout_payment', 20 );
add_filter( 'woocommerce_order_button_text', 'change_button_text' );
function change_button_text( $button_text ) {
	return 'Proceed To Pay'; // new text is here
}
    remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10 );
    /*
     * Hooking "Coupon form" after order total in checkout page with custom function
     */
    add_action( 'woocommerce_review_order_after_order_total', 'woocommerce_checkout_coupon_form_custom' );
    /*
     * Rendering html for "Coupon form" with custom function
     */
    function woocommerce_checkout_coupon_form_custom() {
        echo '<tr class="coupon-form"><td colspan="2">';
        wc_get_template(
            'checkout/form-coupon.php',
            array(
                'checkout' => WC()->checkout(),
            )
        );
        echo '</td></tr>';
              }
    function my_login_logo() { ?>
        <style type="text/css">
            #login h1 a, .login h1 a {
                background-image: url(<?php echo get_stylesheet_directory_uri(); ?>/assets/images/healing-logo.png);
                width: 180px; height: 180px; background-size: 100%; background-color: transparent; padding: 10px; background-position: center;
            }
        </style>
    <?php }
    add_action( 'login_enqueue_scripts', 'my_login_logo' );
    add_filter( 'login_headerurl', 'custom_loginlogo_url' );
    function custom_loginlogo_url($url) {
        return home_url();
    }
add_filter( 'woocommerce_checkout_fields' , 'override_billing_checkout_fields', 20, 1 );
 function override_billing_checkout_fields( $fields ) {
     $fields['billing']['billing_first_name']['placeholder'] = 'First name';
     $fields['billing']['billing_last_name']['placeholder'] = 'Last name';
     $fields['billing']['billing_company']['placeholder'] = 'Company name (optional)';
     $fields['billing']['billing_postcode']['placeholder'] = 'PIN Code';
     $fields['billing']['billing_phone']['placeholder'] = 'Telephone';
     $fields['billing']['billing_city']['placeholder'] = 'Town/City';
     $fields['billing']['billing_email']['placeholder'] = 'Email address';
     $fields['shipping']['shipping_first_name']['placeholder'] = 'First name';
     $fields['shipping']['shipping_last_name']['placeholder'] = 'Last name';
     $fields['shipping']['shipping_company']['placeholder'] = 'Company name (optional)';
     $fields['shipping']['shipping_postcode']['placeholder'] = 'PIN Code';
     $fields['shipping']['shipping_phone']['placeholder'] = 'Telephone';
     $fields['shipping']['shipping_city']['placeholder'] = 'Town/City';
     return $fields;
 }
add_action( 'woocommerce_after_checkout_validation', 'show_one_err', 9999, 2);
function show_one_err( $fields, $errors ){
    // if any validation errors
    if( !empty( $errors->get_error_codes() ) ) {
        // remove all of them
        foreach( $errors->get_error_codes() as $code ) {
            $errors->remove( $code );
        }
        // add our custom one
        $errors->add( 'validation', 'Please fill in all required fields to place order.' );
    }
}
//Remove content form product category
remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
//code to validate textbox
add_filter( 'wpcf7_validate_text', 'alphanumeric_validation_filter', 20, 2 );
add_filter( 'wpcf7_validate_text*', 'alphanumeric_validation_filter', 20, 2 );
function alphanumeric_validation_filter( $result, $tag ) {
    $tag = new WPCF7_Shortcode( $tag );
    if ( 'your-name' == $tag->name ) {
        $name_of_the_input = isset( $_POST['your-name'] ) ? trim( $_POST['your-name'] ) : '';
        if ( !preg_match('/^[a-zA-Z0-9]+$/',$name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed Alphabet only" );
        }
    }
    return $result;
}
add_filter( 'wpcf7_validate_text', 'alphanumeric_validation_filter_lastname', 20, 3 );
add_filter( 'wpcf7_validate_text*', 'alphanumeric_validation_filter_lastname', 20, 3 );
function alphanumeric_validation_filter_lastname( $result, $tag ) {
    $tag = new WPCF7_Shortcode( $tag );
    if ( 'your-lastname' == $tag->name ) {
        $name_of_the_input2 = isset( $_POST['your-lastname'] ) ? trim( $_POST['your-lastname'] ) : '';
        if ( !preg_match('/^[a-zA-Z0-9]+$/',$name_of_the_input2) ) {
            $result->invalidate( $tag, "Allowed Alphabet only" );
        }
    }
    return $result;
}
// Add validation for email and password
function custom_validate_email_and_password( $errors, $username, $password ) {
    if ( empty( $username ) ) {
        $errors->add( 'username_required', __( 'Username is required', 'woocommerce' ) );
    }
    if ( empty( $password ) ) {
        $errors->add( 'password_required', __( 'Password is required', 'woocommerce' ) );
    }
    return $errors;
}
add_filter( 'woocommerce_process_login_errors', 'custom_validate_email_and_password', 10, 3 );
add_filter( 'woocommerce_account_menu_items', 'remove_logout_link' );
function remove_logout_link( $items ) {
    unset( $items['customer-logout'] );
    unset( $items['payment-methods'] );
    return $items;
}
add_filter( 'gettext', function( $translated_text ) {
    if ( 'New passwords do not match.' === $translated_text ) {
        $translated_text = 'Confirm new passwords do not match.';
    }
    return $translated_text;
} );
add_filter( 'gettext', function( $translated_text ) {
    if ( 'Phone is not a valid phone number.' === $translated_text ) {
        $translated_text = 'Phone number is not valid.';
    }
    return $translated_text;
} );
add_filter( 'gettext', function( $translated_text ) {
    if ( 'Please select a rating' === $translated_text ) {
        $translated_text = 'Please provide a rating';
    }
    return $translated_text;
} );
function ValidateFirstnameLastname( $fields, $errors ){
    if ( preg_match( '/\\d/', $fields['billing_first_name'] ) || preg_match( '/\\d/', $fields['billing_last_name'] )  ){
      $errors->add('validation','Your First name or Last name contains a number. Really?' );
    }
  }
  add_action('woocommerce_after_checkout_validation','ValidateFirstnameLastname',99,2);
  add_filter( 'woocommerce_account_menu_items', 'ts_my_account_menu_items', 10, 2 );
function ts_my_account_menu_items( $items ) {
  $items['orders'] = __( 'Orders', 'woocommerce' );
  $items['edit-address'] = __( 'Addresses', 'woocommerce' );
 return $items;
}
// function that runs when shortcode is called
function wpb_demo_shortcode() {
	// Things that you want to do.
	$recent_comments =  '';
	 $recent_comments = get_comments( array(
		'number'      => 5, // number of comments to retrieve.
		'status'      => 'approve', // we only want approved comments.
		'post_status' => 'publish' // limit to published comments.
	) );
	echo '<h2 class="widget-title">Recent Comments</h2>
	<ul id="recentcomments">';
	if ( $recent_comments ) {
		foreach ( (array) $recent_comments as $comment ) {
		  echo '<li class="recentcomments"><a href="' . esc_url( get_comment_link( $comment ) ) . '">' . get_the_title( $comment->comment_post_ID ) . '</li></a>';
		}
	}
	echo '</ul>';
	}
add_shortcode('recentcomment', 'wpb_demo_shortcode');
add_filter( 'woocommerce_email_footer_text', 'remove_wc_email_footer_text' );
function remove_wc_email_footer_text( $text ) {
    return '';
}
function mtp_disable_mobile_messaging( $mailer ) {
    remove_action( 'woocommerce_email_footer', array( $mailer->emails['WC_Email_New_Order'], 'mobile_messaging' ), 9 );
}
add_action( 'woocommerce_email', 'mtp_disable_mobile_messaging' );
function my_acf_cpt_save_folder( $path ) {
    return get_stylesheet_directory() . '/acf-json';
}
add_filter( 'acf/settings/save_json/type=acf-post-type', 'my_acf_cpt_save_folder' );
add_filter( 'woocommerce_cart_item_name', 'ts_product_image_on_checkout', 10, 3 );
function ts_product_image_on_checkout( $name, $cart_item, $cart_item_key ) {
    /* Return if not checkout page */
    if ( ! is_checkout() ) {
        return $name;
    }
    /* Get product object */
    $_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
    /* Get product thumbnail */
    $thumbnail = $_product->get_image();
    /* Add wrapper to image and add some css */
    $image = '<div class="ts-product-image">'
                . $thumbnail .
            '</div>';
    /* Prepend image to name and return it */
    return $image;
}
/**Shop page pagination code**/
add_filter('loop_shop_per_page', 'new_loop_shop_per_page', 9999999);
function new_loop_shop_per_page($cols) {
        $cols = get_field('number_of_product_display_in_shop_page', 'options');
        return $cols;
}
/** product remove icon in checkout page**/
function hg_woocommerce_checkout_remove_item( $product_name, $cart_item, $cart_item_key ) {
    if ( is_checkout() ) {
        $_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
        $product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
        $remove_link = apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
            '<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">×</a>',
            esc_url( WC()->cart->get_remove_url( $cart_item_key ) ),
            __( 'Remove this item', 'woocommerce' ),
            esc_attr( $product_id ),
            esc_attr( $_product->get_sku() )
        ), $cart_item_key );
        return '<span>' . $remove_link . '</span> <span>' . $product_name . '</span>';
    }
    return $product_name;
}
//add_filter( 'woocommerce_cart_item_name', 'hg_woocommerce_checkout_remove_item', 10, 3 );
/**order summary in mobile after shipping address**/
add_action( 'woocommerce_after_checkout_billing_form', 'display_order_summary_before_shipping_address', 10 );
function display_order_summary_before_shipping_address() {
    if ( wp_is_mobile() ) {?>
        <h3 id="order_review_heading"><?php esc_html_e( 'Order Summary', 'woocommerce' ); ?></h3>
        <?php do_action( 'woocommerce_checkout_before_order_review' ); ?>
        <div id="order_review" class="woocommerce-checkout-review-order">
            <?php do_action( 'woocommerce_checkout_order_review' ); ?>
        </div>
        <div class="cart-totla-right">
            <?php do_action( 'woocommerce_checkout_after_order_review' ); ?>
                <div class="total-items">
                    <?php global $woocommerce;
                        echo $woocommerce->cart->cart_contents_count; ?> Items
                </div>
                <div class="item-show" style="display:block">
                    <?php do_action( 'woocommerce_review_order_before_cart_contents' );
                    foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                        $_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                        if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {?>
                                <div class="cart-item">
                                    <span class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
                                        <span class="product-name" style="display:none">
                                            <?php echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) ); ?>
                                        </span>
                                    </span>
                                    <div class="cnt checkoutpage">
                                        <div class="title"><?php echo $_product->get_name();?></div>
                                        <div class="quantity">
                                            <span>
                                                <?php echo apply_filters( 'woocommerce_checkout_cart_item_quantity', ' <strong class="product-quantity">' . sprintf( 'Quantity&minus;&nbsp;%s', $cart_item['quantity'] ) . '</strong>', $cart_item, $cart_item_key ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                                                <?php echo wc_get_formatted_cart_item_data( $cart_item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                                            </span>
                                            <span class="product-total">
                                                <?php echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            <?php
                        }
                    }
                    do_action( 'woocommerce_review_order_after_cart_contents' );?>
                </div>
        </div>
        <?php $coupon_code_text = get_field('bank_offer_text','option');
            if(!empty($coupon_code_text)){?> <p class="cct"> <span class="applycoupon"><?php echo $coupon_code_text ;?> </span></p> <?php } ?>
            <p class="delivery-day">Items will be delivered in <strong class="lightgreen">3 - 4 working days.</strong></p>
            <p class="help-blog">Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our privacy policy.</p>
            <h3 class="accept">We Accept:</h3>
            <img src="<?php echo  get_stylesheet_directory_uri();?>/assets/images/master-card.png">
            <div class="shield-alt">
                <svg xmlns="http://www.w3.org/2000/svg" width="26.722" height="28.5" viewBox="0 0 26.722 28.5">
                <path id="Icon_awesome-shield-alt" data-name="Icon awesome-shield-alt" d="M26.2,4.66,15.516.206a2.681,2.681,0,0,0-2.054,0L2.773,4.66A2.669,2.669,0,0,0,1.125,7.126c0,11.05,6.374,18.688,12.331,21.171a2.681,2.681,0,0,0,2.054,0c4.771-1.987,12.336-8.852,12.336-21.171A2.673,2.673,0,0,0,26.2,4.66ZM14.491,24.846l-.006-21.21,9.792,4.081c-.184,8.428-4.57,14.535-9.787,17.13Z" transform="translate(-1.125 -0.002)" fill="#b0ab36"/>
                </svg>
                <span>All the payments are end to end encrypted & are 100% safe and are processed by Razorpay</span>
            </div>
<?php
    }
}
function add_social_share_buttons() {
    if (is_product()) {
        $product_url = get_permalink();
        $product_title = get_the_title();
        echo '<div class="social-share ">';
        echo '<a class="resp-sharing-button__link facebook"  href="https://www.facebook.com/sharer/sharer.php?u=' . esc_url($product_url) . '" target="_blank" rel="noopener noreferrer"><svg xmlns="http://www.w3.org/2000/svg" width="23.568" height="23.426" viewBox="0 0 23.568 23.426" >
        <path id="Icon_awesome-facebook" data-name="Icon awesome-facebook" d="M24.131,12.347A11.784,11.784,0,1,0,10.505,23.988V15.753H7.512V12.347h2.994V9.75c0-2.953,1.758-4.584,4.451-4.584a18.136,18.136,0,0,1,2.638.23v2.9H16.108a1.7,1.7,0,0,0-1.92,1.84v2.212h3.268l-.523,3.406H14.188v8.235A11.788,11.788,0,0,0,24.131,12.347Z" transform="translate(-0.563 -0.563)" fill="#fff"></path>
        </svg> <span>Share</span> </a>';
        echo '<a class="resp-sharing-button__link  twittre "  href="https://twitter.com/intent/tweet?url=' . esc_url($product_url) . '&text=' . urlencode($product_title) . '" target="_blank" rel="noopener noreferrer">
        <svg data-name="Group " xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="19.554" height="20.018" viewBox="0 0 19.554 20.018">
        <g data-name="Group 2" clip-path="url(#clip-path)">
            <path data-name="Path 4" d="M8.4,12.252,5.034,16.164c-1.019,1.184-2.044,2.364-3.05,3.559a.734.734,0,0,1-.666.294C.908,19.994.5,20.011,0,20.011c.359-.42.659-.773.961-1.124q3.211-3.73,6.428-7.455a.42.42,0,0,0,.038-.625Q3.841,5.62.277.419C.2.3.127.185.014.008H.441C2.1.008,3.749.016,5.4,0a.694.694,0,0,1,.663.342c1.515,2.227,3.046,4.444,4.573,6.663.072.1.15.2.249.34.506-.586.989-1.144,1.47-1.7Q14.665,2.964,16.966.281A.667.667,0,0,1,17.56,0c.426.023.853.006,1.375.006L11.649,8.479l7.9,11.5c-.151.012-.258.028-.365.028-1.706,0-3.412-.006-5.118.009a.566.566,0,0,1-.531-.295q-2.424-3.545-4.86-7.082c-.081-.118-.165-.233-.277-.389M2.373,1.319c.124.189.2.318.292.443q5.7,8.155,11.39,16.318a1.314,1.314,0,0,0,1.35.7c.569-.058,1.15-.012,1.785-.012-.119-.178-.188-.286-.261-.391l-4.493-6.428Q8.836,6.8,5.232,1.651c-.091-.129-.229-.313-.351-.317-.813-.028-1.627-.015-2.508-.015" transform="translate(0 0)" fill="#fff"></path>
        </g></svg> <span>Share</span> </a> </div>';
    }
}
function call_external_api() {
    $response = wp_remote_post('http://localhost/Healing-Gilead/wp-json/wp/v2/posts/', array(
        'method'      => 'POST',
        'body'        => json_encode(array('data' => 'value')),
        'headers'     => array(
            'Content-Type' => 'application/json',
            'Authorization' => 'Bearer YOUR_ACCESS_TOKEN',
        )
    ));
    if (is_wp_error($response)) {
        return 'Failed to connect: ' . $response->get_error_message();
    }
    return json_decode(wp_remote_retrieve_body($response), true);
}