<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Zigcy Lite
 */
?>
</div>
	<div class="footer-top" style="display:none">
		<div class="container">
			<?php if(have_rows('footer_top', 'option')) :
				while(have_rows('footer_top', 'option')): the_row();
					$Address = get_sub_field('addresss');
					$phone_number = get_sub_field('phone_number');
					$email_address = get_sub_field('email_address'); ?>
					<div class="foot-col col_1"><a href="https://maps.app.goo.gl/a5XWqLfjVuTroyXr7" title="<?php echo $Address; ?>" target="_blank">
						<?php if($Address){ ?>
						<svg xmlns="http://www.w3.org/2000/svg" width="21" height="30" viewBox="0 0 21 30">
						<path id="Icon_material-location-on" data-name="Icon material-location-on" d="M18,3A10.492,10.492,0,0,0,7.5,13.5C7.5,21.375,18,33,18,33S28.5,21.375,28.5,13.5A10.492,10.492,0,0,0,18,3Zm0,14.25a3.75,3.75,0,1,1,3.75-3.75A3.751,3.751,0,0,1,18,17.25Z" transform="translate(-7.5 -3)" fill="#fff"/>
						</svg>
						<span><?php echo $Address; ?></span>
						<?php } ?></a>
					</div>
					<div class="foot-col col_2">
						<?php if( $phone_number ):
							$phone_number_url = $phone_number['url'];
							$phone_number_title = $phone_number['title'];
							$phone_number_target = $phone_number['target'] ? $phone_number['target'] : '_self'; ?>
							<a href="<?php echo esc_url( $phone_number_url ); ?>" target="<?php echo esc_attr( $phone_number_target ); ?>"><strong><?php echo esc_html( $phone_number_title ); ?></strong></a>
						<?php endif;
						if($email_address){ ?>
							<a href="mailto:<?php echo $email_address; ?>">
								<svg xmlns="http://www.w3.org/2000/svg" width="25.94" height="21.224" viewBox="0 0 25.94 21.224">
								<g id="Icon_feather-mail" data-name="Icon feather-mail" transform="translate(-1.5 -4.5)">
									<path id="Path_15" data-name="Path 15" d="M5.037,4.5H23.9A3.541,3.541,0,0,1,27.44,8.037V22.186A3.541,3.541,0,0,1,23.9,25.724H5.037A3.541,3.541,0,0,1,1.5,22.186V8.037A3.541,3.541,0,0,1,5.037,4.5ZM23.9,23.365a1.18,1.18,0,0,0,1.179-1.179V8.037A1.18,1.18,0,0,0,23.9,6.858H5.037A1.18,1.18,0,0,0,3.858,8.037V22.186a1.18,1.18,0,0,0,1.179,1.179Z" transform="translate(0)" fill="#fff"/>
									<path id="Path_16" data-name="Path 16" d="M14.47,18.112a1.178,1.178,0,0,1-.676-.213L2,9.645A1.179,1.179,0,1,1,3.355,7.713l11.115,7.78,11.115-7.78a1.179,1.179,0,1,1,1.352,1.932L15.146,17.9A1.178,1.178,0,0,1,14.47,18.112Z" transform="translate(0 -0.642)" fill="#fff"/>
								</g>
								</svg>
								<?php echo $email_address; ?>
							</a>
						<?php } ?>
					</div>
			<?php if(have_rows('soical_links', 'option')) :?>
			<div class="foot-col col_3">
				<?php while(have_rows('soical_links','option'))
				{
					the_row();
						$facebook = get_sub_field('facebook');
						$twitter = get_sub_field('twitter_link');
						$instagram = get_sub_field('instagram_link');
						$blogger = get_sub_field('blogger');
						$linkedin= get_sub_field('linkedin_link');
						if( $facebook ):
							$facebook_url = $facebook['url'];
							$facebook_target = $facebook['target'] ? $facebook['target'] : '_self'; ?>
							<a href="<?php echo esc_url( $facebook_url ); ?>" target="<?php echo esc_attr( $facebook_target ); ?>" title="Facebook">
								<svg xmlns="http://www.w3.org/2000/svg" width="23.568" height="23.426" viewBox="0 0 23.568 23.426">
								<path id="Icon_awesome-facebook" data-name="Icon awesome-facebook" d="M24.131,12.347A11.784,11.784,0,1,0,10.505,23.988V15.753H7.512V12.347h2.994V9.75c0-2.953,1.758-4.584,4.451-4.584a18.136,18.136,0,0,1,2.638.23v2.9H16.108a1.7,1.7,0,0,0-1.92,1.84v2.212h3.268l-.523,3.406H14.188v8.235A11.788,11.788,0,0,0,24.131,12.347Z" transform="translate(-0.563 -0.563)" fill="#fff"/>
								</svg>
							</a>
						<?php endif;
							if( $twitter ):
								$twitter_url = $twitter['url'];
								$twitter_target = $twitter['target'] ? $twitter['target'] : '_self';  ?>
								<a href="<?php echo esc_url( $twitter_url ); ?>" target="<?php echo esc_attr( $twitter_target ); ?>" title="Twitter">
								<svg xmlns="http://www.w3.org/2000/svg" width="24.328" height="19.759" viewBox="0 0 24.328 19.759">
								<path id="Icon_awesome-twitter" data-name="Icon awesome-twitter" d="M21.828,8.305c.015.216.015.432.015.648A14.089,14.089,0,0,1,7.657,23.14,14.09,14.09,0,0,1,0,20.9a10.314,10.314,0,0,0,1.2.062,9.986,9.986,0,0,0,6.19-2.13,5,5,0,0,1-4.662-3.458,6.288,6.288,0,0,0,.942.077,5.274,5.274,0,0,0,1.312-.17,4.987,4.987,0,0,1-4-4.894v-.062a5.022,5.022,0,0,0,2.254.633A4.994,4.994,0,0,1,1.7,4.292,14.173,14.173,0,0,0,11.979,9.509a5.629,5.629,0,0,1-.123-1.142,4.991,4.991,0,0,1,8.629-3.412,9.817,9.817,0,0,0,3.165-1.2A4.973,4.973,0,0,1,21.457,6.5a10,10,0,0,0,2.871-.772,10.718,10.718,0,0,1-2.5,2.578Z" transform="translate(0 -3.381)" fill="#fff"/>
								</svg>
							</a>
						<?php endif;
							if( $instagram ):
								$instagram_url = $instagram['url'];
								$instagram_target = $instagram['target'] ? $instagram['target'] : '_self';  ?>
								<a href="<?php echo esc_url( $instagram_url ); ?>" target="<?php echo esc_attr( $instagram_target ); ?>" title="Instagram">
									<svg xmlns="http://www.w3.org/2000/svg" width="21.299" height="21.295" viewBox="0 0 21.299 21.295">
									<path id="Icon_awesome-instagram" data-name="Icon awesome-instagram" d="M10.647,7.425a5.46,5.46,0,1,0,5.46,5.46A5.451,5.451,0,0,0,10.647,7.425Zm0,9.009a3.55,3.55,0,1,1,3.55-3.55,3.556,3.556,0,0,1-3.55,3.55ZM17.6,7.2A1.273,1.273,0,1,1,16.33,5.929,1.27,1.27,0,0,1,17.6,7.2Zm3.616,1.292A6.3,6.3,0,0,0,19.5,4.033a6.343,6.343,0,0,0-4.462-1.72c-1.758-.1-7.028-.1-8.786,0A6.334,6.334,0,0,0,1.79,4.028,6.323,6.323,0,0,0,.07,8.49c-.1,1.758-.1,7.028,0,8.786a6.3,6.3,0,0,0,1.72,4.462,6.351,6.351,0,0,0,4.462,1.72c1.758.1,7.028.1,8.786,0a6.3,6.3,0,0,0,4.462-1.72,6.343,6.343,0,0,0,1.72-4.462c.1-1.758.1-7.023,0-8.781ZM18.948,19.162a3.594,3.594,0,0,1-2.024,2.024c-1.4.556-4.728.428-6.277.428s-4.88.124-6.277-.428a3.594,3.594,0,0,1-2.024-2.024c-.556-1.4-.428-4.728-.428-6.277s-.124-4.88.428-6.277A3.594,3.594,0,0,1,4.37,4.584c1.4-.556,4.728-.428,6.277-.428s4.88-.124,6.277.428a3.594,3.594,0,0,1,2.024,2.024c.556,1.4.428,4.728.428,6.277S19.5,17.765,18.948,19.162Z" transform="translate(0.005 -2.237)" fill="#fff"/>
									</svg>
								</a>
						<?php endif;
						if( $blogger ):
							$blogger_url = $blogger['url'];
							$blogger_target = $blogger['target'] ? $blogger['target'] : '_self';  ?>
							<a href="<?php echo esc_url( $blogger_url ); ?>" target="<?php echo esc_attr( $blogger_target ); ?>" title="blogger">
								<svg xmlns="http://www.w3.org/2000/svg" width="21.286" height="21.281" viewBox="0 0 21.286 21.281">
									<path id="Icon_awesome-blogger-b" data-name="Icon awesome-blogger-b" d="M21.222,11.314a1.37,1.37,0,0,0-.594-.879,5.737,5.737,0,0,0-1.188-.128c-.955-.043-1.06-.062-1.364-.238-.48-.28-.608-.584-.613-1.4A6.132,6.132,0,0,0,15.52,4.329,7.251,7.251,0,0,0,12.407,2.4,16.622,16.622,0,0,0,9.4,2.267c-3.3-.038-4.029.029-5.151.475A6.753,6.753,0,0,0,.157,7.522,33.315,33.315,0,0,0,.01,12.459c-.029,4.823,0,5.531.3,6.486a6.681,6.681,0,0,0,4.961,4.481c.7.128,9.375.157,10.264.038a6.364,6.364,0,0,0,3.892-1.991A6.505,6.505,0,0,0,21.1,18.522,53.927,53.927,0,0,0,21.222,11.314ZM5.916,8.292c.371-.375.475-.39,2.794-.39,2.086,0,2.157,0,2.461.162A1.046,1.046,0,0,1,11.809,9.1a1.123,1.123,0,0,1-.584,1.026c-.219.138-.347.147-2.39.157a23.229,23.229,0,0,1-2.414-.057,1.21,1.21,0,0,1-.5-1.939Zm9.114,9.494-.708.114-3.683.043a24.667,24.667,0,0,1-4.319-.1,1.321,1.321,0,0,1-.708-.922A1.341,1.341,0,0,1,6,15.861c.337-.3.485-.314,4.623-.318,4.258,0,4.234,0,4.638.371a1.174,1.174,0,0,1-.233,1.872Z" transform="translate(-0.002 -2.258)" fill="#fff"/>
									</svg>
								</a>
						<?php endif;
							if( $linkedin ):
								$linkedin_url = $linkedin['url'];
								$linkedin_target = $linkedin['target'] ? $linkedin['target'] : '_self';  ?>
								<a href="<?php echo esc_url( $linkedin_url ); ?>" target="<?php echo esc_attr( $linkedin_target ); ?>" title="Linked In">
									<svg xmlns="http://www.w3.org/2000/svg" width="21.287" height="21.287" viewBox="0 0 21.287 21.287">
									<path id="Icon_awesome-linkedin-in" data-name="Icon awesome-linkedin-in" d="M4.765,21.288H.352V7.075H4.765ZM2.556,5.137a2.568,2.568,0,1,1,2.556-2.58A2.577,2.577,0,0,1,2.556,5.137ZM21.283,21.288h-4.4V14.369c0-1.649-.033-3.763-2.295-3.763-2.295,0-2.646,1.791-2.646,3.645v7.037H7.53V7.075h4.233V9.014h.062A4.637,4.637,0,0,1,16,6.719c4.467,0,5.288,2.941,5.288,6.762v7.807Z" transform="translate(0 -0.001)" fill="#fff"/>
									</svg>
								</a>
								<?php endif;
				 		}
				endif;
			 endwhile;
			endif;?>
			</div>
		</div>
	</div>
	<div class="footer-main">
		<div class="container">
			<div class="foot-inner">
				<div class="column column-1" style="display: none;">
					<?php if(have_rows('footer_main', 'option')) :
					while(have_rows('footer_main', 'option')) : the_row();
					$contact_us = get_sub_field('contact_us');
					$phone = get_sub_field('phone_number');
					$open_time = get_sub_field('open_time');
					$email_address = get_sub_field('email_address');
					?>
					<h3> <?php echo $contact_us; ?></h3>
					<div class="contact-bx">
						<svg xmlns="http://www.w3.org/2000/svg" width="24.689" height="24.732" viewBox="0 0 24.689 24.732">
							<path id="Icon_feather-phone-call" data-name="Icon feather-phone-call" d="M17.155,5.824a5.406,5.406,0,0,1,4.27,4.27M17.155,1.5a9.73,9.73,0,0,1,8.595,8.584m-1.081,8.627v3.243a2.162,2.162,0,0,1-2.357,2.162,21.4,21.4,0,0,1-9.33-3.319A21.082,21.082,0,0,1,6.5,14.311,21.4,21.4,0,0,1,3.177,4.938,2.162,2.162,0,0,1,5.328,2.581H8.571a2.162,2.162,0,0,1,2.162,1.86,13.881,13.881,0,0,0,.757,3.038A2.162,2.162,0,0,1,11,9.76L9.631,11.133a17.3,17.3,0,0,0,6.487,6.487l1.373-1.373a2.162,2.162,0,0,1,2.281-.486,13.881,13.881,0,0,0,3.038.757A2.162,2.162,0,0,1,24.669,18.711Z" transform="translate(-2.167 -0.396)" fill="none" stroke="#b0ab36" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"/>
						</svg>
						<div class="rgt">
						<?php if( $phone ):
								$phone_url = $phone['url'];
								$phone_title = $phone['title'];
								$phone_target = $phone['target'] ? $phone['target'] : '_self';  ?>
								<a href="<?php echo esc_url( $phone_url ); ?>" target="<?php echo esc_attr( $phone_target ); ?>"><?php echo esc_html( $phone_title ); ?> </a>
								<?php endif; ?>
							<span><?php echo $open_time; ?></span>
						</div>
					</div>
					<div class="contact-bx">
					<svg xmlns="http://www.w3.org/2000/svg" width="24.408" height="19.298" viewBox="0 0 24.408 19.298">
						<g id="Icon_feather-mail" data-name="Icon feather-mail" transform="translate(1.393 1)">
							<path id="Path_44" data-name="Path 44" d="M5.162,6h17.3a2.169,2.169,0,0,1,2.162,2.162V21.136A2.169,2.169,0,0,1,22.46,23.3H5.162A2.169,2.169,0,0,1,3,21.136V8.162A2.169,2.169,0,0,1,5.162,6Z" transform="translate(-3 -6)" fill="none" stroke="#b0ab36" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"/>
							<path id="Path_45" data-name="Path 45" d="M24.622,9,13.811,16.568,3,9" transform="translate(-3 -6.838)" fill="none" stroke="#b0ab36" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"/>
						</g>
						</svg>
						<div class="rgt">
							<a href="mailto:<?php echo $email_address; ?>">
								<?php echo $email_address; ?>
							</a>
						</div>
					</div>
					<?php endwhile;
				 endif;?>
				</div>
				<div class="column column-2">
					<div class="footmenu">
						<?php  dynamic_sidebar("footer-widget");?>
					</div>
					<div class="footmenu">
					<?php  dynamic_sidebar("footer-widget-one");?>
					</div>
				</div>
				<div class="column column-3">
				<?php  dynamic_sidebar("footer-widget-two");?>
				</div>
			</div>
			<div class="footer-top">
				<div class="container">
					<?php if(have_rows('footer_top', 'option')) :
						while(have_rows('footer_top', 'option')): the_row();
							$Address = get_sub_field('addresss');
							$phone_number = get_sub_field('phone_number');
							$email_address = get_sub_field('email_address'); ?>
							<div class="foot-col col_1"><a href="https://maps.app.goo.gl/a5XWqLfjVuTroyXr7" title="<?php echo $Address; ?>" target="_blank">
								<?php if($Address){ ?>
								<svg xmlns="http://www.w3.org/2000/svg" width="21" height="30" viewBox="0 0 21 30">
								<path id="Icon_material-location-on" data-name="Icon material-location-on" d="M18,3A10.492,10.492,0,0,0,7.5,13.5C7.5,21.375,18,33,18,33S28.5,21.375,28.5,13.5A10.492,10.492,0,0,0,18,3Zm0,14.25a3.75,3.75,0,1,1,3.75-3.75A3.751,3.751,0,0,1,18,17.25Z" transform="translate(-7.5 -3)" fill="#fff"/>
								</svg>
								<span><?php echo $Address; ?></span>
								<?php } ?></a>
							</div>
							<div class="foot-col col_2">
								<?php if( $phone_number ):
									$phone_number_url = $phone_number['url'];
									$phone_number_title = $phone_number['title'];
									$phone_number_target = $phone_number['target'] ? $phone_number['target'] : '_self'; ?>
									<a href="<?php echo esc_url( $phone_number_url ); ?>" target="<?php echo esc_attr( $phone_number_target ); ?>"><strong><?php echo esc_html( $phone_number_title ); ?></strong></a>
								<?php endif;
								if($email_address){ ?>
									<a href="mailto:<?php echo $email_address; ?>">
										<svg xmlns="http://www.w3.org/2000/svg" width="25.94" height="21.224" viewBox="0 0 25.94 21.224">
										<g id="Icon_feather-mail" data-name="Icon feather-mail" transform="translate(-1.5 -4.5)">
											<path id="Path_15" data-name="Path 15" d="M5.037,4.5H23.9A3.541,3.541,0,0,1,27.44,8.037V22.186A3.541,3.541,0,0,1,23.9,25.724H5.037A3.541,3.541,0,0,1,1.5,22.186V8.037A3.541,3.541,0,0,1,5.037,4.5ZM23.9,23.365a1.18,1.18,0,0,0,1.179-1.179V8.037A1.18,1.18,0,0,0,23.9,6.858H5.037A1.18,1.18,0,0,0,3.858,8.037V22.186a1.18,1.18,0,0,0,1.179,1.179Z" transform="translate(0)" fill="#fff"/>
											<path id="Path_16" data-name="Path 16" d="M14.47,18.112a1.178,1.178,0,0,1-.676-.213L2,9.645A1.179,1.179,0,1,1,3.355,7.713l11.115,7.78,11.115-7.78a1.179,1.179,0,1,1,1.352,1.932L15.146,17.9A1.178,1.178,0,0,1,14.47,18.112Z" transform="translate(0 -0.642)" fill="#fff"/>
										</g>
										</svg>
										<?php echo $email_address; ?>
									</a>
								<?php } ?>
							</div>
					<?php if(have_rows('soical_links', 'option')) :?>
					<div class="foot-col col_3">
						<?php while(have_rows('soical_links','option'))
						{
							the_row();
								$facebook = get_sub_field('facebook');
								$twitter = get_sub_field('twitter_link');
								$instagram = get_sub_field('instagram_link');
								$blogger = get_sub_field('blogger');
								$linkedin= get_sub_field('linkedin_link');

								if( $facebook ):
									$facebook_url = $facebook['url'];
									$facebook_target = $facebook['target'] ? $facebook['target'] : '_self'; ?>
									<a href="<?php echo esc_url( $facebook_url ); ?>" target="<?php echo esc_attr( $facebook_target ); ?>" title="Facebook">
										<svg xmlns="http://www.w3.org/2000/svg" width="23.568" height="23.426" viewBox="0 0 23.568 23.426">
										<path id="Icon_awesome-facebook" data-name="Icon awesome-facebook" d="M24.131,12.347A11.784,11.784,0,1,0,10.505,23.988V15.753H7.512V12.347h2.994V9.75c0-2.953,1.758-4.584,4.451-4.584a18.136,18.136,0,0,1,2.638.23v2.9H16.108a1.7,1.7,0,0,0-1.92,1.84v2.212h3.268l-.523,3.406H14.188v8.235A11.788,11.788,0,0,0,24.131,12.347Z" transform="translate(-0.563 -0.563)" fill="#fff"/>
										</svg>
									</a>
								<?php endif;
									if( $twitter ):
										$twitter_url = $twitter['url'];
										$twitter_target = $twitter['target'] ? $twitter['target'] : '_self';  ?>
										<a href="<?php echo esc_url( $twitter_url ); ?>" target="<?php echo esc_attr( $twitter_target ); ?>" title="Twitter">
										<svg xmlns="http://www.w3.org/2000/svg" width="24.328" height="19.759" viewBox="0 0 24.328 19.759">
										<path id="Icon_awesome-twitter" data-name="Icon awesome-twitter" d="M21.828,8.305c.015.216.015.432.015.648A14.089,14.089,0,0,1,7.657,23.14,14.09,14.09,0,0,1,0,20.9a10.314,10.314,0,0,0,1.2.062,9.986,9.986,0,0,0,6.19-2.13,5,5,0,0,1-4.662-3.458,6.288,6.288,0,0,0,.942.077,5.274,5.274,0,0,0,1.312-.17,4.987,4.987,0,0,1-4-4.894v-.062a5.022,5.022,0,0,0,2.254.633A4.994,4.994,0,0,1,1.7,4.292,14.173,14.173,0,0,0,11.979,9.509a5.629,5.629,0,0,1-.123-1.142,4.991,4.991,0,0,1,8.629-3.412,9.817,9.817,0,0,0,3.165-1.2A4.973,4.973,0,0,1,21.457,6.5a10,10,0,0,0,2.871-.772,10.718,10.718,0,0,1-2.5,2.578Z" transform="translate(0 -3.381)" fill="#fff"/>
										</svg>
									</a>
								<?php endif;
									if( $instagram ):
										$instagram_url = $instagram['url'];
										$instagram_target = $instagram['target'] ? $instagram['target'] : '_self';  ?>
										<a href="<?php echo esc_url( $instagram_url ); ?>" target="<?php echo esc_attr( $instagram_target ); ?>" title="Instagram">
											<svg xmlns="http://www.w3.org/2000/svg" width="21.299" height="21.295" viewBox="0 0 21.299 21.295">
											<path id="Icon_awesome-instagram" data-name="Icon awesome-instagram" d="M10.647,7.425a5.46,5.46,0,1,0,5.46,5.46A5.451,5.451,0,0,0,10.647,7.425Zm0,9.009a3.55,3.55,0,1,1,3.55-3.55,3.556,3.556,0,0,1-3.55,3.55ZM17.6,7.2A1.273,1.273,0,1,1,16.33,5.929,1.27,1.27,0,0,1,17.6,7.2Zm3.616,1.292A6.3,6.3,0,0,0,19.5,4.033a6.343,6.343,0,0,0-4.462-1.72c-1.758-.1-7.028-.1-8.786,0A6.334,6.334,0,0,0,1.79,4.028,6.323,6.323,0,0,0,.07,8.49c-.1,1.758-.1,7.028,0,8.786a6.3,6.3,0,0,0,1.72,4.462,6.351,6.351,0,0,0,4.462,1.72c1.758.1,7.028.1,8.786,0a6.3,6.3,0,0,0,4.462-1.72,6.343,6.343,0,0,0,1.72-4.462c.1-1.758.1-7.023,0-8.781ZM18.948,19.162a3.594,3.594,0,0,1-2.024,2.024c-1.4.556-4.728.428-6.277.428s-4.88.124-6.277-.428a3.594,3.594,0,0,1-2.024-2.024c-.556-1.4-.428-4.728-.428-6.277s-.124-4.88.428-6.277A3.594,3.594,0,0,1,4.37,4.584c1.4-.556,4.728-.428,6.277-.428s4.88-.124,6.277.428a3.594,3.594,0,0,1,2.024,2.024c.556,1.4.428,4.728.428,6.277S19.5,17.765,18.948,19.162Z" transform="translate(0.005 -2.237)" fill="#fff"/>
											</svg>
										</a>
								<?php endif;
								if( $blogger ):
									$blogger_url = $blogger['url'];
									$blogger_target = $blogger['target'] ? $blogger['target'] : '_self';  ?>
									<a href="<?php echo esc_url( $blogger_url ); ?>" target="<?php echo esc_attr( $blogger_target ); ?>" title="blogger">
										<svg xmlns="http://www.w3.org/2000/svg" width="21.286" height="21.281" viewBox="0 0 21.286 21.281">
											<path id="Icon_awesome-blogger-b" data-name="Icon awesome-blogger-b" d="M21.222,11.314a1.37,1.37,0,0,0-.594-.879,5.737,5.737,0,0,0-1.188-.128c-.955-.043-1.06-.062-1.364-.238-.48-.28-.608-.584-.613-1.4A6.132,6.132,0,0,0,15.52,4.329,7.251,7.251,0,0,0,12.407,2.4,16.622,16.622,0,0,0,9.4,2.267c-3.3-.038-4.029.029-5.151.475A6.753,6.753,0,0,0,.157,7.522,33.315,33.315,0,0,0,.01,12.459c-.029,4.823,0,5.531.3,6.486a6.681,6.681,0,0,0,4.961,4.481c.7.128,9.375.157,10.264.038a6.364,6.364,0,0,0,3.892-1.991A6.505,6.505,0,0,0,21.1,18.522,53.927,53.927,0,0,0,21.222,11.314ZM5.916,8.292c.371-.375.475-.39,2.794-.39,2.086,0,2.157,0,2.461.162A1.046,1.046,0,0,1,11.809,9.1a1.123,1.123,0,0,1-.584,1.026c-.219.138-.347.147-2.39.157a23.229,23.229,0,0,1-2.414-.057,1.21,1.21,0,0,1-.5-1.939Zm9.114,9.494-.708.114-3.683.043a24.667,24.667,0,0,1-4.319-.1,1.321,1.321,0,0,1-.708-.922A1.341,1.341,0,0,1,6,15.861c.337-.3.485-.314,4.623-.318,4.258,0,4.234,0,4.638.371a1.174,1.174,0,0,1-.233,1.872Z" transform="translate(-0.002 -2.258)" fill="#fff"/>
											</svg>
										</a>
								<?php endif;
									if( $linkedin ):
										$linkedin_url = $linkedin['url'];
										$linkedin_target = $linkedin['target'] ? $linkedin['target'] : '_self';  ?>
										<a href="<?php echo esc_url( $linkedin_url ); ?>" target="<?php echo esc_attr( $linkedin_target ); ?>" title="Linked In">
											<svg xmlns="http://www.w3.org/2000/svg" width="21.287" height="21.287" viewBox="0 0 21.287 21.287">
											<path id="Icon_awesome-linkedin-in" data-name="Icon awesome-linkedin-in" d="M4.765,21.288H.352V7.075H4.765ZM2.556,5.137a2.568,2.568,0,1,1,2.556-2.58A2.577,2.577,0,0,1,2.556,5.137ZM21.283,21.288h-4.4V14.369c0-1.649-.033-3.763-2.295-3.763-2.295,0-2.646,1.791-2.646,3.645v7.037H7.53V7.075h4.233V9.014h.062A4.637,4.637,0,0,1,16,6.719c4.467,0,5.288,2.941,5.288,6.762v7.807Z" transform="translate(0 -0.001)" fill="#fff"/>
											</svg>
										</a>
										<?php endif;
						 		}
						endif;
					 endwhile;
					endif;?>
					</div>
				</div>
			</div>
			<div class="copyright-bx">
			<?php if(have_rows('copyrights_section', 'option')) :
					while(have_rows('copyrights_section', 'option')) : the_row();
					$left_content = get_sub_field('left_content');
					$right_content = get_sub_field('right_content'); ?>
				<div class="lft"><?php echo $left_content; ?></div>
				<div class="rgt"> <?php echo $right_content; ?> </div>
				<?php endwhile;
				endif; ?>
			</div>
		</div>
	</div>
	<script>
		function qty_minus(fieldname){
		var $input = jQuery(fieldname).parent().find('input');
		var count = parseInt($input.val()) - 1;
		count = count < 1 ? 1 : count;
		$input.val(count);
		$input.change();
		return false;
	}
	function qty_plus(fieldname){
		var $input = jQuery(fieldname).parent().find('input');
		$input.val(parseInt($input.val()) + 1);
		$input.change();
		return false;
	}
	</script>

	<footer id="colophon" class="site-footer" style="display: none;">
		<div id = "store-mart-lite-section-footer-wrap" class="store-mart-lite-section-footer-wrap-main clearfix">
		<?php $footer_layout = get_theme_mod('zigcy_lite_footer_width_type','layout1');
		if($footer_layout == 'layout1'){
			$class = 'footer-one';
		}else{
			$class = 'footer-two';
		} ?>
			<div class="container <?php echo $class; ?>" >
				<?php do_action( 'zigcy_lite_footer' );  ?>
				<?php do_action( 'zigcy_lite_footer_copyright_fn' ); ?>
			</div>

		</div>
	</footer><!-- #colophon -->
	<div class="sml-scrollup">
		<a href="#" class="back-to-top" >
            <span>
            	<i class="lnr lnr-chevron-up" aria-hidden="true"></i>
            </span>
        </a>
	</div>
<style> #subscribe-popup { display:none; }</style>
<script type="text/javascript">
function zoom(e){
  var zoomer = e.currentTarget;
  e.offsetX ? offsetX = e.offsetX : offsetX = e.touches[0].pageX
  e.offsetY ? offsetY = e.offsetY : offsetX = e.touches[0].pageX
  x = offsetX/zoomer.offsetWidth*100
  y = offsetY/zoomer.offsetHeight*100
  zoomer.style.backgroundPosition = x + '% ' + y + '%';
}
jQuery('.size-full-new').slick({
	arrows:true,
		infinite: false,
		//fade: true,
		autoplay:false,
		speed: 900,
		slidesToShow: 1,
		slidesToScroll: 1,
		responsive: [
    {
      breakpoint:800,
      settings: {
		arrows:true,
      },
    },

  ],
	});
	//hero-slider slider
	jQuery('.hero-slider').slick({
		dots: true,
		infinite: false,
		//fade: true,
		autoplay:true,
		speed: 900,
		slidesToShow: 1,
		slidesToScroll: 1,
		responsive: [
    {
      breakpoint:800,
      settings: {
		dots: false,
      },
    },

  ],
	});
//category-carousel slider
jQuery('.category-carousel').slick({
	infinite: true,
	speed: 900,
	slidesToShow: 4,
	autoplay:true,
	slidesToScroll: 1,
		 responsive: [
	{
	  breakpoint: 1200,
	  settings: {
	    slidesToShow: 3,
	  },
	},
	{
	  breakpoint: 769,
	  settings: {
	    slidesToShow: 2,
	   // arrows : true,
	  },
	},

	{
	  breakpoint:500,
	  settings: {
	    slidesToShow: 1,
	   // arrows : true,
	  },
	},
],
});
//category-carousel slider
jQuery('.product-slider').slick({
	infinite: true,
	speed: 900,
	slidesToShow: 3,
	arrows : false,
	slidesToScroll: 1,
		 responsive: [

	{
	  breakpoint: 769,
	  settings: {
	    slidesToShow: 2,
	    arrows : false,
		autoplay:true,
	  },
	},
	{
	  breakpoint:500,
	  settings: {
	    slidesToShow: 1,
	   arrows : false,
	   autoplay:true,
	  },
	},
	],
});
//Popular category slider
jQuery('.popular-category').slick({
	infinite: true,
	speed: 900,
	slidesToShow: 4,
		autoplay:true,
	slidesToScroll: 1,
		 responsive: [
	{
	  breakpoint: 1200,
	  settings: {
	    slidesToShow: 3,
	  },
	},
	{
	  breakpoint: 769,
	  settings: {
	    slidesToShow: 2,
	    arrows : false,
	  },
	},

	{
	  breakpoint:500,
	  settings: {
	    slidesToShow: 1,
	    arrows : false,
	  },
	},

	],
});
//product-carousel slider
jQuery('.product-carousel').slick({
	infinite: true,
		autoplay:true,
	speed: 900,
	slidesToShow: 4,
	slidesToScroll: 1,
		 responsive: [
	{
	  breakpoint: 1200,
	  settings: {
	    slidesToShow: 3,
	  },
	},
	{
	  breakpoint: 800,
	  settings: {
	    slidesToShow: 2,
	   // arrows : false,
	  },
	},

	{
	  breakpoint:500,
	  settings: {
	    slidesToShow: 1,
	   // arrows : false,
	  },
	},
	],
});
//testimonial slider
jQuery('.testimonial-slider').slick({
	infinite: false,
	speed: 900,
	slidesToShow: 1,
	slidesToScroll: 1,
	arrows:false,
	dots :true,
});
  //Vertical Tab
  jQuery('#parentVerticalTab').easyResponsiveTabs({
        type: 'vertical', //Types: default, vertical, accordion
        width: 'auto', //auto or any width like 600px
        fit: true, // 100% fit in a container
        closed: 'accordion', // Start closed if in accordion view
        tabidentify: 'hor_1', // The tab groups identifier
        activate: function(event) { // Callback function if tab is switched
            var $tab = $(this);
            var $info = $('#nested-tabInfo2');
            var $name = $('span', $info);
            $name.text($tab.text());
            $info.show();
        }
    });

	jQuery("input#keyword").keyup(function() {
  if (jQuery(this).val().length > 2) {
    jQuery("#datafetch").show();
  } else {
    jQuery("#datafetch").hide();
  }
});

//popup
var modalBtns = [document.querySelectorAll(".popup")];
modalBtns.forEach(function (btn) {
    jQuery(btn).bind("click", function () {
        var modal = jQuery(this).attr('data-modal');
        document.getElementById(modal).style.display = "block";
        document.body.style.overflow = "hidden";

    })
});
var closeBtns = [document.querySelectorAll(".close")];
closeBtns.forEach(function (btn) {
    jQuery(btn).bind("click", function () {
        var modal = jQuery(btn).closest('.modal').hide();
        document.body.style.overflow = "auto";
    }
    )
});
window.onclick = function (event) {
    if (event.target.className === "modal") {
        event.target.style.display = "none";
        document.body.style.overflow = "auto";
    }
}

jQuery(function(){
	jQuery('.modal .close').click(function(){
	  jQuery(".modal").hide();
    });
});
/**Local storage popup**/
var poppy = localStorage.getItem('mypopup');
if(!poppy){
    function PopUp(){
        jQuery('#subscribe-popup').fadeIn(500);
    }
    setTimeout(function(){
        PopUp();
    },1000); // 1000 to load it after 1 second from page load
    jQuery('.btnclose').click(function() {
        jQuery('#subscribe-popup').fadeOut(300);
    });
    localStorage.setItem('mypopup','true');
}
//popup End
	jQuery(".total-items").click(function() {
            jQuery(".item-show").fadeToggle();
        });
        jQuery('.total-items').on('click', function () {
    jQuery(this).toggleClass('open')
});
</script>
<script>
	jQuery(document).ready(function () {
		jQuery(".close.btnclose").click(function () {
			jQuery(".modal").removeClass("showpopup");
		});
		jQuery(".popup").click(function () {
			jQuery(".body").addClass("bodyfixed");
		});
		jQuery(".close").click(function () {
			jQuery("body").removeClass("bodyfixed");
		});

		jQuery(".modal.showpopup").each(function(){
			jQuery("body").addClass('bodyfixed');
		})
	});
	jQuery(document).ready(function(){
		jQuery("input#coupon_code").click(function(){
			jQuery("input#coupon_code").addClass("highlightcoupon");
  });
});
jQuery(document).ready(function($) {
	//accordian expand and collaspe
	$(".hide").click(function(){
		$(".accordion-container .ui-accordion .ui-accordion-content").hide();
	});
	$(".show").click(function(){
	$(".accordion-container .ui-accordion .ui-accordion-content").show();
	});
//Accordion
var Accordion = function(el, multiple) {
	this.el = el || {};
	this.multiple = multiple || false;
	var links = this.el.find('.article-title');

	links.on('click', {
		el: this.el,
		multiple: this.multiple
	}, this.dropdown);

}
Accordion.prototype.dropdown = function(e) {
        var $el = e.data.el;

        $this = $(this),
        $next = $this.next();

        $next.slideToggle();
        $this.parent().toggleClass('open');
        if (!e.data.multiple) {
            $el.find('.accordion-content').not($next).slideUp().parent().removeClass('open');
        };
    }
var accordion = new Accordion($('.accordion-container'), false);
 $(".accordion-content").hide(); });
</script>
<script type="text/javascript">
	 jQuery(function($) {
	 $( document ).ajaxComplete(function() {
		$('.orderby').select2({
		    minimumResultsForSearch: -1,
		    dropdownPosition: 'below'
		});
	});
});
</script>
<script type="text/javascript">
	jQuery(document).on('DOMNodeInserted', '.woocommerce-cart .woocommerce-error,.woocommerce-cart .woocommerce-message', function(e) {
        setTimeout(function() {
            jQuery('.woocommerce-cart .woocommerce-error,.woocommerce-cart .woocommerce-message').fadeOut('fast');
        }, 3000);
    });
jQuery(document).ready(function () {
	jQuery(".orderby").select2({
	minimumResultsForSearch: -1
  });
	jQuery(".dropdown-class").select2({
	minimumResultsForSearch: -1
  });
jQuery('.filter-btn').click(function() {
	jQuery('.sidebar-left').slideToggle('fast');
	jQuery('body').toggleClass("bodyfixed");
});
//My account mobile menu
jQuery('.menu-btn').click(function(){
	jQuery(".menu-icon").toggleClass('open');
	jQuery("body").toggleClass('body-absolute');
	});
	jQuery(".menu-btn").click(function () {
		jQuery(" ul").toggleClass("menu-slide");
});
jQuery('.menu-toggle').click(function() {
	jQuery('body').toggleClass("body-absolute");
});
jQuery('.lnr-cross').click(function() {
	jQuery('body').removeClass("body-absolute");
});
jQuery('.close_btn').click(function(){
    jQuery('.header-top').toggleClass('hide');
});
 jQuery('.search-icon.toggle').click(function(){
    jQuery('.searchbox').toggle('slow');
    jQuery('.search-fade').toggle();
   jQuery("body").addClass('body-absolute');
  });
  jQuery('.search_close').click(function(){
    jQuery('.searchbox').toggle('slow');
    jQuery('.search-fade').toggle();
    jQuery("body").removeClass('body-absolute');
  });
});
</script>
<script type="text/javascript">
	jQuery('.minus').click(function () {
		if(jQuery(this ).hasClass( "cart" ))
	return false;
		var $input = jQuery(this).parent().find('input');
		var count = parseInt($input.val()) - 1;
		count = count < 1 ? 1 : count;
		$input.val(count);
		$input.change();
		return false;
	});
	jQuery('.plus').click(function () {
		if(jQuery(this ).hasClass( "cart" ))
	return false;
		var $input = jQuery(this).parent().find('input');
		$input.val(parseInt($input.val()) + 1);
		$input.change();
		return false;
	});
    /*******End product page****** */
	// jQuery(document).ready(function(){
    // jQuery("#commentform").removeAttr('novalidate');
    // });
    /*******Login & Registration Validation****** */
	// jQuery(document).ready(function(jQuery) {
	// jQuery("#logins-form").validate({
	// rules: {
	// 	username: "required",
	// 	password: {
	// required: true,
	// minlength: 6
	// 	},
	// },
	// messages: {
	// 	username: "Please enter username or email id",
	// 	password: {
	// 	required: "Please provide a password",
	// 	minlength: "Your password must be at least 6 characters long"
	// 	},
	// },
	//  errorPlacement: function(error, element)
	// {
	// 	if ( element.is(":radio") )
	// 	{
	// 		error.appendTo( element.parents('.input-bx') );
	// 	}
	// 	else
	// 	{ // This is the default behavior
	// 		error.insertAfter( element );
	// 	}
 	// },
    //     submitHandler: function(form) {
	// 		form.submit();
	// 	}
	// });
	// jQuery("#register-form").validate({
	// 	rules: {
	// 	    username: "required",
	// 	    email: "required",
	// 	    password: {
	// 	        required: true,
	// 	        minlength: 6
	// 	    },
	// 				password2: {
	// 			    required: true,
	// 				equalTo: '[name="password"]'
    //     }
	// 	},
	// 	messages: {
    //                 username: "Please enter username or email id",
    //                 email: "Please enter your Email Address ",
    //                 password: {
    //                     required: "Please provide a password",
    //                     minlength: "Your password must be at least 6 characters long"
    //                 },
	// 				password2: {
	// 					required: "Please provide a confirm password",
    //                     minlength: "Your password must be at least 6 characters long"
    //     }

    //             },
    //              errorPlacement: function(error, element)
    //     {
    //         if ( element.is(":radio") )
    //         {
    //             error.appendTo( element.parents('.woocommerce-form-row') );
    //         }
    //         else
    //         { // This is the default behavior
    //             error.insertAfter( element );
    //         }
    //      },
    //             submitHandler: function(form) {
    //                 form.submit();
    //             }

    //         });

	// 		jQuery("#edit-account").validate({
    //             rules: {
    //                 account_first_name: "required",
    //                 account_last_name: "required",
    //                 account_display_name: "required",
	// 				account_email: "required",
    //             },
    //             messages: {
    //                 account_first_name: "Please enter your First name",
    //                 account_last_name: "Please enter your Last name ",
    //                 account_display_name: "Please enter your Display name",
	// 				account_email: "please enter your Email address",
    //             },
    //              errorPlacement: function(error, element)
    //     {
    //         if ( element.is(":radio") )
    //         {
    //             error.appendTo( element.parents('.woocommerce-form-row') );
    //         }
    //         else
    //         { // This is the default behavior
    //             error.insertAfter( element );
    //         }
    //      },
    //             submitHandler: function(form) {
    //                 form.submit();
    //             }

    //         });

	// 	});


	</script>

<!-- <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="http://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script> -->
<?php wp_footer(); ?>

</body>
</html>
